/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangular;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.awt.Graphics;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RoundRectangle
extends Rectangular {
    private int radius = 10;

    public RoundRectangle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    private static boolean inCircle(int qx, int qy, int cx, int cy, int rx, int ry) {
        double dx = qx - cx;
        double dy = qy - cy;
        double sum = dx * dx / (double)(4 * rx * rx) + dy * dy / (double)(4 * ry * ry);
        return sum <= 0.25;
    }

    @Override
    protected boolean contains(int x, int y, int w, int h, Location q) {
        int qx = q.getX();
        int qy = q.getY();
        int rx = this.radius;
        int ry = this.radius;
        if (2 * rx > w) {
            rx = w / 2;
        }
        if (2 * ry > h) {
            ry = h / 2;
        }
        if (!this.isInRect(qx, qy, x, y, w, h)) {
            return false;
        }
        if (qx < x + rx) {
            if (qy < y + ry) {
                return RoundRectangle.inCircle(qx, qy, x + rx, y + ry, rx, ry);
            }
            if (qy < y + h - ry) {
                return true;
            }
            return RoundRectangle.inCircle(qx, qy, x + rx, y + h - ry, rx, ry);
        }
        if (qx < x + w - rx) {
            return true;
        }
        if (qy < y + ry) {
            return RoundRectangle.inCircle(qx, qy, x + w - rx, y + ry, rx, ry);
        }
        if (qy < y + h - ry) {
            return true;
        }
        return RoundRectangle.inCircle(qx, qy, x + w - rx, y + h - ry, rx, ry);
    }

    @Override
    public void draw(Graphics g, int x, int y, int w, int h) {
        int diam = 2 * this.radius;
        if (this.setForFill(g)) {
            g.fillRoundRect(x, y, w, h, diam, diam);
        }
        if (this.setForStroke(g)) {
            g.drawRoundRect(x, y, w, h, diam, diam);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getRoundRectAttributes(this.getPaintType());
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeRoundRect");
    }

    @Override
    protected Location getRandomPoint(Bounds bds, Random rand) {
        if (this.getPaintType() != DrawAttr.PAINT_STROKE) {
            return super.getRandomPoint(bds, rand);
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int r = this.radius;
        int horz = Math.max(0, w - 2 * r);
        int vert = Math.max(0, h - 2 * r);
        double len = (double)(2 * horz + 2 * vert) + Math.PI * 2 * (double)r;
        double u = len * rand.nextDouble();
        int x = this.getX();
        int y = this.getY();
        if (u < (double)horz) {
            x += r + (int)u;
        } else if (u < (double)(2 * horz)) {
            x += r + (int)(u - (double)horz);
            y += h;
        } else if (u < (double)(2 * horz + vert)) {
            y += r + (int)(u - (double)(2 * horz));
        } else if (u < (double)(2 * horz + 2 * vert)) {
            x += w;
            y += (int)(u - (double)(2 * w) - (double)h);
        } else {
            int rx = this.radius;
            int ry = this.radius;
            if (2 * rx > w) {
                rx = w / 2;
            }
            if (2 * ry > h) {
                ry = h / 2;
            }
            u = Math.PI * 2 * rand.nextDouble();
            int dx = (int)Math.round((double)rx * Math.cos(u));
            int dy = (int)Math.round((double)ry * Math.sin(u));
            x += dx < 0 ? r + dx : r + horz + dx;
            y += dy < 0 ? r + dy : r + vert + dy;
        }
        int d = this.getStrokeWidth();
        if (d > 1) {
            x += rand.nextInt(d) - d / 2;
            y += rand.nextInt(d) - d / 2;
        }
        return Location.create(x, y, false);
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        return (V)(attr == DrawAttr.CORNER_RADIUS ? Integer.valueOf(this.radius) : super.getValue(attr));
    }

    @Override
    public boolean matches(CanvasObject other) {
        boolean bl;
        if (other instanceof RoundRectangle) {
            RoundRectangle that = (RoundRectangle)other;
            bl = super.matches(other) && this.radius == that.radius;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int matchesHashCode() {
        return super.matchesHashCode() * 31 + this.radius;
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createRoundRectangle(doc, this);
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == DrawAttr.CORNER_RADIUS) {
            this.radius = (Integer)value;
        } else {
            super.updateValue(attr, value);
        }
    }
}

