/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Line
extends AbstractCanvasObject {
    static final int ON_LINE_THRESH = 2;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    private Bounds bounds;
    private int strokeWidth;
    private Color strokeColor;

    public Line(int x0, int y0, int x1, int y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.bounds = Bounds.create(x0, y0, 0, 0).add(x1, y1);
        this.strokeWidth = 1;
        this.strokeColor = Color.BLACK;
    }

    @Override
    public boolean canMoveHandle(Handle handle) {
        return true;
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        int thresh;
        int yq;
        int xq = loc.getX();
        double d = LineUtil.ptDistSqSegment(this.x0, this.y0, this.x1, this.y1, xq, yq = loc.getY());
        return d < (double)((thresh = Math.max(2, this.strokeWidth / 2)) * thresh);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.ATTRS_STROKE;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeLine");
    }

    public Location getEnd0() {
        return Location.create(this.x0, this.y0, false);
    }

    public Location getEnd1() {
        return Location.create(this.x1, this.y1, false);
    }

    public List<Handle> getHandles() {
        return this.getHandles(null);
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        if (gesture == null) {
            return UnmodifiableList.create(new Handle[]{new Handle(this, this.x0, this.y0), new Handle(this, this.x1, this.y1)});
        }
        Handle h = gesture.getHandle();
        int dx = gesture.getDeltaX();
        int dy = gesture.getDeltaY();
        Handle[] ret = new Handle[]{new Handle(this, h.isAt(this.x0, this.y0) ? Location.create(this.x0 + dx, this.y0 + dy, false) : Location.create(this.x0, this.y0, false)), new Handle(this, h.isAt(this.x1, this.y1) ? Location.create(this.x1 + dx, this.y1 + dy, false) : Location.create(this.x1, this.y1, false))};
        return UnmodifiableList.create(ret);
    }

    @Override
    public Location getRandomPoint(Bounds bds, Random rand) {
        double u = rand.nextDouble();
        int x = (int)Math.round((double)this.x0 + u * (double)(this.x1 - this.x0));
        int y = (int)Math.round((double)this.y0 + u * (double)(this.y1 - this.y0));
        int w = this.strokeWidth;
        if (w > 1) {
            x += rand.nextInt(w) - w / 2;
            y += rand.nextInt(w) - w / 2;
        }
        return Location.create(x, y, false);
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == DrawAttr.STROKE_COLOR) {
            return (V)this.strokeColor;
        }
        if (attr == DrawAttr.STROKE_WIDTH) {
            return (V)Integer.valueOf(this.strokeWidth);
        }
        return null;
    }

    @Override
    public boolean matches(CanvasObject other) {
        boolean bl;
        if (other instanceof Line) {
            Line that = (Line)other;
            bl = this.x0 == that.x0 && this.y0 == that.x1 && this.x1 == that.y0 && this.y1 == that.y1 && this.strokeWidth == that.strokeWidth && this.strokeColor.equals(that.strokeColor);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int matchesHashCode() {
        int ret = this.x0 * 31 + this.y0;
        ret = ret * 31 * 31 + this.x1 * 31 + this.y1;
        ret = ret * 31 + this.strokeWidth;
        ret = ret * 31 + this.strokeColor.hashCode();
        return ret;
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        Handle h = gesture.getHandle();
        int dx = gesture.getDeltaX();
        int dy = gesture.getDeltaY();
        Handle ret = null;
        if (h.isAt(this.x0, this.y0)) {
            this.x0 += dx;
            this.y0 += dy;
            ret = new Handle(this, this.x0, this.y0);
        }
        if (h.isAt(this.x1, this.y1)) {
            this.x1 += dx;
            this.y1 += dy;
            ret = new Handle(this, this.x1, this.y1);
        }
        this.bounds = Bounds.create(this.x0, this.y0, 0, 0).add(this.x1, this.y1);
        return ret;
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        if (this.setForStroke(g)) {
            int x0 = this.x0;
            int y0 = this.y0;
            int x1 = this.x1;
            int y1 = this.y1;
            Handle h = gesture.getHandle();
            if (h.isAt(x0, y0)) {
                x0 += gesture.getDeltaX();
                y0 += gesture.getDeltaY();
            }
            if (h.isAt(x1, y1)) {
                x1 += gesture.getDeltaX();
                y1 += gesture.getDeltaY();
            }
            g.drawLine(x0, y0, x1, y1);
        }
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createLine(doc, this);
    }

    @Override
    public void translate(int dx, int dy) {
        this.x0 += dx;
        this.y0 += dy;
        this.x1 += dx;
        this.y1 += dy;
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == DrawAttr.STROKE_COLOR) {
            this.strokeColor = (Color)value;
        } else if (attr == DrawAttr.STROKE_WIDTH) {
            this.strokeWidth = (Integer)value;
        }
    }
}

