/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DrawingOverlaps {
    private final Map<CanvasObject, List<CanvasObject>> map = new HashMap<CanvasObject, List<CanvasObject>>();
    private final Set<CanvasObject> untested = new HashSet<CanvasObject>();

    private void addOverlap(CanvasObject a, CanvasObject b) {
        List alist = this.map.computeIfAbsent(a, k -> new ArrayList());
        if (!alist.contains(b)) {
            alist.add(b);
        }
    }

    public void addShape(CanvasObject shape) {
        this.untested.add(shape);
    }

    private void ensureUpdated() {
        for (CanvasObject o : this.untested) {
            ArrayList<CanvasObject> over = new ArrayList<CanvasObject>();
            for (CanvasObject o2 : this.map.keySet()) {
                if (o == o2 || !o.overlaps(o2)) continue;
                over.add(o2);
                this.addOverlap(o2, o);
            }
            this.map.put(o, over);
        }
        this.untested.clear();
    }

    public Collection<CanvasObject> getObjectsOverlapping(CanvasObject o) {
        this.ensureUpdated();
        List<CanvasObject> ret = this.map.get(o);
        return CollectionUtil.isNullOrEmpty(ret) ? Collections.emptyList() : Collections.unmodifiableList(ret);
    }

    public void invalidateShape(CanvasObject shape) {
        this.removeShape(shape);
        this.untested.add(shape);
    }

    public void invalidateShapes(Collection<? extends CanvasObject> shapes) {
        for (CanvasObject canvasObject : shapes) {
            this.invalidateShape(canvasObject);
        }
    }

    public void removeShape(CanvasObject shape) {
        this.untested.remove(shape);
        List<CanvasObject> mapped = this.map.remove(shape);
        if (mapped != null) {
            for (CanvasObject o : mapped) {
                List<CanvasObject> reverse = this.map.get(o);
                if (reverse == null) continue;
                reverse.remove(shape);
            }
        }
    }
}

