/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.gui;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelChangeAttributeAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.canvas.Selection;
import com.cburch.draw.canvas.SelectionEvent;
import com.cburch.draw.canvas.SelectionListener;
import com.cburch.draw.gui.SelectionAttributes;
import com.cburch.draw.model.AttributeMapKey;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import java.util.HashMap;
import java.util.Map;

class AttrTableSelectionModel
extends AttributeSetTableModel
implements SelectionListener {
    private final Canvas canvas;

    public AttrTableSelectionModel(Canvas canvas) {
        super(new SelectionAttributes(canvas.getSelection()));
        this.canvas = canvas;
        canvas.getSelection().addSelectionListener(this);
    }

    @Override
    public String getTitle() {
        Selection sel = this.canvas.getSelection();
        Class<?> commonClass = null;
        int commonCount = 0;
        CanvasObject firstObject = null;
        int totalCount = 0;
        for (CanvasObject obj : sel.getSelected()) {
            if (firstObject == null) {
                firstObject = obj;
                commonClass = obj.getClass();
                commonCount = 1;
            } else if (obj.getClass() == commonClass) {
                ++commonCount;
            } else {
                commonClass = null;
            }
            ++totalCount;
        }
        if (firstObject == null) {
            return null;
        }
        if (commonClass == null) {
            return Strings.S.get("selectionVarious", "" + totalCount);
        }
        if (commonCount == 1) {
            return firstObject.getDisplayNameAndLabel();
        }
        return Strings.S.get("selectionMultiple", firstObject.getDisplayName(), "" + commonCount);
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        this.fireTitleChanged();
    }

    @Override
    public void setValueRequested(Attribute<Object> attr, Object value) {
        SelectionAttributes attrs = (SelectionAttributes)this.getAttributeSet();
        HashMap<AttributeMapKey, Object> oldVals = new HashMap<AttributeMapKey, Object>();
        HashMap<AttributeMapKey, Object> newVals = new HashMap<AttributeMapKey, Object>();
        for (Map.Entry<AttributeSet, CanvasObject> ent : attrs.entries()) {
            AttributeMapKey key = new AttributeMapKey(attr, ent.getValue());
            oldVals.put(key, ent.getKey().getValue(attr));
            newVals.put(key, value);
        }
        CanvasModel model = this.canvas.getModel();
        this.canvas.doAction(new ModelChangeAttributeAction(model, oldVals, newVals));
        this.fireTitleChanged();
    }
}

