/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.util.ZOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ModelRemoveAction
extends ModelAction {
    private final Map<CanvasObject, Integer> removed;

    public ModelRemoveAction(CanvasModel model, CanvasObject removed) {
        this(model, Collections.singleton(removed));
    }

    public ModelRemoveAction(CanvasModel model, Collection<CanvasObject> removed) {
        super(model);
        this.removed = ZOrder.getZIndex(removed, model);
    }

    @Override
    void doSub(CanvasModel model) {
        model.removeObjects(this.removed.keySet());
    }

    @Override
    public String getName() {
        return Strings.S.get("actionRemove", ModelRemoveAction.getShapesName(this.removed.keySet()));
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return Collections.unmodifiableSet(this.removed.keySet());
    }

    @Override
    void undoSub(CanvasModel model) {
        model.addObjects(this.removed);
    }
}

