/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.listeners;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FocusArrowListener
extends KeyAdapter {
    private Component component;
    private Window window;

    private boolean shiftFocus(int dx, int dy) {
        if (this.window == null) {
            return false;
        }
        Set<Component> focusableComponents = this.getFocusableComponents();
        int x = this.component.getWidth() / 2;
        int y = this.component.getHeight() / 2;
        Point p = SwingUtilities.convertPoint(this.component, x, y, this.window);
        Object comp = null;
        while (this.withinWindow(p) && (comp == null || comp.equals(this.component) || comp instanceof JPanel)) {
            boolean cannotAcceptFocus;
            p.x += dx;
            p.y += dy;
            comp = SwingUtilities.getDeepestComponentAt(this.window, p.x, p.y);
            boolean bl = cannotAcceptFocus = !focusableComponents.contains(comp);
            if (comp == null || !cannotAcceptFocus) continue;
            comp = null;
        }
        if (!(comp == null || comp.equals(this.component) || comp.equals(this.window) || comp instanceof JPanel)) {
            ((Component)comp).requestFocus();
            return true;
        }
        return false;
    }

    private boolean withinWindow(Point p) {
        return this.withinHorizontalBound(p) && this.withinVerticalBound(p);
    }

    private boolean withinVerticalBound(Point p) {
        return p.y > 0 && p.y < this.window.getHeight();
    }

    private boolean withinHorizontalBound(Point p) {
        return p.x > 0 && p.x < this.window.getWidth();
    }

    private Set<Component> getFocusableComponents() {
        HashSet<Component> set = new HashSet<Component>();
        set.add(this.component);
        Container rootAncestor = this.component.getFocusCycleRootAncestor();
        Component comp = this.component;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor != null) {
            FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
            Component toFocus = policy.getComponentAfter(rootAncestor, comp);
            while (toFocus != null && !set.contains(toFocus)) {
                set.add(toFocus);
                toFocus = policy.getComponentAfter(rootAncestor, toFocus);
            }
            Component componentBefore = policy.getComponentBefore(rootAncestor, comp);
            while (componentBefore != null && !set.contains(componentBefore)) {
                set.add(componentBefore);
                componentBefore = policy.getComponentBefore(rootAncestor, componentBefore);
            }
        }
        return set;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int dx = 0;
        int dy = 0;
        if (code == 37) {
            dx = -1;
        } else if (code == 38) {
            dy = -1;
        } else if (code == 39) {
            dx = 1;
        } else if (code == 40) {
            dy = 1;
        }
        this.component = (Component)e.getSource();
        this.window = SwingUtilities.getWindowAncestor(this.component);
        if ((dx != 0 || dy != 0) && this.shiftFocus(dx, dy)) {
            e.consume();
        }
    }
}

