/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.colorslider;

import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;
import lombok.NonNull;

public class SliderMouseListener
extends MouseInputAdapter {
    @NonNull
    private final BasicSliderUI sliderUi;
    @NonNull
    private final JSlider slider;

    @Override
    public void mousePressed(MouseEvent e) {
        this.slider.setValueIsAdjusting(true);
        this.updateSliderValue(e);
    }

    private void updateSliderValue(MouseEvent e) {
        int v;
        if (this.slider.getOrientation() == 0) {
            int x = e.getX();
            v = this.sliderUi.valueForXPosition(x);
        } else {
            int y = e.getY();
            v = this.sliderUi.valueForYPosition(y);
        }
        this.slider.setValue(v);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSliderValue(e);
        this.slider.setValueIsAdjusting(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSliderValue(e);
    }

    public SliderMouseListener(@NonNull BasicSliderUI sliderUi, @NonNull JSlider slider) {
        if (sliderUi == null) {
            throw new NullPointerException("sliderUi is marked non-null but is null");
        }
        if (slider == null) {
            throw new NullPointerException("slider is marked non-null but is null");
        }
        this.sliderUi = sliderUi;
        this.slider = slider;
    }
}

