/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class VhdlEntityAttributes
extends AbstractAttributeSet {
    private static final List<Attribute<?>> static_attributes = Arrays.asList(VhdlEntity.nameAttr, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, StdAttr.FACING, StdAttr.APPEARANCE, VhdlSimConstants.SIM_NAME_ATTR);
    private VhdlContent content;
    private Instance vhdlInstance;
    private String label = "";
    private String simName = "";
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Direction facing = Direction.EAST;
    private Boolean labelVisible = false;
    private HashMap<Attribute<Integer>, Integer> genericValues;
    private List<Attribute<?>> instanceAttrs;
    private VhdlEntityListener listener;

    public static Attribute<Integer> forGeneric(VhdlContent.Generic generic) {
        String name = generic.getName();
        StringGetter disp = StringUtil.constantGetter(name);
        if (generic.getType().equals("positive")) {
            return new VhdlGenericAttribute("vhdl_" + name, disp, 1, Integer.MAX_VALUE, generic);
        }
        if (generic.getType().equals("natural")) {
            return new VhdlGenericAttribute("vhdl_" + name, disp, 0, Integer.MAX_VALUE, generic);
        }
        return new VhdlGenericAttribute("vhdl_" + name, disp, Integer.MIN_VALUE, Integer.MAX_VALUE, generic);
    }

    static AttributeSet createBaseAttrs(VhdlContent content) {
        VhdlContent.Generic[] generic = content.getGenerics();
        List<Attribute<Integer>> genericAttr = content.getGenericAttributes();
        Attribute[] attrs = new Attribute[7 + generic.length];
        Object[] value = new Object[7 + generic.length];
        attrs[0] = VhdlEntity.nameAttr;
        value[0] = content.getName();
        attrs[1] = StdAttr.LABEL;
        value[1] = "";
        attrs[2] = StdAttr.LABEL_FONT;
        value[2] = StdAttr.DEFAULT_LABEL_FONT;
        attrs[3] = StdAttr.LABEL_VISIBILITY;
        value[3] = false;
        attrs[4] = StdAttr.FACING;
        value[4] = Direction.EAST;
        attrs[5] = StdAttr.APPEARANCE;
        value[5] = StdAttr.APPEAR_EVOLUTION;
        attrs[6] = VhdlSimConstants.SIM_NAME_ATTR;
        value[6] = "";
        for (int i = 0; i < generic.length; ++i) {
            attrs[6 + i] = genericAttr.get(i);
            value[6 + i] = generic[i].getDefaultValue();
        }
        return AttributeSets.fixedSet(attrs, value);
    }

    public VhdlEntityAttributes(VhdlContent content) {
        this.content = content;
        this.genericValues = null;
        this.vhdlInstance = null;
        this.listener = null;
        this.updateGenerics();
    }

    public VhdlContent getContent() {
        return this.content;
    }

    public Direction getFacing() {
        return this.facing;
    }

    void setInstance(Instance value) {
        this.vhdlInstance = value;
        if (this.vhdlInstance != null && this.listener != null) {
            this.listener = new VhdlEntityListener(this);
            this.content.addHdlModelListener(this.listener);
        }
    }

    void updateGenerics() {
        List<Attribute<Integer>> genericAttrs = this.content.getGenericAttributes();
        this.instanceAttrs = new ArrayList(6 + genericAttrs.size());
        this.instanceAttrs.add(VhdlEntity.nameAttr);
        this.instanceAttrs.add(StdAttr.LABEL);
        this.instanceAttrs.add(StdAttr.LABEL_FONT);
        this.instanceAttrs.add(StdAttr.LABEL_VISIBILITY);
        this.instanceAttrs.add(StdAttr.FACING);
        this.instanceAttrs.add(StdAttr.APPEARANCE);
        this.instanceAttrs.add(VhdlSimConstants.SIM_NAME_ATTR);
        this.instanceAttrs.addAll(genericAttrs);
        if (this.genericValues == null) {
            this.genericValues = new HashMap();
        }
        ArrayList<Attribute<Integer>> toRemove = new ArrayList<Attribute<Integer>>();
        for (Attribute<Integer> a : this.genericValues.keySet()) {
            if (genericAttrs.contains(a)) continue;
            toRemove.add(a);
        }
        for (Attribute<Integer> a : toRemove) {
            this.genericValues.remove(a);
        }
        this.fireAttributeListChanged();
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        VhdlEntityAttributes attr = (VhdlEntityAttributes)dest;
        attr.content = this.content;
        attr.labelFont = this.labelFont;
        attr.labelVisible = this.labelVisible;
        attr.facing = this.facing;
        attr.instanceAttrs = this.instanceAttrs;
        attr.genericValues = new HashMap();
        for (Attribute<Integer> a : this.genericValues.keySet()) {
            attr.genericValues.put(a, this.genericValues.get(a));
        }
        attr.listener = null;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.instanceAttrs;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == VhdlEntity.nameAttr) {
            return (V)this.content.getName();
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == StdAttr.APPEARANCE) {
            return (V)this.content.getAppearance();
        }
        if (attr == StdAttr.FACING) {
            return (V)this.facing;
        }
        if (attr == VhdlSimConstants.SIM_NAME_ATTR) {
            return (V)this.simName;
        }
        if (this.genericValues.containsKey(attr)) {
            return (V)this.genericValues.get(attr);
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == VhdlEntity.nameAttr) {
            String newValue = (String)value;
            if (this.content.getName().equals(newValue)) {
                return;
            }
            if (!this.content.setName(newValue)) {
                return;
            }
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (attr == StdAttr.LABEL && value instanceof String) {
            String newLabel = (String)value;
            String oldLabel = this.label;
            if (this.label.equals(newLabel)) {
                return;
            }
            this.label = newLabel;
            this.fireAttributeValueChanged(attr, value, oldLabel);
            return;
        }
        if (attr == StdAttr.LABEL_FONT && value instanceof Font) {
            Font newFont = (Font)value;
            if (this.labelFont.equals(newFont)) {
                return;
            }
            this.labelFont = newFont;
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean newVisibility = (Boolean)value;
            if (this.labelVisible.equals(newVisibility)) {
                return;
            }
            this.labelVisible = newVisibility;
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (attr == StdAttr.FACING) {
            Direction direction = (Direction)value;
            if (this.facing.equals(direction)) {
                return;
            }
            this.facing = direction;
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (attr == VhdlSimConstants.SIM_NAME_ATTR) {
            String name = (String)value;
            if (name.equals(this.simName)) {
                return;
            }
            this.simName = name;
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (attr == StdAttr.APPEARANCE && (value == StdAttr.APPEAR_FPGA || value == StdAttr.APPEAR_CLASSIC || value == StdAttr.APPEAR_EVOLUTION)) {
            AttributeOption attrOpt = (AttributeOption)value;
            if (this.content.getAppearance().equals(attrOpt)) {
                return;
            }
            this.content.setAppearance(attrOpt);
            this.fireAttributeValueChanged(attr, value, null);
            return;
        }
        if (this.genericValues != null) {
            this.genericValues.put(attr, (Integer)value);
            this.fireAttributeValueChanged(attr, value, null);
        }
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != VhdlSimConstants.SIM_NAME_ATTR;
    }

    public static class VhdlGenericAttribute
    extends Attribute<Integer> {
        final int start;
        final int end;
        final VhdlContent.Generic g;

        private VhdlGenericAttribute(String name, StringGetter disp, int start, int end, VhdlContent.Generic generic) {
            super(name, disp);
            this.start = start;
            this.end = end;
            this.g = generic;
        }

        public VhdlContent.Generic getGeneric() {
            return this.g;
        }

        @Override
        public Component getCellEditor(Integer value) {
            return super.getCellEditor(value != null ? value.intValue() : this.g.getDefaultValue());
        }

        @Override
        public Integer parse(String value) {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() == 0 || value.equals("default") || value.equals("(default)") || value.equals(this.toDisplayString(null))) {
                return null;
            }
            long v = Long.parseLong(value);
            if (v < (long)this.start) {
                throw new NumberFormatException("integer must be at least " + this.start);
            }
            if (v > (long)this.end) {
                throw new NumberFormatException("integer must be at most " + this.end);
            }
            return (int)v;
        }

        @Override
        public String toDisplayString(Integer value) {
            return value == null ? "(default) " + this.g.getDefaultValue() : value.toString();
        }
    }

    static class VhdlEntityListener
    implements HdlModelListener {
        final VhdlEntityAttributes attrs;

        VhdlEntityListener(VhdlEntityAttributes attrs) {
            this.attrs = attrs;
        }

        @Override
        public void contentSet(HdlModel source) {
            this.attrs.updateGenerics();
            this.attrs.vhdlInstance.fireInvalidated();
            this.attrs.vhdlInstance.recomputeBounds();
            this.attrs.fireAttributeValueChanged(VhdlEntity.nameAttr, source.getName(), null);
        }

        @Override
        public void appearanceChanged(HdlModel source) {
            this.attrs.vhdlInstance.recomputeBounds();
            this.attrs.fireAttributeValueChanged(StdAttr.APPEARANCE, ((VhdlContent)source).getAppearance(), null);
        }
    }
}

