/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.bfh;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.bfh.BinToBcd;
import com.cburch.logisim.util.LineBuffer;

public class BinToBcdHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STR = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;

    public BinToBcdHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STR, -1, 6, BinToBcd.ATTR_BinBits);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        BitWidth nrOfBits = attrs.getValue(BinToBcd.ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(1 << nrOfBits.getWidth()) + 1.0);
        int nrOfSignalBits = switch (nrOfPorts) {
            case 2 -> 7;
            case 3 -> 11;
            default -> 16;
        };
        int nrOfSignals = switch (nrOfPorts) {
            case 2 -> 4;
            case 3 -> 7;
            default -> 11;
        };
        for (int signal = 0; signal < nrOfSignals; ++signal) {
            this.myWires.addWire(String.format("s_level%d", signal), nrOfSignalBits);
        }
        this.myPorts.add("input", "binValue", -1, 0);
        for (int i = 1; i <= nrOfPorts; ++i) {
            this.myPorts.add("output", String.format("bcd%d", (int)Math.pow(10.0, i - 1)), 4, i);
        }
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist netlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair(NR_OF_BITS_STR, NR_OF_BITS_STR);
        BitWidth nrOfBits = attrs.getValue(BinToBcd.ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(1 << nrOfBits.getWidth()) + 1.0);
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords();
            switch (nrOfPorts) {
                case 2: {
                    contents.add("s_level0(6 {{downto}} {{nrOfBits}}) <= ({{others}} => '0');\ns_level0({{nrOfBits}}-1 {{downto}} 0) <= binValue;\ns_level1(2 {{downto}} 0) <= s_level0(2 {{downto}} 0);\ns_level2(1 {{downto}} 0) <= s_level1(1 {{downto}} 0);\ns_level2(6)          <= s_level1(6);\ns_level3(6 {{downto}} 5) <= s_level2(6 {{downto}} 5);\ns_level3(0)          <= s_level2(0);\n\nbcd1  <= s_level3( 3 {{downto}} 0);\nbcd10 <= \"0\"&s_level3(6 {{downto}} 4);\n").add(this.getAdd3Block("s_level0", 6, "s_level1", 6, "C1")).add(this.getAdd3Block("s_level1", 5, "s_level2", 5, "C2")).add(this.getAdd3Block("s_level2", 4, "s_level3", 4, "C3"));
                    break;
                }
                case 3: {
                    contents.add("s_level0(10 {{downto}} {{nrOfBits}}) <= ({{others}} => '0');\ns_level0({{nrOfBits}}-1 {{downto}} 0) <= binValue;\ns_level1(10)          <= s_level0(10);\ns_level1( 5 {{downto}} 0) <= s_level0( 5 {{downto}} 0);\ns_level2(10 {{downto}} 9) <= s_level1(10 {{downto}} 9);\ns_level2( 4 {{downto}} 0) <= s_level1( 4 {{downto}} 0);\ns_level3(10 {{downto}} 8) <= s_level2(10 {{downto}} 8);\ns_level3( 3 {{downto}} 0) <= s_level2( 3 {{downto}} 0);\ns_level4( 2 {{downto}} 0) <= s_level3( 2 {{downto}} 0);\ns_level5(10)          <= s_level4(10);\ns_level5( 1 {{downto}} 0) <= s_level4( 1 {{downto}} 0);\ns_level6(10 {{downto}} 9) <= s_level5(10 {{downto}} 9);\ns_level6(0)           <= s_level5(0);\n\nbcd1   <= s_level6( 3 {{downto}} 0 );\nbcd10  <= s_level6( 7 {{downto}} 4 );\nbcd100 <= \"0\"&s_level6(10 {{downto}} 8);\n").add(this.getAdd3Block("s_level0", 9, "s_level1", 9, "C0")).add(this.getAdd3Block("s_level1", 8, "s_level2", 8, "C1")).add(this.getAdd3Block("s_level2", 7, "s_level3", 7, "C2")).add(this.getAdd3Block("s_level3", 6, "s_level4", 6, "C3")).add(this.getAdd3Block("s_level4", 5, "s_level5", 5, "C4")).add(this.getAdd3Block("s_level5", 4, "s_level6", 4, "C5")).add(this.getAdd3Block("s_level3", 10, "s_level4", 10, "C6")).add(this.getAdd3Block("s_level4", 9, "s_level5", 9, "C7")).add(this.getAdd3Block("s_level5", 8, "s_level6", 8, "C8"));
                    break;
                }
                case 4: {
                    contents.add("s_level0(15 {{downto}} {{nrOfBits}}) <= ({{others}} => '0');\ns_level0({{nrOfBits}}-1 {{downto}} 0) <= binValue;\ns_level1(15 {{downto}} 14)  <= s_level0(15 {{downto}} 14);\ns_level1( 9 {{downto}}  0)  <= s_level0( 9 {{downto}}  0);\ns_level2(15 {{downto}} 13)  <= s_level1(15 {{downto}} 13);\ns_level2( 8 {{downto}}  0)  <= s_level1( 8 {{downto}}  0);\ns_level3(15 {{downto}} 12)  <= s_level2(15 {{downto}} 12);\ns_level3( 7 {{downto}}  0)  <= s_level2( 7 {{downto}}  0);\ns_level4(15)            <= s_level3(15);\ns_level4( 6 {{downto}}  0)  <= s_level3( 6 {{downto}}  0);\ns_level5(15 {{downto}} 14)  <= s_level4(15 {{downto}} 14);\ns_level5( 5 {{downto}}  0)  <= s_level4( 5 {{downto}}  0);\ns_level6(15 {{downto}} 13)  <= s_level5(15 {{downto}} 13);\ns_level6( 4 {{downto}}  0)  <= s_level5( 4 {{downto}}  0);\ns_level7( 3 {{downto}}  0)  <= s_level6( 3 {{downto}}  0);\ns_level8(15)            <= s_level7(15);\ns_level8( 2 {{downto}}  0)  <= s_level7( 2 {{downto}}  0);\ns_level9(15 {{downto}} 14)  <= s_level8(15 {{downto}} 14);\ns_level9( 1 {{downto}}  0)  <= s_level8( 1 {{downto}}  0);\ns_level10(15 {{downto}} 13) <= s_level9(15 {{downto}} 13);\ns_level10(0)            <= s_level9(0);\n\nbcd1    <= s_level10( 3 {{downto}}  0);\nbcd10   <= s_level10( 7 {{downto}}  4);\nbcd100  <= s_level10(11 {{downto}}  8);\nbcd1000 <= s_level10(15 {{downto}} 12);\n").add(this.getAdd3Block("s_level0", 13, "s_level1", 13, "C0")).add(this.getAdd3Block("s_level1", 12, "s_level2", 12, "C1")).add(this.getAdd3Block("s_level2", 11, "s_level3", 11, "C2")).add(this.getAdd3Block("s_level3", 10, "s_level4", 10, "C3")).add(this.getAdd3Block("s_level4", 9, "s_level5", 9, "C4")).add(this.getAdd3Block("s_level5", 8, "s_level6", 8, "C5")).add(this.getAdd3Block("s_level6", 7, "s_level7", 7, "C6")).add(this.getAdd3Block("s_level7", 6, "s_level8", 6, "C7")).add(this.getAdd3Block("s_level8", 5, "s_level9", 5, "C8")).add(this.getAdd3Block("s_level9", 4, "s_level10", 4, "C9")).add(this.getAdd3Block("s_level3", 14, "s_level4", 14, "C10")).add(this.getAdd3Block("s_level4", 13, "s_level5", 13, "C11")).add(this.getAdd3Block("s_level5", 12, "s_level6", 12, "C12")).add(this.getAdd3Block("s_level6", 11, "s_level7", 11, "C13")).add(this.getAdd3Block("s_level7", 10, "s_level8", 10, "C14")).add(this.getAdd3Block("s_level8", 9, "s_level9", 9, "C15")).add(this.getAdd3Block("s_level9", 8, "s_level10", 8, "C16")).add(this.getAdd3Block("s_level6", 15, "s_level7", 15, "C17")).add(this.getAdd3Block("s_level7", 14, "s_level8", 14, "C18")).add(this.getAdd3Block("s_level8", 13, "s_level9", 13, "C19")).add(this.getAdd3Block("s_level9", 12, "s_level10", 12, "C20"));
                }
            }
        } else {
            Reporter.report.addFatalError("Strange, this should not happen as Verilog is not yet supported!\n");
        }
        return contents.empty();
    }

    private LineBuffer getAdd3Block(String srcName, int srcStartId, String destName, int destStartId, String processName) {
        return LineBuffer.getBuffer().addVhdlKeywords().pair("srcName", srcName).pair("srcStartId", srcStartId).pair("srcDownTo", srcStartId - 3).pair("destName", destName).pair("destStartId", destStartId).pair("destDownTo", destStartId - 3).pair("proc", processName).empty().add("add3{{proc}} : {{process}} ({{srcName}}) {{is}}\n{{begin}}\n   {{case}} ( {{srcName}}( {{srcStartId}} {{downto}} {{srcDownTo}}) ) {{is}}\n      {{when}} \"0000\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0000\";\n      {{when}} \"0001\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0001\";\n      {{when}} \"0010\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0010\";\n      {{when}} \"0011\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0011\";\n      {{when}} \"0100\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0100\";\n      {{when}} \"0101\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"1000\";\n      {{when}} \"0110\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"1001\";\n      {{when}} \"0111\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"1010\";\n      {{when}} \"1000\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"1011\";\n      {{when}} \"1001\" => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"1100\";\n      {{when}} {{others}} => {{destName}}( {{destStartId}} {{downto}} {{destDownTo}} ) <= \"0000\";\n   {{end}} {{case}};\n{{end}} {{process}} add3{{proc}};\n");
    }
}

