/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TablePanel
extends LogPanel {
    private static final long serialVersionUID = 1L;
    private static final Font HEAD_FONT = new Font("Serif", 1, 14);
    private static final Font BODY_FONT = new Font("Serif", 0, 14);
    private static final int COLUMN_SEP = 8;
    private static final int HEADER_SEP = 4;
    private final MyListener myListener = new MyListener();
    private final VerticalScrollBar vsb = new VerticalScrollBar();
    private final TableView tableView = new TableView();
    private int cellWidth = 25;
    private int cellHeight = 15;
    private final int rowCount = 0;
    private int tableWidth;
    private int tableHeight;

    public TablePanel(LogFrame frame) {
        super(frame);
        JScrollPane pane = new JScrollPane(this.tableView, 22, 30);
        pane.setVerticalScrollBar(this.vsb);
        this.setLayout(new BorderLayout());
        this.add(pane);
        this.modelChanged(null, this.getModel());
    }

    public int getColumn(MouseEvent event) {
        Model model = this.getModel();
        int x = event.getX() - (this.getWidth() - this.tableWidth) / 2;
        if (x < 0) {
            return -1;
        }
        int ret = (x + 4) / (this.cellWidth + 8);
        return ret >= 0 && ret < model.getSignalCount() ? ret : -1;
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("tableHelp");
    }

    public int getRow(MouseEvent event) {
        int y = event.getY() - (this.getHeight() - this.tableHeight) / 2;
        if (y < this.cellHeight + 4) {
            return -1;
        }
        int ret = (y - this.cellHeight - 4) / this.cellHeight;
        return ret >= 0 && ret < 0 ? ret : -1;
    }

    @Override
    public String getTitle() {
        return Strings.S.get("tableTab");
    }

    @Override
    public void localeChanged() {
        this.tableView.computePreferredSize();
        this.repaint();
    }

    @Override
    public void modelChanged(Model oldModel, Model newModel) {
        if (oldModel != null) {
            oldModel.removeModelListener(this.myListener);
        }
        if (newModel != null) {
            newModel.addModelListener(this.myListener);
        }
    }

    private static class MyListener
    implements Model.Listener {
        private MyListener() {
        }

        private void computeRowCount() {
        }

        void update() {
        }

        @Override
        public void modeChanged(Model.Event event) {
            System.out.println("todo");
        }

        @Override
        public void historyLimitChanged(Model.Event event) {
            System.out.println("todo");
        }

        @Override
        public void signalsExtended(Model.Event event) {
            this.update();
        }

        @Override
        public void signalsReset(Model.Event event) {
            this.update();
        }

        @Override
        public void selectionChanged(Model.Event event) {
            this.computeRowCount();
        }
    }

    private class VerticalScrollBar
    extends JScrollBar
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private int oldMaximum = -1;
        private int oldExtent = -1;

        public VerticalScrollBar() {
            this.getModel().addChangeListener(this);
        }

        @Override
        public int getBlockIncrement(int direction) {
            int curY = this.getValue();
            int curHeight = this.getVisibleAmount();
            int numCells = curHeight / TablePanel.this.cellHeight - 1;
            if (numCells <= 0) {
                numCells = 1;
            }
            return direction > 0 ? (curY > 0 ? numCells * TablePanel.this.cellHeight : numCells * TablePanel.this.cellHeight + 4) : (curY > TablePanel.this.cellHeight + 4 ? numCells * TablePanel.this.cellHeight : numCells * TablePanel.this.cellHeight + 4);
        }

        @Override
        public int getUnitIncrement(int direction) {
            int curY = this.getValue();
            return direction > 0 ? (curY > 0 ? TablePanel.this.cellHeight : TablePanel.this.cellHeight + 4) : (curY > TablePanel.this.cellHeight + 4 ? TablePanel.this.cellHeight : TablePanel.this.cellHeight + 4);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int newMaximum = this.getMaximum();
            int newExtent = this.getVisibleAmount();
            if (this.oldMaximum != newMaximum || this.oldExtent != newExtent) {
                if (this.getValue() + this.oldExtent >= this.oldMaximum) {
                    this.setValue(newMaximum - newExtent);
                }
                this.oldMaximum = newMaximum;
                this.oldExtent = newExtent;
            }
        }
    }

    class TableView
    extends JPanel {
        private static final long serialVersionUID = 1L;

        TableView() {
        }

        private void computePreferredSize() {
            Model model = TablePanel.this.getModel();
            int columns = model.getSignalCount();
            if (columns == 0) {
                this.setPreferredSize(new Dimension(0, 0));
                return;
            }
            Graphics g = this.getGraphics();
            if (g == null) {
                TablePanel.this.cellHeight = 16;
                TablePanel.this.cellWidth = 24;
            } else {
                FontMetrics fm = g.getFontMetrics(HEAD_FONT);
                TablePanel.this.cellHeight = fm.getHeight();
                TablePanel.this.cellWidth = 24;
                for (int i = 0; i < columns; ++i) {
                    String header = model.getItem(i).getShortName();
                    TablePanel.this.cellWidth = Math.max(TablePanel.this.cellWidth, fm.stringWidth(header));
                }
            }
            TablePanel.this.tableWidth = (TablePanel.this.cellWidth + 8) * columns - 8;
            TablePanel.this.tableHeight = TablePanel.this.cellHeight * 1 + 4;
            this.setPreferredSize(new Dimension(TablePanel.this.tableWidth, TablePanel.this.tableHeight));
            this.revalidate();
            TablePanel.this.myListener.update();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension sz = this.getSize();
            int top = Math.max(0, (sz.height - TablePanel.this.tableHeight) / 2);
            int left = Math.max(0, (sz.width - TablePanel.this.tableWidth) / 2);
            Model model = TablePanel.this.getModel();
            if (model == null) {
                return;
            }
            int columns = model.getSignalCount();
            if (columns == 0) {
                g.setFont(BODY_FONT);
                GraphicsUtil.drawCenteredText(g, Strings.S.get("tableEmptyMessage"), sz.width / 2, sz.height / 2);
                return;
            }
            g.setColor(Color.GRAY);
            int lineY = top + TablePanel.this.cellHeight + 2;
            g.drawLine(left, lineY, left + TablePanel.this.tableWidth, lineY);
            g.setColor(Color.BLACK);
            g.setFont(HEAD_FONT);
            FontMetrics headerMetric = g.getFontMetrics();
            int x = left;
            int y = top + headerMetric.getAscent() + 1;
            for (int i = 0; i < columns; ++i) {
                x = this.paintHeader(model.getItem(i).getShortName(), x, y, g, headerMetric);
            }
            g.setFont(BODY_FONT);
        }

        private int paintHeader(String header, int x, int y, Graphics g, FontMetrics fm) {
            int width = fm.stringWidth(header);
            g.drawString(header, x + (TablePanel.this.cellWidth - width) / 2, y);
            return x + TablePanel.this.cellWidth + 8;
        }
    }
}

