/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.StringParsers$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private static final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private static final Map<TimeUnit, String> timeUnitName;
    private static final Map<String, TimeUnit> timeUnit;
    private static final FiniteDuration Zero;
    private static final Duration.Infinite Undefined;
    private static final Duration.Infinite Inf;
    private static final Duration.Infinite MinusInf;

    /*
     * WARNING - void declaration
     */
    static {
        Nil$ nil$;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        MODULE$ = new Duration$();
        Tuple2[] tuple2Array = new Tuple2[7];
        String $minus$greater$extension_y6 = "d day";
        TimeUnit $minus$greater$extension_$this = TimeUnit.DAYS;
        Object var0_1 = null;
        Object var1 = null;
        tuple2Array[0] = new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y6);
        String $minus$greater$extension_y7 = "h hr hour";
        TimeUnit $minus$greater$extension_$this2 = TimeUnit.HOURS;
        Object var2_3 = null;
        Object var3_2 = null;
        tuple2Array[1] = new Tuple2<TimeUnit, String>($minus$greater$extension_$this2, $minus$greater$extension_y7);
        String string = "m min minute";
        TimeUnit $minus$greater$extension_$this3 = TimeUnit.MINUTES;
        Object var4_5 = null;
        string = null;
        tuple2Array[2] = new Tuple2<TimeUnit, void>($minus$greater$extension_$this3, $minus$greater$extension_y5);
        String string2 = "s sec second";
        TimeUnit $minus$greater$extension_$this4 = TimeUnit.SECONDS;
        Object var6_7 = null;
        string2 = null;
        tuple2Array[3] = new Tuple2<TimeUnit, void>($minus$greater$extension_$this4, $minus$greater$extension_y4);
        String string3 = "ms milli millisecond";
        TimeUnit $minus$greater$extension_$this5 = TimeUnit.MILLISECONDS;
        Object var8_9 = null;
        string3 = null;
        tuple2Array[4] = new Tuple2<TimeUnit, void>($minus$greater$extension_$this5, $minus$greater$extension_y3);
        String string4 = "\u00b5s micro microsecond";
        TimeUnit $minus$greater$extension_$this6 = TimeUnit.MICROSECONDS;
        Object var10_11 = null;
        string4 = null;
        tuple2Array[5] = new Tuple2<TimeUnit, void>($minus$greater$extension_$this6, $minus$greater$extension_y2);
        String string5 = "ns nano nanosecond";
        TimeUnit $minus$greater$extension_$this7 = TimeUnit.NANOSECONDS;
        Object var12_13 = null;
        string5 = null;
        tuple2Array[6] = new Tuple2<TimeUnit, void>($minus$greater$extension_$this7, $minus$greater$extension_y);
        ArraySeq<Tuple2> apply_elems = ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array);
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        Object var14_14 = null;
        timeUnitLabels = Nil$.MODULE$.prependedAll(apply_elems);
        timeUnitName = timeUnitLabels.toMap($less$colon$less$.MODULE$.refl()).view().mapValues((Function1<String, String> & Serializable)s -> MODULE$.words((String)s).last()).toMap($less$colon$less$.MODULE$.refl());
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        for (List flatMap_rest = timeUnitLabels; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
            Iterator flatMap_it = Duration$.$anonfun$timeUnit$1((Tuple2)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
        }
        if (flatMap_h == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Statics.releaseFence();
            nil$ = flatMap_h;
        }
        Object var15_15 = null;
        Object var16_16 = null;
        Object var17_17 = null;
        Object var18_18 = null;
        Object var19_19 = null;
        timeUnit = nil$.toMap($less$colon$less$.MODULE$.refl());
        Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Undefined();
            }
        };
        Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                int n = other == Duration$.MODULE$.Undefined() ? -1 : (other == this ? 0 : 1);
                return n;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Inf();
            }
        };
        MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.MinusInf();
            }
        };
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s) {
        Duration duration;
        block27: {
            Option option;
            String valueStr;
            TimeUnit unit;
            String string;
            int n;
            String takeWhile$extension_$this;
            String s1;
            block24: {
                block25: {
                    block26: {
                        int filterNot$extension_filter$extension_len = s.length();
                        StringBuilder filterNot$extension_filter$extension_sb = new StringBuilder(filterNot$extension_filter$extension_len);
                        for (int filterNot$extension_filter$extension_i = 0; filterNot$extension_filter$extension_i < filterNot$extension_filter$extension_len; ++filterNot$extension_filter$extension_i) {
                            char filterNot$extension_filter$extension_x = s.charAt(filterNot$extension_filter$extension_i);
                            if (!(!Duration$.$anonfun$apply$1(filterNot$extension_filter$extension_x))) continue;
                            filterNot$extension_filter$extension_sb.append(filterNot$extension_filter$extension_x);
                        }
                        Object var10_3 = null;
                        s1 = filterNot$extension_filter$extension_len == filterNot$extension_filter$extension_sb.length() ? s : filterNot$extension_filter$extension_sb.toString();
                        switch (s1 == null ? 0 : s1.hashCode()) {
                            case -1772306297: {
                                if ("Duration.Inf".equals(s1)) {
                                    break;
                                }
                                break block25;
                            }
                            case -1283193487: {
                                if (!"MinusInf".equals(s1)) break block25;
                                break block26;
                            }
                            case 73665: {
                                if ("Inf".equals(s1)) {
                                    break;
                                }
                                break block25;
                            }
                            case 1354678: {
                                if ("+Inf".equals(s1)) {
                                    break;
                                }
                                break block25;
                            }
                            case 1414260: {
                                if (!"-Inf".equals(s1)) break block25;
                                break block26;
                            }
                            case 784790902: {
                                if (!"Duration.Undefined".equals(s1)) break block25;
                                duration = this.Undefined();
                                break block27;
                            }
                            case 927723627: {
                                if (!"Duration.MinusInf".equals(s1)) break block25;
                                break block26;
                            }
                            case 1189350343: {
                                if ("PlusInf".equals(s1)) {
                                    break;
                                }
                                break block25;
                            }
                            default: {
                                break block25;
                            }
                        }
                        duration = this.Inf();
                        break block27;
                    }
                    duration = this.MinusInf();
                    break block27;
                }
                takeWhile$extension_$this = StringOps$.MODULE$.reverse$extension(s1);
                int n2 = 0;
                int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
                for (int takeWhile$extension_indexWhere$extension_i = n2; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                    if (!(!Duration$.$anonfun$apply$2(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))) continue;
                    n = takeWhile$extension_indexWhere$extension_i;
                    break block24;
                }
                n = -1;
            }
            switch (n) {
                case -1: {
                    string = takeWhile$extension_$this;
                    break;
                }
                default: {
                    string = takeWhile$extension_$this.substring(0, n);
                }
            }
            Object var15_8 = null;
            String unitName = StringOps$.MODULE$.reverse$extension(string);
            Option option2 = this.timeUnit().get(unitName);
            if (option2 instanceof Some) {
                unit = (TimeUnit)((Object)((Some)option2).value());
                valueStr = StringOps$.MODULE$.dropRight$extension(s1, unitName.length());
                Option<Object> option3 = StringParsers$.MODULE$.parseLong(valueStr);
                if (option3 == null) {
                    throw null;
                }
                Option<Object> map_this = option3;
                if (map_this.isEmpty()) {
                    option = None$.MODULE$;
                } else {
                    Object object = map_this.get();
                    Some<FiniteDuration> some = new Some<FiniteDuration>(Duration$.MODULE$.apply(BoxesRunTime.unboxToLong(object), unit));
                    option = some;
                }
            } else {
                throw new NumberFormatException(new StringBuilder(13).append("format error ").append(s).toString());
            }
            Object var13_17 = null;
            Option getOrElse_this = option;
            Object var14_19 = null;
            Duration duration2 = getOrElse_this.isEmpty() ? Duration$.MODULE$.apply(Double.parseDouble(valueStr), unit) : getOrElse_this.get();
            duration = duration2;
        }
        return duration;
    }

    private List<String> words(String s) {
        ArraySeq.ofRef<String> ofRef2 = Predef$.MODULE$.wrapRefArray(s.trim().split("\\s+"));
        if (ofRef2 == null) {
            throw null;
        }
        return IterableOnceOps.toList$(ofRef2);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> expandLabels(String labels) {
        void var4_4;
        Nil$ nil$;
        Nil$ nil$2;
        void var5_5;
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        String hd = (String)$colon$colon.head();
        List rest = $colon$colon.next$access$1();
        if (var5_5 == null) {
            throw null;
        }
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        for (List flatMap_rest = var5_5; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
            Iterator flatMap_it = Duration$.$anonfun$expandLabels$1((String)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
        }
        if (flatMap_h == null) {
            nil$2 = Nil$.MODULE$;
        } else {
            Statics.releaseFence();
            nil$2 = flatMap_h;
        }
        Nil$ nil$3 = nil$ = nil$2;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        nil$ = null;
        Nil$ $colon$colon_this = nil$3;
        return new $colon$colon<Nothing$>((Nothing$)var4_4, $colon$colon_this);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s) {
        Option option;
        try {
            option = new Some<Duration>(this.apply(s));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option.flatMap((Function1<Duration, Option> & Serializable)d -> MODULE$.unapply((Duration)d));
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        if (d.isFinite()) {
            return new Some<Tuple2<Object, TimeUnit>>(new Tuple2<Long, TimeUnit>(d.length(), d.unit()));
        }
        return None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        if (Double.isInfinite(nanos)) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Double.isNaN(nanos)) {
            return this.Undefined();
        }
        if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(46).append("trying to construct too large duration with ").append(nanos).append("ns").toString());
        }
        return this.fromNanos(Math.round(nanos));
    }

    /*
     * WARNING - void declaration
     */
    public FiniteDuration fromNanos(long nanos) {
        if (nanos % 86400000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.DAYS;
            long apply_length = nanos / 86400000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 3600000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.HOURS;
            long apply_length = nanos / 3600000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 60000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MINUTES;
            long apply_length = nanos / 60000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            long apply_length = nanos / 1000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            long apply_length = nanos / 1000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MICROSECONDS;
            long apply_length = nanos / 1000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        TimeUnit apply_unit = TimeUnit.NANOSECONDS;
        return new FiniteDuration(nanos, apply_unit);
    }

    public FiniteDuration Zero() {
        return Zero;
    }

    public Duration.Infinite Undefined() {
        return Undefined;
    }

    public Duration.Infinite Inf() {
        return Inf;
    }

    public Duration.Infinite MinusInf() {
        return MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(char x$1) {
        return Character.isWhitespace(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(char x$2) {
        return Character.isLetter(x$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List $anonfun$expandLabels$1(String s) {
        void apply_elems;
        ArraySeq<String> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new String[]{s, new StringBuilder(1).append(s).append("s").toString()});
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        return Nil$.MODULE$.prependedAll((IterableOnce)apply_elems);
    }

    public static final /* synthetic */ Tuple2 $anonfun$timeUnit$2(TimeUnit unit$2, String x$5) {
        return new Tuple2<String, TimeUnit>(x$5, unit$2);
    }

    public static final /* synthetic */ List $anonfun$timeUnit$1(Tuple2 x0$1) {
        Nil$ nil$;
        List list;
        if (x0$1 != null) {
            TimeUnit unit = (TimeUnit)((Object)x0$1._1());
            String names = (String)x0$1._2();
            List<String> list2 = MODULE$.expandLabels(names);
            if (list2 == null) {
                throw null;
            }
            List<String> map_this = list2;
            if (map_this == Nil$.MODULE$) {
                list = Nil$.MODULE$;
            } else {
                $colon$colon<Nothing$> map_h;
                String string = (String)map_this.head();
                $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    string = (String)map_rest.head();
                    $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
                    map_t.next_$eq(map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                list = map_h;
            }
        } else {
            throw new MatchError((Object)null);
        }
        Nil$ nil$2 = nil$ = list;
        Object var4_3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        nil$ = null;
        Nil$ nil$3 = nil$2;
        return nil$3;
    }

    private Duration$() {
    }

    public static final /* synthetic */ Object $anonfun$apply$1$adapted(Object x$1) {
        return BoxesRunTime.boxToBoolean(Duration$.$anonfun$apply$1(BoxesRunTime.unboxToChar(x$1)));
    }

    public static final /* synthetic */ Object $anonfun$apply$2$adapted(Object x$2) {
        return BoxesRunTime.boxToBoolean(Duration$.$anonfun$apply$2(BoxesRunTime.unboxToChar(x$2)));
    }

    public static final /* synthetic */ FiniteDuration $anonfun$apply$3$adapted(TimeUnit unit$1, Object x$3) {
        return Duration$.MODULE$.apply(BoxesRunTime.unboxToLong(x$3), unit$1);
    }
}

