/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.BeanSetPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutablePropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetImmutableSetter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

class ImmutableSetPropertyField<M, E, T extends ObservableSet<E>, R extends Property<T>>
implements ImmutablePropertyField<T, M, R> {
    private final SetGetter<M, E> getter;
    private final SetImmutableSetter<M, E> immutableSetter;
    private Set<E> defaultValue;
    private final SetProperty<E> targetProperty;

    public ImmutableSetPropertyField(SideEffect updateFunction, SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter, Supplier<SetProperty<E>> propertySupplier) {
        this(updateFunction, getter, immutableSetter, propertySupplier, Collections.emptySet());
    }

    public ImmutableSetPropertyField(SideEffect updateFunction, SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter, Supplier<SetProperty<E>> propertySupplier, Set<E> defaultValue) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.immutableSetter = immutableSetter;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableSet(new HashSet()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
    }

    @Override
    public M commitImmutable(M wrappedObject) {
        return this.immutableSetter.apply(wrappedObject, (Set<E>)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanSetPropertyField.setAll(this.targetProperty, this.getter.apply((Object)wrappedObject));
    }

    @Override
    public void resetToDefault() {
        BeanSetPropertyField.setAll(this.targetProperty, this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashSet(this.getter.apply((Object)wrappedObject));
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        SetProperty<E> wrappedValue;
        Object modelValue = this.getter.apply((Object)wrappedObject);
        return !Objects.equals(modelValue, wrappedValue = this.targetProperty);
    }
}

