/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.views;

import com.airhacks.afterburner.views.DefaultResourceLocator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ResourceLocator {
    public static ResourceLocator discover() {
        ServiceLoader<ResourceLocator> discoveredLocators = ServiceLoader.load(ResourceLocator.class);
        List<ResourceLocator> factories = StreamSupport.stream(discoveredLocators.spliterator(), false).collect(Collectors.toList());
        if (factories.isEmpty()) {
            return new DefaultResourceLocator();
        }
        if (factories.size() == 1) {
            return (ResourceLocator)factories.get(0);
        }
        Logger logger = LoggerFactory.getLogger(ResourceLocator.class);
        factories.forEach(factory -> logger.error(factory.toString()));
        throw new IllegalStateException("More than one ResourceLocator discovered");
    }

    public ResourceBundle getResourceBundle(String var1);
}

