/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javafx.scene.text.Font;
import org.kordamp.ikonli.AbstractIkonResolver;
import org.kordamp.ikonli.IkonHandler;

public class IkonResolver
extends AbstractIkonResolver {
    private static final IkonResolver INSTANCE;
    private static final Set<IkonHandler> HANDLERS;
    private static final Set<IkonHandler> CUSTOM_HANDLERS;
    private static final Map<String, Font> FONTS;

    private IkonResolver() {
    }

    public boolean registerHandler(IkonHandler handler) {
        return this.registerHandler(handler, HANDLERS, CUSTOM_HANDLERS);
    }

    public boolean unregisterHandler(IkonHandler handler) {
        return this.unregisterHandler(handler, HANDLERS, CUSTOM_HANDLERS);
    }

    public IkonHandler resolve(String value) {
        return this.resolve(value, HANDLERS, CUSTOM_HANDLERS);
    }

    public static IkonResolver getInstance() {
        return INSTANCE;
    }

    static {
        HANDLERS = new LinkedHashSet<IkonHandler>();
        CUSTOM_HANDLERS = new LinkedHashSet<IkonHandler>();
        FONTS = new LinkedHashMap<String, Font>();
        INSTANCE = new IkonResolver();
        ServiceLoader loader = IkonResolver.resolveServiceLoader();
        for (IkonHandler handler : loader) {
            HANDLERS.add(handler);
            String fontResource = handler.getFontResource().toExternalForm();
            handler.setFont((Object)FONTS.computeIfAbsent(fontResource, key -> Font.loadFont((String)key, (double)16.0)));
        }
    }
}

