/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.ScreensView;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Reflection;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class ScreensViewSkin
extends SkinBase<ScreensView> {
    private Group scalingGroup = new Group();

    public ScreensViewSkin(ScreensView view) {
        super((Control)view);
        Group group = new Group(new Node[]{this.scalingGroup});
        group.getStyleClass().add((Object)"container");
        group.effectProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            DropShadow shadow = view.getShadow();
            Reflection reflection = view.getReflection();
            if (view.isShowShadow() && view.isShowReflection()) {
                reflection.setInput((Effect)shadow);
                return reflection;
            }
            if (view.isShowShadow()) {
                return shadow;
            }
            if (view.isShowReflection()) {
                reflection.setInput(null);
                return reflection;
            }
            return null;
        }, (Observable[])new Observable[]{view.showReflectionProperty(), view.showShadowProperty()}));
        this.getChildren().add((Object)group);
        InvalidationListener updateViewListener = it -> this.updateView();
        view.showWallpaperProperty().addListener(updateViewListener);
        view.showWindowsProperty().addListener(updateViewListener);
        view.getShapes().addListener(updateViewListener);
        Screen.getScreens().addListener(updateViewListener);
        Window.getWindows().addListener(updateViewListener);
        this.updateView();
    }

    private void updateView() {
        this.scalingGroup.getChildren().clear();
        ObservableList screens = Screen.getScreens();
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Object screen : screens) {
            Group group = new Group();
            Rectangle2D bounds = screen.getBounds();
            Rectangle clip = new Rectangle(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            clip.setArcWidth(32.0);
            clip.setArcHeight(32.0);
            group.setClip((Node)clip);
            group.getChildren().add((Object)new BackgroundView((Screen)screen));
            group.getChildren().add((Object)new ScreenView((Screen)screen));
            group.getChildren().add((Object)new VisibleAreaView((Screen)screen));
            group.getChildren().add((Object)new GlassView((Screen)screen));
            minX = Math.min(minX, bounds.getMinX());
            minY = Math.min(minY, bounds.getMinY());
            maxX = Math.max(maxX, bounds.getMinX() + bounds.getWidth());
            maxY = Math.max(maxY, bounds.getMinY() + bounds.getHeight());
            this.scalingGroup.getChildren().add((Object)group);
        }
        ScreensView view = (ScreensView)this.getSkinnable();
        for (Shape shape : view.getShapes()) {
            this.scalingGroup.getChildren().add((Object)shape);
            minX = Math.min(minX, shape.getLayoutX());
            minY = Math.min(minY, shape.getLayoutY());
            maxX = Math.max(maxX, shape.getLayoutX() + shape.prefWidth(-1.0));
            maxY = Math.max(maxY, shape.getLayoutY() + shape.prefHeight(-1.0));
        }
        if (view.isShowWindows()) {
            for (Window window : Window.getWindows()) {
                this.scalingGroup.getChildren().add((Object)new WindowView(window));
            }
        }
        Rectangle2D totalBounds = new Rectangle2D(minX, minY, maxX - minX, maxY - minY);
        DoubleBinding scale = Bindings.createDoubleBinding(() -> Math.min(view.getWidth() / totalBounds.getWidth(), view.getHeight() / totalBounds.getHeight()) * 0.75, (Observable[])new Observable[]{view.widthProperty(), view.heightProperty(), Screen.getScreens(), Window.getWindows()});
        this.scalingGroup.scaleXProperty().bind((ObservableValue)scale);
        this.scalingGroup.scaleYProperty().bind((ObservableValue)scale);
    }

    public class BackgroundView
    extends StackPane {
        public BackgroundView(Screen screen) {
            Image image;
            Callback<Screen, Image> wallpaperProvider;
            this.getStyleClass().add((Object)"background");
            ScreensView view = (ScreensView)ScreensViewSkin.this.getSkinnable();
            if (view.isShowWallpaper() && (wallpaperProvider = view.getWallpaperProvider()) != null && (image = (Image)wallpaperProvider.call((Object)screen)) != null) {
                this.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS)}));
                this.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(-1.0, -1.0, false, false, false, true))}));
            }
            Rectangle2D bounds = screen.getBounds();
            this.setLayoutX(bounds.getMinX());
            this.setLayoutY(bounds.getMinY());
            this.setPrefWidth(bounds.getWidth());
            this.setPrefHeight(bounds.getHeight());
        }
    }

    public class ScreenView
    extends StackPane {
        public ScreenView(Screen screen) {
            this.getStyleClass().add((Object)"screen");
            ScreensView view = (ScreensView)ScreensViewSkin.this.getSkinnable();
            if (!view.isShowWallpaper()) {
                this.getStyleClass().add((Object)"no-wallpaper");
            }
            Rectangle2D bounds = screen.getBounds();
            this.setLayoutX(bounds.getMinX());
            this.setLayoutY(bounds.getMinY());
            this.setPrefWidth(bounds.getWidth());
            this.setPrefHeight(bounds.getHeight());
            Label label = new Label("Screen " + Screen.getScreens().indexOf((Object)screen));
            label.setTextAlignment(TextAlignment.CENTER);
            label.setWrapText(true);
            if (Screen.getPrimary().equals((Object)screen)) {
                label.setText("Primary");
            }
            this.getChildren().add((Object)label);
        }
    }

    static class VisibleAreaView
    extends StackPane {
        public VisibleAreaView(Screen screen) {
            this.getStyleClass().add((Object)"visible-area");
            Rectangle2D bounds = screen.getBounds();
            this.setLayoutX(bounds.getMinX());
            this.setLayoutY(bounds.getMinY());
            this.setPrefWidth(bounds.getWidth());
            this.setPrefHeight(bounds.getHeight());
            Rectangle2D visualBounds = screen.getVisualBounds();
            Rectangle clipRectangle = new Rectangle(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            clipRectangle.setArcWidth(32.0);
            clipRectangle.setArcHeight(32.0);
            Rectangle visibleAreaClip = clipRectangle;
            visibleAreaClip = Shape.subtract((Shape)visibleAreaClip, (Shape)new Rectangle(visualBounds.getMinX(), visualBounds.getMinY(), visualBounds.getWidth(), visualBounds.getHeight()));
            this.setClip((Node)visibleAreaClip);
        }
    }

    static class GlassView
    extends StackPane {
        public GlassView(Screen screen) {
            this.getStyleClass().add((Object)"glass");
            Rectangle2D bounds = screen.getBounds();
            this.setLayoutX(bounds.getMinX());
            this.setLayoutY(bounds.getMinY());
            this.setPrefWidth(bounds.getWidth());
            this.setPrefHeight(bounds.getHeight());
        }
    }

    class WindowView
    extends StackPane {
        private double startX;
        private double startY;

        public WindowView(Window window) {
            this.getStyleClass().add((Object)"window");
            this.layoutXProperty().bind((ObservableValue)window.xProperty());
            this.layoutYProperty().bind((ObservableValue)window.yProperty());
            this.prefWidthProperty().bind((ObservableValue)window.widthProperty());
            this.prefHeightProperty().bind((ObservableValue)window.heightProperty());
            BooleanBinding visibleBinding = Bindings.createBooleanBinding(() -> ((Window)window).isShowing(), (Observable[])new Observable[]{window.showingProperty()});
            if (window instanceof Stage) {
                Stage stage = (Stage)window;
                visibleBinding = visibleBinding.and((ObservableBooleanValue)stage.iconifiedProperty().not());
                Label label = new Label();
                label.setWrapText(true);
                label.setTextAlignment(TextAlignment.CENTER);
                label.textProperty().bind((ObservableValue)stage.titleProperty());
                this.getChildren().add((Object)label);
            }
            this.visibleProperty().bind((ObservableValue)visibleBinding);
            this.setOnMouseClicked(evt -> {
                if (evt.isStillSincePress() && evt.getButton().equals((Object)MouseButton.PRIMARY)) {
                    this.toFront();
                }
            });
            this.setOnMousePressed(evt -> {
                this.startX = evt.getScreenX();
                this.startY = evt.getScreenY();
            });
            this.setOnMouseDragged(evt -> {
                if (((ScreensView)ScreensViewSkin.this.getSkinnable()).isEnableWindowDragging()) {
                    window.setX(window.getX() + (evt.getScreenX() - this.startX) * (1.0 / ScreensViewSkin.this.scalingGroup.getScaleX()));
                    window.setY(window.getY() + (evt.getScreenY() - this.startY) * (1.0 / ScreensViewSkin.this.scalingGroup.getScaleY()));
                    this.startX = evt.getScreenX();
                    this.startY = evt.getScreenY();
                }
            });
        }
    }
}

