/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator;

import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class GemScrollPane
extends ScrollPane {
    private Timeline timeline;
    private final ObjectProperty<Duration> scrollToDuration = new SimpleObjectProperty((Object)this, "scrollToDuration", (Object)Duration.millis((double)333.0));
    private final ListProperty<Node> visibleNodes = new SimpleListProperty((Object)this, "visibleNodes", FXCollections.observableArrayList());

    public GemScrollPane() {
        this.init();
    }

    public GemScrollPane(Node content) {
        super(content);
        this.init();
    }

    private void init() {
    }

    public final Duration getScrollToDuration() {
        return (Duration)this.scrollToDuration.get();
    }

    public final ObjectProperty<Duration> scrollToDurationProperty() {
        return this.scrollToDuration;
    }

    public final void setScrollToDuration(Duration scrollToDuration) {
        this.scrollToDuration.set((Object)scrollToDuration);
    }

    public void showNode(Node node, boolean animated) {
        double targetVValue = -1.0;
        double targetHValue = -1.0;
        Bounds nodeBounds = this.getContent().sceneToLocal(node.localToScene(node.getBoundsInLocal()));
        if (this.getVbarPolicy() != ScrollPane.ScrollBarPolicy.NEVER) {
            double minV = this.computeMinVerticalValue(nodeBounds);
            double maxV = this.computeMaxVerticalValue(nodeBounds);
            System.out.println("vv: " + this.getVvalue() + ", minV: " + minV + ", maxV: " + maxV);
            if (maxV < this.getVvalue()) {
                System.out.println("node is above, maxV = " + maxV + ", vv = " + this.getVvalue());
                System.out.println("scrolling to minV = " + minV);
                targetVValue = minV;
            } else if (minV > this.getVvalue()) {
                System.out.println("node is below, minV = " + minV + ", vv = " + this.getVvalue());
                System.out.println("scrolling to maxV = " + maxV);
                targetVValue = maxV;
            }
        }
        if (this.getHbarPolicy() != ScrollPane.ScrollBarPolicy.NEVER) {
            double minH = this.computeMinHorizontalValue(nodeBounds);
            double maxH = this.computeMaxHorizontalValue(nodeBounds);
            if (maxH < this.getHvalue()) {
                targetHValue = minH;
            } else if (minH > this.getHvalue()) {
                targetHValue = maxH;
            }
        }
        if (animated && this.getScene() != null && this.isVisible()) {
            if (this.timeline != null && this.timeline.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.timeline.stop();
            }
            this.timeline = new Timeline();
            KeyValue verticalValue = new KeyValue((WritableValue)this.vvalueProperty(), (Object)targetVValue);
            KeyValue horizontalValue = new KeyValue((WritableValue)this.hvalueProperty(), (Object)targetHValue);
            if (targetVValue != -1.0) {
                KeyFrame verticalFrame = new KeyFrame(this.getScrollToDuration(), new KeyValue[]{verticalValue});
                this.timeline.getKeyFrames().add((Object)verticalFrame);
            }
            if (targetHValue != -1.0) {
                KeyFrame horizontalFrame = new KeyFrame(this.getScrollToDuration(), new KeyValue[]{horizontalValue});
                this.timeline.getKeyFrames().add((Object)horizontalFrame);
            }
            this.timeline.play();
        } else {
            this.setVvalue(targetVValue);
            this.setHvalue(targetHValue);
        }
    }

    private double computeMinHorizontalValue(Bounds nodeBounds) {
        double width = this.getContent().getBoundsInLocal().getWidth();
        double minX = nodeBounds.getMinX();
        double minHValue = minX / width;
        return minHValue;
    }

    private double computeMaxHorizontalValue(Bounds nodeBounds) {
        double width = this.getContent().getBoundsInLocal().getWidth();
        double maxX = nodeBounds.getMaxX();
        double maxHValue = maxX / width;
        return maxHValue;
    }

    private double computeMinVerticalValue(Bounds nodeBounds) {
        double height = this.getContent().getBoundsInLocal().getHeight();
        double minY = nodeBounds.getMinY();
        double minVValue = minY / height;
        return minVValue;
    }

    private double computeMaxVerticalValue(Bounds nodeBounds) {
        Region viewport = (Region)this.lookup(".viewport");
        double viewportHeight = viewport.getHeight();
        double height = this.getContent().getBoundsInLocal().getHeight();
        double maxY = nodeBounds.getMaxY();
        return (maxY - viewportHeight) / height;
    }

    public void centerNode(Node node) {
        double h = this.getContent().getBoundsInLocal().getHeight();
        double y = (node.getBoundsInParent().getMaxY() + node.getBoundsInParent().getMinY()) / 2.0;
        double v = this.getViewportBounds().getHeight();
        this.setVvalue(this.getVmax() * ((y - 0.5 * v) / (h - v)));
    }

    public void topNode(Node node) {
        double h = this.getContent().getBoundsInLocal().getHeight();
        double y = node.getBoundsInParent().getMinY();
        this.setVvalue(this.getVmax() * (y / h));
    }

    public void bottomNode(Node node) {
        double h = this.getContent().getBoundsInLocal().getHeight();
        double y = node.getBoundsInParent().getMaxY();
        double v = this.getViewportBounds().getHeight();
        this.setVvalue(this.getVmax() * ((y - v) / (h - v)));
    }

    public ObservableList<Node> getVisibleNodes() {
        return (ObservableList)this.visibleNodes.get();
    }

    public ListProperty<Node> visibleNodesProperty() {
        return this.visibleNodes;
    }

    public void setVisibleNodes(ObservableList<Node> visibleNodes) {
        this.visibleNodes.set(visibleNodes);
    }

    private void updateVisibleNodes() {
        System.out.println("--------------");
        ArrayList<Node> visibleNodes = new ArrayList<Node>();
        Node viewport = this.lookup(".viewport");
        if (viewport != null) {
            Bounds viewportBounds = viewport.localToScene(viewport.getBoundsInLocal());
            if (this.getContent() instanceof Parent) {
                for (Node n : ((Parent)this.getContent()).getChildrenUnmodifiable()) {
                    Bounds nodeBounds = n.localToScene(n.getBoundsInLocal());
                    System.out.println("ch: " + n);
                    System.out.println("vb: " + viewportBounds);
                    System.out.println("nb: " + nodeBounds);
                    if (!viewportBounds.contains(nodeBounds)) continue;
                    visibleNodes.add(n);
                }
            }
        }
        this.getVisibleNodes().setAll(visibleNodes);
    }
}

