/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.pdf.search.SearchResult;
import org.jabref.model.search.rules.FullTextSearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.strings.StringUtil;
import org.jabref.search.SearchBaseVisitor;
import org.jabref.search.SearchLexer;
import org.jabref.search.SearchParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="Because access to the lucene index is needed")
public class GrammarBasedSearchRule
extends FullTextSearchRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrammarBasedSearchRule.class);
    private final EnumSet<SearchRules.SearchFlags> searchFlags;
    private ParseTree tree;
    private String query;
    private List<SearchResult> searchResults = new ArrayList<SearchResult>();

    public GrammarBasedSearchRule(EnumSet<SearchRules.SearchFlags> searchFlags) throws RecognitionException {
        super(searchFlags);
        this.searchFlags = searchFlags;
    }

    public static boolean isValid(EnumSet<SearchRules.SearchFlags> searchFlags, String query) {
        return new GrammarBasedSearchRule(searchFlags).validateSearchStrings(query);
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public String getQuery() {
        return this.query;
    }

    private void init(String query) throws ParseCancellationException {
        if (Objects.equals(this.query, query)) {
            return;
        }
        SearchLexer lexer = new SearchLexer((CharStream)new ANTLRInputStream(query));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        SearchParser parser = new SearchParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        this.tree = parser.start();
        this.query = query;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        try {
            return (Boolean)new BibtexSearchVisitor(this.searchFlags, bibEntry).visit(this.tree);
        }
        catch (Exception e) {
            LOGGER.info("Search failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean validateSearchStrings(String query) {
        try {
            this.init(query);
            return true;
        }
        catch (ParseCancellationException e) {
            LOGGER.debug("Search query invalid", (Throwable)e);
            return false;
        }
    }

    @Override
    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        return this.searchFlags;
    }

    public static class ThrowingErrorListener
    extends BaseErrorListener {
        public static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }

    static class BibtexSearchVisitor
    extends SearchBaseVisitor<Boolean> {
        private final EnumSet<SearchRules.SearchFlags> searchFlags;
        private final BibEntry entry;

        public BibtexSearchVisitor(EnumSet<SearchRules.SearchFlags> searchFlags, BibEntry bibEntry) {
            this.searchFlags = searchFlags;
            this.entry = bibEntry;
        }

        public boolean comparison(String field, ComparisonOperator operator, String value) {
            return new Comparator(field, value, operator, this.searchFlags).compare(this.entry);
        }

        @Override
        public Boolean visitStart(SearchParser.StartContext ctx) {
            return (Boolean)this.visit((ParseTree)ctx.expression());
        }

        @Override
        public Boolean visitComparison(SearchParser.ComparisonContext context) {
            Optional<SearchParser.NameContext> fieldDescriptor;
            String right = context.right.getText();
            if (right.startsWith("\"") && right.endsWith("\"")) {
                right = right.substring(1, right.length() - 1);
            }
            if ((fieldDescriptor = Optional.ofNullable(context.left)).isPresent()) {
                return this.comparison(fieldDescriptor.get().getText(), ComparisonOperator.build(context.operator.getText()), right);
            }
            return SearchRules.getSearchRule(this.searchFlags).applyRule(right, this.entry);
        }

        @Override
        public Boolean visitUnaryExpression(SearchParser.UnaryExpressionContext ctx) {
            return (Boolean)this.visit((ParseTree)ctx.expression()) == false;
        }

        @Override
        public Boolean visitParenExpression(SearchParser.ParenExpressionContext ctx) {
            return (Boolean)this.visit((ParseTree)ctx.expression());
        }

        @Override
        public Boolean visitBinaryExpression(SearchParser.BinaryExpressionContext ctx) {
            if ("AND".equalsIgnoreCase(ctx.operator.getText())) {
                return (Boolean)this.visit((ParseTree)ctx.left) != false && (Boolean)this.visit((ParseTree)ctx.right) != false;
            }
            return (Boolean)this.visit((ParseTree)ctx.left) != false || (Boolean)this.visit((ParseTree)ctx.right) != false;
        }
    }

    public static class Comparator {
        private final ComparisonOperator operator;
        private final Pattern fieldPattern;
        private final Pattern valuePattern;

        public Comparator(String field, String value, ComparisonOperator operator, EnumSet<SearchRules.SearchFlags> searchFlags) {
            this.operator = operator;
            int option = searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE) ? 0 : 2;
            this.fieldPattern = Pattern.compile((String)(searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION) ? StringUtil.stripAccents(field) : "\\Q" + StringUtil.stripAccents(field) + "\\E"), option);
            this.valuePattern = Pattern.compile((String)(searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION) ? StringUtil.stripAccents(value) : "\\Q" + StringUtil.stripAccents(value) + "\\E"), option);
        }

        public boolean compare(BibEntry entry) {
            if (this.fieldPattern.matcher(InternalField.TYPE_HEADER.getName()).matches()) {
                return this.matchFieldValue(entry.getType().getName());
            }
            if (this.fieldPattern.matcher("anykeyword").matches()) {
                return entry.getKeywords(Character.valueOf(',')).stream().map(Keyword::toString).anyMatch(this::matchFieldValue);
            }
            Set<Field> fieldsKeys = entry.getFields();
            if (!this.fieldPattern.matcher("anyfield").matches()) {
                fieldsKeys = fieldsKeys.stream().filter(this.matchFieldKey()).collect(Collectors.toSet());
            }
            for (Field field : fieldsKeys) {
                Optional<String> fieldValue = entry.getFieldLatexFree(field);
                if (!fieldValue.isPresent() || !this.matchFieldValue(StringUtil.stripAccents(fieldValue.get()))) continue;
                return true;
            }
            return fieldsKeys.isEmpty() && this.operator == ComparisonOperator.DOES_NOT_CONTAIN;
        }

        private Predicate<Field> matchFieldKey() {
            return field -> this.fieldPattern.matcher(field.getName()).matches();
        }

        public boolean matchFieldValue(String content) {
            Matcher matcher = this.valuePattern.matcher(content);
            if (this.operator == ComparisonOperator.CONTAINS) {
                return matcher.find();
            }
            if (this.operator == ComparisonOperator.EXACT) {
                return matcher.matches();
            }
            if (this.operator == ComparisonOperator.DOES_NOT_CONTAIN) {
                return !matcher.find();
            }
            throw new IllegalStateException("MUST NOT HAPPEN");
        }
    }

    public static enum ComparisonOperator {
        EXACT,
        CONTAINS,
        DOES_NOT_CONTAIN;


        public static ComparisonOperator build(String value) {
            if ("CONTAINS".equalsIgnoreCase(value) || "=".equals(value)) {
                return CONTAINS;
            }
            if ("MATCHES".equalsIgnoreCase(value) || "==".equals(value)) {
                return EXACT;
            }
            return DOES_NOT_CONTAIN;
        }
    }
}

