/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitedKey;
import org.jabref.model.openoffice.style.CompareCitedKey;

public class CitedKeys {
    private LinkedHashMap<String, CitedKey> data;

    CitedKeys(LinkedHashMap<String, CitedKey> data) {
        this.data = data;
    }

    public List<CitedKey> values() {
        return new ArrayList<CitedKey>(this.data.values());
    }

    public CitedKey get(String citationKey) {
        return this.data.get(citationKey);
    }

    void sortByComparator(Comparator<BibEntry> entryComparator) {
        ArrayList<CitedKey> cks = new ArrayList<CitedKey>(this.data.values());
        cks.sort(new CompareCitedKey(entryComparator, true));
        LinkedHashMap<String, CitedKey> newData = new LinkedHashMap<String, CitedKey>();
        for (CitedKey ck : cks) {
            newData.put(ck.citationKey, ck);
        }
        this.data = newData;
    }

    void numberCitedKeysInCurrentOrder() {
        int index = 1;
        for (CitedKey ck : this.data.values()) {
            if (ck.getLookupResult().isPresent()) {
                ck.setNumber(Optional.of(index));
                ++index;
                continue;
            }
            ck.setNumber(Optional.empty());
        }
    }

    public void lookupInDatabases(List<BibDatabase> databases) {
        for (CitedKey ck : this.data.values()) {
            ck.lookupInDatabases(databases);
        }
    }

    void distributeLookupResults(CitationGroups citationGroups) {
        for (CitedKey ck : this.data.values()) {
            ck.distributeLookupResult(citationGroups);
        }
    }

    void distributeNumbers(CitationGroups citationGroups) {
        for (CitedKey ck : this.data.values()) {
            ck.distributeNumber(citationGroups);
        }
    }

    public void distributeUniqueLetters(CitationGroups citationGroups) {
        for (CitedKey ck : this.data.values()) {
            ck.distributeUniqueLetter(citationGroups);
        }
    }
}

