/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.List;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationLookupResult;
import org.jabref.model.openoffice.style.CitationMarkerEntry;
import org.jabref.model.openoffice.style.CitationMarkerNumericEntry;
import org.jabref.model.openoffice.style.ComparableCitation;
import org.jabref.model.openoffice.style.PageInfo;
import org.jabref.model.openoffice.util.OOPair;

public class Citation
implements ComparableCitation,
CitationMarkerEntry,
CitationMarkerNumericEntry {
    public final String citationKey;
    private Optional<CitationLookupResult> db;
    private Optional<Integer> number;
    private Optional<String> uniqueLetter;
    private Optional<OOText> pageInfo;
    private boolean isFirstAppearanceOfSource;

    public Citation(String citationKey) {
        this.citationKey = citationKey;
        this.db = Optional.empty();
        this.number = Optional.empty();
        this.uniqueLetter = Optional.empty();
        this.pageInfo = Optional.empty();
        this.isFirstAppearanceOfSource = false;
    }

    @Override
    public String getCitationKey() {
        return this.citationKey;
    }

    @Override
    public Optional<OOText> getPageInfo() {
        return this.pageInfo;
    }

    @Override
    public boolean getIsFirstAppearanceOfSource() {
        return this.isFirstAppearanceOfSource;
    }

    @Override
    public Optional<BibEntry> getBibEntry() {
        return this.db.map(citationLookupResult -> citationLookupResult.entry);
    }

    public static Optional<CitationLookupResult> lookup(BibDatabase database, String key) {
        return database.getEntryByCitationKey(key).map(bibEntry -> new CitationLookupResult((BibEntry)bibEntry, database));
    }

    public static Optional<CitationLookupResult> lookup(List<BibDatabase> databases, String key) {
        return databases.stream().map(database -> Citation.lookup(database, key)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public void lookupInDatabases(List<BibDatabase> databases) {
        this.db = Citation.lookup(databases, this.citationKey);
    }

    @Override
    public Optional<CitationLookupResult> getLookupResult() {
        return this.db;
    }

    public void setLookupResult(Optional<CitationLookupResult> db) {
        this.db = db;
    }

    public boolean isUnresolved() {
        return this.db.isEmpty();
    }

    @Override
    public Optional<Integer> getNumber() {
        return this.number;
    }

    public void setNumber(Optional<Integer> number) {
        this.number = number;
    }

    public int getNumberOrThrow() {
        return this.number.get();
    }

    @Override
    public Optional<String> getUniqueLetter() {
        return this.uniqueLetter;
    }

    public void setUniqueLetter(Optional<String> uniqueLetter) {
        this.uniqueLetter = uniqueLetter;
    }

    public void setPageInfo(Optional<OOText> pageInfo) {
        Optional<OOText> normalizedPageInfo = PageInfo.normalizePageInfo(pageInfo);
        if (!normalizedPageInfo.equals(pageInfo)) {
            throw new IllegalArgumentException("setPageInfo argument is not normalized");
        }
        this.pageInfo = normalizedPageInfo;
    }

    public void setIsFirstAppearanceOfSource(boolean value) {
        this.isFirstAppearanceOfSource = value;
    }

    public static void setLookupResult(OOPair<Citation, Optional<CitationLookupResult>> pair) {
        Citation citation = (Citation)pair.a;
        citation.db = (Optional)pair.b;
    }

    public static void setNumber(OOPair<Citation, Optional<Integer>> pair) {
        Citation citation = (Citation)pair.a;
        citation.number = (Optional)pair.b;
    }

    public static void setUniqueLetter(OOPair<Citation, Optional<String>> pair) {
        Citation citation = (Citation)pair.a;
        citation.uniqueLetter = (Optional)pair.b;
    }
}

