/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.Collection;
import java.util.Optional;
import org.jabref.logic.preferences.OwnerPreferences;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;

public class UpdateField {
    private UpdateField() {
    }

    public static Optional<FieldChange> updateField(BibEntry be, Field field, String newValue) {
        return UpdateField.updateField(be, field, newValue, false);
    }

    public static Optional<FieldChange> updateNonDisplayableField(BibEntry be, Field field, String newValue) {
        boolean changed = be.hasChanged();
        Optional<FieldChange> fieldChange = UpdateField.updateField(be, field, newValue, false);
        be.setChanged(changed);
        return fieldChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<FieldChange> updateField(BibEntry be, Field field, String newValue, Boolean nullFieldIfValueIsTheSame) {
        String writtenValue = null;
        String oldValue = null;
        if (be.hasField(field)) {
            oldValue = be.getField(field).get();
            if (newValue == null || oldValue.equals(newValue) && nullFieldIfValueIsTheSame.booleanValue()) {
                be.clearField(field);
                return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
            } else {
                if (oldValue.equals(newValue)) return Optional.empty();
                writtenValue = newValue;
                be.setField(field, newValue);
            }
            return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
        } else {
            if (newValue == null) {
                return Optional.empty();
            }
            writtenValue = newValue;
            be.setField(field, newValue);
        }
        return Optional.of(new FieldChange(be, field, oldValue, writtenValue));
    }

    private static void setAutomaticFields(BibEntry entry, boolean setOwner, String owner, boolean setTimeStamp, String timeStamp) {
        if (setOwner) {
            entry.setField(StandardField.OWNER, owner);
        }
        if (setTimeStamp) {
            entry.setField(StandardField.CREATIONDATE, timeStamp);
        }
    }

    public static void setAutomaticFields(Collection<BibEntry> entries, OwnerPreferences ownerPreferences, TimestampPreferences timestampPreferences) {
        boolean globalSetOwner = ownerPreferences.isUseOwner();
        boolean setTimeStamp = timestampPreferences.shouldAddCreationDate();
        if (!globalSetOwner && !setTimeStamp) {
            return;
        }
        String defaultOwner = ownerPreferences.getDefaultOwner();
        boolean overwriteOwner = ownerPreferences.isOverwriteOwner();
        String timestamp = timestampPreferences.now();
        for (BibEntry curEntry : entries) {
            boolean setOwner = globalSetOwner && (overwriteOwner || !curEntry.hasField(StandardField.OWNER));
            UpdateField.setAutomaticFields(curEntry, setOwner, defaultOwner, setTimeStamp, timestamp);
        }
    }
}

