/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.architecture.AllowedToUseStandardStreams;
import org.jabref.logic.l10n.Language;
import org.jabref.logic.l10n.LocalizationKeyParams;
import org.slf4j.LoggerFactory;

@AllowedToUseStandardStreams(value="Needs to have acess to System.err because it's called very early before our loggers")
public class Localization {
    static final String RESOURCE_PREFIX = "l10n/JabRef";
    private static Locale locale;
    private static LocalizationBundle localizedMessages;

    private Localization() {
    }

    public static String lang(String key, Object ... params) {
        if (localizedMessages == null) {
            System.err.println("Messages are not initialized before accessing key: " + key);
            Localization.setLanguage(Language.ENGLISH);
        }
        String[] stringParams = (String[])Arrays.stream(params).map(Object::toString).toArray(String[]::new);
        return Localization.lookup(localizedMessages, key, stringParams);
    }

    public static void setLanguage(Language language) {
        Optional<Locale> knownLanguage = Language.convertToSupportedLocale(language);
        Locale defaultLocale = Locale.getDefault();
        if (knownLanguage.isEmpty()) {
            LoggerFactory.getLogger(Localization.class).warn("Language {} is not supported by JabRef (Default: {})", (Object)language, (Object)defaultLocale);
            Localization.setLanguage(Language.ENGLISH);
            return;
        }
        Locale langLocale = knownLanguage.get();
        if (locale != null && locale.equals(langLocale) && locale.equals(defaultLocale)) {
            return;
        }
        locale = langLocale;
        Locale.setDefault(locale);
        try {
            Localization.createResourceBundles(locale);
        }
        catch (MissingResourceException ex) {
            LoggerFactory.getLogger(Localization.class).warn("Could not find bundles for language " + String.valueOf(locale) + ", switching to full english language", (Throwable)ex);
            Localization.setLanguage(Language.ENGLISH);
        }
    }

    public static LocalizationBundle getMessages() {
        if (locale == null) {
            Localization.setLanguage(Language.ENGLISH);
        }
        return localizedMessages;
    }

    private static void createResourceBundles(Locale locale) {
        ResourceBundle messages = ResourceBundle.getBundle(RESOURCE_PREFIX, locale);
        Objects.requireNonNull(messages, "Could not load l10n/JabRef resource.");
        localizedMessages = new LocalizationBundle(Localization.createLookupMap(messages));
    }

    private static Map<String, String> createLookupMap(ResourceBundle baseBundle) {
        ArrayList<String> baseKeys = Collections.list(baseBundle.getKeys());
        return new HashMap<String, String>(baseKeys.stream().collect(Collectors.toMap(key -> key, baseBundle::getString)));
    }

    private static String lookup(LocalizationBundle bundle, String key, String ... params) {
        String translation;
        Objects.requireNonNull(key);
        String string = translation = bundle.containsKey(key) ? bundle.getString(key) : "";
        if (translation.isEmpty()) {
            LoggerFactory.getLogger(Localization.class).warn("Warning: could not get translation for \"{}\" for locale {}", (Object)key, (Object)Locale.getDefault());
            translation = key;
        }
        return new LocalizationKeyParams(translation, params).replacePlaceholders();
    }

    private static class LocalizationBundle
    extends ResourceBundle {
        private final Map<String, String> lookup;

        LocalizationBundle(Map<String, String> lookupMap) {
            this.lookup = lookupMap;
        }

        @Override
        public final Object handleGetObject(String key) {
            Objects.requireNonNull(key);
            return Optional.ofNullable(this.lookup.get(key)).orElse(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.lookup.keySet());
        }

        @Override
        protected Set<String> handleKeySet() {
            return this.lookup.keySet();
        }

        @Override
        public boolean containsKey(String key) {
            return true;
        }
    }
}

