/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jabref.logic.journals.Abbreviation;

public class JournalAbbreviationRepository {
    static final Pattern QUESTION_MARK = Pattern.compile("\\?");
    private final Map<String, Abbreviation> fullToAbbreviationObject = new HashMap<String, Abbreviation>();
    private final Map<String, Abbreviation> abbreviationToAbbreviationObject = new HashMap<String, Abbreviation>();
    private final Map<String, Abbreviation> dotlessToAbbreviationObject = new HashMap<String, Abbreviation>();
    private final Map<String, Abbreviation> shortestUniqueToAbbreviationObject = new HashMap<String, Abbreviation>();
    private final TreeSet<Abbreviation> customAbbreviations = new TreeSet();

    public JournalAbbreviationRepository(Path journalList) {
        try (MVStore store = new MVStore.Builder().readOnly().fileName(journalList.toAbsolutePath().toString()).open();){
            MVMap mvFullToAbbreviationObject = store.openMap("FullToAbbreviation");
            mvFullToAbbreviationObject.forEach((name, abbreviation) -> {
                String abbrevationString = abbreviation.getAbbreviation();
                String shortestUniqueAbbreviation = abbreviation.getShortestUniqueAbbreviation();
                Abbreviation newAbbreviation = new Abbreviation((String)name, abbrevationString, shortestUniqueAbbreviation);
                this.fullToAbbreviationObject.put((String)name, newAbbreviation);
                this.abbreviationToAbbreviationObject.put(abbrevationString, newAbbreviation);
                this.dotlessToAbbreviationObject.put(newAbbreviation.getDotlessAbbreviation(), newAbbreviation);
                this.shortestUniqueToAbbreviationObject.put(shortestUniqueAbbreviation, newAbbreviation);
            });
        }
    }

    public JournalAbbreviationRepository() {
        Abbreviation newAbbreviation = new Abbreviation("Demonstration", "Demo", "Dem");
        this.fullToAbbreviationObject.put("Demonstration", newAbbreviation);
        this.abbreviationToAbbreviationObject.put("Demo", newAbbreviation);
        this.dotlessToAbbreviationObject.put("Demo", newAbbreviation);
        this.shortestUniqueToAbbreviationObject.put("Dem", newAbbreviation);
    }

    private static boolean isMatched(String name, Abbreviation abbreviation) {
        return name.equalsIgnoreCase(abbreviation.getName()) || name.equalsIgnoreCase(abbreviation.getAbbreviation()) || name.equalsIgnoreCase(abbreviation.getDotlessAbbreviation()) || name.equalsIgnoreCase(abbreviation.getShortestUniqueAbbreviation());
    }

    private static boolean isMatchedAbbreviated(String name, Abbreviation abbreviation) {
        boolean isExpanded = name.equalsIgnoreCase(abbreviation.getName());
        if (isExpanded) {
            return false;
        }
        return name.equalsIgnoreCase(abbreviation.getAbbreviation()) || name.equalsIgnoreCase(abbreviation.getDotlessAbbreviation()) || name.equalsIgnoreCase(abbreviation.getShortestUniqueAbbreviation());
    }

    public boolean isKnownName(String journalName) {
        if (QUESTION_MARK.matcher(journalName).find()) {
            return false;
        }
        String journal = journalName.trim().replaceAll(Matcher.quoteReplacement("\\&"), "&");
        return this.customAbbreviations.stream().anyMatch(abbreviation -> JournalAbbreviationRepository.isMatched(journal, abbreviation)) || this.fullToAbbreviationObject.containsKey(journal) || this.abbreviationToAbbreviationObject.containsKey(journal) || this.dotlessToAbbreviationObject.containsKey(journal) || this.shortestUniqueToAbbreviationObject.containsKey(journal);
    }

    public boolean isAbbreviatedName(String journalName) {
        if (QUESTION_MARK.matcher(journalName).find()) {
            return false;
        }
        String journal = journalName.trim().replaceAll(Matcher.quoteReplacement("\\&"), "&");
        return this.customAbbreviations.stream().anyMatch(abbreviation -> JournalAbbreviationRepository.isMatchedAbbreviated(journal, abbreviation)) || this.abbreviationToAbbreviationObject.containsKey(journal) || this.dotlessToAbbreviationObject.containsKey(journal) || this.shortestUniqueToAbbreviationObject.containsKey(journal);
    }

    public Optional<Abbreviation> get(String input) {
        String journal = input.trim().replaceAll(Matcher.quoteReplacement("\\&"), "&");
        Optional<Abbreviation> customAbbreviation = this.customAbbreviations.stream().filter(abbreviation -> JournalAbbreviationRepository.isMatched(journal, abbreviation)).findFirst();
        if (customAbbreviation.isPresent()) {
            return customAbbreviation;
        }
        return Optional.ofNullable(this.fullToAbbreviationObject.get(journal)).or(() -> Optional.ofNullable(this.abbreviationToAbbreviationObject.get(journal))).or(() -> Optional.ofNullable(this.dotlessToAbbreviationObject.get(journal))).or(() -> Optional.ofNullable(this.shortestUniqueToAbbreviationObject.get(journal)));
    }

    public void addCustomAbbreviation(Abbreviation abbreviation) {
        Objects.requireNonNull(abbreviation);
        this.customAbbreviations.add(abbreviation);
    }

    public Collection<Abbreviation> getCustomAbbreviations() {
        return this.customAbbreviations;
    }

    public void addCustomAbbreviations(Collection<Abbreviation> abbreviationsToAdd) {
        abbreviationsToAdd.forEach(this::addCustomAbbreviation);
    }

    public Optional<String> getNextAbbreviation(String text) {
        return this.get(text).map(abbreviation -> abbreviation.getNext(text));
    }

    public Optional<String> getDefaultAbbreviation(String text) {
        return this.get(text).map(Abbreviation::getAbbreviation);
    }

    public Optional<String> getDotless(String text) {
        return this.get(text).map(Abbreviation::getDotlessAbbreviation);
    }

    public Optional<String> getShortestUniqueAbbreviation(String text) {
        return this.get(text).map(Abbreviation::getShortestUniqueAbbreviation);
    }

    public Set<String> getFullNames() {
        return this.fullToAbbreviationObject.keySet();
    }

    public Collection<Abbreviation> getAllLoaded() {
        return this.fullToAbbreviationObject.values();
    }
}

