/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.preferences.DOIPreferences;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoiResolution
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoiResolution.class);
    private final DOIPreferences doiPreferences;

    public DoiResolution(DOIPreferences doiPreferences) {
        this.doiPreferences = doiPreferences;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String doiLink;
        URL base;
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (doi.isEmpty()) {
            return Optional.empty();
        }
        if (this.doiPreferences.isUseCustom()) {
            base = new URL(this.doiPreferences.getDefaultBaseURI());
            doiLink = ((DOI)doi.get()).getExternalURIWithCustomBase(base.toString()).map(URI::toASCIIString).orElse("");
        } else {
            base = DOI.RESOLVER.toURL();
            doiLink = ((DOI)doi.get()).getURIAsASCIIString();
        }
        if (doiLink.isEmpty()) {
            return Optional.empty();
        }
        try {
            Connection connection = Jsoup.connect((String)doiLink);
            connection.userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36");
            connection.referrer("https://www.google.com");
            connection.followRedirects(true);
            connection.ignoreHttpErrors(true);
            connection.timeout(30000);
            Connection.Response response = connection.execute();
            Document html = response.parse();
            Optional<URL> citationMetaTag = this.citationMetaTag(html);
            if (citationMetaTag.isPresent()) {
                return citationMetaTag;
            }
            Optional<URL> embeddedLink = this.findEmbeddedLink(html, base);
            if (embeddedLink.isPresent()) {
                return embeddedLink;
            }
            Elements hrefElements = html.body().select("a[href]");
            ArrayList<URL> links = new ArrayList<URL>();
            for (Element element : hrefElements) {
                String href = element.attr("abs:href").toLowerCase(Locale.ENGLISH);
                String hrefText = element.text().toLowerCase(Locale.ENGLISH);
                if (element.attr("title").toLowerCase(Locale.ENGLISH).contains("pdf") && new URLDownload(href).isPdf()) {
                    return Optional.of(new URL(href));
                }
                if (!href.contains("pdf") && (!hrefText.contains("pdf") || !new URLDownload(href).isPdf())) continue;
                links.add(new URL(href));
            }
            if (links.size() == 1) {
                LOGGER.info("Fulltext PDF found @ {}", (Object)doiLink);
                return Optional.of((URL)links.getFirst());
            }
            return this.findDistinctLinks(links);
        }
        catch (UnsupportedMimeTypeException type) {
            if (type.getMimeType().startsWith("application/pdf")) {
                return Optional.of(new URL(type.getUrl()));
            }
            LOGGER.warn("DoiResolution fetcher failed: ", (Throwable)type);
        }
        catch (IOException e) {
            LOGGER.warn("DoiResolution fetcher failed: ", (Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<URL> citationMetaTag(Document html) {
        Elements citationPdfUrlElement = html.head().select("meta[name='citation_pdf_url']");
        Optional<String> citationPdfUrl = citationPdfUrlElement.stream().map(e -> e.attr("content")).findFirst();
        if (citationPdfUrl.isPresent()) {
            try {
                return Optional.of(new URL(citationPdfUrl.get()));
            }
            catch (MalformedURLException e2) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<URL> findEmbeddedLink(Document html, URL base) {
        Elements embedElement = html.body().select("embed[id='pdf']");
        Optional<String> pdfUrl = embedElement.stream().map(e -> e.attr("src")).findFirst();
        if (pdfUrl.isPresent()) {
            try {
                URL url = base.toURI().resolve(pdfUrl.get()).toURL();
                return Optional.of(url);
            }
            catch (MalformedURLException | URISyntaxException e2) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<URL> findDistinctLinks(List<URL> urls) {
        List distinctLinks = urls.stream().distinct().collect(Collectors.toList());
        if (distinctLinks.isEmpty()) {
            return Optional.empty();
        }
        if (distinctLinks.size() == 1) {
            return Optional.of((URL)distinctLinks.getFirst());
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.SOURCE;
    }
}

