/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;

public class EscapeAmpersandsFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Escape ampersands", new Object[0]);
    }

    @Override
    public String getKey() {
        return "escapeAmpersands";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        StringBuilder result = new StringBuilder();
        boolean escape = false;
        boolean inCommandName = false;
        boolean inCommand = false;
        boolean inCommandOption = false;
        int nestedEnvironments = 0;
        StringBuilder commandName = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) && (escape || inCommandName)) {
                inCommandName = true;
                if (!inCommandOption) {
                    commandName.append(c);
                }
            } else if ((!Character.isWhitespace(c) || !inCommand && !inCommandOption) && inCommandName) {
                if (c == '[') {
                    inCommandOption = true;
                } else if (inCommandOption && c == ']') {
                    inCommandOption = false;
                } else if (!inCommandOption && c == '{') {
                    inCommandName = false;
                    inCommand = true;
                } else {
                    commandName.delete(0, commandName.length());
                    inCommandName = false;
                }
            }
            if (inCommand && c == '}') {
                if ("begin".contentEquals(commandName)) {
                    ++nestedEnvironments;
                }
                if (nestedEnvironments > 0 && "end".contentEquals(commandName)) {
                    --nestedEnvironments;
                }
                commandName.delete(0, commandName.length());
                inCommand = false;
            }
            if (!(c != '&' || escape || inCommand && "url".contentEquals(commandName) || nestedEnvironments != 0)) {
                result.append("\\&");
            } else {
                result.append(c);
            }
            escape = c == '\\';
        }
        return result.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Escape ampersands", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "Text & with &ampersands";
    }
}

