/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.StringJsonBuilderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.integrity.PagesChecker;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.DigitStringValue;
import org.jbibtex.Key;
import org.jbibtex.Value;

public class JabRefItemDataProvider
implements ItemDataProvider {
    private static final BibTeXConverter BIBTEX_CONVERTER = new BibTeXConverter();
    private final StringJsonBuilderFactory stringJsonBuilderFactory;
    private final List<BibEntry> data = new ArrayList<BibEntry>();
    private BibDatabaseContext bibDatabaseContext;
    private BibEntryTypesManager entryTypesManager;
    private PagesChecker pagesChecker;

    public JabRefItemDataProvider() {
        this.stringJsonBuilderFactory = new StringJsonBuilderFactory();
    }

    private CSLItemData bibEntryToCSLItemData(BibEntry originalBibEntry, BibDatabaseContext bibDatabaseContext, BibEntryTypesManager entryTypesManager) {
        SequencedCollection<Field> fields;
        BibEntry bibEntry = (BibEntry)originalBibEntry.clone();
        String citeKey = bibEntry.getCitationKey().orElse("");
        BibTeXEntry bibTeXEntry = new BibTeXEntry(new Key(bibEntry.getType().getName()), new Key(citeKey));
        RemoveNewlinesFormatter removeNewlinesFormatter = new RemoveNewlinesFormatter();
        Optional<BibEntryType> entryType = entryTypesManager.enrich(bibEntry.getType(), bibDatabaseContext.getMode());
        if (bibEntry.getType().equals(StandardEntryType.Article)) {
            if (bibDatabaseContext.isBiblatexMode()) {
                Optional<String> numberField = bibEntry.getField(StandardField.NUMBER);
                numberField.ifPresent(number -> {
                    bibEntry.setField(StandardField.ISSUE, (String)number);
                    bibEntry.clearField(StandardField.NUMBER);
                });
                bibEntry.getField(StandardField.EID).ifPresent(eid -> {
                    if (!bibEntry.hasField(StandardField.NUMBER)) {
                        bibEntry.setField(StandardField.NUMBER, (String)eid);
                        bibEntry.clearField(StandardField.EID);
                    }
                });
            } else {
                bibEntry.getField(StandardField.NUMBER).ifPresent(number -> {
                    bibEntry.setField(StandardField.ISSUE, (String)number);
                    bibEntry.clearField(StandardField.NUMBER);
                });
                bibEntry.getField(StandardField.PAGES).ifPresent(pages -> {
                    if (pages.toLowerCase(Locale.ROOT).startsWith("article ")) {
                        pages = pages.substring("Article ".length());
                        bibEntry.setField(StandardField.NUMBER, (String)pages);
                    }
                });
                bibEntry.getField(StandardField.EID).ifPresent(eid -> {
                    if (!bibEntry.hasField(StandardField.PAGES)) {
                        bibEntry.setField(StandardField.PAGES, (String)eid);
                        bibEntry.clearField(StandardField.EID);
                    }
                });
            }
        }
        if (entryType.isPresent()) {
            fields = entryType.map(BibEntryType::getAllFields).map(LinkedHashSet::new).get();
            fields.addAll(bibEntry.getFields());
        } else {
            fields = bibEntry.getFields();
        }
        for (Field key : fields) {
            bibEntry.getResolvedFieldOrAlias(key, bibDatabaseContext.getDatabase()).map(removeNewlinesFormatter::format).map(LatexToUnicodeAdapter::format).ifPresent(value -> {
                if (StandardField.MONTH == key) {
                    value = bibEntry.getMonth().map(Month::getShortName).orElse((String)value);
                }
                bibTeXEntry.addField(new Key(key.getName()), (Value)new DigitStringValue(value));
            });
        }
        return BIBTEX_CONVERTER.toItemData(bibTeXEntry);
    }

    public void setData(BibDatabaseContext bibDatabaseContext, BibEntryTypesManager entryTypesManager) {
        this.setData(bibDatabaseContext.getEntries(), bibDatabaseContext, entryTypesManager);
    }

    public void setData(List<BibEntry> data, BibDatabaseContext bibDatabaseContext, BibEntryTypesManager entryTypesManager) {
        this.data.clear();
        this.data.addAll(data);
        this.bibDatabaseContext = bibDatabaseContext;
        this.entryTypesManager = entryTypesManager;
        BibDatabaseContext ctx = new BibDatabaseContext();
        ctx.setMode(BibDatabaseMode.BIBLATEX);
        this.pagesChecker = new PagesChecker(ctx);
    }

    public CSLItemData retrieveItem(String id) {
        return this.data.stream().filter(entry -> entry.getCitationKey().orElse("").equals(id)).map(entry -> this.bibEntryToCSLItemData((BibEntry)entry, this.bibDatabaseContext, this.entryTypesManager)).findFirst().orElse(null);
    }

    public Collection<String> getIds() {
        return this.data.stream().map(entry -> entry.getCitationKey().orElse("")).toList();
    }

    public String toJson() {
        List<BibEntry> entries = this.bibDatabaseContext.getEntries();
        this.setData(entries, this.bibDatabaseContext, this.entryTypesManager);
        return entries.stream().map(entry -> this.bibEntryToCSLItemData((BibEntry)entry, this.bibDatabaseContext, this.entryTypesManager)).map(item -> item.toJson(this.stringJsonBuilderFactory.createJsonBuilder())).map(String.class::cast).collect(Collectors.joining(",", "[", "]"));
    }
}

