/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.http.server;

import jakarta.ws.rs.SeBootstrap;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javax.net.ssl.SSLContext;
import net.harawata.appdirs.AppDirsFactory;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.jabref.architecture.AllowedToUseStandardStreams;
import org.jabref.http.server.Application;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@AllowedToUseStandardStreams(value="This is a CLI application. It resides in the package http.server to be close to the other http server related classes.")
public class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static SeBootstrap.Instance serverInstance;

    public static void main(String[] args) throws InterruptedException, URISyntaxException {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ObservableList<Path> lastFilesOpened = JabRefPreferences.getInstance().getGuiPreferences().getLastFilesOpened();
        if (args.length > 0) {
            LOGGER.debug("Command line parameters passed");
            List<Path> filesToAdd = Arrays.stream(args).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(path -> !lastFilesOpened.contains(path)).toList();
            LOGGER.debug("Adding following files to the list of opened libraries: {}", filesToAdd);
            for (Path path2 : filesToAdd.reversed()) {
                lastFilesOpened.addFirst((Object)path2);
            }
        }
        if (lastFilesOpened.isEmpty()) {
            LOGGER.debug("still no library available to serve, serve the demo library");
            Path bibPath = Path.of("src/main/resources/org/jabref/http/server/http-server-demo.bib", new String[0]).toAbsolutePath();
            LOGGER.debug("Location of demo library: {}", (Object)bibPath);
            lastFilesOpened.add((Object)bibPath);
        }
        LOGGER.debug("Libraries served: {}", lastFilesOpened);
        Server.startServer();
        Thread.currentThread().join();
    }

    private static void startServer() {
        SSLContext sslContext = Server.getSslContext();
        SeBootstrap.Configuration configuration = SeBootstrap.Configuration.builder().sslContext(sslContext).protocol("HTTPS").port(Integer.valueOf(6051)).build();
        LOGGER.debug("Starting server...");
        SeBootstrap.start(Application.class, (SeBootstrap.Configuration)configuration).thenAccept(instance -> {
            LOGGER.debug("Server started.");
            instance.stopOnShutdown(stopResult -> System.out.printf("Stop result: %s [Native stop result: %s].%n", stopResult, stopResult.unwrap(Object.class)));
            URI uri = instance.configuration().baseUri();
            System.out.printf("Instance %s running at %s [Native handle: %s].%n", instance, uri, instance.unwrap(Object.class));
            System.out.println("Send SIGKILL to shutdown.");
            serverInstance = instance;
        });
    }

    private static SSLContext getSslContext() {
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        Path serverKeyStore = Path.of(AppDirsFactory.getInstance().getUserDataDir("jabref", "ssl", "org.jabref"), new String[0]).resolve("server.p12");
        if (Files.exists(serverKeyStore, new LinkOption[0])) {
            sslContextConfig.setKeyStoreFile(serverKeyStore.toString());
            sslContextConfig.setKeyStorePass("changeit");
        } else {
            LOGGER.error("Could not find server key store {}.", (Object)serverKeyStore);
            LOGGER.error("One create one by following the steps described in [http-server.md](/docs/code-howtos/http-server.md), which is rendered at <https://devdocs.jabref.org/code-howtos/http-server.html>");
        }
        return sslContextConfig.createSSLContext();
    }

    static void stopServer() {
        serverInstance.stop();
    }
}

