/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util.component;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextInputControl;
import javafx.util.StringConverter;
import org.jabref.gui.fieldeditors.contextmenu.EditorContextAction;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.model.entry.Date;
import org.jabref.model.strings.StringUtil;

public class TemporalAccessorPicker
extends DatePicker {
    private final ObjectProperty<TemporalAccessor> temporalAccessorValue = new SimpleObjectProperty(null);
    private final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final ObjectProperty<StringConverter<TemporalAccessor>> converter = new SimpleObjectProperty(null);

    public TemporalAccessorPicker() {
        this.setConverter(new InternalConverter());
        BindingsHelper.bindBidirectional(this.valueProperty(), this.temporalAccessorValue, TemporalAccessorPicker::addCurrentTime, TemporalAccessorPicker::getDate);
        this.getEditor().setOnContextMenuRequested(event -> {
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.getItems().setAll(EditorContextAction.getDefaultContextMenuItems((TextInputControl)this.getEditor()));
            contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        });
    }

    private static TemporalAccessor addCurrentTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date, LocalTime.now());
    }

    private static LocalDate getDate(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return TemporalAccessorPicker.getLocalDate(temporalAccessor);
    }

    private static LocalDate getLocalDate(TemporalAccessor dateTime) {
        if (dateTime == null) {
            return null;
        }
        LocalDate date = dateTime.query(TemporalQueries.localDate());
        if (date != null) {
            return date;
        }
        try {
            return YearMonth.from(dateTime).atDay(1);
        }
        catch (DateTimeException exception) {
            return Year.from(dateTime).atDay(1);
        }
    }

    public final ObjectProperty<StringConverter<TemporalAccessor>> stringConverterProperty() {
        return this.converter;
    }

    public final StringConverter<TemporalAccessor> getStringConverter() {
        StringConverter<TemporalAccessor> newConverter = new StringConverter<TemporalAccessor>(){

            public String toString(TemporalAccessor value) {
                return TemporalAccessorPicker.this.defaultFormatter.format(value);
            }

            public TemporalAccessor fromString(String value) {
                if (StringUtil.isNotBlank(value)) {
                    try {
                        return TemporalAccessorPicker.this.defaultFormatter.parse(value);
                    }
                    catch (DateTimeParseException exception) {
                        return Date.parse(value).map(Date::toTemporalAccessor).orElse(null);
                    }
                }
                return null;
            }
        };
        return Objects.requireNonNullElseGet((StringConverter)this.stringConverterProperty().get(), () -> TemporalAccessorPicker.lambda$getStringConverter$1((StringConverter)newConverter));
    }

    public final void setStringConverter(StringConverter<TemporalAccessor> value) {
        this.stringConverterProperty().set(value);
    }

    public TemporalAccessor getTemporalAccessorValue() {
        return (TemporalAccessor)this.temporalAccessorValue.get();
    }

    public void setTemporalAccessorValue(TemporalAccessor temporalAccessorValue) {
        this.temporalAccessorValue.set((Object)temporalAccessorValue);
    }

    public ObjectProperty<TemporalAccessor> temporalAccessorValueProperty() {
        return this.temporalAccessorValue;
    }

    private static /* synthetic */ StringConverter lambda$getStringConverter$1(StringConverter newConverter) {
        return newConverter;
    }

    private class InternalConverter
    extends StringConverter<LocalDate> {
        private InternalConverter() {
        }

        public String toString(LocalDate object) {
            TemporalAccessor value = TemporalAccessorPicker.this.getTemporalAccessorValue();
            return value != null ? TemporalAccessorPicker.this.getStringConverter().toString((Object)value) : TemporalAccessorPicker.this.getEditor().getText();
        }

        public LocalDate fromString(String value) {
            if (value == null || value.isEmpty()) {
                TemporalAccessorPicker.this.temporalAccessorValue.set(null);
                return null;
            }
            TemporalAccessor dateTime = (TemporalAccessor)TemporalAccessorPicker.this.getStringConverter().fromString(value);
            TemporalAccessorPicker.this.temporalAccessorValue.set((Object)dateTime);
            return TemporalAccessorPicker.getLocalDate(dateTime);
        }
    }
}

