/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import javafx.animation.Transition;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.jabref.logic.l10n.Localization;

public class TextFlowLimited
extends TextFlow {
    private boolean isCollapsed = true;
    private Hyperlink moreLink = new Hyperlink(Localization.lang("(more)", new Object[0]));
    private Rectangle clip = new Rectangle();

    public TextFlowLimited(Text ... texts) {
        super((Node[])texts);
        this.setPrefWidth(Double.NEGATIVE_INFINITY);
        this.moreLink.setOnAction(event -> this.expand());
        this.moreLink.setStyle("-fx-background-color: white");
        this.setOnMouseClicked(event -> this.expand());
    }

    private void expand() {
        final double newPrefHeight = super.computePrefHeight(this.getWidth());
        Transition expandPanel = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)200.0));
            }

            protected void interpolate(double fraction) {
                TextFlowLimited.this.setPrefHeight(newPrefHeight * fraction);
            }
        };
        expandPanel.setOnFinished(event -> {
            this.isCollapsed = false;
            this.requestLayout();
        });
        expandPanel.play();
    }

    protected double computePrefHeight(double width) {
        if (this.isCollapsed) {
            return 38.0;
        }
        return super.computePrefHeight(width);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.isCollapsed) {
            if (!this.getChildren().contains((Object)this.moreLink)) {
                this.getChildren().add((Object)this.moreLink);
            }
            this.layoutInArea((Node)this.moreLink, 0.0, 0.0, this.getWidth(), this.getHeight(), this.getBaselineOffset(), HPos.RIGHT, VPos.BOTTOM);
            this.clip.setHeight(this.computePrefHeight(this.getWidth()));
            this.clip.setWidth(this.getWidth());
            this.setClip((Node)this.clip);
        } else {
            this.getChildren().remove((Object)this.moreLink);
            this.setClip(null);
        }
    }
}

