/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import java.util.Collections;
import java.util.List;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoableRemoveEntries
extends AbstractUndoableJabRefEdit {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoableRemoveEntries.class);
    private final BibDatabase base;
    private final List<BibEntry> entries;
    private final boolean cut;

    public UndoableRemoveEntries(BibDatabase base, BibEntry entry) {
        this(base, Collections.singletonList(entry));
    }

    public UndoableRemoveEntries(BibDatabase base, List<BibEntry> entries) {
        this(base, entries, false);
    }

    public UndoableRemoveEntries(BibDatabase base, List<BibEntry> entries, boolean cut) {
        this.base = base;
        this.entries = entries;
        this.cut = cut;
    }

    @Override
    public String getPresentationName() {
        if (this.cut) {
            if (this.entries.size() > 1) {
                return Localization.lang("cut entries", new Object[0]);
            }
            if (this.entries.size() == 1) {
                return Localization.lang("cut entry %0", StringUtil.boldHTML(this.entries.getFirst().getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
            }
            return null;
        }
        if (this.entries.size() > 1) {
            return Localization.lang("remove entries", new Object[0]);
        }
        if (this.entries.size() == 1) {
            return Localization.lang("remove entry %0", StringUtil.boldHTML(this.entries.getFirst().getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
        }
        return null;
    }

    @Override
    public void undo() {
        super.undo();
        this.base.insertEntries(this.entries, EntriesEventSource.UNDO);
    }

    @Override
    public void redo() {
        super.redo();
        try {
            this.base.removeEntries(this.entries);
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem to redo `remove entries`", ex);
        }
    }
}

