/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.specialfields.SpecialFieldAction;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.SpecialFieldValue;
import org.jabref.preferences.PreferencesService;

public class SpecialFieldViewModel {
    private final SpecialField field;
    private final PreferencesService preferencesService;
    private final UndoManager undoManager;

    public SpecialFieldViewModel(SpecialField field, PreferencesService preferencesService, UndoManager undoManager) {
        this.field = Objects.requireNonNull(field);
        this.preferencesService = Objects.requireNonNull(preferencesService);
        this.undoManager = Objects.requireNonNull(undoManager);
    }

    public SpecialField getField() {
        return this.field;
    }

    public SpecialFieldAction getSpecialFieldAction(SpecialFieldValue value, Supplier<LibraryTab> tabSupplier, DialogService dialogService, StateManager stateManager) {
        return new SpecialFieldAction(tabSupplier, this.field, value.getFieldValue().orElse(null), this.field.getValues().size() == 1, this.getLocalization(), dialogService, this.preferencesService, this.undoManager, stateManager);
    }

    public JabRefIcon getIcon() {
        return this.getAction().getIcon().get();
    }

    public String getLocalization() {
        return this.getAction().getText();
    }

    public Action getAction() {
        return switch (this.field) {
            default -> throw new MatchException(null, null);
            case SpecialField.PRINTED -> StandardActions.PRINTED;
            case SpecialField.PRIORITY -> StandardActions.PRIORITY;
            case SpecialField.QUALITY -> StandardActions.QUALITY;
            case SpecialField.RANKING -> StandardActions.RANKING;
            case SpecialField.READ_STATUS -> StandardActions.READ_STATUS;
            case SpecialField.RELEVANCE -> StandardActions.RELEVANCE;
        };
    }

    public JabRefIcon getEmptyIcon() {
        return this.getIcon();
    }

    public List<SpecialFieldValueViewModel> getValues() {
        return this.field.getValues().stream().map(SpecialFieldValueViewModel::new).collect(Collectors.toList());
    }

    public void setSpecialFieldValue(BibEntry bibEntry, SpecialFieldValue value) {
        Optional<FieldChange> change = UpdateField.updateField(bibEntry, this.getField(), value.getFieldValue().orElse(null), this.getField().isSingleValueField());
        change.ifPresent(fieldChange -> this.undoManager.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
    }

    public void toggle(BibEntry entry) {
        this.setSpecialFieldValue(entry, this.getField().getValues().getFirst());
    }
}

