/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationSettings;
import org.jabref.gui.push.PushToEmacsSettings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PushToApplicationPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToEmacs
extends AbstractPushToApplication {
    public static final String NAME = "Emacs";
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToEmacs.class);

    public PushToEmacs(DialogService dialogService, PreferencesService preferencesService) {
        super(dialogService, preferencesService);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_EMACS;
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keys) {
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        PushToApplicationPreferences pushToApplicationPreferences = this.preferencesService.getPushToApplicationPreferences();
        this.commandPath = (String)pushToApplicationPreferences.getCommandPaths().get((Object)this.getDisplayName());
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        this.commandPath = (String)pushToApplicationPreferences.getCommandPaths().get((Object)this.getDisplayName());
        String[] addParams = pushToApplicationPreferences.getEmacsArguments().split(" ");
        try {
            String[] com = new String[addParams.length + 2];
            com[0] = this.commandPath;
            System.arraycopy(addParams, 0, com, 1, addParams.length);
            String prefix = "(with-current-buffer (window-buffer (selected-window)) (insert ";
            String suffix = "))";
            com[com.length - 1] = OS.WINDOWS ? prefix.concat("\"" + this.getCitePrefix().replace("\\", "\\\\") + keys + this.getCiteSuffix().replace("\\", "\\\\") + "\"").concat(suffix).replace("\"", "\\\"") : prefix.concat("\"" + this.getCitePrefix().replace("\\", "\\\\") + keys + this.getCiteSuffix().replace("\\", "\\\\") + "\"").concat(suffix);
            LOGGER.atDebug().setMessage("Executing command {}").addArgument(() -> Arrays.toString(com)).log();
            Process p = Runtime.getRuntime().exec(com);
            HeadlessExecutorService.INSTANCE.executeAndWait(() -> {
                try (InputStream out = p.getErrorStream();){
                    StringBuilder sb = new StringBuilder();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not read from stderr.", (Throwable)e);
                    }
                    if (!sb.toString().trim().isEmpty()) {
                        LOGGER.warn("Push to Emacs error: {}", (Object)sb);
                        this.couldNotPush = true;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Error handling std streams", (Throwable)e);
                }
            });
        }
        catch (IOException excep) {
            LOGGER.warn("Problem pushing to Emacs.", (Throwable)excep);
            this.couldNotCall = true;
        }
    }

    @Override
    public void onOperationCompleted() {
        if (this.couldNotPush) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not push to a running emacs daemon.", new Object[0]));
        } else if (this.couldNotCall) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not run the emacs client.", new Object[0]));
        } else {
            super.onOperationCompleted();
        }
    }

    @Override
    protected String getCommandName() {
        return "gnuclient " + Localization.lang("or", new Object[0]) + " emacsclient";
    }

    @Override
    public PushToApplicationSettings getSettings(PushToApplication application, PushToApplicationPreferences preferences) {
        return new PushToEmacsSettings(application, this.dialogService, this.preferencesService.getFilePreferences(), preferences);
    }
}

