/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.input.Dragboard;
import javafx.scene.paint.Color;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.StateManager;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.DroppingMouseLocation;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.groups.LastNameGroup;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;

public class GroupNodeViewModel {
    private final String displayName;
    private final boolean isRoot;
    private final ObservableList<GroupNodeViewModel> children;
    private final BibDatabaseContext databaseContext;
    private final StateManager stateManager;
    private final GroupTreeNode groupNode;
    private final ObservableList<BibEntry> matchedEntries = FXCollections.observableArrayList();
    private final SimpleBooleanProperty hasChildren;
    private final SimpleBooleanProperty expandedProperty = new SimpleBooleanProperty();
    private final BooleanBinding anySelectedEntriesMatched;
    private final BooleanBinding allSelectedEntriesMatched;
    private final TaskExecutor taskExecutor;
    private final CustomLocalDragboard localDragBoard;
    private final ObservableList<BibEntry> entriesList;
    private final PreferencesService preferencesService;
    private final InvalidationListener onInvalidatedGroup = listener -> this.refreshGroup();

    public GroupNodeViewModel(BibDatabaseContext databaseContext, StateManager stateManager, TaskExecutor taskExecutor, GroupTreeNode groupNode, CustomLocalDragboard localDragBoard, PreferencesService preferencesService) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.stateManager = Objects.requireNonNull(stateManager);
        this.groupNode = Objects.requireNonNull(groupNode);
        this.localDragBoard = Objects.requireNonNull(localDragBoard);
        this.preferencesService = preferencesService;
        this.displayName = new LatexToUnicodeFormatter().format(groupNode.getName());
        this.isRoot = groupNode.isRoot();
        AbstractGroup abstractGroup = groupNode.getGroup();
        if (abstractGroup instanceof AutomaticGroup) {
            AutomaticGroup automaticGroup = (AutomaticGroup)abstractGroup;
            this.children = automaticGroup.createSubgroups(this.databaseContext.getDatabase().getEntries()).stream().map(this::toViewModel).sorted((group1, group2) -> group1.getDisplayName().compareToIgnoreCase(group2.getDisplayName())).collect(Collectors.toCollection(FXCollections::observableArrayList));
        } else {
            this.children = EasyBind.mapBacked(groupNode.getChildren(), this::toViewModel);
        }
        if (groupNode.getGroup() instanceof TexGroup) {
            databaseContext.getMetaData().groupsBinding().addListener((InvalidationListener)new WeakInvalidationListener(this.onInvalidatedGroup));
        }
        this.hasChildren = new SimpleBooleanProperty();
        this.hasChildren.bind((ObservableValue)Bindings.isNotEmpty(this.children));
        EasyBind.subscribe((ObservableValue)preferencesService.getGroupsPreferences().displayGroupCountProperty(), shouldDisplay -> this.updateMatchedEntries());
        this.expandedProperty.set(groupNode.getGroup().isExpanded());
        this.expandedProperty.addListener((observable, oldValue, newValue) -> groupNode.getGroup().setExpanded((boolean)newValue));
        this.entriesList = databaseContext.getDatabase().getEntries();
        this.entriesList.addListener(this::onDatabaseChanged);
        EasyObservableList selectedEntriesMatchStatus = EasyBind.map(stateManager.getSelectedEntries(), groupNode::matches);
        this.anySelectedEntriesMatched = selectedEntriesMatchStatus.anyMatch(matched -> matched);
        this.allSelectedEntriesMatched = selectedEntriesMatchStatus.isEmptyBinding().not().and((ObservableBooleanValue)selectedEntriesMatchStatus.allMatch(matched -> matched));
    }

    public GroupNodeViewModel(BibDatabaseContext databaseContext, StateManager stateManager, TaskExecutor taskExecutor, AbstractGroup group, CustomLocalDragboard localDragboard, PreferencesService preferencesService) {
        this(databaseContext, stateManager, taskExecutor, new GroupTreeNode(group), localDragboard, preferencesService);
    }

    static GroupNodeViewModel getAllEntriesGroup(BibDatabaseContext newDatabase, StateManager stateManager, TaskExecutor taskExecutor, CustomLocalDragboard localDragBoard, PreferencesService preferencesService) {
        return new GroupNodeViewModel(newDatabase, stateManager, taskExecutor, DefaultGroupsFactory.getAllEntriesGroup(), localDragBoard, preferencesService);
    }

    private GroupNodeViewModel toViewModel(GroupTreeNode child) {
        return new GroupNodeViewModel(this.databaseContext, this.stateManager, this.taskExecutor, child, this.localDragBoard, this.preferencesService);
    }

    public List<FieldChange> addEntriesToGroup(List<BibEntry> entries) {
        List<FieldChange> changes = this.groupNode.addEntriesToGroup(entries);
        this.anySelectedEntriesMatched.invalidate();
        this.allSelectedEntriesMatched.invalidate();
        return changes;
    }

    public SimpleBooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public BooleanBinding anySelectedEntriesMatchedProperty() {
        return this.anySelectedEntriesMatched;
    }

    public BooleanBinding allSelectedEntriesMatchedProperty() {
        return this.allSelectedEntriesMatched;
    }

    public SimpleBooleanProperty hasChildrenProperty() {
        return this.hasChildren;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getDescription() {
        return this.groupNode.getGroup().getDescription().orElse("");
    }

    public IntegerBinding getHits() {
        return Bindings.size(this.matchedEntries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupNodeViewModel that = (GroupNodeViewModel)o;
        return this.groupNode.equals(that.groupNode);
    }

    public String toString() {
        return "GroupNodeViewModel{displayName='" + this.displayName + "', isRoot=" + this.isRoot + ", icon='" + String.valueOf(this.getIcon()) + "', children=" + String.valueOf(this.children) + ", databaseContext=" + String.valueOf(this.databaseContext) + ", groupNode=" + String.valueOf(this.groupNode) + ", matchedEntries=" + String.valueOf(this.matchedEntries) + "}";
    }

    public int hashCode() {
        return this.groupNode.hashCode();
    }

    public JabRefIcon getIcon() {
        Optional<String> iconName = this.groupNode.getGroup().getIconName();
        return iconName.flatMap(this::parseIcon).orElseGet(this::createDefaultIcon);
    }

    private JabRefIcon createDefaultIcon() {
        Color color = this.groupNode.getGroup().getColor().orElse(IconTheme.getDefaultGroupColor());
        return IconTheme.JabRefIcons.DEFAULT_GROUP_ICON_COLORED.withColor(color);
    }

    private Optional<JabRefIcon> parseIcon(String iconCode) {
        return IconTheme.findIcon(iconCode, this.getColor());
    }

    public ObservableList<GroupNodeViewModel> getChildren() {
        return this.children;
    }

    public GroupTreeNode getGroupNode() {
        return this.groupNode;
    }

    private void onDatabaseChanged(ListChangeListener.Change<? extends BibEntry> change) {
        while (change.next()) {
            if (change.wasPermutated()) continue;
            if (change.wasUpdated()) {
                for (BibEntry changedEntry : change.getList().subList(change.getFrom(), change.getTo())) {
                    if (this.groupNode.matches(changedEntry)) {
                        if (this.matchedEntries.contains((Object)changedEntry)) continue;
                        this.matchedEntries.add((Object)changedEntry);
                        continue;
                    }
                    this.matchedEntries.remove((Object)changedEntry);
                }
                continue;
            }
            for (BibEntry removedEntry : change.getRemoved()) {
                this.matchedEntries.remove((Object)removedEntry);
            }
            for (BibEntry addedEntry : change.getAddedSubList()) {
                if (!this.groupNode.matches(addedEntry) || this.matchedEntries.contains((Object)addedEntry)) continue;
                this.matchedEntries.add((Object)addedEntry);
            }
        }
    }

    private void refreshGroup() {
        UiTaskExecutor.runInJavaFXThread(() -> {
            this.updateMatchedEntries();
            ObservableList<GroupTreeNode> selectedGroups = this.stateManager.getSelectedGroups(this.databaseContext);
            if (selectedGroups.remove((Object)this.groupNode)) {
                selectedGroups.add((Object)this.groupNode);
            }
        });
    }

    private void updateMatchedEntries() {
        if (this.preferencesService.getGroupsPreferences().shouldDisplayGroupCount()) {
            BackgroundTask.wrap(() -> this.groupNode.findMatches(this.databaseContext.getDatabase())).onSuccess(entries -> {
                this.matchedEntries.clear();
                this.matchedEntries.addAll((Collection)entries);
            }).executeWith(this.taskExecutor);
        }
    }

    public GroupTreeNode addSubgroup(AbstractGroup subgroup) {
        return this.groupNode.addSubgroup(subgroup);
    }

    void toggleExpansion() {
        this.expandedProperty().set(!this.expandedProperty().get());
    }

    boolean isMatchedBy(String searchString) {
        return StringUtil.isBlank(searchString) || StringUtil.containsIgnoreCase(this.getDisplayName(), searchString);
    }

    public Color getColor() {
        return this.groupNode.getGroup().getColor().orElse(IconTheme.getDefaultGroupColor());
    }

    public String getPath() {
        return this.groupNode.getPath();
    }

    public Optional<GroupNodeViewModel> getChildByPath(String pathToSource) {
        return this.groupNode.getChildByPath(pathToSource).map(this::toViewModel);
    }

    public boolean acceptableDrop(Dragboard dragboard) {
        boolean canDropOtherGroup = dragboard.hasContent(DragAndDropDataFormats.GROUP);
        boolean canDropEntries = this.localDragBoard.hasBibEntries() && this.groupNode.getGroup() instanceof GroupEntryChanger;
        return canDropOtherGroup || canDropEntries;
    }

    public void moveTo(GroupNodeViewModel target) {
        this.getGroupNode().moveTo(target.getGroupNode());
    }

    public void moveTo(GroupTreeNode target, int targetIndex) {
        this.getGroupNode().moveTo(target, targetIndex);
    }

    public Optional<GroupTreeNode> getParent() {
        return this.groupNode.getParent();
    }

    public void draggedOn(GroupNodeViewModel target, DroppingMouseLocation mouseLocation) {
        if (this.equals(target)) {
            return;
        }
        Optional<GroupTreeNode> targetParent = target.getParent();
        if (targetParent.isPresent()) {
            int sourceIndex;
            int targetIndex = target.getPositionInParent();
            if (targetParent.equals(this.getParent()) && (sourceIndex = this.getPositionInParent()) < targetIndex) {
                --targetIndex;
            }
            switch (mouseLocation) {
                case BOTTOM: {
                    this.moveTo(targetParent.get(), targetIndex + 1);
                    break;
                }
                case CENTER: {
                    this.moveTo(target);
                    break;
                }
                case TOP: {
                    this.moveTo(targetParent.get(), targetIndex);
                }
            }
        } else {
            this.moveTo(target);
        }
    }

    private int getPositionInParent() {
        return this.groupNode.getPositionInParent();
    }

    public boolean hasSubgroups() {
        return !this.getChildren().isEmpty();
    }

    public boolean canAddEntriesIn() {
        AbstractGroup group = this.groupNode.getGroup();
        if (group instanceof AllEntriesGroup) {
            return false;
        }
        if (group instanceof ExplicitGroup) {
            return true;
        }
        if (group instanceof LastNameGroup || group instanceof RegexKeywordGroup) {
            return this.groupNode.getParent().map(parent -> parent.getGroup()).map(groupParent -> groupParent instanceof AutomaticKeywordGroup || groupParent instanceof AutomaticPersonsGroup).orElse(false);
        }
        if (group instanceof KeywordGroup) {
            return true;
        }
        if (group instanceof SearchGroup) {
            return false;
        }
        if (group instanceof AutomaticKeywordGroup) {
            return false;
        }
        if (group instanceof AutomaticPersonsGroup) {
            return false;
        }
        if (group instanceof TexGroup) {
            return false;
        }
        throw new UnsupportedOperationException("canAddEntriesIn method not yet implemented in group: " + group.getClass().getName());
    }

    public boolean canBeDragged() {
        AbstractGroup group = this.groupNode.getGroup();
        if (group instanceof AllEntriesGroup) {
            return false;
        }
        if (group instanceof ExplicitGroup) {
            return true;
        }
        if (group instanceof KeywordGroup) {
            return this.groupNode.getParent().map(parent -> parent.getGroup()).map(groupParent -> !(groupParent instanceof AutomaticKeywordGroup) && !(groupParent instanceof AutomaticPersonsGroup)).orElse(false);
        }
        if (group instanceof SearchGroup) {
            return true;
        }
        if (group instanceof AutomaticKeywordGroup) {
            return true;
        }
        if (group instanceof AutomaticPersonsGroup) {
            return true;
        }
        if (group instanceof TexGroup) {
            return true;
        }
        throw new UnsupportedOperationException("canBeDragged method not yet implemented in group: " + group.getClass().getName());
    }

    public boolean canAddGroupsIn() {
        AbstractGroup group = this.groupNode.getGroup();
        if (group instanceof AllEntriesGroup) {
            return true;
        }
        if (group instanceof ExplicitGroup) {
            return true;
        }
        if (group instanceof KeywordGroup) {
            return this.groupNode.getParent().map(parent -> parent.getGroup()).map(groupParent -> !(groupParent instanceof AutomaticKeywordGroup) && !(groupParent instanceof AutomaticPersonsGroup)).orElse(false);
        }
        if (group instanceof SearchGroup) {
            return true;
        }
        if (group instanceof AutomaticKeywordGroup) {
            return false;
        }
        if (group instanceof AutomaticPersonsGroup) {
            return false;
        }
        if (group instanceof TexGroup) {
            return true;
        }
        throw new UnsupportedOperationException("canAddGroupsIn method not yet implemented in group: " + group.getClass().getName());
    }

    public boolean canRemove() {
        AbstractGroup group = this.groupNode.getGroup();
        if (group instanceof AllEntriesGroup) {
            return false;
        }
        if (group instanceof ExplicitGroup) {
            return true;
        }
        if (group instanceof KeywordGroup) {
            return this.groupNode.getParent().map(parent -> parent.getGroup()).map(groupParent -> !(groupParent instanceof AutomaticKeywordGroup) && !(groupParent instanceof AutomaticPersonsGroup)).orElse(false);
        }
        if (group instanceof SearchGroup) {
            return true;
        }
        if (group instanceof AutomaticKeywordGroup) {
            return true;
        }
        if (group instanceof AutomaticPersonsGroup) {
            return true;
        }
        if (group instanceof TexGroup) {
            return true;
        }
        throw new UnsupportedOperationException("canRemove method not yet implemented in group: " + group.getClass().getName());
    }

    public boolean isEditable() {
        AbstractGroup group = this.groupNode.getGroup();
        if (group instanceof AllEntriesGroup) {
            return false;
        }
        if (group instanceof ExplicitGroup) {
            return true;
        }
        if (group instanceof KeywordGroup) {
            return this.groupNode.getParent().map(parent -> parent.getGroup()).map(groupParent -> !(groupParent instanceof AutomaticKeywordGroup) && !(groupParent instanceof AutomaticPersonsGroup)).orElse(false);
        }
        if (group instanceof SearchGroup) {
            return true;
        }
        if (group instanceof AutomaticKeywordGroup) {
            return true;
        }
        if (group instanceof AutomaticPersonsGroup) {
            return true;
        }
        if (group instanceof TexGroup) {
            return true;
        }
        throw new UnsupportedOperationException("isEditable method not yet implemented in group: " + group.getClass().getName());
    }
}

