/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.List;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.ContentSelectorSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.fieldeditors.CitationKeyEditor;
import org.jabref.gui.fieldeditors.DateEditor;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.GroupEditor;
import org.jabref.gui.fieldeditors.ISSNEditor;
import org.jabref.gui.fieldeditors.JournalEditor;
import org.jabref.gui.fieldeditors.KeywordsEditor;
import org.jabref.gui.fieldeditors.LinkedEntriesEditor;
import org.jabref.gui.fieldeditors.LinkedFilesEditor;
import org.jabref.gui.fieldeditors.MarkdownEditor;
import org.jabref.gui.fieldeditors.OwnerEditor;
import org.jabref.gui.fieldeditors.PersonsEditor;
import org.jabref.gui.fieldeditors.SimpleEditor;
import org.jabref.gui.fieldeditors.UrlEditor;
import org.jabref.gui.fieldeditors.identifier.IdentifierEditor;
import org.jabref.gui.fieldeditors.optioneditors.MonthEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.OptionEditor;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.CustomFieldEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.EditorTypeEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.GenderEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.PaginationEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.PatentTypeEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.TypeEditorViewModel;
import org.jabref.gui.fieldeditors.optioneditors.mapbased.YesNoEditorViewModel;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.metadata.MetaData;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldEditors {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldEditors.class);

    public static FieldEditorFX getForField(Field field, TaskExecutor taskExecutor, DialogService dialogService, JournalAbbreviationRepository journalAbbreviationRepository, PreferencesService preferences, BibDatabaseContext databaseContext, EntryType entryType, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction) {
        EnumSet<FieldProperty> fieldProperties = field.getProperties();
        SuggestionProvider<?> suggestionProvider = FieldEditors.getSuggestionProvider(field, suggestionProviders, databaseContext.getMetaData());
        FieldCheckers fieldCheckers = new FieldCheckers(databaseContext, preferences.getFilePreferences(), journalAbbreviationRepository, preferences.getEntryEditorPreferences().shouldAllowIntegerEditionBibtex());
        boolean isMultiLine = FieldFactory.isMultiLineField(field, preferences.getFieldPreferences().getNonWrappableFields());
        if (preferences.getTimestampPreferences().getTimestampField().equals(field)) {
            return new DateEditor(field, DateTimeFormatter.ofPattern(preferences.getTimestampPreferences().getTimestampFormat()), suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (fieldProperties.contains((Object)FieldProperty.DATE)) {
            return new DateEditor(field, DateTimeFormatter.ofPattern("[uuuu][-MM][-dd]"), suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (fieldProperties.contains((Object)FieldProperty.EXTERNAL)) {
            return new UrlEditor(field, suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (fieldProperties.contains((Object)FieldProperty.JOURNAL_NAME)) {
            return new JournalEditor(field, suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (fieldProperties.contains((Object)FieldProperty.IDENTIFIER) && field != StandardField.PMID || field == StandardField.ISBN) {
            return new IdentifierEditor(field, suggestionProvider, fieldCheckers);
        }
        if (field == StandardField.ISSN) {
            return new ISSNEditor(field, suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (field == StandardField.OWNER) {
            return new OwnerEditor(field, suggestionProvider, fieldCheckers, undoAction, redoAction);
        }
        if (field == StandardField.GROUPS) {
            return new GroupEditor(field, suggestionProvider, fieldCheckers, preferences, isMultiLine, undoManager, undoAction, redoAction);
        }
        if (field == StandardField.FILE) {
            return new LinkedFilesEditor(field, databaseContext, suggestionProvider, fieldCheckers);
        }
        if (fieldProperties.contains((Object)FieldProperty.YES_NO)) {
            return new OptionEditor<String>(new YesNoEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
        }
        if (fieldProperties.contains((Object)FieldProperty.MONTH)) {
            return new OptionEditor<Month>(new MonthEditorViewModel(field, suggestionProvider, databaseContext.getMode(), fieldCheckers, undoManager));
        }
        if (field == StandardField.GENDER) {
            return new OptionEditor<String>(new GenderEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
        }
        if (fieldProperties.contains((Object)FieldProperty.EDITOR_TYPE)) {
            return new OptionEditor<String>(new EditorTypeEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
        }
        if (fieldProperties.contains((Object)FieldProperty.PAGINATION)) {
            return new OptionEditor<String>(new PaginationEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
        }
        if (field == StandardField.TYPE) {
            if (entryType.equals(IEEETranEntryType.Patent)) {
                return new OptionEditor<String>(new PatentTypeEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
            }
            return new OptionEditor<String>(new TypeEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager));
        }
        if (fieldProperties.contains((Object)FieldProperty.SINGLE_ENTRY_LINK) || fieldProperties.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) {
            return new LinkedEntriesEditor(field, databaseContext, suggestionProvider, fieldCheckers);
        }
        if (fieldProperties.contains((Object)FieldProperty.PERSON_NAMES)) {
            return new PersonsEditor(field, suggestionProvider, fieldCheckers, isMultiLine, undoManager, undoAction, redoAction);
        }
        if (StandardField.KEYWORDS == field) {
            return new KeywordsEditor(field, suggestionProvider, fieldCheckers);
        }
        if (field == InternalField.KEY_FIELD) {
            return new CitationKeyEditor(field, suggestionProvider, fieldCheckers, databaseContext, undoAction, redoAction);
        }
        if (fieldProperties.contains((Object)FieldProperty.MARKDOWN)) {
            return new MarkdownEditor(field, suggestionProvider, fieldCheckers, preferences, undoManager, undoAction, redoAction);
        }
        List<String> selectorValues = databaseContext.getMetaData().getContentSelectorValuesForField(field);
        if (!isMultiLine && !selectorValues.isEmpty()) {
            return new OptionEditor<String>(new CustomFieldEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager, selectorValues));
        }
        return new SimpleEditor(field, suggestionProvider, fieldCheckers, preferences, isMultiLine, undoManager, undoAction, redoAction);
    }

    private static SuggestionProvider<?> getSuggestionProvider(Field field, SuggestionProviders suggestionProviders, MetaData metaData) {
        SuggestionProvider<String> suggestionProvider = suggestionProviders.getForField(field);
        List<String> contentSelectorValues = metaData.getContentSelectorValuesForField(field);
        if (!contentSelectorValues.isEmpty()) {
            try {
                return new ContentSelectorSuggestionProvider(suggestionProvider, contentSelectorValues);
            }
            catch (ClassCastException exception) {
                LOGGER.error("Content selectors are only supported for normal fields with string-based auto completion.");
                return suggestionProvider;
            }
        }
        return suggestionProvider;
    }
}

