/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.tobiasdiez.easybind.EasyObservableValue;
import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.Collection;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class AbstractEditorViewModel
extends AbstractViewModel {
    protected final Field field;
    protected StringProperty text = new SimpleStringProperty("");
    protected BibEntry entry;
    private final SuggestionProvider<?> suggestionProvider;
    private final UndoManager undoManager;
    private final CompositeValidator fieldValidator;
    private EasyObservableValue<String> fieldBinding;

    public AbstractEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoManager undoManager) {
        this.field = field;
        this.suggestionProvider = suggestionProvider;
        this.undoManager = undoManager;
        this.fieldValidator = new CompositeValidator();
        for (ValueChecker checker : fieldCheckers.getForField(field)) {
            FunctionBasedValidator validator = new FunctionBasedValidator((ObservableValue)this.text, value -> checker.checkValue((String)value).map(ValidationMessage::warning).orElse(null));
            this.fieldValidator.addValidators(new Validator[]{validator});
        }
    }

    public Validator getFieldValidator() {
        return this.fieldValidator;
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void bindToEntry(BibEntry entry) {
        this.entry = entry;
        this.fieldBinding = entry.getFieldBinding(this.field).asOrdinary();
        BindingsHelper.bindBidirectional(this.textProperty(), this.fieldBinding, newValue -> {
            String oldValue;
            if (newValue != null && !newValue.equals(oldValue = (String)entry.getField(this.field).map(value -> value.replace("\r\n", "\n")).orElse(null))) {
                entry.setField(this.field, (String)newValue);
                this.undoManager.addEdit(new UndoableFieldChange(entry, this.field, oldValue, (String)newValue));
            }
        });
    }

    public Collection<?> complete(AutoCompletionBinding.ISuggestionRequest request) {
        return this.suggestionProvider.provideSuggestions(request);
    }
}

