/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.jabref.gui.externalfiletype.CustomExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.StandardExternalFileType;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.FilePreferences;

public class ExternalFileTypes {
    private static final String FILE_TYPE_REMOVED_FLAG = "REMOVED";
    private static final ExternalFileType HTML_FALLBACK_TYPE = StandardExternalFileType.URL;

    private ExternalFileTypes() {
    }

    public static List<ExternalFileType> getDefaultExternalFileTypes() {
        return Arrays.asList(StandardExternalFileType.values());
    }

    public static Optional<ExternalFileType> getExternalFileTypeByName(String name, FilePreferences filePreferences) {
        Optional<ExternalFileType> externalFileType = filePreferences.getExternalFileTypes().stream().filter(type -> type.getName().equals(name)).findFirst();
        if (externalFileType.isPresent()) {
            return externalFileType;
        }
        return Optional.of(new UnknownExternalFileType(name));
    }

    public static Optional<ExternalFileType> getExternalFileTypeByExt(String extension, FilePreferences filePreferences) {
        String extensionCleaned = extension.replace(".", "").replace("*", "");
        return filePreferences.getExternalFileTypes().stream().filter(type -> type.getExtension().equalsIgnoreCase(extensionCleaned)).findFirst();
    }

    public static boolean isExternalFileTypeByExt(String extension, FilePreferences filePreferences) {
        return filePreferences.getExternalFileTypes().stream().anyMatch(type -> type.getExtension().equalsIgnoreCase(extension));
    }

    public static Optional<ExternalFileType> getExternalFileTypeForName(String filename, FilePreferences filePreferences) {
        int longestFound = -1;
        ExternalFileType foundType = null;
        for (ExternalFileType type : filePreferences.getExternalFileTypes()) {
            if (type.getExtension().isEmpty() || !filename.toLowerCase(Locale.ROOT).endsWith(type.getExtension().toLowerCase(Locale.ROOT)) || type.getExtension().length() <= longestFound) continue;
            longestFound = type.getExtension().length();
            foundType = type;
        }
        return Optional.ofNullable(foundType);
    }

    public static Optional<ExternalFileType> getExternalFileTypeByMimeType(String mimeType, FilePreferences filePreferences) {
        if (mimeType.indexOf(59) != -1) {
            mimeType = mimeType.substring(0, mimeType.indexOf(59)).trim();
        }
        for (ExternalFileType type : filePreferences.getExternalFileTypes()) {
            if (!type.getMimeType().equalsIgnoreCase(mimeType)) continue;
            return Optional.of(type);
        }
        if ("text/html".equalsIgnoreCase(mimeType)) {
            return Optional.of(HTML_FALLBACK_TYPE);
        }
        return Optional.empty();
    }

    public static Optional<ExternalFileType> getExternalFileTypeByFile(Path file, FilePreferences filePreferences) {
        String filePath = file.toString();
        Optional<String> extension = FileUtil.getFileExtension(filePath);
        return extension.flatMap(ext -> ExternalFileTypes.getExternalFileTypeByExt(ext, filePreferences));
    }

    public static Optional<ExternalFileType> getExternalFileTypeByLinkedFile(LinkedFile linkedFile, boolean deduceUnknownType, FilePreferences filePreferences) {
        boolean isUnknownType;
        Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByName(linkedFile.getFileType(), filePreferences);
        boolean bl = isUnknownType = type.isEmpty() || type.get() instanceof UnknownExternalFileType;
        if (isUnknownType && deduceUnknownType) {
            Optional<ExternalFileType> mimeType = ExternalFileTypes.getExternalFileTypeByMimeType(linkedFile.getFileType(), filePreferences);
            if (mimeType.isPresent()) {
                return mimeType;
            }
            return FileUtil.getFileExtension(linkedFile.getLink()).flatMap(extension -> ExternalFileTypes.getExternalFileTypeByExt(extension, filePreferences));
        }
        return type;
    }

    public static String toStringList(Collection<ExternalFileType> fileTypes) {
        ArrayList<ExternalFileType> defTypes = new ArrayList<ExternalFileType>(ExternalFileTypes.getDefaultExternalFileTypes());
        ArrayList<ExternalFileType> unchanged = new ArrayList<ExternalFileType>();
        ArrayList<ExternalFileType> results = new ArrayList<ExternalFileType>();
        for (ExternalFileType type : fileTypes) {
            results.add(type);
            Object found = null;
            for (ExternalFileType defType : defTypes) {
                if (!defType.getExtension().equals(type.getExtension())) continue;
                found = defType;
                break;
            }
            if (found == null) continue;
            if (found.equals(type)) {
                unchanged.add(type);
                continue;
            }
            defTypes.remove(found);
        }
        for (ExternalFileType type : unchanged) {
            defTypes.remove(type);
            results.remove(type);
        }
        String[][] array = new String[results.size() + defTypes.size()][];
        int i = 0;
        for (ExternalFileType type : results) {
            array[i] = type.toStringArray();
            ++i;
        }
        for (ExternalFileType type : defTypes) {
            array[i] = new String[]{type.getName(), FILE_TYPE_REMOVED_FLAG};
            ++i;
        }
        return FileFieldWriter.encodeStringArray(array);
    }

    public static Set<ExternalFileType> fromString(String storedFileTypes) {
        String[][] vals;
        HashSet<ExternalFileType> types = new HashSet<ExternalFileType>(ExternalFileTypes.getDefaultExternalFileTypes());
        if (StringUtil.isBlank(storedFileTypes)) {
            return types;
        }
        for (String[] val : vals = StringUtil.decodeStringDoubleArray(storedFileTypes)) {
            if (val.length == 2 && val[1].equals(FILE_TYPE_REMOVED_FLAG)) {
                ExternalFileType toRemove = null;
                for (ExternalFileType type : types) {
                    if (!type.getName().equals(val[0])) continue;
                    toRemove = type;
                    break;
                }
                if (toRemove == null) continue;
                types.remove(toRemove);
                continue;
            }
            ExternalFileType type = CustomExternalFileType.buildFromArgs(val);
            ExternalFileType toRemove = null;
            for (ExternalFileType defType : types) {
                if (!type.getExtension().equals(defType.getExtension())) continue;
                toRemove = defType;
                break;
            }
            if (toRemove != null) {
                types.remove(toRemove);
            }
            types.add(type);
        }
        return types;
    }
}

