/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationViewModel;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.pdf.FileAnnotation;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnnotationTabViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnnotationTabViewModel.class);
    private final ListProperty<FileAnnotationViewModel> annotations = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<Path> files = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<FileAnnotationViewModel> currentAnnotation = new SimpleObjectProperty();
    private final ReadOnlyBooleanProperty annotationEmpty = this.annotations.emptyProperty();
    private final FileAnnotationCache cache;
    private final BibEntry entry;
    private Map<Path, List<FileAnnotation>> fileAnnotations;
    private Path currentFile;
    private final FileUpdateMonitor fileMonitor;
    private final ClipBoardManager clipBoardManager;
    private final FileUpdateListener fileListener = this::reloadAnnotations;

    public FileAnnotationTabViewModel(FileAnnotationCache cache, BibEntry entry, FileUpdateMonitor fileMonitor, ClipBoardManager clipBoardManager) {
        this.cache = cache;
        this.entry = entry;
        this.fileMonitor = fileMonitor;
        this.clipBoardManager = clipBoardManager;
        this.fileAnnotations = this.cache.getFromCache(this.entry);
        this.files.setAll(this.fileAnnotations.keySet());
    }

    public ObjectProperty<FileAnnotationViewModel> currentAnnotationProperty() {
        return this.currentAnnotation;
    }

    public ReadOnlyBooleanProperty isAnnotationsEmpty() {
        return this.annotationEmpty;
    }

    public ListProperty<FileAnnotationViewModel> annotationsProperty() {
        return this.annotations;
    }

    public ListProperty<Path> filesProperty() {
        return this.files;
    }

    public void notifyNewSelectedAnnotation(FileAnnotationViewModel newAnnotation) {
        this.currentAnnotation.set((Object)newAnnotation);
    }

    public void notifyNewSelectedFile(Path newFile) {
        this.fileMonitor.removeListener(this.currentFile, this.fileListener);
        this.currentFile = newFile;
        Comparator<FileAnnotation> byPage = Comparator.comparingInt(FileAnnotation::getPage);
        List newAnnotations = ((List)this.fileAnnotations.getOrDefault(this.currentFile, new ArrayList())).stream().filter(annotation -> null != annotation.getContent()).sorted(byPage).map(FileAnnotationViewModel::new).collect(Collectors.toList());
        this.annotations.setAll(newAnnotations);
        try {
            this.fileMonitor.addListenerForFile(this.currentFile, this.fileListener);
        }
        catch (IOException e) {
            LOGGER.error("Problem while watching file for changes " + String.valueOf(this.currentFile), (Throwable)e);
        }
    }

    private void reloadAnnotations() {
        UiTaskExecutor.runInJavaFXThread(() -> {
            this.cache.remove(this.entry);
            this.fileAnnotations = this.cache.getFromCache(this.entry);
            this.files.setAll(this.fileAnnotations.keySet());
            this.notifyNewSelectedFile(this.currentFile);
        });
    }

    public void copyCurrentAnnotation() {
        if (null == this.getCurrentAnnotation()) {
            return;
        }
        StringJoiner sj = new StringJoiner("," + OS.NEWLINE);
        sj.add(Localization.lang("Author", new Object[0]) + ": " + this.getCurrentAnnotation().getAuthor());
        sj.add(Localization.lang("Date", new Object[0]) + ": " + this.getCurrentAnnotation().getDate());
        sj.add(Localization.lang("Page", new Object[0]) + ": " + this.getCurrentAnnotation().getPage());
        sj.add(Localization.lang("Content", new Object[0]) + ": " + this.getCurrentAnnotation().getContent());
        sj.add(Localization.lang("Marking", new Object[0]) + ": " + (String)this.getCurrentAnnotation().markingProperty().get());
        this.clipBoardManager.setContent(sj.toString());
    }

    private FileAnnotationViewModel getCurrentAnnotation() {
        return (FileAnnotationViewModel)this.currentAnnotation.get();
    }
}

