/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.cleanup.CleanupDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.cleanup.CleanupWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.PreferencesService;

public class CleanupSingleAction
extends SimpleCommand {
    private final PreferencesService preferences;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final BibEntry entry;
    private final UndoManager undoManager;
    private boolean isCanceled;
    private int modifiedEntriesCount;

    public CleanupSingleAction(BibEntry entry, PreferencesService preferences, DialogService dialogService, StateManager stateManager, UndoManager undoManager) {
        this.entry = entry;
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        this.isCanceled = false;
        CleanupDialog cleanupDialog = new CleanupDialog(this.stateManager.getActiveDatabase().get(), this.preferences.getCleanupPreferences(), this.preferences.getFilePreferences());
        Optional<CleanupPreferences> chosenPreset = this.dialogService.showCustomDialogAndWait(cleanupDialog);
        chosenPreset.ifPresent(preset -> {
            boolean confirmed;
            if (preset.isActive(CleanupPreferences.CleanupStep.RENAME_PDF).booleanValue() && this.preferences.getAutoLinkPreferences().shouldAskAutoNamingPdfs() && !(confirmed = this.dialogService.showConfirmationDialogWithOptOutAndWait(Localization.lang("Autogenerate PDF Names", new Object[0]), Localization.lang("Auto-generating PDF-Names does not support undo. Continue?", new Object[0]), Localization.lang("Autogenerate PDF Names", new Object[0]), Localization.lang("Cancel", new Object[0]), Localization.lang("Do not ask again", new Object[0]), optOut -> this.preferences.getAutoLinkPreferences().setAskAutoNamingPdfs(optOut == false)))) {
                this.isCanceled = true;
                return;
            }
            this.preferences.getCleanupPreferences().setActiveJobs(preset.getActiveJobs());
            this.preferences.getCleanupPreferences().setFieldFormatterCleanups(preset.getFieldFormatterCleanups());
            this.cleanup(this.stateManager.getActiveDatabase().get(), (CleanupPreferences)preset);
        });
    }

    private void doCleanup(BibDatabaseContext databaseContext, CleanupPreferences preset, BibEntry entry, NamedCompound ce) {
        CleanupWorker cleaner = new CleanupWorker(databaseContext, this.preferences.getFilePreferences(), this.preferences.getTimestampPreferences());
        List<FieldChange> changes = cleaner.cleanup(preset, entry);
        for (FieldChange change : changes) {
            ce.addEdit(new UndoableFieldChange(change));
        }
    }

    private void cleanup(BibDatabaseContext databaseContext, CleanupPreferences cleanupPreferences) {
        NamedCompound ce = new NamedCompound(Localization.lang("Cleanup entry", new Object[0]));
        this.doCleanup(databaseContext, cleanupPreferences, this.entry, ce);
        ce.end();
        if (ce.hasEdits()) {
            this.undoManager.addEdit(ce);
        }
    }
}

