//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file ExP02Classes.hh
/// \brief Definition of the ExP02Classes class

#include "ExP02GeoTree.hh"
//
#include "ExP02DetectorConstruction.hh"
//
#include "CLHEP/Geometry/Transform3D.h"
#include "CLHEP/Vector/EulerAngles.h"
#include "CLHEP/Vector/Rotation.h"
#include "CLHEP/Vector/ThreeVector.h"
//
#include "G4Box.hh"
#include "G4Cons.hh"
#include "G4Element.hh"
#include "G4ElementTable.hh"
#include "G4ElementVector.hh"
#include "G4EnclosingCylinder.hh"
#include "G4IntersectingCone.hh"
#include "G4IntersectionSolid.hh"
#include "G4Isotope.hh"
#include "G4LogicalVolume.hh"
#include "G4Material.hh"
#include "G4MaterialCutsCouple.hh"
#include "G4MaterialPropertiesTable.hh"
#include "G4Orb.hh"
#include "G4PVPlacement.hh"
#include "G4Para.hh"
#include "G4PolyPhiFace.hh"
#include "G4Polycone.hh"
#include "G4PolyconeSide.hh"
#include "G4Polyhedra.hh"
#include "G4Polyhedron.hh"
#include "G4ReduciblePolygon.hh"
#include "G4RunManager.hh"
#include "G4Sphere.hh"
#include "G4SubtractionSolid.hh"
#include "G4Torus.hh"
#include "G4Trap.hh"
#include "G4Trd.hh"
#include "G4Tubs.hh"
#include "G4UnionSolid.hh"
#include "G4UserLimits.hh"
#include "G4VCSGfaceted.hh"
#include "G4VPVParameterisation.hh"
#include "G4VSolid.hh"
#include "G4VUserRegionInformation.hh"
#include "G4VisExtent.hh"
//
std::vector<CLHEP::Hep3Vector> g4a;
std::vector<G4VCSGface*> g4b;
std::vector<G4PolyconeSideRZ> g4c;
std::vector<G4PolyPhiFaceEdge> g4d;
std::vector<G4PolyPhiFaceVertex> g4e;
//
#undef __G4String
