#ifndef __CS_MESH_HEADERS_H__
#define __CS_MESH_HEADERS_H__

/*============================================================================
 * Global code_saturne headers file for easier include
 *============================================================================*/

/*
  This file is part of code_saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2023 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*----------------------------------------------------------------------------
 * Local headers
 *----------------------------------------------------------------------------*/

#include "cs_geom.h"
#include "cs_join.h"
#include "cs_join_intersect.h"
#include "cs_join_merge.h"
#include "cs_join_mesh.h"
#include "cs_join_perio.h"
#include "cs_join_post.h"
#include "cs_join_set.h"
#include "cs_join_split.h"
#include "cs_join_update.h"
#include "cs_join_util.h"
#include "cs_mesh.h"
#include "cs_mesh_adjacencies.h"
#include "cs_mesh_bad_cells.h"
#include "cs_mesh_boundary.h"
#include "cs_mesh_boundary_layer.h"
#include "cs_mesh_builder.h"
#include "cs_mesh_cartesian.h"
#include "cs_mesh_coarsen.h"
#include "cs_mesh_coherency.h"
#include "cs_mesh_connect.h"
#include "cs_mesh_extrude.h"
#include "cs_mesh_from_builder.h"
#include "cs_mesh_group.h"
#include "cs_mesh_halo.h"
#include "cs_mesh_intersect.h"
#include "cs_mesh_location.h"
#include "cs_mesh_quality.h"
#include "cs_mesh_quantities.h"
#include "cs_mesh_refine.h"
#include "cs_mesh_remove.h"
#include "cs_mesh_save.h"
#include "cs_mesh_to_builder.h"
#include "cs_mesh_warping.h"
#include "cs_mesh_smoother.h"
#include "cs_partition.h"

/*----------------------------------------------------------------------------*/

#endif /* __CS_MESH_HEADERS_H__ */
