/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;

public interface TermWeightor
extends ToDoubleFunction<Term> {
    public static final TermWeightor DEFAULT = TermWeightor.lengthWeightor(3.0, 0.3f);

    public static TermWeightor combine(TermWeightor ... weightors) {
        return value -> {
            double r = 1.0;
            for (TermWeightor w : weightors) {
                r *= w.applyAsDouble(value);
            }
            return r;
        };
    }

    public static TermWeightor fieldWeightor(double weight, Set<String> fields) {
        return value -> {
            if (fields.contains(value.field())) {
                return weight;
            }
            return 1.0;
        };
    }

    public static TermWeightor fieldWeightor(double weight, String ... fields) {
        return TermWeightor.fieldWeightor(weight, new HashSet<String>(Arrays.asList(fields)));
    }

    public static TermWeightor termWeightor(double weight, Set<BytesRef> terms) {
        return value -> {
            if (terms.contains(value.bytes())) {
                return weight;
            }
            return 1.0;
        };
    }

    public static TermWeightor termWeightor(double weight, BytesRef ... terms) {
        return TermWeightor.termWeightor(weight, new HashSet<BytesRef>(Arrays.asList(terms)));
    }

    public static TermWeightor termAndFieldWeightor(double weight, Set<Term> terms) {
        return value -> {
            if (terms.contains(value)) {
                return weight;
            }
            return 1.0;
        };
    }

    public static TermWeightor termAndFieldWeightor(double weight, Term ... terms) {
        return TermWeightor.termAndFieldWeightor(weight, new HashSet<Term>(Arrays.asList(terms)));
    }

    public static TermWeightor termFreqWeightor(Map<String, Integer> frequencies, double n, double k) {
        return value -> {
            Integer mapVal = (Integer)frequencies.get(value.text());
            if (mapVal != null) {
                return n / (double)mapVal.intValue() + k;
            }
            return 1.0;
        };
    }

    public static TermWeightor lengthWeightor(double a, double k) {
        double[] lengthNorms = new double[32];
        for (int i = 0; i < 32; ++i) {
            lengthNorms[i] = (float)(a * Math.exp(-k * (double)i));
        }
        return value -> {
            if (value.bytes().length >= 32) {
                return 4.0 - lengthNorms[31];
            }
            return 4.0 - lengthNorms[value.bytes().length];
        };
    }
}

