"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright: Ankitects Pty Ltd and contributors
License: GNU AGPL, version 3 or later; http://www.gnu.org/licenses/agpl.html
"""

import anki.cards_pb2
import anki.config_pb2
import anki.deck_config_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SchedulingState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class New(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POSITION_FIELD_NUMBER: builtins.int
        position: builtins.int
        def __init__(
            self,
            *,
            position: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["position", b"position"]) -> None: ...

    @typing.final
    class Learning(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REMAINING_STEPS_FIELD_NUMBER: builtins.int
        SCHEDULED_SECS_FIELD_NUMBER: builtins.int
        ELAPSED_SECS_FIELD_NUMBER: builtins.int
        MEMORY_STATE_FIELD_NUMBER: builtins.int
        remaining_steps: builtins.int
        scheduled_secs: builtins.int
        elapsed_secs: builtins.int
        @property
        def memory_state(self) -> anki.cards_pb2.FsrsMemoryState: ...
        def __init__(
            self,
            *,
            remaining_steps: builtins.int = ...,
            scheduled_secs: builtins.int = ...,
            elapsed_secs: builtins.int = ...,
            memory_state: anki.cards_pb2.FsrsMemoryState | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_memory_state", b"_memory_state", "memory_state", b"memory_state"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_memory_state", b"_memory_state", "elapsed_secs", b"elapsed_secs", "memory_state", b"memory_state", "remaining_steps", b"remaining_steps", "scheduled_secs", b"scheduled_secs"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["_memory_state", b"_memory_state"]) -> typing.Literal["memory_state"] | None: ...

    @typing.final
    class Review(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SCHEDULED_DAYS_FIELD_NUMBER: builtins.int
        ELAPSED_DAYS_FIELD_NUMBER: builtins.int
        EASE_FACTOR_FIELD_NUMBER: builtins.int
        LAPSES_FIELD_NUMBER: builtins.int
        LEECHED_FIELD_NUMBER: builtins.int
        MEMORY_STATE_FIELD_NUMBER: builtins.int
        scheduled_days: builtins.int
        elapsed_days: builtins.int
        ease_factor: builtins.float
        lapses: builtins.int
        leeched: builtins.bool
        @property
        def memory_state(self) -> anki.cards_pb2.FsrsMemoryState: ...
        def __init__(
            self,
            *,
            scheduled_days: builtins.int = ...,
            elapsed_days: builtins.int = ...,
            ease_factor: builtins.float = ...,
            lapses: builtins.int = ...,
            leeched: builtins.bool = ...,
            memory_state: anki.cards_pb2.FsrsMemoryState | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_memory_state", b"_memory_state", "memory_state", b"memory_state"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_memory_state", b"_memory_state", "ease_factor", b"ease_factor", "elapsed_days", b"elapsed_days", "lapses", b"lapses", "leeched", b"leeched", "memory_state", b"memory_state", "scheduled_days", b"scheduled_days"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["_memory_state", b"_memory_state"]) -> typing.Literal["memory_state"] | None: ...

    @typing.final
    class Relearning(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REVIEW_FIELD_NUMBER: builtins.int
        LEARNING_FIELD_NUMBER: builtins.int
        @property
        def review(self) -> global___SchedulingState.Review: ...
        @property
        def learning(self) -> global___SchedulingState.Learning: ...
        def __init__(
            self,
            *,
            review: global___SchedulingState.Review | None = ...,
            learning: global___SchedulingState.Learning | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["learning", b"learning", "review", b"review"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["learning", b"learning", "review", b"review"]) -> None: ...

    @typing.final
    class Normal(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NEW_FIELD_NUMBER: builtins.int
        LEARNING_FIELD_NUMBER: builtins.int
        REVIEW_FIELD_NUMBER: builtins.int
        RELEARNING_FIELD_NUMBER: builtins.int
        @property
        def new(self) -> global___SchedulingState.New: ...
        @property
        def learning(self) -> global___SchedulingState.Learning: ...
        @property
        def review(self) -> global___SchedulingState.Review: ...
        @property
        def relearning(self) -> global___SchedulingState.Relearning: ...
        def __init__(
            self,
            *,
            new: global___SchedulingState.New | None = ...,
            learning: global___SchedulingState.Learning | None = ...,
            review: global___SchedulingState.Review | None = ...,
            relearning: global___SchedulingState.Relearning | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["kind", b"kind", "learning", b"learning", "new", b"new", "relearning", b"relearning", "review", b"review"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["kind", b"kind", "learning", b"learning", "new", b"new", "relearning", b"relearning", "review", b"review"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["new", "learning", "review", "relearning"] | None: ...

    @typing.final
    class Preview(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SCHEDULED_SECS_FIELD_NUMBER: builtins.int
        FINISHED_FIELD_NUMBER: builtins.int
        scheduled_secs: builtins.int
        finished: builtins.bool
        def __init__(
            self,
            *,
            scheduled_secs: builtins.int = ...,
            finished: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["finished", b"finished", "scheduled_secs", b"scheduled_secs"]) -> None: ...

    @typing.final
    class ReschedulingFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ORIGINAL_STATE_FIELD_NUMBER: builtins.int
        @property
        def original_state(self) -> global___SchedulingState.Normal: ...
        def __init__(
            self,
            *,
            original_state: global___SchedulingState.Normal | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["original_state", b"original_state"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["original_state", b"original_state"]) -> None: ...

    @typing.final
    class Filtered(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PREVIEW_FIELD_NUMBER: builtins.int
        RESCHEDULING_FIELD_NUMBER: builtins.int
        @property
        def preview(self) -> global___SchedulingState.Preview: ...
        @property
        def rescheduling(self) -> global___SchedulingState.ReschedulingFilter: ...
        def __init__(
            self,
            *,
            preview: global___SchedulingState.Preview | None = ...,
            rescheduling: global___SchedulingState.ReschedulingFilter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["kind", b"kind", "preview", b"preview", "rescheduling", b"rescheduling"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["kind", b"kind", "preview", b"preview", "rescheduling", b"rescheduling"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["preview", "rescheduling"] | None: ...

    NORMAL_FIELD_NUMBER: builtins.int
    FILTERED_FIELD_NUMBER: builtins.int
    CUSTOM_DATA_FIELD_NUMBER: builtins.int
    custom_data: builtins.str
    """The backend does not populate this field in GetQueuedCards; the front-end
    is expected to populate it based on the provided Card. If it's not set when
    answering a card, the existing custom data will not be updated.
    """
    @property
    def normal(self) -> global___SchedulingState.Normal: ...
    @property
    def filtered(self) -> global___SchedulingState.Filtered: ...
    def __init__(
        self,
        *,
        normal: global___SchedulingState.Normal | None = ...,
        filtered: global___SchedulingState.Filtered | None = ...,
        custom_data: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_custom_data", b"_custom_data", "custom_data", b"custom_data", "filtered", b"filtered", "kind", b"kind", "normal", b"normal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_custom_data", b"_custom_data", "custom_data", b"custom_data", "filtered", b"filtered", "kind", b"kind", "normal", b"normal"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_custom_data", b"_custom_data"]) -> typing.Literal["custom_data"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["normal", "filtered"] | None: ...

global___SchedulingState = SchedulingState

@typing.final
class QueuedCards(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Queue:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _QueueEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[QueuedCards._Queue.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NEW: QueuedCards._Queue.ValueType  # 0
        LEARNING: QueuedCards._Queue.ValueType  # 1
        REVIEW: QueuedCards._Queue.ValueType  # 2

    class Queue(_Queue, metaclass=_QueueEnumTypeWrapper): ...
    NEW: QueuedCards.Queue.ValueType  # 0
    LEARNING: QueuedCards.Queue.ValueType  # 1
    REVIEW: QueuedCards.Queue.ValueType  # 2

    @typing.final
    class QueuedCard(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CARD_FIELD_NUMBER: builtins.int
        QUEUE_FIELD_NUMBER: builtins.int
        STATES_FIELD_NUMBER: builtins.int
        CONTEXT_FIELD_NUMBER: builtins.int
        queue: global___QueuedCards.Queue.ValueType
        @property
        def card(self) -> anki.cards_pb2.Card: ...
        @property
        def states(self) -> global___SchedulingStates: ...
        @property
        def context(self) -> global___SchedulingContext: ...
        def __init__(
            self,
            *,
            card: anki.cards_pb2.Card | None = ...,
            queue: global___QueuedCards.Queue.ValueType = ...,
            states: global___SchedulingStates | None = ...,
            context: global___SchedulingContext | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["card", b"card", "context", b"context", "states", b"states"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["card", b"card", "context", b"context", "queue", b"queue", "states", b"states"]) -> None: ...

    CARDS_FIELD_NUMBER: builtins.int
    NEW_COUNT_FIELD_NUMBER: builtins.int
    LEARNING_COUNT_FIELD_NUMBER: builtins.int
    REVIEW_COUNT_FIELD_NUMBER: builtins.int
    new_count: builtins.int
    learning_count: builtins.int
    review_count: builtins.int
    @property
    def cards(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QueuedCards.QueuedCard]: ...
    def __init__(
        self,
        *,
        cards: collections.abc.Iterable[global___QueuedCards.QueuedCard] | None = ...,
        new_count: builtins.int = ...,
        learning_count: builtins.int = ...,
        review_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cards", b"cards", "learning_count", b"learning_count", "new_count", b"new_count", "review_count", b"review_count"]) -> None: ...

global___QueuedCards = QueuedCards

@typing.final
class GetQueuedCardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FETCH_LIMIT_FIELD_NUMBER: builtins.int
    INTRADAY_LEARNING_ONLY_FIELD_NUMBER: builtins.int
    fetch_limit: builtins.int
    intraday_learning_only: builtins.bool
    def __init__(
        self,
        *,
        fetch_limit: builtins.int = ...,
        intraday_learning_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fetch_limit", b"fetch_limit", "intraday_learning_only", b"intraday_learning_only"]) -> None: ...

global___GetQueuedCardsRequest = GetQueuedCardsRequest

@typing.final
class SchedTimingTodayResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DAYS_ELAPSED_FIELD_NUMBER: builtins.int
    NEXT_DAY_AT_FIELD_NUMBER: builtins.int
    days_elapsed: builtins.int
    next_day_at: builtins.int
    def __init__(
        self,
        *,
        days_elapsed: builtins.int = ...,
        next_day_at: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["days_elapsed", b"days_elapsed", "next_day_at", b"next_day_at"]) -> None: ...

global___SchedTimingTodayResponse = SchedTimingTodayResponse

@typing.final
class StudiedTodayMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CARDS_FIELD_NUMBER: builtins.int
    SECONDS_FIELD_NUMBER: builtins.int
    cards: builtins.int
    seconds: builtins.float
    def __init__(
        self,
        *,
        cards: builtins.int = ...,
        seconds: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cards", b"cards", "seconds", b"seconds"]) -> None: ...

global___StudiedTodayMessageRequest = StudiedTodayMessageRequest

@typing.final
class UpdateStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    NEW_DELTA_FIELD_NUMBER: builtins.int
    REVIEW_DELTA_FIELD_NUMBER: builtins.int
    MILLISECOND_DELTA_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    new_delta: builtins.int
    review_delta: builtins.int
    millisecond_delta: builtins.int
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        new_delta: builtins.int = ...,
        review_delta: builtins.int = ...,
        millisecond_delta: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id", "millisecond_delta", b"millisecond_delta", "new_delta", b"new_delta", "review_delta", b"review_delta"]) -> None: ...

global___UpdateStatsRequest = UpdateStatsRequest

@typing.final
class ExtendLimitsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    NEW_DELTA_FIELD_NUMBER: builtins.int
    REVIEW_DELTA_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    new_delta: builtins.int
    review_delta: builtins.int
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        new_delta: builtins.int = ...,
        review_delta: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id", "new_delta", b"new_delta", "review_delta", b"review_delta"]) -> None: ...

global___ExtendLimitsRequest = ExtendLimitsRequest

@typing.final
class CountsForDeckTodayResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEW_FIELD_NUMBER: builtins.int
    REVIEW_FIELD_NUMBER: builtins.int
    new: builtins.int
    review: builtins.int
    def __init__(
        self,
        *,
        new: builtins.int = ...,
        review: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["new", b"new", "review", b"review"]) -> None: ...

global___CountsForDeckTodayResponse = CountsForDeckTodayResponse

@typing.final
class CongratsInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LEARN_REMAINING_FIELD_NUMBER: builtins.int
    SECS_UNTIL_NEXT_LEARN_FIELD_NUMBER: builtins.int
    REVIEW_REMAINING_FIELD_NUMBER: builtins.int
    NEW_REMAINING_FIELD_NUMBER: builtins.int
    HAVE_SCHED_BURIED_FIELD_NUMBER: builtins.int
    HAVE_USER_BURIED_FIELD_NUMBER: builtins.int
    IS_FILTERED_DECK_FIELD_NUMBER: builtins.int
    BRIDGE_COMMANDS_SUPPORTED_FIELD_NUMBER: builtins.int
    DECK_DESCRIPTION_FIELD_NUMBER: builtins.int
    learn_remaining: builtins.int
    secs_until_next_learn: builtins.int
    review_remaining: builtins.bool
    new_remaining: builtins.bool
    have_sched_buried: builtins.bool
    have_user_buried: builtins.bool
    is_filtered_deck: builtins.bool
    bridge_commands_supported: builtins.bool
    deck_description: builtins.str
    def __init__(
        self,
        *,
        learn_remaining: builtins.int = ...,
        secs_until_next_learn: builtins.int = ...,
        review_remaining: builtins.bool = ...,
        new_remaining: builtins.bool = ...,
        have_sched_buried: builtins.bool = ...,
        have_user_buried: builtins.bool = ...,
        is_filtered_deck: builtins.bool = ...,
        bridge_commands_supported: builtins.bool = ...,
        deck_description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bridge_commands_supported", b"bridge_commands_supported", "deck_description", b"deck_description", "have_sched_buried", b"have_sched_buried", "have_user_buried", b"have_user_buried", "is_filtered_deck", b"is_filtered_deck", "learn_remaining", b"learn_remaining", "new_remaining", b"new_remaining", "review_remaining", b"review_remaining", "secs_until_next_learn", b"secs_until_next_learn"]) -> None: ...

global___CongratsInfoResponse = CongratsInfoResponse

@typing.final
class UnburyDeckRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UnburyDeckRequest._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALL: UnburyDeckRequest._Mode.ValueType  # 0
        SCHED_ONLY: UnburyDeckRequest._Mode.ValueType  # 1
        USER_ONLY: UnburyDeckRequest._Mode.ValueType  # 2

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    ALL: UnburyDeckRequest.Mode.ValueType  # 0
    SCHED_ONLY: UnburyDeckRequest.Mode.ValueType  # 1
    USER_ONLY: UnburyDeckRequest.Mode.ValueType  # 2

    DECK_ID_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    mode: global___UnburyDeckRequest.Mode.ValueType
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        mode: global___UnburyDeckRequest.Mode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id", "mode", b"mode"]) -> None: ...

global___UnburyDeckRequest = UnburyDeckRequest

@typing.final
class BuryOrSuspendCardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BuryOrSuspendCardsRequest._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUSPEND: BuryOrSuspendCardsRequest._Mode.ValueType  # 0
        BURY_SCHED: BuryOrSuspendCardsRequest._Mode.ValueType  # 1
        BURY_USER: BuryOrSuspendCardsRequest._Mode.ValueType  # 2

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    SUSPEND: BuryOrSuspendCardsRequest.Mode.ValueType  # 0
    BURY_SCHED: BuryOrSuspendCardsRequest.Mode.ValueType  # 1
    BURY_USER: BuryOrSuspendCardsRequest.Mode.ValueType  # 2

    CARD_IDS_FIELD_NUMBER: builtins.int
    NOTE_IDS_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    mode: global___BuryOrSuspendCardsRequest.Mode.ValueType
    @property
    def card_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def note_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        card_ids: collections.abc.Iterable[builtins.int] | None = ...,
        note_ids: collections.abc.Iterable[builtins.int] | None = ...,
        mode: global___BuryOrSuspendCardsRequest.Mode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["card_ids", b"card_ids", "mode", b"mode", "note_ids", b"note_ids"]) -> None: ...

global___BuryOrSuspendCardsRequest = BuryOrSuspendCardsRequest

@typing.final
class ScheduleCardsAsNewRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Context:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ContextEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ScheduleCardsAsNewRequest._Context.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BROWSER: ScheduleCardsAsNewRequest._Context.ValueType  # 0
        REVIEWER: ScheduleCardsAsNewRequest._Context.ValueType  # 1

    class Context(_Context, metaclass=_ContextEnumTypeWrapper): ...
    BROWSER: ScheduleCardsAsNewRequest.Context.ValueType  # 0
    REVIEWER: ScheduleCardsAsNewRequest.Context.ValueType  # 1

    CARD_IDS_FIELD_NUMBER: builtins.int
    LOG_FIELD_NUMBER: builtins.int
    RESTORE_POSITION_FIELD_NUMBER: builtins.int
    RESET_COUNTS_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    log: builtins.bool
    restore_position: builtins.bool
    reset_counts: builtins.bool
    context: global___ScheduleCardsAsNewRequest.Context.ValueType
    @property
    def card_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        card_ids: collections.abc.Iterable[builtins.int] | None = ...,
        log: builtins.bool = ...,
        restore_position: builtins.bool = ...,
        reset_counts: builtins.bool = ...,
        context: global___ScheduleCardsAsNewRequest.Context.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_context", b"_context", "context", b"context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_context", b"_context", "card_ids", b"card_ids", "context", b"context", "log", b"log", "reset_counts", b"reset_counts", "restore_position", b"restore_position"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_context", b"_context"]) -> typing.Literal["context"] | None: ...

global___ScheduleCardsAsNewRequest = ScheduleCardsAsNewRequest

@typing.final
class ScheduleCardsAsNewDefaultsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXT_FIELD_NUMBER: builtins.int
    context: global___ScheduleCardsAsNewRequest.Context.ValueType
    def __init__(
        self,
        *,
        context: global___ScheduleCardsAsNewRequest.Context.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["context", b"context"]) -> None: ...

global___ScheduleCardsAsNewDefaultsRequest = ScheduleCardsAsNewDefaultsRequest

@typing.final
class ScheduleCardsAsNewDefaultsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESTORE_POSITION_FIELD_NUMBER: builtins.int
    RESET_COUNTS_FIELD_NUMBER: builtins.int
    restore_position: builtins.bool
    reset_counts: builtins.bool
    def __init__(
        self,
        *,
        restore_position: builtins.bool = ...,
        reset_counts: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["reset_counts", b"reset_counts", "restore_position", b"restore_position"]) -> None: ...

global___ScheduleCardsAsNewDefaultsResponse = ScheduleCardsAsNewDefaultsResponse

@typing.final
class SetDueDateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CARD_IDS_FIELD_NUMBER: builtins.int
    DAYS_FIELD_NUMBER: builtins.int
    CONFIG_KEY_FIELD_NUMBER: builtins.int
    days: builtins.str
    @property
    def card_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def config_key(self) -> anki.config_pb2.OptionalStringConfigKey: ...
    def __init__(
        self,
        *,
        card_ids: collections.abc.Iterable[builtins.int] | None = ...,
        days: builtins.str = ...,
        config_key: anki.config_pb2.OptionalStringConfigKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_key", b"config_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["card_ids", b"card_ids", "config_key", b"config_key", "days", b"days"]) -> None: ...

global___SetDueDateRequest = SetDueDateRequest

@typing.final
class GradeNowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CARD_IDS_FIELD_NUMBER: builtins.int
    RATING_FIELD_NUMBER: builtins.int
    rating: global___CardAnswer.Rating.ValueType
    @property
    def card_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        card_ids: collections.abc.Iterable[builtins.int] | None = ...,
        rating: global___CardAnswer.Rating.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["card_ids", b"card_ids", "rating", b"rating"]) -> None: ...

global___GradeNowRequest = GradeNowRequest

@typing.final
class SortCardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CARD_IDS_FIELD_NUMBER: builtins.int
    STARTING_FROM_FIELD_NUMBER: builtins.int
    STEP_SIZE_FIELD_NUMBER: builtins.int
    RANDOMIZE_FIELD_NUMBER: builtins.int
    SHIFT_EXISTING_FIELD_NUMBER: builtins.int
    starting_from: builtins.int
    step_size: builtins.int
    randomize: builtins.bool
    shift_existing: builtins.bool
    @property
    def card_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        card_ids: collections.abc.Iterable[builtins.int] | None = ...,
        starting_from: builtins.int = ...,
        step_size: builtins.int = ...,
        randomize: builtins.bool = ...,
        shift_existing: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["card_ids", b"card_ids", "randomize", b"randomize", "shift_existing", b"shift_existing", "starting_from", b"starting_from", "step_size", b"step_size"]) -> None: ...

global___SortCardsRequest = SortCardsRequest

@typing.final
class SortDeckRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    RANDOMIZE_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    randomize: builtins.bool
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        randomize: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id", "randomize", b"randomize"]) -> None: ...

global___SortDeckRequest = SortDeckRequest

@typing.final
class SchedulingStates(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_FIELD_NUMBER: builtins.int
    AGAIN_FIELD_NUMBER: builtins.int
    HARD_FIELD_NUMBER: builtins.int
    GOOD_FIELD_NUMBER: builtins.int
    EASY_FIELD_NUMBER: builtins.int
    @property
    def current(self) -> global___SchedulingState: ...
    @property
    def again(self) -> global___SchedulingState: ...
    @property
    def hard(self) -> global___SchedulingState: ...
    @property
    def good(self) -> global___SchedulingState: ...
    @property
    def easy(self) -> global___SchedulingState: ...
    def __init__(
        self,
        *,
        current: global___SchedulingState | None = ...,
        again: global___SchedulingState | None = ...,
        hard: global___SchedulingState | None = ...,
        good: global___SchedulingState | None = ...,
        easy: global___SchedulingState | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["again", b"again", "current", b"current", "easy", b"easy", "good", b"good", "hard", b"hard"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["again", b"again", "current", b"current", "easy", b"easy", "good", b"good", "hard", b"hard"]) -> None: ...

global___SchedulingStates = SchedulingStates

@typing.final
class CardAnswer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Rating:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RatingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CardAnswer._Rating.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AGAIN: CardAnswer._Rating.ValueType  # 0
        HARD: CardAnswer._Rating.ValueType  # 1
        GOOD: CardAnswer._Rating.ValueType  # 2
        EASY: CardAnswer._Rating.ValueType  # 3

    class Rating(_Rating, metaclass=_RatingEnumTypeWrapper): ...
    AGAIN: CardAnswer.Rating.ValueType  # 0
    HARD: CardAnswer.Rating.ValueType  # 1
    GOOD: CardAnswer.Rating.ValueType  # 2
    EASY: CardAnswer.Rating.ValueType  # 3

    CARD_ID_FIELD_NUMBER: builtins.int
    CURRENT_STATE_FIELD_NUMBER: builtins.int
    NEW_STATE_FIELD_NUMBER: builtins.int
    RATING_FIELD_NUMBER: builtins.int
    ANSWERED_AT_MILLIS_FIELD_NUMBER: builtins.int
    MILLISECONDS_TAKEN_FIELD_NUMBER: builtins.int
    card_id: builtins.int
    rating: global___CardAnswer.Rating.ValueType
    answered_at_millis: builtins.int
    milliseconds_taken: builtins.int
    @property
    def current_state(self) -> global___SchedulingState: ...
    @property
    def new_state(self) -> global___SchedulingState: ...
    def __init__(
        self,
        *,
        card_id: builtins.int = ...,
        current_state: global___SchedulingState | None = ...,
        new_state: global___SchedulingState | None = ...,
        rating: global___CardAnswer.Rating.ValueType = ...,
        answered_at_millis: builtins.int = ...,
        milliseconds_taken: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["current_state", b"current_state", "new_state", b"new_state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["answered_at_millis", b"answered_at_millis", "card_id", b"card_id", "current_state", b"current_state", "milliseconds_taken", b"milliseconds_taken", "new_state", b"new_state", "rating", b"rating"]) -> None: ...

global___CardAnswer = CardAnswer

@typing.final
class CustomStudyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Cram(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _CramKind:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _CramKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CustomStudyRequest.Cram._CramKind.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            CRAM_KIND_DUE: CustomStudyRequest.Cram._CramKind.ValueType  # 0
            """due cards in due order"""
            CRAM_KIND_NEW: CustomStudyRequest.Cram._CramKind.ValueType  # 1
            """new cards in added order"""
            CRAM_KIND_REVIEW: CustomStudyRequest.Cram._CramKind.ValueType  # 2
            """review cards in random order"""
            CRAM_KIND_ALL: CustomStudyRequest.Cram._CramKind.ValueType  # 3
            """all cards in random order; no rescheduling"""

        class CramKind(_CramKind, metaclass=_CramKindEnumTypeWrapper): ...
        CRAM_KIND_DUE: CustomStudyRequest.Cram.CramKind.ValueType  # 0
        """due cards in due order"""
        CRAM_KIND_NEW: CustomStudyRequest.Cram.CramKind.ValueType  # 1
        """new cards in added order"""
        CRAM_KIND_REVIEW: CustomStudyRequest.Cram.CramKind.ValueType  # 2
        """review cards in random order"""
        CRAM_KIND_ALL: CustomStudyRequest.Cram.CramKind.ValueType  # 3
        """all cards in random order; no rescheduling"""

        KIND_FIELD_NUMBER: builtins.int
        CARD_LIMIT_FIELD_NUMBER: builtins.int
        TAGS_TO_INCLUDE_FIELD_NUMBER: builtins.int
        TAGS_TO_EXCLUDE_FIELD_NUMBER: builtins.int
        kind: global___CustomStudyRequest.Cram.CramKind.ValueType
        card_limit: builtins.int
        """the maximum number of cards"""
        @property
        def tags_to_include(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """cards must match one of these, if unempty"""

        @property
        def tags_to_exclude(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """cards must not match any of these"""

        def __init__(
            self,
            *,
            kind: global___CustomStudyRequest.Cram.CramKind.ValueType = ...,
            card_limit: builtins.int = ...,
            tags_to_include: collections.abc.Iterable[builtins.str] | None = ...,
            tags_to_exclude: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["card_limit", b"card_limit", "kind", b"kind", "tags_to_exclude", b"tags_to_exclude", "tags_to_include", b"tags_to_include"]) -> None: ...

    DECK_ID_FIELD_NUMBER: builtins.int
    NEW_LIMIT_DELTA_FIELD_NUMBER: builtins.int
    REVIEW_LIMIT_DELTA_FIELD_NUMBER: builtins.int
    FORGOT_DAYS_FIELD_NUMBER: builtins.int
    REVIEW_AHEAD_DAYS_FIELD_NUMBER: builtins.int
    PREVIEW_DAYS_FIELD_NUMBER: builtins.int
    CRAM_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    new_limit_delta: builtins.int
    """increase new limit by x"""
    review_limit_delta: builtins.int
    """increase review limit by x"""
    forgot_days: builtins.int
    """repeat cards forgotten in the last x days"""
    review_ahead_days: builtins.int
    """review cards due in the next x days"""
    preview_days: builtins.int
    """preview new cards added in the last x days"""
    @property
    def cram(self) -> global___CustomStudyRequest.Cram: ...
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        new_limit_delta: builtins.int = ...,
        review_limit_delta: builtins.int = ...,
        forgot_days: builtins.int = ...,
        review_ahead_days: builtins.int = ...,
        preview_days: builtins.int = ...,
        cram: global___CustomStudyRequest.Cram | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cram", b"cram", "forgot_days", b"forgot_days", "new_limit_delta", b"new_limit_delta", "preview_days", b"preview_days", "review_ahead_days", b"review_ahead_days", "review_limit_delta", b"review_limit_delta", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cram", b"cram", "deck_id", b"deck_id", "forgot_days", b"forgot_days", "new_limit_delta", b"new_limit_delta", "preview_days", b"preview_days", "review_ahead_days", b"review_ahead_days", "review_limit_delta", b"review_limit_delta", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["value", b"value"]) -> typing.Literal["new_limit_delta", "review_limit_delta", "forgot_days", "review_ahead_days", "preview_days", "cram"] | None: ...

global___CustomStudyRequest = CustomStudyRequest

@typing.final
class SchedulingContext(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_NAME_FIELD_NUMBER: builtins.int
    SEED_FIELD_NUMBER: builtins.int
    deck_name: builtins.str
    seed: builtins.int
    def __init__(
        self,
        *,
        deck_name: builtins.str = ...,
        seed: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_name", b"deck_name", "seed", b"seed"]) -> None: ...

global___SchedulingContext = SchedulingContext

@typing.final
class CustomStudyDefaultsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id"]) -> None: ...

global___CustomStudyDefaultsRequest = CustomStudyDefaultsRequest

@typing.final
class CustomStudyDefaultsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Tag(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        INCLUDE_FIELD_NUMBER: builtins.int
        EXCLUDE_FIELD_NUMBER: builtins.int
        name: builtins.str
        include: builtins.bool
        exclude: builtins.bool
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            include: builtins.bool = ...,
            exclude: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["exclude", b"exclude", "include", b"include", "name", b"name"]) -> None: ...

    TAGS_FIELD_NUMBER: builtins.int
    EXTEND_NEW_FIELD_NUMBER: builtins.int
    EXTEND_REVIEW_FIELD_NUMBER: builtins.int
    AVAILABLE_NEW_FIELD_NUMBER: builtins.int
    AVAILABLE_REVIEW_FIELD_NUMBER: builtins.int
    AVAILABLE_NEW_IN_CHILDREN_FIELD_NUMBER: builtins.int
    AVAILABLE_REVIEW_IN_CHILDREN_FIELD_NUMBER: builtins.int
    extend_new: builtins.int
    extend_review: builtins.int
    available_new: builtins.int
    available_review: builtins.int
    available_new_in_children: builtins.int
    """in v3, counts for children are provided separately"""
    available_review_in_children: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CustomStudyDefaultsResponse.Tag]: ...
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[global___CustomStudyDefaultsResponse.Tag] | None = ...,
        extend_new: builtins.int = ...,
        extend_review: builtins.int = ...,
        available_new: builtins.int = ...,
        available_review: builtins.int = ...,
        available_new_in_children: builtins.int = ...,
        available_review_in_children: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["available_new", b"available_new", "available_new_in_children", b"available_new_in_children", "available_review", b"available_review", "available_review_in_children", b"available_review_in_children", "extend_new", b"extend_new", "extend_review", b"extend_review", "tags", b"tags"]) -> None: ...

global___CustomStudyDefaultsResponse = CustomStudyDefaultsResponse

@typing.final
class RepositionDefaultsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RANDOM_FIELD_NUMBER: builtins.int
    SHIFT_FIELD_NUMBER: builtins.int
    random: builtins.bool
    shift: builtins.bool
    def __init__(
        self,
        *,
        random: builtins.bool = ...,
        shift: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["random", b"random", "shift", b"shift"]) -> None: ...

global___RepositionDefaultsResponse = RepositionDefaultsResponse

@typing.final
class ComputeFsrsParamsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_FIELD_NUMBER: builtins.int
    CURRENT_PARAMS_FIELD_NUMBER: builtins.int
    IGNORE_REVLOGS_BEFORE_MS_FIELD_NUMBER: builtins.int
    NUM_OF_RELEARNING_STEPS_FIELD_NUMBER: builtins.int
    HEALTH_CHECK_FIELD_NUMBER: builtins.int
    search: builtins.str
    """/ The search used to gather cards for training"""
    ignore_revlogs_before_ms: builtins.int
    num_of_relearning_steps: builtins.int
    health_check: builtins.bool
    @property
    def current_params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        search: builtins.str = ...,
        current_params: collections.abc.Iterable[builtins.float] | None = ...,
        ignore_revlogs_before_ms: builtins.int = ...,
        num_of_relearning_steps: builtins.int = ...,
        health_check: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["current_params", b"current_params", "health_check", b"health_check", "ignore_revlogs_before_ms", b"ignore_revlogs_before_ms", "num_of_relearning_steps", b"num_of_relearning_steps", "search", b"search"]) -> None: ...

global___ComputeFsrsParamsRequest = ComputeFsrsParamsRequest

@typing.final
class ComputeFsrsParamsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    FSRS_ITEMS_FIELD_NUMBER: builtins.int
    HEALTH_CHECK_PASSED_FIELD_NUMBER: builtins.int
    fsrs_items: builtins.int
    health_check_passed: builtins.bool
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        params: collections.abc.Iterable[builtins.float] | None = ...,
        fsrs_items: builtins.int = ...,
        health_check_passed: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_health_check_passed", b"_health_check_passed", "health_check_passed", b"health_check_passed"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_health_check_passed", b"_health_check_passed", "fsrs_items", b"fsrs_items", "health_check_passed", b"health_check_passed", "params", b"params"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_health_check_passed", b"_health_check_passed"]) -> typing.Literal["health_check_passed"] | None: ...

global___ComputeFsrsParamsResponse = ComputeFsrsParamsResponse

@typing.final
class ComputeFsrsParamsFromItemsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FsrsItem]: ...
    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___FsrsItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["items", b"items"]) -> None: ...

global___ComputeFsrsParamsFromItemsRequest = ComputeFsrsParamsFromItemsRequest

@typing.final
class FsrsBenchmarkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIN_SET_FIELD_NUMBER: builtins.int
    @property
    def train_set(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FsrsItem]: ...
    def __init__(
        self,
        *,
        train_set: collections.abc.Iterable[global___FsrsItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["train_set", b"train_set"]) -> None: ...

global___FsrsBenchmarkRequest = FsrsBenchmarkRequest

@typing.final
class FsrsBenchmarkResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        params: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["params", b"params"]) -> None: ...

global___FsrsBenchmarkResponse = FsrsBenchmarkResponse

@typing.final
class ExportDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_ENTRIES_FIELD_NUMBER: builtins.int
    TARGET_PATH_FIELD_NUMBER: builtins.int
    min_entries: builtins.int
    target_path: builtins.str
    def __init__(
        self,
        *,
        min_entries: builtins.int = ...,
        target_path: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["min_entries", b"min_entries", "target_path", b"target_path"]) -> None: ...

global___ExportDatasetRequest = ExportDatasetRequest

@typing.final
class FsrsItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REVIEWS_FIELD_NUMBER: builtins.int
    @property
    def reviews(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FsrsReview]: ...
    def __init__(
        self,
        *,
        reviews: collections.abc.Iterable[global___FsrsReview] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["reviews", b"reviews"]) -> None: ...

global___FsrsItem = FsrsItem

@typing.final
class FsrsReview(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RATING_FIELD_NUMBER: builtins.int
    DELTA_T_FIELD_NUMBER: builtins.int
    rating: builtins.int
    delta_t: builtins.int
    def __init__(
        self,
        *,
        rating: builtins.int = ...,
        delta_t: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["delta_t", b"delta_t", "rating", b"rating"]) -> None: ...

global___FsrsReview = FsrsReview

@typing.final
class SimulateFsrsReviewRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    DESIRED_RETENTION_FIELD_NUMBER: builtins.int
    DECK_SIZE_FIELD_NUMBER: builtins.int
    DAYS_TO_SIMULATE_FIELD_NUMBER: builtins.int
    NEW_LIMIT_FIELD_NUMBER: builtins.int
    REVIEW_LIMIT_FIELD_NUMBER: builtins.int
    MAX_INTERVAL_FIELD_NUMBER: builtins.int
    SEARCH_FIELD_NUMBER: builtins.int
    NEW_CARDS_IGNORE_REVIEW_LIMIT_FIELD_NUMBER: builtins.int
    EASY_DAYS_PERCENTAGES_FIELD_NUMBER: builtins.int
    REVIEW_ORDER_FIELD_NUMBER: builtins.int
    SUSPEND_AFTER_LAPSE_COUNT_FIELD_NUMBER: builtins.int
    HISTORICAL_RETENTION_FIELD_NUMBER: builtins.int
    LEARNING_STEP_COUNT_FIELD_NUMBER: builtins.int
    RELEARNING_STEP_COUNT_FIELD_NUMBER: builtins.int
    desired_retention: builtins.float
    deck_size: builtins.int
    days_to_simulate: builtins.int
    new_limit: builtins.int
    review_limit: builtins.int
    max_interval: builtins.int
    search: builtins.str
    new_cards_ignore_review_limit: builtins.bool
    review_order: anki.deck_config_pb2.DeckConfig.Config.ReviewCardOrder.ValueType
    suspend_after_lapse_count: builtins.int
    historical_retention: builtins.float
    learning_step_count: builtins.int
    relearning_step_count: builtins.int
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def easy_days_percentages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        params: collections.abc.Iterable[builtins.float] | None = ...,
        desired_retention: builtins.float = ...,
        deck_size: builtins.int = ...,
        days_to_simulate: builtins.int = ...,
        new_limit: builtins.int = ...,
        review_limit: builtins.int = ...,
        max_interval: builtins.int = ...,
        search: builtins.str = ...,
        new_cards_ignore_review_limit: builtins.bool = ...,
        easy_days_percentages: collections.abc.Iterable[builtins.float] | None = ...,
        review_order: anki.deck_config_pb2.DeckConfig.Config.ReviewCardOrder.ValueType = ...,
        suspend_after_lapse_count: builtins.int | None = ...,
        historical_retention: builtins.float = ...,
        learning_step_count: builtins.int = ...,
        relearning_step_count: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_suspend_after_lapse_count", b"_suspend_after_lapse_count", "suspend_after_lapse_count", b"suspend_after_lapse_count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_suspend_after_lapse_count", b"_suspend_after_lapse_count", "days_to_simulate", b"days_to_simulate", "deck_size", b"deck_size", "desired_retention", b"desired_retention", "easy_days_percentages", b"easy_days_percentages", "historical_retention", b"historical_retention", "learning_step_count", b"learning_step_count", "max_interval", b"max_interval", "new_cards_ignore_review_limit", b"new_cards_ignore_review_limit", "new_limit", b"new_limit", "params", b"params", "relearning_step_count", b"relearning_step_count", "review_limit", b"review_limit", "review_order", b"review_order", "search", b"search", "suspend_after_lapse_count", b"suspend_after_lapse_count"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_suspend_after_lapse_count", b"_suspend_after_lapse_count"]) -> typing.Literal["suspend_after_lapse_count"] | None: ...

global___SimulateFsrsReviewRequest = SimulateFsrsReviewRequest

@typing.final
class SimulateFsrsReviewResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCUMULATED_KNOWLEDGE_ACQUISITION_FIELD_NUMBER: builtins.int
    DAILY_REVIEW_COUNT_FIELD_NUMBER: builtins.int
    DAILY_NEW_COUNT_FIELD_NUMBER: builtins.int
    DAILY_TIME_COST_FIELD_NUMBER: builtins.int
    @property
    def accumulated_knowledge_acquisition(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def daily_review_count(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def daily_new_count(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def daily_time_cost(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        accumulated_knowledge_acquisition: collections.abc.Iterable[builtins.float] | None = ...,
        daily_review_count: collections.abc.Iterable[builtins.int] | None = ...,
        daily_new_count: collections.abc.Iterable[builtins.int] | None = ...,
        daily_time_cost: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["accumulated_knowledge_acquisition", b"accumulated_knowledge_acquisition", "daily_new_count", b"daily_new_count", "daily_review_count", b"daily_review_count", "daily_time_cost", b"daily_time_cost"]) -> None: ...

global___SimulateFsrsReviewResponse = SimulateFsrsReviewResponse

@typing.final
class SimulateFsrsWorkloadResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CostEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.float
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MemorizedEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.float
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class ReviewCountEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    COST_FIELD_NUMBER: builtins.int
    MEMORIZED_FIELD_NUMBER: builtins.int
    REVIEW_COUNT_FIELD_NUMBER: builtins.int
    @property
    def cost(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.float]: ...
    @property
    def memorized(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.float]: ...
    @property
    def review_count(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.int]: ...
    def __init__(
        self,
        *,
        cost: collections.abc.Mapping[builtins.int, builtins.float] | None = ...,
        memorized: collections.abc.Mapping[builtins.int, builtins.float] | None = ...,
        review_count: collections.abc.Mapping[builtins.int, builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cost", b"cost", "memorized", b"memorized", "review_count", b"review_count"]) -> None: ...

global___SimulateFsrsWorkloadResponse = SimulateFsrsWorkloadResponse

@typing.final
class ComputeOptimalRetentionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIMAL_RETENTION_FIELD_NUMBER: builtins.int
    optimal_retention: builtins.float
    def __init__(
        self,
        *,
        optimal_retention: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["optimal_retention", b"optimal_retention"]) -> None: ...

global___ComputeOptimalRetentionResponse = ComputeOptimalRetentionResponse

@typing.final
class GetOptimalRetentionParametersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_FIELD_NUMBER: builtins.int
    search: builtins.str
    def __init__(
        self,
        *,
        search: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["search", b"search"]) -> None: ...

global___GetOptimalRetentionParametersRequest = GetOptimalRetentionParametersRequest

@typing.final
class GetOptimalRetentionParametersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_SIZE_FIELD_NUMBER: builtins.int
    LEARN_SPAN_FIELD_NUMBER: builtins.int
    MAX_COST_PERDAY_FIELD_NUMBER: builtins.int
    MAX_IVL_FIELD_NUMBER: builtins.int
    FIRST_RATING_PROB_FIELD_NUMBER: builtins.int
    REVIEW_RATING_PROB_FIELD_NUMBER: builtins.int
    LOSS_AVERSION_FIELD_NUMBER: builtins.int
    LEARN_LIMIT_FIELD_NUMBER: builtins.int
    REVIEW_LIMIT_FIELD_NUMBER: builtins.int
    LEARNING_STEP_TRANSITIONS_FIELD_NUMBER: builtins.int
    RELEARNING_STEP_TRANSITIONS_FIELD_NUMBER: builtins.int
    STATE_RATING_COSTS_FIELD_NUMBER: builtins.int
    LEARNING_STEP_COUNT_FIELD_NUMBER: builtins.int
    RELEARNING_STEP_COUNT_FIELD_NUMBER: builtins.int
    deck_size: builtins.int
    learn_span: builtins.int
    max_cost_perday: builtins.float
    max_ivl: builtins.float
    loss_aversion: builtins.float
    learn_limit: builtins.int
    review_limit: builtins.int
    learning_step_count: builtins.int
    relearning_step_count: builtins.int
    @property
    def first_rating_prob(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def review_rating_prob(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def learning_step_transitions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def relearning_step_transitions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def state_rating_costs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        deck_size: builtins.int = ...,
        learn_span: builtins.int = ...,
        max_cost_perday: builtins.float = ...,
        max_ivl: builtins.float = ...,
        first_rating_prob: collections.abc.Iterable[builtins.float] | None = ...,
        review_rating_prob: collections.abc.Iterable[builtins.float] | None = ...,
        loss_aversion: builtins.float = ...,
        learn_limit: builtins.int = ...,
        review_limit: builtins.int = ...,
        learning_step_transitions: collections.abc.Iterable[builtins.float] | None = ...,
        relearning_step_transitions: collections.abc.Iterable[builtins.float] | None = ...,
        state_rating_costs: collections.abc.Iterable[builtins.float] | None = ...,
        learning_step_count: builtins.int = ...,
        relearning_step_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_size", b"deck_size", "first_rating_prob", b"first_rating_prob", "learn_limit", b"learn_limit", "learn_span", b"learn_span", "learning_step_count", b"learning_step_count", "learning_step_transitions", b"learning_step_transitions", "loss_aversion", b"loss_aversion", "max_cost_perday", b"max_cost_perday", "max_ivl", b"max_ivl", "relearning_step_count", b"relearning_step_count", "relearning_step_transitions", b"relearning_step_transitions", "review_limit", b"review_limit", "review_rating_prob", b"review_rating_prob", "state_rating_costs", b"state_rating_costs"]) -> None: ...

global___GetOptimalRetentionParametersResponse = GetOptimalRetentionParametersResponse

@typing.final
class EvaluateParamsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_FIELD_NUMBER: builtins.int
    IGNORE_REVLOGS_BEFORE_MS_FIELD_NUMBER: builtins.int
    NUM_OF_RELEARNING_STEPS_FIELD_NUMBER: builtins.int
    search: builtins.str
    ignore_revlogs_before_ms: builtins.int
    num_of_relearning_steps: builtins.int
    def __init__(
        self,
        *,
        search: builtins.str = ...,
        ignore_revlogs_before_ms: builtins.int = ...,
        num_of_relearning_steps: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ignore_revlogs_before_ms", b"ignore_revlogs_before_ms", "num_of_relearning_steps", b"num_of_relearning_steps", "search", b"search"]) -> None: ...

global___EvaluateParamsRequest = EvaluateParamsRequest

@typing.final
class EvaluateParamsLegacyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    SEARCH_FIELD_NUMBER: builtins.int
    IGNORE_REVLOGS_BEFORE_MS_FIELD_NUMBER: builtins.int
    search: builtins.str
    ignore_revlogs_before_ms: builtins.int
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        params: collections.abc.Iterable[builtins.float] | None = ...,
        search: builtins.str = ...,
        ignore_revlogs_before_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ignore_revlogs_before_ms", b"ignore_revlogs_before_ms", "params", b"params", "search", b"search"]) -> None: ...

global___EvaluateParamsLegacyRequest = EvaluateParamsLegacyRequest

@typing.final
class EvaluateParamsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOG_LOSS_FIELD_NUMBER: builtins.int
    RMSE_BINS_FIELD_NUMBER: builtins.int
    log_loss: builtins.float
    rmse_bins: builtins.float
    def __init__(
        self,
        *,
        log_loss: builtins.float = ...,
        rmse_bins: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["log_loss", b"log_loss", "rmse_bins", b"rmse_bins"]) -> None: ...

global___EvaluateParamsResponse = EvaluateParamsResponse

@typing.final
class ComputeMemoryStateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    DESIRED_RETENTION_FIELD_NUMBER: builtins.int
    DECAY_FIELD_NUMBER: builtins.int
    desired_retention: builtins.float
    decay: builtins.float
    @property
    def state(self) -> anki.cards_pb2.FsrsMemoryState: ...
    def __init__(
        self,
        *,
        state: anki.cards_pb2.FsrsMemoryState | None = ...,
        desired_retention: builtins.float = ...,
        decay: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_state", b"_state", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_state", b"_state", "decay", b"decay", "desired_retention", b"desired_retention", "state", b"state"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_state", b"_state"]) -> typing.Literal["state"] | None: ...

global___ComputeMemoryStateResponse = ComputeMemoryStateResponse

@typing.final
class FuzzDeltaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CARD_ID_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    card_id: builtins.int
    interval: builtins.int
    def __init__(
        self,
        *,
        card_id: builtins.int = ...,
        interval: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["card_id", b"card_id", "interval", b"interval"]) -> None: ...

global___FuzzDeltaRequest = FuzzDeltaRequest

@typing.final
class FuzzDeltaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DELTA_DAYS_FIELD_NUMBER: builtins.int
    delta_days: builtins.int
    def __init__(
        self,
        *,
        delta_days: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["delta_days", b"delta_days"]) -> None: ...

global___FuzzDeltaResponse = FuzzDeltaResponse
