"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright: Ankitects Pty Ltd and contributors
License: GNU AGPL, version 3 or later; http://www.gnu.org/licenses/agpl.html
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DeckId(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DID_FIELD_NUMBER: builtins.int
    did: builtins.int
    def __init__(
        self,
        *,
        did: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["did", b"did"]) -> None: ...

global___DeckId = DeckId

@typing.final
class DeckIds(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIDS_FIELD_NUMBER: builtins.int
    @property
    def dids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        dids: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dids", b"dids"]) -> None: ...

global___DeckIds = DeckIds

@typing.final
class Deck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Common(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        STUDY_COLLAPSED_FIELD_NUMBER: builtins.int
        BROWSER_COLLAPSED_FIELD_NUMBER: builtins.int
        LAST_DAY_STUDIED_FIELD_NUMBER: builtins.int
        NEW_STUDIED_FIELD_NUMBER: builtins.int
        REVIEW_STUDIED_FIELD_NUMBER: builtins.int
        MILLISECONDS_STUDIED_FIELD_NUMBER: builtins.int
        LEARNING_STUDIED_FIELD_NUMBER: builtins.int
        OTHER_FIELD_NUMBER: builtins.int
        study_collapsed: builtins.bool
        browser_collapsed: builtins.bool
        last_day_studied: builtins.int
        new_studied: builtins.int
        review_studied: builtins.int
        milliseconds_studied: builtins.int
        learning_studied: builtins.int
        """previously set in the v1 scheduler,
        but not currently used for anything
        """
        other: builtins.bytes
        def __init__(
            self,
            *,
            study_collapsed: builtins.bool = ...,
            browser_collapsed: builtins.bool = ...,
            last_day_studied: builtins.int = ...,
            new_studied: builtins.int = ...,
            review_studied: builtins.int = ...,
            milliseconds_studied: builtins.int = ...,
            learning_studied: builtins.int = ...,
            other: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["browser_collapsed", b"browser_collapsed", "last_day_studied", b"last_day_studied", "learning_studied", b"learning_studied", "milliseconds_studied", b"milliseconds_studied", "new_studied", b"new_studied", "other", b"other", "review_studied", b"review_studied", "study_collapsed", b"study_collapsed"]) -> None: ...

    @typing.final
    class Normal(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class DayLimit(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            LIMIT_FIELD_NUMBER: builtins.int
            TODAY_FIELD_NUMBER: builtins.int
            limit: builtins.int
            today: builtins.int
            def __init__(
                self,
                *,
                limit: builtins.int = ...,
                today: builtins.int = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["limit", b"limit", "today", b"today"]) -> None: ...

        CONFIG_ID_FIELD_NUMBER: builtins.int
        EXTEND_NEW_FIELD_NUMBER: builtins.int
        EXTEND_REVIEW_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        MARKDOWN_DESCRIPTION_FIELD_NUMBER: builtins.int
        REVIEW_LIMIT_FIELD_NUMBER: builtins.int
        NEW_LIMIT_FIELD_NUMBER: builtins.int
        REVIEW_LIMIT_TODAY_FIELD_NUMBER: builtins.int
        NEW_LIMIT_TODAY_FIELD_NUMBER: builtins.int
        DESIRED_RETENTION_FIELD_NUMBER: builtins.int
        config_id: builtins.int
        extend_new: builtins.int
        extend_review: builtins.int
        description: builtins.str
        markdown_description: builtins.bool
        review_limit: builtins.int
        new_limit: builtins.int
        desired_retention: builtins.float
        """Deck-specific desired retention override"""
        @property
        def review_limit_today(self) -> global___Deck.Normal.DayLimit: ...
        @property
        def new_limit_today(self) -> global___Deck.Normal.DayLimit: ...
        def __init__(
            self,
            *,
            config_id: builtins.int = ...,
            extend_new: builtins.int = ...,
            extend_review: builtins.int = ...,
            description: builtins.str = ...,
            markdown_description: builtins.bool = ...,
            review_limit: builtins.int | None = ...,
            new_limit: builtins.int | None = ...,
            review_limit_today: global___Deck.Normal.DayLimit | None = ...,
            new_limit_today: global___Deck.Normal.DayLimit | None = ...,
            desired_retention: builtins.float | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_desired_retention", b"_desired_retention", "_new_limit", b"_new_limit", "_review_limit", b"_review_limit", "desired_retention", b"desired_retention", "new_limit", b"new_limit", "new_limit_today", b"new_limit_today", "review_limit", b"review_limit", "review_limit_today", b"review_limit_today"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_desired_retention", b"_desired_retention", "_new_limit", b"_new_limit", "_review_limit", b"_review_limit", "config_id", b"config_id", "description", b"description", "desired_retention", b"desired_retention", "extend_new", b"extend_new", "extend_review", b"extend_review", "markdown_description", b"markdown_description", "new_limit", b"new_limit", "new_limit_today", b"new_limit_today", "review_limit", b"review_limit", "review_limit_today", b"review_limit_today"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_desired_retention", b"_desired_retention"]) -> typing.Literal["desired_retention"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_new_limit", b"_new_limit"]) -> typing.Literal["new_limit"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["_review_limit", b"_review_limit"]) -> typing.Literal["review_limit"] | None: ...

    @typing.final
    class Filtered(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class SearchTerm(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Order:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _OrderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Deck.Filtered.SearchTerm._Order.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                OLDEST_REVIEWED_FIRST: Deck.Filtered.SearchTerm._Order.ValueType  # 0
                RANDOM: Deck.Filtered.SearchTerm._Order.ValueType  # 1
                INTERVALS_ASCENDING: Deck.Filtered.SearchTerm._Order.ValueType  # 2
                INTERVALS_DESCENDING: Deck.Filtered.SearchTerm._Order.ValueType  # 3
                LAPSES: Deck.Filtered.SearchTerm._Order.ValueType  # 4
                ADDED: Deck.Filtered.SearchTerm._Order.ValueType  # 5
                DUE: Deck.Filtered.SearchTerm._Order.ValueType  # 6
                REVERSE_ADDED: Deck.Filtered.SearchTerm._Order.ValueType  # 7
                RETRIEVABILITY_ASCENDING: Deck.Filtered.SearchTerm._Order.ValueType  # 8
                RETRIEVABILITY_DESCENDING: Deck.Filtered.SearchTerm._Order.ValueType  # 9

            class Order(_Order, metaclass=_OrderEnumTypeWrapper): ...
            OLDEST_REVIEWED_FIRST: Deck.Filtered.SearchTerm.Order.ValueType  # 0
            RANDOM: Deck.Filtered.SearchTerm.Order.ValueType  # 1
            INTERVALS_ASCENDING: Deck.Filtered.SearchTerm.Order.ValueType  # 2
            INTERVALS_DESCENDING: Deck.Filtered.SearchTerm.Order.ValueType  # 3
            LAPSES: Deck.Filtered.SearchTerm.Order.ValueType  # 4
            ADDED: Deck.Filtered.SearchTerm.Order.ValueType  # 5
            DUE: Deck.Filtered.SearchTerm.Order.ValueType  # 6
            REVERSE_ADDED: Deck.Filtered.SearchTerm.Order.ValueType  # 7
            RETRIEVABILITY_ASCENDING: Deck.Filtered.SearchTerm.Order.ValueType  # 8
            RETRIEVABILITY_DESCENDING: Deck.Filtered.SearchTerm.Order.ValueType  # 9

            SEARCH_FIELD_NUMBER: builtins.int
            LIMIT_FIELD_NUMBER: builtins.int
            ORDER_FIELD_NUMBER: builtins.int
            search: builtins.str
            limit: builtins.int
            order: global___Deck.Filtered.SearchTerm.Order.ValueType
            def __init__(
                self,
                *,
                search: builtins.str = ...,
                limit: builtins.int = ...,
                order: global___Deck.Filtered.SearchTerm.Order.ValueType = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["limit", b"limit", "order", b"order", "search", b"search"]) -> None: ...

        RESCHEDULE_FIELD_NUMBER: builtins.int
        SEARCH_TERMS_FIELD_NUMBER: builtins.int
        DELAYS_FIELD_NUMBER: builtins.int
        PREVIEW_DELAY_FIELD_NUMBER: builtins.int
        PREVIEW_AGAIN_SECS_FIELD_NUMBER: builtins.int
        PREVIEW_HARD_SECS_FIELD_NUMBER: builtins.int
        PREVIEW_GOOD_SECS_FIELD_NUMBER: builtins.int
        reschedule: builtins.bool
        preview_delay: builtins.int
        """v2 and old v3 scheduler only"""
        preview_again_secs: builtins.int
        """recent v3 scheduler only; 0 means card will be returned"""
        preview_hard_secs: builtins.int
        """recent v3 scheduler only; 0 means card will be returned"""
        preview_good_secs: builtins.int
        """recent v3 scheduler only; 0 means card will be returned"""
        @property
        def search_terms(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Deck.Filtered.SearchTerm]: ...
        @property
        def delays(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """v1 scheduler only"""

        def __init__(
            self,
            *,
            reschedule: builtins.bool = ...,
            search_terms: collections.abc.Iterable[global___Deck.Filtered.SearchTerm] | None = ...,
            delays: collections.abc.Iterable[builtins.float] | None = ...,
            preview_delay: builtins.int = ...,
            preview_again_secs: builtins.int = ...,
            preview_hard_secs: builtins.int = ...,
            preview_good_secs: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["delays", b"delays", "preview_again_secs", b"preview_again_secs", "preview_delay", b"preview_delay", "preview_good_secs", b"preview_good_secs", "preview_hard_secs", b"preview_hard_secs", "reschedule", b"reschedule", "search_terms", b"search_terms"]) -> None: ...

    @typing.final
    class KindContainer(google.protobuf.message.Message):
        """a container to store the deck specifics in the DB
        as a tagged enum
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NORMAL_FIELD_NUMBER: builtins.int
        FILTERED_FIELD_NUMBER: builtins.int
        @property
        def normal(self) -> global___Deck.Normal: ...
        @property
        def filtered(self) -> global___Deck.Filtered: ...
        def __init__(
            self,
            *,
            normal: global___Deck.Normal | None = ...,
            filtered: global___Deck.Filtered | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["filtered", b"filtered", "kind", b"kind", "normal", b"normal"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["filtered", b"filtered", "kind", b"kind", "normal", b"normal"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["normal", "filtered"] | None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MTIME_SECS_FIELD_NUMBER: builtins.int
    USN_FIELD_NUMBER: builtins.int
    COMMON_FIELD_NUMBER: builtins.int
    NORMAL_FIELD_NUMBER: builtins.int
    FILTERED_FIELD_NUMBER: builtins.int
    id: builtins.int
    name: builtins.str
    mtime_secs: builtins.int
    usn: builtins.int
    @property
    def common(self) -> global___Deck.Common: ...
    @property
    def normal(self) -> global___Deck.Normal: ...
    @property
    def filtered(self) -> global___Deck.Filtered: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
        mtime_secs: builtins.int = ...,
        usn: builtins.int = ...,
        common: global___Deck.Common | None = ...,
        normal: global___Deck.Normal | None = ...,
        filtered: global___Deck.Filtered | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["common", b"common", "filtered", b"filtered", "kind", b"kind", "normal", b"normal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["common", b"common", "filtered", b"filtered", "id", b"id", "kind", b"kind", "mtime_secs", b"mtime_secs", "name", b"name", "normal", b"normal", "usn", b"usn"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["normal", "filtered"] | None: ...

global___Deck = Deck

@typing.final
class AddOrUpdateDeckLegacyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_FIELD_NUMBER: builtins.int
    PRESERVE_USN_AND_MTIME_FIELD_NUMBER: builtins.int
    deck: builtins.bytes
    preserve_usn_and_mtime: builtins.bool
    def __init__(
        self,
        *,
        deck: builtins.bytes = ...,
        preserve_usn_and_mtime: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck", b"deck", "preserve_usn_and_mtime", b"preserve_usn_and_mtime"]) -> None: ...

global___AddOrUpdateDeckLegacyRequest = AddOrUpdateDeckLegacyRequest

@typing.final
class DeckTreeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOW_FIELD_NUMBER: builtins.int
    now: builtins.int
    """if non-zero, counts for the provided timestamp will be included"""
    def __init__(
        self,
        *,
        now: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["now", b"now"]) -> None: ...

global___DeckTreeRequest = DeckTreeRequest

@typing.final
class DeckTreeNode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    COLLAPSED_FIELD_NUMBER: builtins.int
    REVIEW_COUNT_FIELD_NUMBER: builtins.int
    LEARN_COUNT_FIELD_NUMBER: builtins.int
    NEW_COUNT_FIELD_NUMBER: builtins.int
    INTRADAY_LEARNING_FIELD_NUMBER: builtins.int
    INTERDAY_LEARNING_UNCAPPED_FIELD_NUMBER: builtins.int
    NEW_UNCAPPED_FIELD_NUMBER: builtins.int
    REVIEW_UNCAPPED_FIELD_NUMBER: builtins.int
    TOTAL_IN_DECK_FIELD_NUMBER: builtins.int
    TOTAL_INCLUDING_CHILDREN_FIELD_NUMBER: builtins.int
    FILTERED_FIELD_NUMBER: builtins.int
    CHILDREN_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    name: builtins.str
    level: builtins.int
    collapsed: builtins.bool
    review_count: builtins.int
    """counts after adding children+applying limits"""
    learn_count: builtins.int
    new_count: builtins.int
    intraday_learning: builtins.int
    """card counts without children or limits applied"""
    interday_learning_uncapped: builtins.int
    new_uncapped: builtins.int
    review_uncapped: builtins.int
    total_in_deck: builtins.int
    total_including_children: builtins.int
    """with children, without any limits"""
    filtered: builtins.bool
    @property
    def children(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeckTreeNode]:
        """low index so key can be packed into a byte, but at bottom
        to make debug output easier to read
        """

    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        name: builtins.str = ...,
        level: builtins.int = ...,
        collapsed: builtins.bool = ...,
        review_count: builtins.int = ...,
        learn_count: builtins.int = ...,
        new_count: builtins.int = ...,
        intraday_learning: builtins.int = ...,
        interday_learning_uncapped: builtins.int = ...,
        new_uncapped: builtins.int = ...,
        review_uncapped: builtins.int = ...,
        total_in_deck: builtins.int = ...,
        total_including_children: builtins.int = ...,
        filtered: builtins.bool = ...,
        children: collections.abc.Iterable[global___DeckTreeNode] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["children", b"children", "collapsed", b"collapsed", "deck_id", b"deck_id", "filtered", b"filtered", "interday_learning_uncapped", b"interday_learning_uncapped", "intraday_learning", b"intraday_learning", "learn_count", b"learn_count", "level", b"level", "name", b"name", "new_count", b"new_count", "new_uncapped", b"new_uncapped", "review_count", b"review_count", "review_uncapped", b"review_uncapped", "total_in_deck", b"total_in_deck", "total_including_children", b"total_including_children"]) -> None: ...

global___DeckTreeNode = DeckTreeNode

@typing.final
class SetDeckCollapsedRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Scope:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ScopeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SetDeckCollapsedRequest._Scope.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REVIEWER: SetDeckCollapsedRequest._Scope.ValueType  # 0
        BROWSER: SetDeckCollapsedRequest._Scope.ValueType  # 1

    class Scope(_Scope, metaclass=_ScopeEnumTypeWrapper): ...
    REVIEWER: SetDeckCollapsedRequest.Scope.ValueType  # 0
    BROWSER: SetDeckCollapsedRequest.Scope.ValueType  # 1

    DECK_ID_FIELD_NUMBER: builtins.int
    COLLAPSED_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    collapsed: builtins.bool
    scope: global___SetDeckCollapsedRequest.Scope.ValueType
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        collapsed: builtins.bool = ...,
        scope: global___SetDeckCollapsedRequest.Scope.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["collapsed", b"collapsed", "deck_id", b"deck_id", "scope", b"scope"]) -> None: ...

global___SetDeckCollapsedRequest = SetDeckCollapsedRequest

@typing.final
class GetDeckNamesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SKIP_EMPTY_DEFAULT_FIELD_NUMBER: builtins.int
    INCLUDE_FILTERED_FIELD_NUMBER: builtins.int
    skip_empty_default: builtins.bool
    include_filtered: builtins.bool
    """if unset, implies skip_empty_default"""
    def __init__(
        self,
        *,
        skip_empty_default: builtins.bool = ...,
        include_filtered: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["include_filtered", b"include_filtered", "skip_empty_default", b"skip_empty_default"]) -> None: ...

global___GetDeckNamesRequest = GetDeckNamesRequest

@typing.final
class DeckNames(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeckNameId]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Iterable[global___DeckNameId] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries"]) -> None: ...

global___DeckNames = DeckNames

@typing.final
class DeckNameId(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    id: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "name", b"name"]) -> None: ...

global___DeckNameId = DeckNameId

@typing.final
class ReparentDecksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_IDS_FIELD_NUMBER: builtins.int
    NEW_PARENT_FIELD_NUMBER: builtins.int
    new_parent: builtins.int
    @property
    def deck_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        deck_ids: collections.abc.Iterable[builtins.int] | None = ...,
        new_parent: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_ids", b"deck_ids", "new_parent", b"new_parent"]) -> None: ...

global___ReparentDecksRequest = ReparentDecksRequest

@typing.final
class RenameDeckRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECK_ID_FIELD_NUMBER: builtins.int
    NEW_NAME_FIELD_NUMBER: builtins.int
    deck_id: builtins.int
    new_name: builtins.str
    def __init__(
        self,
        *,
        deck_id: builtins.int = ...,
        new_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deck_id", b"deck_id", "new_name", b"new_name"]) -> None: ...

global___RenameDeckRequest = RenameDeckRequest

@typing.final
class FilteredDeckForUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    ALLOW_EMPTY_FIELD_NUMBER: builtins.int
    id: builtins.int
    name: builtins.str
    allow_empty: builtins.bool
    @property
    def config(self) -> global___Deck.Filtered: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
        config: global___Deck.Filtered | None = ...,
        allow_empty: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow_empty", b"allow_empty", "config", b"config", "id", b"id", "name", b"name"]) -> None: ...

global___FilteredDeckForUpdate = FilteredDeckForUpdate
