# Copyright: Ankitects Pty Ltd and contributors
# License: GNU AGPL, version 3 or later; http://www.gnu.org/licenses/agpl.html

# This file is automatically generated from the *.ftl files.

from __future__ import annotations

from typing import Union

FluentVariable = Union[str, int, float]

class GeneratedTranslations:
    def _translate(self, module: int, translation: int, args: dict) -> str:
        raise Exception('not implemented')


    def about_a_big_thanks_to_all_the(self, ) -> str:
        r''' A big thanks to all the people who have provided suggestions, bug reports and donations. '''
        return self._translate(0, 0, {})


    def about_about_anki(self, ) -> str:
        r''' About Anki '''
        return self._translate(0, 1, {})


    def about_and_others(self, ) -> str:
        r''' and others '''
        return self._translate(0, 2, {})


    def about_anki_is_a_friendly_intelligent_spaced(self, ) -> str:
        r''' Anki is a friendly, intelligent spaced learning system. It's free and open source. '''
        return self._translate(0, 3, {})


    def about_anki_is_licensed_under_the_agpl3(self, ) -> str:
        r''' Anki is licensed under the AGPL3 license. Please see the license file in the source distribution for more information. '''
        return self._translate(0, 4, {})


    def about_copied_to_clipboard(self, ) -> str:
        r''' Copied to clipboard '''
        return self._translate(0, 5, {})


    def about_copy_debug_info(self, ) -> str:
        r''' Copy Debug Info '''
        return self._translate(0, 6, {})


    def about_if_you_have_contributed_and_are(self, ) -> str:
        r''' If you have contributed and are not on this list, please get in touch. '''
        return self._translate(0, 7, {})


    def about_version(self, val: FluentVariable) -> str:
        r''' Version {$val} '''
        return self._translate(0, 8, {"val": val})


    def about_visit_website(self, val: FluentVariable) -> str:
        r''' <a href='{$val}'>Visit website</a> '''
        return self._translate(0, 9, {"val": val})


    def about_written_by_damien_elmes_with_patches(self, cont: str) -> str:
        r''' Written by Damien Elmes, with patches, translation,    testing and design from:<p>{$cont} '''
        return self._translate(0, 10, {"cont": cont})


    def actions_add(self, ) -> str:
        r''' Add '''
        return self._translate(1, 0, {})


    def actions_add_deck(self, ) -> str:
        r''' Add Deck '''
        return self._translate(1, 1, {})


    def actions_add_note(self, ) -> str:
        r''' Add Note '''
        return self._translate(1, 2, {})


    def actions_add_notetype(self, ) -> str:
        r''' Add Note Type '''
        return self._translate(1, 3, {})


    def actions_all_selected(self, ) -> str:
        r''' All selected '''
        return self._translate(1, 4, {})


    def actions_answer_card(self, ) -> str:
        r''' Answer Card '''
        return self._translate(1, 5, {})


    def actions_any_selected(self, ) -> str:
        r''' Any selected '''
        return self._translate(1, 6, {})


    def actions_auto_advance(self, ) -> str:
        r''' Auto Advance '''
        return self._translate(1, 7, {})


    def actions_auto_advance_activated(self, ) -> str:
        r''' Auto Advance enabled '''
        return self._translate(1, 8, {})


    def actions_auto_advance_deactivated(self, ) -> str:
        r''' Auto Advance disabled '''
        return self._translate(1, 9, {})


    def actions_build_filtered_deck(self, ) -> str:
        r''' Build Deck '''
        return self._translate(1, 10, {})


    def actions_cancel(self, ) -> str:
        r''' Cancel '''
        return self._translate(1, 11, {})


    def actions_card_info(self, ) -> str:
        r''' Card Info '''
        return self._translate(1, 12, {})


    def actions_choose(self, ) -> str:
        r''' Choose '''
        return self._translate(1, 13, {})


    def actions_close(self, ) -> str:
        r''' Close '''
        return self._translate(1, 14, {})


    def actions_copy(self, ) -> str:
        r''' Copy '''
        return self._translate(1, 15, {})


    def actions_create_copy(self, ) -> str:
        r''' Create Copy '''
        return self._translate(1, 16, {})


    def actions_custom_study(self, ) -> str:
        r''' Custom Study '''
        return self._translate(1, 17, {})


    def actions_decks(self, ) -> str:
        r''' Decks '''
        return self._translate(1, 18, {})


    def actions_decrement_value(self, ) -> str:
        r''' Decrement value '''
        return self._translate(1, 19, {})


    def actions_delete(self, ) -> str:
        r''' Delete '''
        return self._translate(1, 20, {})


    def actions_discard(self, ) -> str:
        r''' Discard '''
        return self._translate(1, 21, {})


    def actions_empty_cards(self, ) -> str:
        r''' Empty Cards '''
        return self._translate(1, 22, {})


    def actions_export(self, ) -> str:
        r''' Export '''
        return self._translate(1, 23, {})


    def actions_filter(self, ) -> str:
        r''' Filter '''
        return self._translate(1, 24, {})


    def actions_flag_blue(self, ) -> str:
        r''' Blue '''
        return self._translate(1, 25, {})


    def actions_flag_green(self, ) -> str:
        r''' Green '''
        return self._translate(1, 26, {})


    def actions_flag_number(self, number: FluentVariable) -> str:
        r''' Flag {$number} '''
        return self._translate(1, 27, {"number": number})


    def actions_flag_orange(self, ) -> str:
        r''' Orange '''
        return self._translate(1, 28, {})


    def actions_flag_pink(self, ) -> str:
        r''' Pink '''
        return self._translate(1, 29, {})


    def actions_flag_purple(self, ) -> str:
        r''' Purple '''
        return self._translate(1, 30, {})


    def actions_flag_red(self, ) -> str:
        r''' Red '''
        return self._translate(1, 31, {})


    def actions_flag_turquoise(self, ) -> str:
        r''' Turquoise '''
        return self._translate(1, 32, {})


    def actions_forget_card(self, ) -> str:
        r''' Reset Card '''
        return self._translate(1, 33, {})


    def actions_fullscreen_unsupported(self, ) -> str:
        r''' Full screen mode is not supported for your video driver. Try switching to a different one from the preferences screen. '''
        return self._translate(1, 34, {})


    def actions_grade_now(self, ) -> str:
        r''' Grade Now '''
        return self._translate(1, 35, {})


    def actions_help(self, ) -> str:
        r''' Help '''
        return self._translate(1, 36, {})


    def actions_import(self, ) -> str:
        r''' Import '''
        return self._translate(1, 37, {})


    def actions_increment_value(self, ) -> str:
        r''' Increment value '''
        return self._translate(1, 38, {})


    def actions_manage(self, ) -> str:
        r''' Manage... '''
        return self._translate(1, 39, {})


    def actions_name(self, ) -> str:
        r''' Name: '''
        return self._translate(1, 40, {})


    def actions_new(self, ) -> str:
        r''' New '''
        return self._translate(1, 41, {})


    def actions_new_name(self, ) -> str:
        r''' New name: '''
        return self._translate(1, 42, {})


    def actions_nothing_to_redo(self, ) -> str:
        r''' Nothing to redo '''
        return self._translate(1, 43, {})


    def actions_nothing_to_undo(self, ) -> str:
        r''' Nothing to undo '''
        return self._translate(1, 44, {})


    def actions_options(self, ) -> str:
        r''' Options '''
        return self._translate(1, 45, {})


    def actions_options_for(self, val: FluentVariable) -> str:
        r''' Options for {$val} '''
        return self._translate(1, 46, {"val": val})


    def actions_preview(self, ) -> str:
        r''' Preview '''
        return self._translate(1, 47, {})


    def actions_previous_card_info(self, ) -> str:
        r''' Previous Card Info '''
        return self._translate(1, 48, {})


    def actions_processing(self, ) -> str:
        r''' Processing... '''
        return self._translate(1, 49, {})


    def actions_rebuild(self, ) -> str:
        r''' Rebuild '''
        return self._translate(1, 50, {})


    def actions_remove_notetype(self, ) -> str:
        r''' Remove Note Type '''
        return self._translate(1, 51, {})


    def actions_remove_tag(self, ) -> str:
        r''' Remove Tag '''
        return self._translate(1, 52, {})


    def actions_rename(self, ) -> str:
        r''' Rename '''
        return self._translate(1, 53, {})


    def actions_rename_deck(self, ) -> str:
        r''' Rename Deck '''
        return self._translate(1, 54, {})


    def actions_rename_tag(self, ) -> str:
        r''' Rename Tag '''
        return self._translate(1, 55, {})


    def actions_rename_with_parents(self, ) -> str:
        r''' Rename with Parents '''
        return self._translate(1, 56, {})


    def actions_replay_audio(self, ) -> str:
        r''' Replay Audio '''
        return self._translate(1, 57, {})


    def actions_reposition(self, ) -> str:
        r''' Reposition '''
        return self._translate(1, 58, {})


    def actions_save(self, ) -> str:
        r''' Save '''
        return self._translate(1, 59, {})


    def actions_search(self, ) -> str:
        r''' Search '''
        return self._translate(1, 60, {})


    def actions_select(self, ) -> str:
        r''' Select '''
        return self._translate(1, 61, {})


    def actions_set_due_date(self, ) -> str:
        r''' Set Due Date '''
        return self._translate(1, 62, {})


    def actions_set_flag(self, ) -> str:
        r''' Set Flag '''
        return self._translate(1, 63, {})


    def actions_shortcut_key(self, val: FluentVariable) -> str:
        r''' Shortcut key: {$val} '''
        return self._translate(1, 64, {"val": val})


    def actions_suspend_card(self, ) -> str:
        r''' Suspend Card '''
        return self._translate(1, 65, {})


    def actions_toggle_load_balancer(self, ) -> str:
        r''' Toggle Load Balancer '''
        return self._translate(1, 66, {})


    def actions_unbury_unsuspend(self, ) -> str:
        r''' Unbury/Unsuspend '''
        return self._translate(1, 67, {})


    def actions_update_card(self, ) -> str:
        r''' Update Card '''
        return self._translate(1, 68, {})


    def actions_update_config(self, ) -> str:
        r''' Update Config '''
        return self._translate(1, 69, {})


    def actions_update_deck(self, ) -> str:
        r''' Update Deck '''
        return self._translate(1, 70, {})


    def actions_update_note(self, ) -> str:
        r''' Update Note '''
        return self._translate(1, 71, {})


    def actions_update_notetype(self, ) -> str:
        r''' Update Note Type '''
        return self._translate(1, 72, {})


    def actions_update_tag(self, ) -> str:
        r''' Update Tag '''
        return self._translate(1, 73, {})


    def actions_with_ellipsis(self, action: str) -> str:
        r''' {$action}... '''
        return self._translate(1, 74, {"action": action})


    def adding_add_shortcut_ctrlandenter(self, ) -> str:
        r''' Add (shortcut: ctrl+enter) '''
        return self._translate(2, 0, {})


    def adding_added(self, ) -> str:
        r''' Added '''
        return self._translate(2, 1, {})


    def adding_cloze_outside_cloze_field(self, ) -> str:
        r''' Cloze deletion can only be used in fields which use the 'cloze:' filter. This is typically the first field. '''
        return self._translate(2, 2, {})


    def adding_cloze_outside_cloze_notetype(self, ) -> str:
        r''' Cloze deletion can only be used on cloze note types. '''
        return self._translate(2, 3, {})


    def adding_discard_current_input(self, ) -> str:
        r''' Discard current input? '''
        return self._translate(2, 4, {})


    def adding_edit(self, val: FluentVariable) -> str:
        r''' Edit "{$val}" '''
        return self._translate(2, 5, {"val": val})


    def adding_history(self, ) -> str:
        r''' History '''
        return self._translate(2, 6, {})


    def adding_keep_editing(self, ) -> str:
        r''' Keep Editing '''
        return self._translate(2, 7, {})


    def adding_note_deleted(self, ) -> str:
        r''' (Note deleted) '''
        return self._translate(2, 8, {})


    def adding_shortcut(self, val: FluentVariable) -> str:
        r''' Shortcut: {$val} '''
        return self._translate(2, 9, {"val": val})


    def adding_the_first_field_is_empty(self, ) -> str:
        r''' The first field is empty. '''
        return self._translate(2, 10, {})


    def adding_you_have_a_cloze_deletion_note(self, ) -> str:
        r''' You have a cloze note type but have not made any cloze deletions. Proceed? '''
        return self._translate(2, 11, {})


    def addons_addon_has_no_configuration(self, ) -> str:
        r''' Add-on has no configuration. '''
        return self._translate(3, 0, {})


    def addons_addon_installation_error(self, ) -> str:
        r''' Add-on installation error '''
        return self._translate(3, 1, {})


    def addons_browse_addons(self, ) -> str:
        r''' Browse Add-ons '''
        return self._translate(3, 2, {})


    def addons_changes_will_take_effect_when_anki(self, ) -> str:
        r''' Changes will take effect when Anki is restarted. '''
        return self._translate(3, 3, {})


    def addons_check_for_updates(self, ) -> str:
        r''' Check for Updates '''
        return self._translate(3, 4, {})


    def addons_checking(self, ) -> str:
        r''' Checking... '''
        return self._translate(3, 5, {})


    def addons_choose_update_update_all(self, ) -> str:
        r''' Update All '''
        return self._translate(3, 6, {})


    def addons_choose_update_window_title(self, ) -> str:
        r''' Update Add-ons '''
        return self._translate(3, 7, {})


    def addons_code(self, ) -> str:
        r''' Code: '''
        return self._translate(3, 8, {})


    def addons_config(self, ) -> str:
        r''' Config '''
        return self._translate(3, 9, {})


    def addons_config_validation_error(self, problem: str, path: str, schema: str) -> str:
        r''' There was a problem with the provided configuration: {$problem}, at path {$path}, against schema {$schema}. '''
        return self._translate(3, 10, {"problem": problem, "path": path, "schema": schema})


    def addons_config_window_title(self, name: str) -> str:
        r''' Configure '{$name}' '''
        return self._translate(3, 11, {"name": name})


    def addons_configuration(self, ) -> str:
        r''' Configuration '''
        return self._translate(3, 12, {})


    def addons_corrupt_addon_file(self, ) -> str:
        r''' Corrupt add-on file. '''
        return self._translate(3, 13, {})


    def addons_delete_the_numd_selected_addon(self, count: int) -> str:
        r''' Delete the {$count} selected add-ons? '''
        return self._translate(3, 14, {"count": count})


    def addons_disabled(self, ) -> str:
        r''' (disabled) '''
        return self._translate(3, 15, {})


    def addons_disabled2(self, ) -> str:
        r''' (disabled) '''
        return self._translate(3, 16, {})


    def addons_download_complete_please_restart_anki_to(self, ) -> str:
        r''' Download complete. Please restart Anki to apply changes. '''
        return self._translate(3, 17, {})


    def addons_downloaded_fnames(self, fname: str) -> str:
        r''' Downloaded {$fname} '''
        return self._translate(3, 18, {"fname": fname})


    def addons_downloading_adbd_kb02fkb(self, part: FluentVariable, total: int, kilobytes: int) -> str:
        r''' Downloading {$part}/{$total} ({$kilobytes}KB)... '''
        return self._translate(3, 19, {"part": part, "total": total, "kilobytes": kilobytes})


    def addons_error_downloading_ids_errors(self, id: str, error: str) -> str:
        r''' Error downloading <i>{$id}</i>: {$error} '''
        return self._translate(3, 20, {"id": id, "error": error})


    def addons_error_installing_bases_errors(self, base: str, error: str) -> str:
        r''' Error installing <i>{$base}</i>: {$error} '''
        return self._translate(3, 21, {"base": base, "error": error})


    def addons_failed_to_load(self, name: str, traceback: str) -> str:
        r''' An add-on you installed failed to load. If problems persist, please go to the Tools>Add-ons menu, and disable or delete the add-on.

When loading '{$name}':
{$traceback} '''
        return self._translate(3, 22, {"name": name, "traceback": traceback})


    def addons_failed_to_load2(self, addons: str) -> str:
        r''' The following add-ons failed to load:
{$addons}

They may need to be updated to support this version of Anki. Click the  button
to see if any updates are available.

You can use the  button to get information that you can paste in a report to
the add-on author.

For add-ons that don't have an update available, you can disable or delete the add-on to prevent this
message from appearing. '''
        return self._translate(3, 23, {"addons": addons})


    def addons_get_addons(self, ) -> str:
        r''' Get Add-ons... '''
        return self._translate(3, 24, {})


    def addons_important_as_addons_are_programs_downloaded(self, ) -> str:
        r''' <b>Important</b>: As add-ons are programs downloaded from the internet, they are potentially malicious.<b>You should only install add-ons you trust.</b><br><br>Are you sure you want to proceed with the installation of the following Anki add-on(s)?<br><br>%(names)s '''
        return self._translate(3, 25, {})


    def addons_install_addon(self, ) -> str:
        r''' Install Add-on '''
        return self._translate(3, 26, {})


    def addons_install_addons(self, ) -> str:
        r''' Install Add-on(s) '''
        return self._translate(3, 27, {})


    def addons_install_anki_addon(self, ) -> str:
        r''' Install Anki add-on '''
        return self._translate(3, 28, {})


    def addons_install_from_file(self, ) -> str:
        r''' Install from file... '''
        return self._translate(3, 29, {})


    def addons_installation_complete(self, ) -> str:
        r''' Installation complete '''
        return self._translate(3, 30, {})


    def addons_installed_names(self, name: str) -> str:
        r''' Installed {$name} '''
        return self._translate(3, 31, {"name": name})


    def addons_installed_successfully(self, ) -> str:
        r''' Installed successfully. '''
        return self._translate(3, 32, {})


    def addons_invalid_addon_manifest(self, ) -> str:
        r''' Invalid add-on manifest. '''
        return self._translate(3, 33, {})


    def addons_invalid_code(self, ) -> str:
        r''' Invalid code. '''
        return self._translate(3, 34, {})


    def addons_invalid_code_or_addon_not_available(self, ) -> str:
        r''' Invalid code, or add-on not available for your version of Anki. '''
        return self._translate(3, 35, {})


    def addons_invalid_configuration(self, ) -> str:
        r''' Invalid configuration: '''
        return self._translate(3, 36, {})


    def addons_invalid_configuration_top_level_object_must(self, ) -> str:
        r''' Invalid configuration: top level object must be a map '''
        return self._translate(3, 37, {})


    def addons_no_updates_available(self, ) -> str:
        r''' No updates available. '''
        return self._translate(3, 38, {})


    def addons_one_or_more_errors_occurred(self, ) -> str:
        r''' One or more errors occurred: '''
        return self._translate(3, 39, {})


    def addons_packaged_anki_addon(self, ) -> str:
        r''' Packaged Anki Add-on '''
        return self._translate(3, 40, {})


    def addons_please_check_your_internet_connection(self, ) -> str:
        r''' Please check your internet connection. '''
        return self._translate(3, 41, {})


    def addons_please_report_this_to_the_respective(self, ) -> str:
        r''' Please report this to the respective add-on author(s). '''
        return self._translate(3, 42, {})


    def addons_please_restart_anki_to_complete_the(self, ) -> str:
        r''' <b>Please restart Anki to complete the installation.</b> '''
        return self._translate(3, 43, {})


    def addons_please_select_a_single_addon_first(self, ) -> str:
        r''' Please select a single add-on first. '''
        return self._translate(3, 44, {})


    def addons_possibly_involved(self, addons: str) -> str:
        r''' Add-ons possibly involved: {$addons} '''
        return self._translate(3, 45, {"addons": addons})


    def addons_requires(self, val: FluentVariable) -> str:
        r''' (requires {$val}) '''
        return self._translate(3, 46, {"val": val})


    def addons_restored_defaults(self, ) -> str:
        r''' Restored defaults '''
        return self._translate(3, 47, {})


    def addons_startup_failed(self, ) -> str:
        r''' Add-on Startup Failed '''
        return self._translate(3, 48, {})


    def addons_the_following_addons_are_incompatible_with(self, name: str, found: FluentVariable) -> str:
        r''' The following add-ons are incompatible with {$name} and have been disabled: {$found} '''
        return self._translate(3, 49, {"name": name, "found": found})


    def addons_the_following_addons_have_updates_available(self, ) -> str:
        r''' The following add-ons have updates available. Install them now? '''
        return self._translate(3, 50, {})


    def addons_the_following_conflicting_addons_were_disabled(self, ) -> str:
        r''' The following conflicting add-ons were disabled: '''
        return self._translate(3, 51, {})


    def addons_this_addon_is_not_compatible_with(self, ) -> str:
        r''' This add-on is not compatible with your version of Anki. '''
        return self._translate(3, 52, {})


    def addons_to_browse_addons_please_click_the(self, ) -> str:
        r''' To browse add-ons, please click the browse button below.<br><br>When you've found an add-on you like, please paste its code below. You can paste multiple codes, separated by spaces. '''
        return self._translate(3, 53, {})


    def addons_toggle_enabled(self, ) -> str:
        r''' Toggle Enabled '''
        return self._translate(3, 54, {})


    def addons_unable_to_update_or_delete_addon(self, val: FluentVariable) -> str:
        r''' Unable to update or delete add-on. Please start Anki while holding down the shift key to temporarily disable add-ons, then try again.  Debug info: {$val} '''
        return self._translate(3, 55, {"val": val})


    def addons_unknown_error(self, val: FluentVariable) -> str:
        r''' Unknown error: {$val} '''
        return self._translate(3, 56, {"val": val})


    def addons_view_addon_page(self, ) -> str:
        r''' View Add-on Page '''
        return self._translate(3, 57, {})


    def addons_view_files(self, ) -> str:
        r''' View Files '''
        return self._translate(3, 58, {})


    def addons_window_title(self, ) -> str:
        r''' Add-ons '''
        return self._translate(3, 59, {})


    def browsing_add_notes(self, ) -> str:
        r''' Add Notes... '''
        return self._translate(4, 0, {})


    def browsing_add_tags2(self, ) -> str:
        r''' Add Tags... '''
        return self._translate(4, 1, {})


    def browsing_add_to_selected_notes(self, ) -> str:
        r''' Add to Selected Notes '''
        return self._translate(4, 2, {})


    def browsing_added_today(self, ) -> str:
        r''' Added '''
        return self._translate(4, 3, {})


    def browsing_addon(self, ) -> str:
        r''' Add-on '''
        return self._translate(4, 4, {})


    def browsing_again_today(self, ) -> str:
        r''' Again '''
        return self._translate(4, 5, {})


    def browsing_all_fields(self, ) -> str:
        r''' All Fields '''
        return self._translate(4, 6, {})


    def browsing_answer(self, ) -> str:
        r''' Answer '''
        return self._translate(4, 7, {})


    def browsing_any_flag(self, ) -> str:
        r''' Any Flag '''
        return self._translate(4, 8, {})


    def browsing_average_ease(self, ) -> str:
        r''' Avg. Ease '''
        return self._translate(4, 9, {})


    def browsing_average_interval(self, ) -> str:
        r''' Avg. Interval '''
        return self._translate(4, 10, {})


    def browsing_browser_appearance(self, ) -> str:
        r''' Browser Appearance '''
        return self._translate(4, 11, {})


    def browsing_browser_options(self, ) -> str:
        r''' Browser Options '''
        return self._translate(4, 12, {})


    def browsing_buried(self, ) -> str:
        r''' Buried '''
        return self._translate(4, 13, {})


    def browsing_card(self, ) -> str:
        r''' Card '''
        return self._translate(4, 14, {})


    def browsing_card_initial(self, ) -> str:
        r''' C '''
        return self._translate(4, 15, {})


    def browsing_card_list(self, ) -> str:
        r''' Card List '''
        return self._translate(4, 16, {})


    def browsing_cards(self, ) -> str:
        r''' Cards '''
        return self._translate(4, 17, {})


    def browsing_cards_cant_be_manually_moved_into(self, ) -> str:
        r''' Cards can't be manually moved into a filtered deck. '''
        return self._translate(4, 18, {})


    def browsing_cards_deleted(self, count: int) -> str:
        r''' {$count} cards deleted. '''
        return self._translate(4, 19, {"count": count})


    def browsing_cards_deleted_with_deckname(self, count: int, deck_name: str) -> str:
        r''' {$count} cards deleted from {$deck_name}. '''
        return self._translate(4, 20, {"count": count, "deck_name": deck_name})


    def browsing_cards_updated(self, count: int) -> str:
        r''' {$count} cards updated. '''
        return self._translate(4, 21, {"count": count})


    def browsing_change_deck(self, ) -> str:
        r''' Change Deck '''
        return self._translate(4, 22, {})


    def browsing_change_deck2(self, ) -> str:
        r''' Change Deck... '''
        return self._translate(4, 23, {})


    def browsing_change_note_type(self, ) -> str:
        r''' Change Note Type '''
        return self._translate(4, 24, {})


    def browsing_change_note_type2(self, ) -> str:
        r''' Change Note Type... '''
        return self._translate(4, 25, {})


    def browsing_change_notetype(self, ) -> str:
        r''' Change Note Type '''
        return self._translate(4, 26, {})


    def browsing_changed_new_position(self, count: int) -> str:
        r''' Changed position of {$count} new cards. '''
        return self._translate(4, 27, {"count": count})


    def browsing_clear_unused_tags(self, ) -> str:
        r''' Clear Unused Tags '''
        return self._translate(4, 28, {})


    def browsing_confirm_saved_search_overwrite(self, name: str) -> str:
        r''' A saved search with the name {$name} already exists. Do you want to overwrite it? '''
        return self._translate(4, 29, {"name": name})


    def browsing_created(self, ) -> str:
        r''' Created '''
        return self._translate(4, 30, {})


    def browsing_current_deck(self, ) -> str:
        r''' Current Deck '''
        return self._translate(4, 31, {})


    def browsing_current_note_type(self, ) -> str:
        r''' Current note type: '''
        return self._translate(4, 32, {})


    def browsing_delete_notes(self, ) -> str:
        r''' Delete Notes '''
        return self._translate(4, 33, {})


    def browsing_duplicate(self, ) -> str:
        r''' duplicate '''
        return self._translate(4, 34, {})


    def browsing_ease(self, ) -> str:
        r''' Ease '''
        return self._translate(4, 35, {})


    def browsing_edited_today(self, ) -> str:
        r''' Edited '''
        return self._translate(4, 36, {})


    def browsing_enter_tags_to_add(self, ) -> str:
        r''' Enter tags to add: '''
        return self._translate(4, 37, {})


    def browsing_enter_tags_to_delete(self, ) -> str:
        r''' Enter tags to delete: '''
        return self._translate(4, 38, {})


    def browsing_filtered(self, ) -> str:
        r''' (filtered) '''
        return self._translate(4, 39, {})


    def browsing_find(self, ) -> str:
        r''' <b>Find</b>: '''
        return self._translate(4, 40, {})


    def browsing_find_and_replace(self, ) -> str:
        r''' Find and Replace '''
        return self._translate(4, 41, {})


    def browsing_find_duplicates(self, ) -> str:
        r''' Find Duplicates '''
        return self._translate(4, 42, {})


    def browsing_first_card(self, ) -> str:
        r''' First Card '''
        return self._translate(4, 43, {})


    def browsing_flag(self, ) -> str:
        r''' Flag '''
        return self._translate(4, 44, {})


    def browsing_font(self, ) -> str:
        r''' <b>Font</b>: '''
        return self._translate(4, 45, {})


    def browsing_font_size(self, ) -> str:
        r''' <b>Font Size</b>: '''
        return self._translate(4, 46, {})


    def browsing_found_as_across_bs(self, part: FluentVariable, whole: str) -> str:
        r''' Found {$part} across {$whole}. '''
        return self._translate(4, 47, {"part": part, "whole": whole})


    def browsing_group(self, count: int) -> str:
        r''' {$count} groups '''
        return self._translate(4, 48, {"count": count})


    def browsing_ignore_case(self, ) -> str:
        r''' Ignore case '''
        return self._translate(4, 49, {})


    def browsing_in(self, ) -> str:
        r''' <b>In</b>: '''
        return self._translate(4, 50, {})


    def browsing_interval(self, ) -> str:
        r''' Interval '''
        return self._translate(4, 51, {})


    def browsing_last_card(self, ) -> str:
        r''' Last Card '''
        return self._translate(4, 52, {})


    def browsing_learning(self, ) -> str:
        r''' (learning) '''
        return self._translate(4, 53, {})


    def browsing_line_size(self, ) -> str:
        r''' <b>Line Size</b>: '''
        return self._translate(4, 54, {})


    def browsing_manage_note_types(self, ) -> str:
        r''' Manage Note Types '''
        return self._translate(4, 55, {})


    def browsing_move_cards(self, ) -> str:
        r''' Move Cards '''
        return self._translate(4, 56, {})


    def browsing_move_cards_to_deck(self, ) -> str:
        r''' Move cards to deck: '''
        return self._translate(4, 57, {})


    def browsing_new(self, ) -> str:
        r''' (new) '''
        return self._translate(4, 58, {})


    def browsing_new_note_type(self, ) -> str:
        r''' New note type: '''
        return self._translate(4, 59, {})


    def browsing_no_flag(self, ) -> str:
        r''' No Flag '''
        return self._translate(4, 60, {})


    def browsing_no_selection(self, ) -> str:
        r''' No cards or notes selected. '''
        return self._translate(4, 61, {})


    def browsing_note(self, ) -> str:
        r''' Note '''
        return self._translate(4, 62, {})


    def browsing_note_count(self, count: int) -> str:
        r''' {$count} notes '''
        return self._translate(4, 63, {"count": count})


    def browsing_note_initial(self, ) -> str:
        r''' N '''
        return self._translate(4, 64, {})


    def browsing_notes(self, ) -> str:
        r''' Notes '''
        return self._translate(4, 65, {})


    def browsing_notes_updated(self, count: int) -> str:
        r''' {$count} notes updated. '''
        return self._translate(4, 66, {"count": count})


    def browsing_optional_filter(self, ) -> str:
        r''' Optional filter: '''
        return self._translate(4, 67, {})


    def browsing_override_back_template(self, ) -> str:
        r''' Override back template: '''
        return self._translate(4, 68, {})


    def browsing_override_font(self, ) -> str:
        r''' Override font: '''
        return self._translate(4, 69, {})


    def browsing_override_front_template(self, ) -> str:
        r''' Override front template: '''
        return self._translate(4, 70, {})


    def browsing_please_give_your_filter_a_name(self, ) -> str:
        r''' Please give your filter a name: '''
        return self._translate(4, 71, {})


    def browsing_preview_selected_card(self, val: FluentVariable) -> str:
        r''' Preview Selected Card ({$val}) '''
        return self._translate(4, 72, {"val": val})


    def browsing_question(self, ) -> str:
        r''' Question '''
        return self._translate(4, 73, {})


    def browsing_queue_bottom(self, val: FluentVariable) -> str:
        r''' Queue bottom: {$val} '''
        return self._translate(4, 74, {"val": val})


    def browsing_queue_top(self, val: FluentVariable) -> str:
        r''' Queue top: {$val} '''
        return self._translate(4, 75, {"val": val})


    def browsing_randomize_order(self, ) -> str:
        r''' Randomize order '''
        return self._translate(4, 76, {})


    def browsing_remove_from_selected_notes(self, ) -> str:
        r''' Remove from Selected Notes '''
        return self._translate(4, 77, {})


    def browsing_remove_tags(self, ) -> str:
        r''' Remove Tags... '''
        return self._translate(4, 78, {})


    def browsing_removed_unused_tags_count(self, count: int) -> str:
        r''' Removed {$count} unused tags. '''
        return self._translate(4, 79, {"count": count})


    def browsing_reparented_decks(self, count: int) -> str:
        r''' Renamed {$count} decks. '''
        return self._translate(4, 80, {"count": count})


    def browsing_replace_with(self, ) -> str:
        r''' <b>Replace With</b>: '''
        return self._translate(4, 81, {})


    def browsing_reposition(self, ) -> str:
        r''' Reposition... '''
        return self._translate(4, 82, {})


    def browsing_reposition_new_cards(self, ) -> str:
        r''' Reposition New Cards '''
        return self._translate(4, 83, {})


    def browsing_reschedule(self, ) -> str:
        r''' Reschedule '''
        return self._translate(4, 84, {})


    def browsing_row_deleted(self, ) -> str:
        r''' (deleted) '''
        return self._translate(4, 85, {})


    def browsing_search_bar_hint(self, ) -> str:
        r''' Search cards/notes (type text, then press Enter) '''
        return self._translate(4, 86, {})


    def browsing_search_in(self, ) -> str:
        r''' Search in: '''
        return self._translate(4, 87, {})


    def browsing_search_within_formatting_slow(self, ) -> str:
        r''' Search within formatting (slow) '''
        return self._translate(4, 88, {})


    def browsing_select_deck(self, ) -> str:
        r''' Select Deck '''
        return self._translate(4, 89, {})


    def browsing_selected_notes_only(self, ) -> str:
        r''' Selected notes only '''
        return self._translate(4, 90, {})


    def browsing_shift_position_of_existing_cards(self, ) -> str:
        r''' Shift position of existing cards '''
        return self._translate(4, 91, {})


    def browsing_sidebar(self, ) -> str:
        r''' Sidebar '''
        return self._translate(4, 92, {})


    def browsing_sidebar_card_state(self, ) -> str:
        r''' Card State '''
        return self._translate(4, 93, {})


    def browsing_sidebar_card_state_review(self, ) -> str:
        r''' Review '''
        return self._translate(4, 94, {})


    def browsing_sidebar_collapse(self, ) -> str:
        r''' Collapse '''
        return self._translate(4, 95, {})


    def browsing_sidebar_collapse_children(self, ) -> str:
        r''' Collapse Children '''
        return self._translate(4, 96, {})


    def browsing_sidebar_decks(self, ) -> str:
        r''' Decks '''
        return self._translate(4, 97, {})


    def browsing_sidebar_due_today(self, ) -> str:
        r''' Due '''
        return self._translate(4, 98, {})


    def browsing_sidebar_expand(self, ) -> str:
        r''' Expand '''
        return self._translate(4, 99, {})


    def browsing_sidebar_expand_children(self, ) -> str:
        r''' Expand Children '''
        return self._translate(4, 100, {})


    def browsing_sidebar_filter(self, ) -> str:
        r''' Sidebar filter '''
        return self._translate(4, 101, {})


    def browsing_sidebar_first_review(self, ) -> str:
        r''' First Review '''
        return self._translate(4, 102, {})


    def browsing_sidebar_flags(self, ) -> str:
        r''' Flags '''
        return self._translate(4, 103, {})


    def browsing_sidebar_notetypes(self, ) -> str:
        r''' Note Types '''
        return self._translate(4, 104, {})


    def browsing_sidebar_overdue(self, ) -> str:
        r''' Overdue '''
        return self._translate(4, 105, {})


    def browsing_sidebar_rescheduled(self, ) -> str:
        r''' Rescheduled '''
        return self._translate(4, 106, {})


    def browsing_sidebar_save_current_search(self, ) -> str:
        r''' Save Current Search '''
        return self._translate(4, 107, {})


    def browsing_sidebar_saved_searches(self, ) -> str:
        r''' Saved Searches '''
        return self._translate(4, 108, {})


    def browsing_sidebar_tags(self, ) -> str:
        r''' Tags '''
        return self._translate(4, 109, {})


    def browsing_sidebar_untagged(self, ) -> str:
        r''' Untagged '''
        return self._translate(4, 110, {})


    def browsing_sort_field(self, ) -> str:
        r''' Sort Field '''
        return self._translate(4, 111, {})


    def browsing_sorting_on_this_column_is_not(self, ) -> str:
        r''' Sorting on this column is not supported. Please choose another. '''
        return self._translate(4, 112, {})


    def browsing_start_position(self, ) -> str:
        r''' Start position: '''
        return self._translate(4, 113, {})


    def browsing_step(self, ) -> str:
        r''' Step: '''
        return self._translate(4, 114, {})


    def browsing_studied_today(self, ) -> str:
        r''' Studied '''
        return self._translate(4, 115, {})


    def browsing_suspended(self, ) -> str:
        r''' Suspended '''
        return self._translate(4, 116, {})


    def browsing_tag_duplicates(self, ) -> str:
        r''' Tag Duplicates '''
        return self._translate(4, 117, {})


    def browsing_tag_rename_warning_empty(self, ) -> str:
        r''' You can't rename a tag that has no notes. '''
        return self._translate(4, 118, {})


    def browsing_target_field(self, ) -> str:
        r''' Target field: '''
        return self._translate(4, 119, {})


    def browsing_today(self, ) -> str:
        r''' Today '''
        return self._translate(4, 120, {})


    def browsing_toggle_bury(self, ) -> str:
        r''' Toggle Bury '''
        return self._translate(4, 121, {})


    def browsing_toggle_mark(self, ) -> str:
        r''' Toggle Mark '''
        return self._translate(4, 122, {})


    def browsing_toggle_showing_cards_notes(self, ) -> str:
        r''' Toggle Cards/Notes '''
        return self._translate(4, 123, {})


    def browsing_toggle_suspend(self, ) -> str:
        r''' Toggle Suspend '''
        return self._translate(4, 124, {})


    def browsing_tooltip_answer(self, ) -> str:
        r''' The back side of a card, customisable in the card template editor '''
        return self._translate(4, 125, {})


    def browsing_tooltip_card(self, ) -> str:
        r''' The name of a card's card template '''
        return self._translate(4, 126, {})


    def browsing_tooltip_card_modified(self, ) -> str:
        r''' The last time changes were made to a card, including reviews, flags and deck changes '''
        return self._translate(4, 127, {})


    def browsing_tooltip_cards(self, ) -> str:
        r''' The number of cards a note has '''
        return self._translate(4, 128, {})


    def browsing_tooltip_note_modified(self, ) -> str:
        r''' The last time changes were made to a note, usually field content or tag edits '''
        return self._translate(4, 129, {})


    def browsing_tooltip_notetype(self, ) -> str:
        r''' The name of a note's note type '''
        return self._translate(4, 130, {})


    def browsing_tooltip_question(self, ) -> str:
        r''' The front side of a card, customisable in the card template editor '''
        return self._translate(4, 131, {})


    def browsing_treat_input_as_regular_expression(self, ) -> str:
        r''' Treat input as regular expression '''
        return self._translate(4, 132, {})


    def browsing_update_saved_search(self, ) -> str:
        r''' Update with Current Search '''
        return self._translate(4, 133, {})


    def browsing_whole_collection(self, ) -> str:
        r''' Whole Collection '''
        return self._translate(4, 134, {})


    def browsing_window_title(self, selected: int, total: int) -> str:
        r''' Browse ({$selected} of {$total} cards selected) '''
        return self._translate(4, 135, {"selected": selected, "total": total})


    def browsing_window_title_notes(self, selected: int, total: int) -> str:
        r''' Browse ({$selected} of {$total} notes selected) '''
        return self._translate(4, 136, {"selected": selected, "total": total})


    def browsing_you_must_have_at_least_one(self, ) -> str:
        r''' You must have at least one column. '''
        return self._translate(4, 137, {})


    def card_stats_added(self, ) -> str:
        r''' Added '''
        return self._translate(5, 0, {})


    def card_stats_average_time(self, ) -> str:
        r''' Average Time '''
        return self._translate(5, 1, {})


    def card_stats_card_id(self, ) -> str:
        r''' Card ID '''
        return self._translate(5, 2, {})


    def card_stats_card_template(self, ) -> str:
        r''' Card Type '''
        return self._translate(5, 3, {})


    def card_stats_current_card(self, context: str) -> str:
        r''' Current Card ({$context}) '''
        return self._translate(5, 4, {"context": context})


    def card_stats_custom_data(self, ) -> str:
        r''' Custom Data '''
        return self._translate(5, 5, {})


    def card_stats_deck_name(self, ) -> str:
        r''' Deck '''
        return self._translate(5, 6, {})


    def card_stats_ease(self, ) -> str:
        r''' Ease '''
        return self._translate(5, 7, {})


    def card_stats_first_review(self, ) -> str:
        r''' First Review '''
        return self._translate(5, 8, {})


    def card_stats_fsrs_difficulty(self, ) -> str:
        r''' Difficulty '''
        return self._translate(5, 9, {})


    def card_stats_fsrs_forgetting_curve_all_time(self, ) -> str:
        r''' All Time '''
        return self._translate(5, 10, {})


    def card_stats_fsrs_forgetting_curve_desired_retention(self, ) -> str:
        r''' Desired Retention '''
        return self._translate(5, 11, {})


    def card_stats_fsrs_forgetting_curve_first_month(self, ) -> str:
        r''' First Month '''
        return self._translate(5, 12, {})


    def card_stats_fsrs_forgetting_curve_first_week(self, ) -> str:
        r''' First Week '''
        return self._translate(5, 13, {})


    def card_stats_fsrs_forgetting_curve_first_year(self, ) -> str:
        r''' First Year '''
        return self._translate(5, 14, {})


    def card_stats_fsrs_forgetting_curve_probability_of_recalling(self, ) -> str:
        r''' Probability of Recall '''
        return self._translate(5, 15, {})


    def card_stats_fsrs_forgetting_curve_title(self, ) -> str:
        r''' Forgetting Curve '''
        return self._translate(5, 16, {})


    def card_stats_fsrs_retrievability(self, ) -> str:
        r''' Retrievability '''
        return self._translate(5, 17, {})


    def card_stats_fsrs_stability(self, ) -> str:
        r''' Stability '''
        return self._translate(5, 18, {})


    def card_stats_interval(self, ) -> str:
        r''' Interval '''
        return self._translate(5, 19, {})


    def card_stats_lapse_count(self, ) -> str:
        r''' Lapses '''
        return self._translate(5, 20, {})


    def card_stats_latest_review(self, ) -> str:
        r''' Latest Review '''
        return self._translate(5, 21, {})


    def card_stats_new_card_position(self, ) -> str:
        r''' Position '''
        return self._translate(5, 22, {})


    def card_stats_no_card(self, ) -> str:
        r''' (No card to display.) '''
        return self._translate(5, 23, {})


    def card_stats_note_id(self, ) -> str:
        r''' Note ID '''
        return self._translate(5, 24, {})


    def card_stats_note_type(self, ) -> str:
        r''' Note Type '''
        return self._translate(5, 25, {})


    def card_stats_preset(self, ) -> str:
        r''' Preset '''
        return self._translate(5, 26, {})


    def card_stats_previous_card(self, context: str) -> str:
        r''' Previous Card ({$context}) '''
        return self._translate(5, 27, {"context": context})


    def card_stats_review_count(self, ) -> str:
        r''' Reviews '''
        return self._translate(5, 28, {})


    def card_stats_review_log_date(self, ) -> str:
        r''' Date '''
        return self._translate(5, 29, {})


    def card_stats_review_log_elapsed_time(self, ) -> str:
        r''' Elapsed Time '''
        return self._translate(5, 30, {})


    def card_stats_review_log_rating(self, ) -> str:
        r''' Rating '''
        return self._translate(5, 31, {})


    def card_stats_review_log_time_taken(self, ) -> str:
        r''' Time '''
        return self._translate(5, 32, {})


    def card_stats_review_log_type(self, ) -> str:
        r''' Type '''
        return self._translate(5, 33, {})


    def card_stats_review_log_type_filtered(self, ) -> str:
        r''' Filtered '''
        return self._translate(5, 34, {})


    def card_stats_review_log_type_learn(self, ) -> str:
        r''' Learn '''
        return self._translate(5, 35, {})


    def card_stats_review_log_type_manual(self, ) -> str:
        r''' Manual '''
        return self._translate(5, 36, {})


    def card_stats_review_log_type_relearn(self, ) -> str:
        r''' Relearn '''
        return self._translate(5, 37, {})


    def card_stats_review_log_type_rescheduled(self, ) -> str:
        r''' Rescheduled '''
        return self._translate(5, 38, {})


    def card_stats_review_log_type_review(self, ) -> str:
        r''' Review '''
        return self._translate(5, 39, {})


    def card_stats_total_time(self, ) -> str:
        r''' Total Time '''
        return self._translate(5, 40, {})


    def card_template_rendering_back_side_problem(self, ) -> str:
        r''' Back template has a problem: '''
        return self._translate(6, 0, {})


    def card_template_rendering_browser_back_side_problem(self, ) -> str:
        r''' Browser-specific back template has a problem: '''
        return self._translate(6, 1, {})


    def card_template_rendering_browser_front_side_problem(self, ) -> str:
        r''' Browser-specific front template has a problem: '''
        return self._translate(6, 2, {})


    def card_template_rendering_conditional_not_closed(self, missing: str) -> str:
        r''' Missing '{$missing}' '''
        return self._translate(6, 3, {"missing": missing})


    def card_template_rendering_conditional_not_open(self, found: FluentVariable, missing1: str, missing2: str) -> str:
        r''' Found '{$found}', but missing '{$missing1}' or '{$missing2}' '''
        return self._translate(6, 4, {"found": found, "missing1": missing1, "missing2": missing2})


    def card_template_rendering_empty_front(self, ) -> str:
        r''' The front of this card is blank. '''
        return self._translate(6, 5, {})


    def card_template_rendering_front_side_problem(self, ) -> str:
        r''' Front template has a problem: '''
        return self._translate(6, 6, {})


    def card_template_rendering_missing_cloze(self, number: FluentVariable) -> str:
        r''' No cloze {$number} found on card.
Please either add a cloze deletion, or use the Empty Cards tool. '''
        return self._translate(6, 7, {"number": number})


    def card_template_rendering_more_info(self, ) -> str:
        r''' More information '''
        return self._translate(6, 8, {})


    def card_template_rendering_no_closing_brackets(self, missing: str, tag: str) -> str:
        r''' Missing '{$missing}' in '{$tag}' '''
        return self._translate(6, 9, {"missing": missing, "tag": tag})


    def card_template_rendering_no_such_field(self, found: FluentVariable, field: str) -> str:
        r''' Found '{$found}', but there is no field called '{$field}' '''
        return self._translate(6, 10, {"found": found, "field": field})


    def card_template_rendering_wrong_conditional_closed(self, found: FluentVariable, expected: FluentVariable) -> str:
        r''' Found '{$found}', but expected '{$expected}' '''
        return self._translate(6, 11, {"found": found, "expected": expected})


    def card_templates_add_card_type(self, ) -> str:
        r''' Add Card Type... '''
        return self._translate(7, 0, {})


    def card_templates_add_mobile_class(self, ) -> str:
        r''' Add Mobile Class '''
        return self._translate(7, 1, {})


    def card_templates_anki_couldnt_find_the_line_between(self, ) -> str:
        r''' Anki couldn't find the line between the question and answer. Please adjust the template manually to switch the question and answer. '''
        return self._translate(7, 2, {})


    def card_templates_at_least_one_card_type_is(self, ) -> str:
        r''' At least one card type is required. '''
        return self._translate(7, 3, {})


    def card_templates_back_preview(self, ) -> str:
        r''' Back Preview '''
        return self._translate(7, 4, {})


    def card_templates_back_template(self, ) -> str:
        r''' Back Template '''
        return self._translate(7, 5, {})


    def card_templates_blank(self, ) -> str:
        r''' blank '''
        return self._translate(7, 6, {})


    def card_templates_browser_appearance(self, ) -> str:
        r''' Browser Appearance... '''
        return self._translate(7, 7, {})


    def card_templates_card(self, val: FluentVariable) -> str:
        r''' Card {$val} '''
        return self._translate(7, 8, {"val": val})


    def card_templates_card_count(self, count: int) -> str:
        r''' {$count} cards '''
        return self._translate(7, 9, {"count": count})


    def card_templates_card_type(self, ) -> str:
        r''' Card Type: '''
        return self._translate(7, 10, {})


    def card_templates_card_types_for(self, val: FluentVariable) -> str:
        r''' Card Types for {$val} '''
        return self._translate(7, 11, {"val": val})


    def card_templates_changes_saved(self, ) -> str:
        r''' Changes saved. '''
        return self._translate(7, 12, {})


    def card_templates_changes_will_affect_notes(self, count: int) -> str:
        r''' Changes below will affect the {$count} notes that use this card type. '''
        return self._translate(7, 13, {"count": count})


    def card_templates_cloze(self, val: FluentVariable) -> str:
        r''' Cloze {$val} '''
        return self._translate(7, 14, {"val": val})


    def card_templates_copy_info(self, ) -> str:
        r''' Copy Info to Clipboard '''
        return self._translate(7, 15, {})


    def card_templates_deck_override(self, ) -> str:
        r''' Deck Override... '''
        return self._translate(7, 16, {})


    def card_templates_delete_the_as_card_type_and(self, template: str, cards: int) -> str:
        r''' Delete the '{$template}' card type, and its {$cards}? '''
        return self._translate(7, 17, {"template": template, "cards": cards})


    def card_templates_discard_changes(self, ) -> str:
        r''' Discard changes? '''
        return self._translate(7, 18, {})


    def card_templates_enter_deck_to_place_new(self, val: FluentVariable) -> str:
        r''' Enter deck to place new {$val} cards in, or leave blank: '''
        return self._translate(7, 19, {"val": val})


    def card_templates_enter_new_card_position_1(self, val: FluentVariable) -> str:
        r''' Enter new card position (1...{$val}): '''
        return self._translate(7, 20, {"val": val})


    def card_templates_extraneous_cloze(self, ) -> str:
        r''' 'cloze:' can only be used on cloze note types. '''
        return self._translate(7, 21, {})


    def card_templates_field_not_found(self, field: str) -> str:
        r''' Field '{$field}' not found. '''
        return self._translate(7, 22, {"field": field})


    def card_templates_fill_empty(self, ) -> str:
        r''' Fill Empty Fields '''
        return self._translate(7, 23, {})


    def card_templates_flip(self, ) -> str:
        r''' Flip '''
        return self._translate(7, 24, {})


    def card_templates_form(self, ) -> str:
        r''' Form '''
        return self._translate(7, 25, {})


    def card_templates_front_preview(self, ) -> str:
        r''' Front Preview '''
        return self._translate(7, 26, {})


    def card_templates_front_template(self, ) -> str:
        r''' Front Template '''
        return self._translate(7, 27, {})


    def card_templates_identical_front(self, number: FluentVariable) -> str:
        r''' The front side is identical to card template {$number}. '''
        return self._translate(7, 28, {"number": number})


    def card_templates_invalid_template_number(self, number: FluentVariable, notetype: str) -> str:
        r''' Card template {$number} in note type '{$notetype}' has a problem. '''
        return self._translate(7, 29, {"number": number, "notetype": notetype})


    def card_templates_missing_cloze(self, ) -> str:
        r''' Expected to find 'cloze:Text' or similar on the front and back of the card template. '''
        return self._translate(7, 30, {})


    def card_templates_night_mode(self, ) -> str:
        r''' Night Mode '''
        return self._translate(7, 31, {})


    def card_templates_no_front_field(self, ) -> str:
        r''' Expected to find a field replacement on the front of the card template. '''
        return self._translate(7, 32, {})


    def card_templates_off(self, ) -> str:
        r''' (off) '''
        return self._translate(7, 33, {})


    def card_templates_on(self, ) -> str:
        r''' (on) '''
        return self._translate(7, 34, {})


    def card_templates_preview_box(self, ) -> str:
        r''' Preview '''
        return self._translate(7, 35, {})


    def card_templates_preview_settings(self, ) -> str:
        r''' Options '''
        return self._translate(7, 36, {})


    def card_templates_remove_card_type(self, ) -> str:
        r''' Remove Card Type... '''
        return self._translate(7, 37, {})


    def card_templates_rename_card_type(self, ) -> str:
        r''' Rename Card Type... '''
        return self._translate(7, 38, {})


    def card_templates_reposition_card_type(self, ) -> str:
        r''' Reposition Card Type... '''
        return self._translate(7, 39, {})


    def card_templates_restore_to_default(self, ) -> str:
        r''' Restore to Default '''
        return self._translate(7, 40, {})


    def card_templates_restore_to_default_confirmation(self, ) -> str:
        r''' This will reset all fields and templates in this note type to their default values, removing any extra fields/templates and their content, and any custom styling. Do you wish to proceed? '''
        return self._translate(7, 41, {})


    def card_templates_restored_to_default(self, ) -> str:
        r''' Note type has been restored to its original state. '''
        return self._translate(7, 42, {})


    def card_templates_sample_cloze(self, ) -> str:
        r''' This is a sample cloze deletion. '''
        return self._translate(7, 43, {})


    def card_templates_see_preview(self, ) -> str:
        r''' See the preview for more information. '''
        return self._translate(7, 44, {})


    def card_templates_template_box(self, ) -> str:
        r''' Template '''
        return self._translate(7, 45, {})


    def card_templates_template_styling(self, ) -> str:
        r''' Styling '''
        return self._translate(7, 46, {})


    def card_templates_this_will_create_card_proceed(self, count: int) -> str:
        r''' This will create {$count} cards. Proceed? '''
        return self._translate(7, 47, {"count": count})


    def card_templates_type_boxes_warning(self, ) -> str:
        r''' Only one typing box per card template is supported. '''
        return self._translate(7, 48, {})


    def change_notetype_collapse(self, ) -> str:
        r''' Collapse '''
        return self._translate(8, 0, {})


    def change_notetype_current(self, ) -> str:
        r''' Current '''
        return self._translate(8, 1, {})


    def change_notetype_expand(self, ) -> str:
        r''' Expand '''
        return self._translate(8, 2, {})


    def change_notetype_fields(self, ) -> str:
        r''' Fields '''
        return self._translate(8, 3, {})


    def change_notetype_new(self, ) -> str:
        r''' New '''
        return self._translate(8, 4, {})


    def change_notetype_nothing(self, ) -> str:
        r''' (Nothing) '''
        return self._translate(8, 5, {})


    def change_notetype_templates(self, ) -> str:
        r''' Templates '''
        return self._translate(8, 6, {})


    def change_notetype_to_from_cloze(self, ) -> str:
        r''' When changing to or from a Cloze note type, card numbers remain unchanged.

If changing to a regular note type, and there are more cloze deletions
than available card templates, any extra cards will be removed. '''
        return self._translate(8, 7, {})


    def change_notetype_will_discard_cards(self, ) -> str:
        r''' Will remove the following cards: '''
        return self._translate(8, 8, {})


    def change_notetype_will_discard_content(self, ) -> str:
        r''' Will discard content on the following fields: '''
        return self._translate(8, 9, {})


    def custom_study_all_cards_in_random_order_dont(self, ) -> str:
        r''' All cards in random order (don't reschedule) '''
        return self._translate(9, 0, {})


    def custom_study_all_review_cards_in_random_order(self, ) -> str:
        r''' All review cards in random order '''
        return self._translate(9, 1, {})


    def custom_study_available_child_count(self, count: int) -> str:
        r''' ({$count} in subdecks) '''
        return self._translate(9, 2, {"count": count})


    def custom_study_available_new_cards(self, count: int) -> str:
        r''' Available new cards: {$count} '''
        return self._translate(9, 3, {"count": count})


    def custom_study_available_new_cards_2(self, count_string: str) -> str:
        r''' Available new cards: {$countString} '''
        return self._translate(9, 4, {"countString": count_string})


    def custom_study_available_review_cards(self, count: int) -> str:
        r''' Available review cards: {$count} '''
        return self._translate(9, 5, {"count": count})


    def custom_study_available_review_cards_2(self, count_string: str) -> str:
        r''' Available review cards: {$countString} '''
        return self._translate(9, 6, {"countString": count_string})


    def custom_study_cards(self, ) -> str:
        r''' cards '''
        return self._translate(9, 7, {})


    def custom_study_cards_from_the_deck(self, ) -> str:
        r''' cards from the deck '''
        return self._translate(9, 8, {})


    def custom_study_choose_tags(self, ) -> str:
        r''' Choose Tags '''
        return self._translate(9, 9, {})


    def custom_study_custom_study_session(self, ) -> str:
        r''' Custom Study Session '''
        return self._translate(9, 10, {})


    def custom_study_due_cards_only(self, ) -> str:
        r''' Due cards only '''
        return self._translate(9, 11, {})


    def custom_study_increase_todays_new_card_limit(self, ) -> str:
        r''' Increase today's new card limit '''
        return self._translate(9, 12, {})


    def custom_study_increase_todays_new_card_limit_by(self, ) -> str:
        r''' Increase today's new card limit by '''
        return self._translate(9, 13, {})


    def custom_study_increase_todays_review_card_limit(self, ) -> str:
        r''' Increase today's review card limit '''
        return self._translate(9, 14, {})


    def custom_study_increase_todays_review_limit_by(self, ) -> str:
        r''' Increase today's review limit by '''
        return self._translate(9, 15, {})


    def custom_study_must_rename_deck(self, ) -> str:
        r''' Please rename the existing Custom Study deck first. '''
        return self._translate(9, 16, {})


    def custom_study_new_cards_only(self, ) -> str:
        r''' New cards only '''
        return self._translate(9, 17, {})


    def custom_study_no_cards_matched_the_criteria_you(self, ) -> str:
        r''' No cards matched the criteria you provided. '''
        return self._translate(9, 18, {})


    def custom_study_ok(self, ) -> str:
        r''' OK '''
        return self._translate(9, 19, {})


    def custom_study_preview_new_cards(self, ) -> str:
        r''' Preview new cards '''
        return self._translate(9, 20, {})


    def custom_study_preview_new_cards_added_in_the(self, ) -> str:
        r''' Preview new cards added in the last '''
        return self._translate(9, 21, {})


    def custom_study_require_one_or_more_of_these(self, ) -> str:
        r''' Require one or more of these tags: '''
        return self._translate(9, 22, {})


    def custom_study_review_ahead(self, ) -> str:
        r''' Review ahead '''
        return self._translate(9, 23, {})


    def custom_study_review_ahead_by(self, ) -> str:
        r''' Review ahead by '''
        return self._translate(9, 24, {})


    def custom_study_review_cards_forgotten_in_last(self, ) -> str:
        r''' Review cards forgotten in last '''
        return self._translate(9, 25, {})


    def custom_study_review_forgotten_cards(self, ) -> str:
        r''' Review forgotten cards '''
        return self._translate(9, 26, {})


    def custom_study_select(self, ) -> str:
        r''' Select '''
        return self._translate(9, 27, {})


    def custom_study_select_tags_to_exclude(self, ) -> str:
        r''' Select tags to exclude: '''
        return self._translate(9, 28, {})


    def custom_study_selective_study(self, ) -> str:
        r''' Selective Study '''
        return self._translate(9, 29, {})


    def custom_study_study_by_card_state_or_tag(self, ) -> str:
        r''' Study by card state or tag '''
        return self._translate(9, 30, {})


    def database_check_card_last_review_time_empty(self, count: int) -> str:
        r''' Added last review time to {$count} cards. '''
        return self._translate(10, 0, {"count": count})


    def database_check_card_missing_note(self, count: int) -> str:
        r''' Deleted {$count} cards with missing note. '''
        return self._translate(10, 1, {"count": count})


    def database_check_card_properties(self, count: int) -> str:
        r''' Fixed {$count} invalid card properties. '''
        return self._translate(10, 2, {"count": count})


    def database_check_checking_cards(self, ) -> str:
        r''' Checking cards... '''
        return self._translate(10, 3, {})


    def database_check_checking_history(self, ) -> str:
        r''' Checking history... '''
        return self._translate(10, 4, {})


    def database_check_checking_integrity(self, ) -> str:
        r''' Checking collection... '''
        return self._translate(10, 5, {})


    def database_check_checking_notes(self, ) -> str:
        r''' Checking notes... '''
        return self._translate(10, 6, {})


    def database_check_corrupt(self, ) -> str:
        r''' Collection file is corrupt. Please restore from an automatic backup. '''
        return self._translate(10, 7, {})


    def database_check_duplicate_card_ords(self, count: int) -> str:
        r''' Deleted {$count} cards with duplicate template. '''
        return self._translate(10, 8, {"count": count})


    def database_check_field_count(self, count: int) -> str:
        r''' Fixed {$count} notes with wrong field count. '''
        return self._translate(10, 9, {"count": count})


    def database_check_fixed_invalid_ids(self, count: int) -> str:
        r''' Fixed {$count} objects with timestamps in the future. '''
        return self._translate(10, 10, {"count": count})


    def database_check_missing_decks(self, count: int) -> str:
        r''' Fixed {$count} missing decks. '''
        return self._translate(10, 11, {"count": count})


    def database_check_missing_templates(self, count: int) -> str:
        r''' Deleted {$count} cards with missing template. '''
        return self._translate(10, 12, {"count": count})


    def database_check_new_card_high_due(self, count: int) -> str:
        r''' Found {$count} new cards with a due number >= 1,000,000 - consider repositioning them in the Browse screen. '''
        return self._translate(10, 13, {"count": count})


    def database_check_notes_with_invalid_utf8(self, count: int) -> str:
        r''' Fixed {$count} notes with invalid utf8 characters. '''
        return self._translate(10, 14, {"count": count})


    def database_check_notetypes_recovered(self, ) -> str:
        r''' One or more note types were missing. The notes that used them have been given new note types starting with "db-check", but field names and card design have been lost, so you may be better off restoring from an automatic backup. '''
        return self._translate(10, 15, {})


    def database_check_rebuilding(self, ) -> str:
        r''' Rebuilding... '''
        return self._translate(10, 16, {})


    def database_check_rebuilt(self, ) -> str:
        r''' Database rebuilt and optimized. '''
        return self._translate(10, 17, {})


    def database_check_revlog_properties(self, count: int) -> str:
        r''' Fixed {$count} review entries with invalid properties. '''
        return self._translate(10, 18, {"count": count})


    def database_check_title(self, ) -> str:
        r''' Check Database '''
        return self._translate(10, 19, {})


    def deck_config_a_100_day_interval(self, days: int) -> str:
        r''' A 100 day interval will become {$days} days. '''
        return self._translate(11, 0, {"days": days})


    def deck_config_add_group(self, ) -> str:
        r''' Add Preset '''
        return self._translate(11, 1, {})


    def deck_config_additional_new_cards_to_simulate(self, ) -> str:
        r''' Additional new cards to simulate '''
        return self._translate(11, 2, {})


    def deck_config_advanced_settings(self, ) -> str:
        r''' Advanced Settings '''
        return self._translate(11, 3, {})


    def deck_config_advanced_title(self, ) -> str:
        r''' Advanced '''
        return self._translate(11, 4, {})


    def deck_config_affects_entire_collection(self, ) -> str:
        r''' Affects the entire collection. '''
        return self._translate(11, 5, {})


    def deck_config_always_include_question_audio_tooltip(self, ) -> str:
        r''' Whether the question audio should be included when the Replay action is
used while looking at the answer side of a card. '''
        return self._translate(11, 6, {})


    def deck_config_answer_action(self, ) -> str:
        r''' Answer action '''
        return self._translate(11, 7, {})


    def deck_config_answer_action_tooltip(self, ) -> str:
        r''' The action to perform on the current card before automatically advancing to the next one. '''
        return self._translate(11, 8, {})


    def deck_config_answer_action_tooltip_2(self, ) -> str:
        r''' The action to perform after the answer is shown, and time has elapsed. '''
        return self._translate(11, 9, {})


    def deck_config_answer_again(self, ) -> str:
        r''' Answer Again '''
        return self._translate(11, 10, {})


    def deck_config_answer_good(self, ) -> str:
        r''' Answer Good '''
        return self._translate(11, 11, {})


    def deck_config_answer_hard(self, ) -> str:
        r''' Answer Hard '''
        return self._translate(11, 12, {})


    def deck_config_apply_all_parent_limits(self, ) -> str:
        r''' Limits start from top '''
        return self._translate(11, 13, {})


    def deck_config_apply_all_parent_limits_tooltip(self, ) -> str:
        r''' By default, the daily limits of a higher-level deck do not apply if you're studying from its subdeck.
If this option is enabled, the limits will
start from the top-level deck instead, which can be useful if you wish to study individual
subdecks, while enforcing a total limit on cards for the deck tree. '''
        return self._translate(11, 14, {})


    def deck_config_audio_title(self, ) -> str:
        r''' Audio '''
        return self._translate(11, 15, {})


    def deck_config_bury_if_new(self, ) -> str:
        r''' Bury if new '''
        return self._translate(11, 16, {})


    def deck_config_bury_if_new_or_review(self, ) -> str:
        r''' Bury if new or review '''
        return self._translate(11, 17, {})


    def deck_config_bury_if_new_review_or_interday(self, ) -> str:
        r''' Bury if new, review, or interday learning '''
        return self._translate(11, 18, {})


    def deck_config_bury_interday_learning_siblings(self, ) -> str:
        r''' Bury interday learning siblings '''
        return self._translate(11, 19, {})


    def deck_config_bury_interday_learning_tooltip(self, ) -> str:
        r''' Whether other `learning` cards of the same note with intervals > 1 day
will be delayed until the next day. '''
        return self._translate(11, 20, {})


    def deck_config_bury_new_siblings(self, ) -> str:
        r''' Bury new siblings '''
        return self._translate(11, 21, {})


    def deck_config_bury_new_tooltip(self, ) -> str:
        r''' Whether other `new` cards of the same note (e.g. reverse cards, adjacent cloze deletions)
will be delayed until the next day. '''
        return self._translate(11, 22, {})


    def deck_config_bury_priority_tooltip(self, ) -> str:
        r''' When Anki gathers cards, it first gathers intraday learning cards, then
interday learning cards, then review cards, and finally new cards. This affects
how burying works:

- If you have all burying options enabled, the sibling that comes earliest in
that list will be shown. For example, a review card will be shown in preference
to a new card.
- Siblings later in the list can not bury earlier card types. For example, if you
disable burying of new cards, and study a new card, it will not bury any interday
learning or review cards, and you may see both a review sibling and new sibling in the
same session. '''
        return self._translate(11, 23, {})


    def deck_config_bury_review_siblings(self, ) -> str:
        r''' Bury review siblings '''
        return self._translate(11, 24, {})


    def deck_config_bury_review_tooltip(self, ) -> str:
        r''' Whether other `review` cards of the same note will be delayed until the next day. '''
        return self._translate(11, 25, {})


    def deck_config_bury_siblings(self, ) -> str:
        r''' Bury siblings '''
        return self._translate(11, 26, {})


    def deck_config_bury_title(self, ) -> str:
        r''' Burying '''
        return self._translate(11, 27, {})


    def deck_config_bury_tooltip(self, ) -> str:
        r''' Siblings are other cards from the same note (eg forward/reverse cards, or
other cloze deletions from the same text).

When this option is off, multiple cards from the same note may be seen on the same
day. When enabled, Anki will automatically *bury* siblings, hiding them until the next
day. This option allows you to choose which kinds of cards may be buried when you answer
one of their siblings.

When using the V3 scheduler, interday learning cards can also be buried. Interday
learning cards are cards with a current learning step of one or more days. '''
        return self._translate(11, 28, {})


    def deck_config_checking_for_improvement(self, ) -> str:
        r''' Checking for improvement... '''
        return self._translate(11, 29, {})


    def deck_config_clear_last_simulate(self, ) -> str:
        r''' Clear Last Simulation '''
        return self._translate(11, 30, {})


    def deck_config_clone_group(self, ) -> str:
        r''' Clone Preset '''
        return self._translate(11, 31, {})


    def deck_config_complete(self, num: FluentVariable) -> str:
        r''' {$num}% complete. '''
        return self._translate(11, 32, {"num": num})


    def deck_config_compute_button(self, ) -> str:
        r''' Compute '''
        return self._translate(11, 33, {})


    def deck_config_compute_minimum_recommended_retention(self, ) -> str:
        r''' Minimum recommended retention '''
        return self._translate(11, 34, {})


    def deck_config_compute_optimal_retention(self, ) -> str:
        r''' Compute minimum recommended retention '''
        return self._translate(11, 35, {})


    def deck_config_compute_optimal_retention_tooltip(self, ) -> str:
        r''' This tool assumes you're starting with 0 cards, and will attempt to calculate the amount of material you'll
be able to retain in the given time frame. The estimated retention will greatly depend on your inputs, and
if it significantly differs from 0.9, it's a sign that the time you've allocated each day is either too low
or too high for the amount of cards you're trying to learn. This number can be useful as a reference, but it
is not recommended to copy it into the desired retention field. '''
        return self._translate(11, 36, {})


    def deck_config_compute_optimal_retention_tooltip2(self, ) -> str:
        r''' This tool assumes that you’re starting with 0 learned cards, and will attempt to find the desired retention
value that will lead to the most material learnt, in the least amount of time. This number can be used as a
reference when deciding what to set your desired retention to. You may wish to choose a higher desired retention,
if you’re willing to trade more study time for a greater recall rate. Setting your desired retention lower than
the minimum is not recommended, as it will lead to more work without benefit. '''
        return self._translate(11, 37, {})


    def deck_config_compute_optimal_retention_tooltip3(self, ) -> str:
        r''' This tool assumes that you’re starting with 0 learned cards, and will attempt to find the desired retention value 
that will lead to the most material learnt, in the least amount of time. To accurately simulate your learning process, 
this feature requires a minimum of 400+ reviews. The calculated number can serve as a reference when deciding what to 
set your desired retention to. You may wish to choose a higher desired retention, if you’re willing to trade more study 
time for a greater recall rate. Setting your desired retention lower than the minimum is not recommended, as it will 
lead to a higher workload, because of the high forgetting rate. '''
        return self._translate(11, 38, {})


    def deck_config_compute_optimal_retention_tooltip4(self, ) -> str:
        r''' This tool will attempt to find the desired retention value 
that will lead to the most material learnt, in the least amount of time. The calculated number can serve as a reference
when deciding what to set your desired retention to. You may wish to choose a higher desired retention if you’re 
willing to invest more study time to achieve it. Setting your desired retention lower than the minimum
is not recommended, as it will lead to a higher workload, because of the high forgetting rate. '''
        return self._translate(11, 39, {})


    def deck_config_compute_optimal_weights(self, ) -> str:
        r''' Optimize FSRS parameters '''
        return self._translate(11, 40, {})


    def deck_config_compute_optimal_weights_tooltip(self, ) -> str:
        r''' Once you've done 1000+ reviews in Anki, you can use the Optimize button to analyze your review history,
and automatically generate parameters that are optimal for your memory and the content you're studying.
If you have decks that vary wildly in difficulty, it is recommended to assign them separate presets, as
the parameters for easy decks and hard decks will be different. There is no need to optimize your parameters
frequently - once every few months is sufficient.

By default, parameters will be calculated from the review history of all decks using the current preset. You can
optionally adjust the search before calculating the parameters, if you'd like to alter which cards are used for
optimizing the parameters. '''
        return self._translate(11, 41, {})


    def deck_config_compute_optimal_weights_tooltip2(self, ) -> str:
        r''' When you click the Optimize button, FSRS will analyze your review history, and generate parameters that are 
optimal for your memory and the content you're studying. If your decks vary wildly in subjective difficulty, it 
is recommended to assign them separate presets, as the parameters for easy decks and hard decks will be different. 
You don't need to optimize your parameters frequently - once every few months is sufficient.

By default, parameters will be calculated from the review history of all decks using the current preset. You can
optionally adjust the search before calculating the parameters, if you'd like to alter which cards are used for
optimizing the parameters. '''
        return self._translate(11, 42, {})


    def deck_config_confirm_remove_name(self, name: str) -> str:
        r''' Remove {$name}? '''
        return self._translate(11, 43, {"name": name})


    def deck_config_custom_scheduling(self, ) -> str:
        r''' Custom scheduling '''
        return self._translate(11, 44, {})


    def deck_config_custom_scheduling_tooltip(self, ) -> str:
        r''' Affects the entire collection. Use at your own risk! '''
        return self._translate(11, 45, {})


    def deck_config_daily_limit_will_be_capped(self, cards: int) -> str:
        r''' A parent deck has a limit of {$cards} cards, which will override this limit. '''
        return self._translate(11, 46, {"cards": cards})


    def deck_config_daily_limits(self, ) -> str:
        r''' Daily Limits '''
        return self._translate(11, 47, {})


    def deck_config_days_to_simulate(self, ) -> str:
        r''' Days to simulate '''
        return self._translate(11, 48, {})


    def deck_config_deck_only(self, ) -> str:
        r''' This deck '''
        return self._translate(11, 49, {})


    def deck_config_default_name(self, ) -> str:
        r''' Default '''
        return self._translate(11, 50, {})


    def deck_config_description_new_handling(self, ) -> str:
        r''' Anki 2.1.41+ handling '''
        return self._translate(11, 51, {})


    def deck_config_description_new_handling_hint(self, ) -> str:
        r''' Treats input as markdown, and cleans HTML input. When enabled, the
description will also be shown on the congratulations screen.
Markdown will appear as text on Anki 2.1.40 and below. '''
        return self._translate(11, 52, {})


    def deck_config_desired_retention(self, ) -> str:
        r''' Desired retention '''
        return self._translate(11, 53, {})


    def deck_config_desired_retention_below_optimal(self, ) -> str:
        r''' Your desired retention is below optimal. Increasing it is recommended. '''
        return self._translate(11, 54, {})


    def deck_config_desired_retention_too_high(self, ) -> str:
        r''' Your desired retention is very high, which can lead to very short intervals. '''
        return self._translate(11, 55, {})


    def deck_config_desired_retention_too_low(self, ) -> str:
        r''' Your desired retention is very low, which can lead to very long intervals. '''
        return self._translate(11, 56, {})


    def deck_config_desired_retention_tooltip(self, ) -> str:
        r''' By default, Anki schedules cards so that you have a 90% chance of remembering them when
they come up for review again. If you increase this value, Anki will show cards more frequently
to increase the chances of you remembering them. If you decrease the value, Anki will show cards
less frequently, and you will forget more of them. Be conservative when adjusting this - higher
values will greatly increase your workload, and lower values can be demoralizing when you forget
a lot of material. '''
        return self._translate(11, 57, {})


    def deck_config_desired_retention_tooltip2(self, ) -> str:
        r''' The workload values provided by the info box are a rough approximation. For a greater level of accuracy, use the simulator. '''
        return self._translate(11, 58, {})


    def deck_config_disable_autoplay(self, ) -> str:
        r''' Don't play audio automatically '''
        return self._translate(11, 59, {})


    def deck_config_disable_autoplay_tooltip(self, ) -> str:
        r''' When enabled, Anki will not play audio automatically.
It can be played manually by clicking/tapping on an audio icon, or by using the Replay action. '''
        return self._translate(11, 60, {})


    def deck_config_display_order_will_use_current_deck(self, ) -> str:
        r''' Anki will use the display order from the deck you 
select to study, and not any subdecks it may have. '''
        return self._translate(11, 61, {})


    def deck_config_do_not_bury(self, ) -> str:
        r''' Do not bury siblings '''
        return self._translate(11, 62, {})


    def deck_config_easy_bonus_tooltip(self, ) -> str:
        r''' An extra multiplier that is applied to a review card's interval when you rate
it `Easy`. '''
        return self._translate(11, 63, {})


    def deck_config_easy_days_change(self, ) -> str:
        r''' Existing reviews will not be rescheduled unless '' is enabled in the FSRS options. '''
        return self._translate(11, 64, {})


    def deck_config_easy_days_friday(self, ) -> str:
        r''' Fri '''
        return self._translate(11, 65, {})


    def deck_config_easy_days_minimum(self, ) -> str:
        r''' Minimum '''
        return self._translate(11, 66, {})


    def deck_config_easy_days_monday(self, ) -> str:
        r''' Mon '''
        return self._translate(11, 67, {})


    def deck_config_easy_days_no_normal_days(self, ) -> str:
        r''' At least one day should be set to ''. '''
        return self._translate(11, 68, {})


    def deck_config_easy_days_normal(self, ) -> str:
        r''' Normal '''
        return self._translate(11, 69, {})


    def deck_config_easy_days_reduced(self, ) -> str:
        r''' Reduced '''
        return self._translate(11, 70, {})


    def deck_config_easy_days_saturday(self, ) -> str:
        r''' Sat '''
        return self._translate(11, 71, {})


    def deck_config_easy_days_sunday(self, ) -> str:
        r''' Sun '''
        return self._translate(11, 72, {})


    def deck_config_easy_days_thursday(self, ) -> str:
        r''' Thu '''
        return self._translate(11, 73, {})


    def deck_config_easy_days_title(self, ) -> str:
        r''' Easy Days '''
        return self._translate(11, 74, {})


    def deck_config_easy_days_tuesday(self, ) -> str:
        r''' Tue '''
        return self._translate(11, 75, {})


    def deck_config_easy_days_wednesday(self, ) -> str:
        r''' Wed '''
        return self._translate(11, 76, {})


    def deck_config_easy_interval_tooltip(self, ) -> str:
        r''' The number of days to wait before showing a card again, after the `Easy` button
is used to immediately remove a card from learning. '''
        return self._translate(11, 77, {})


    def deck_config_evaluate_button(self, ) -> str:
        r''' Evaluate '''
        return self._translate(11, 78, {})


    def deck_config_fsrs_bad_fit_warning(self, ) -> str:
        r''' Health Check:
Your memory is difficult for FSRS to predict. Recommendations:

- Suspend or reformulate any cards you constantly forget.
- Use the answer buttons consistently. Keep in mind that "Hard" is a passing grade, not a failing grade.
- Understand before you memorize.

If you follow these suggestions, performance will usually improve over the next few months. '''
        return self._translate(11, 79, {})


    def deck_config_fsrs_desired_retention_help_me_decide_experimental(self, ) -> str:
        r''' Help Me Decide (Experimental) '''
        return self._translate(11, 80, {})


    def deck_config_fsrs_good_fit(self, ) -> str:
        r''' Health Check:
FSRS can adapt to your memory well. '''
        return self._translate(11, 81, {})


    def deck_config_fsrs_must_be_enabled(self, ) -> str:
        r''' FSRS must be enabled first. '''
        return self._translate(11, 82, {})


    def deck_config_fsrs_on_all_clients(self, ) -> str:
        r''' Please ensure all of your Anki clients are Anki(Mobile) 23.10+ or AnkiDroid 2.17+. FSRS will
not work correctly if one of your clients is older. '''
        return self._translate(11, 83, {})


    def deck_config_fsrs_params_no_reviews(self, ) -> str:
        r''' No reviews found. Make sure this preset is assigned to all decks (including subdecks) that you want to optimize, and try again. '''
        return self._translate(11, 84, {})


    def deck_config_fsrs_params_optimal(self, ) -> str:
        r''' The FSRS parameters currently appear to be optimal. '''
        return self._translate(11, 85, {})


    def deck_config_fsrs_simulate_desired_retention_experimental(self, ) -> str:
        r''' FSRS Desired Retention Simulator (Experimental) '''
        return self._translate(11, 86, {})


    def deck_config_fsrs_simulate_save_preset(self, ) -> str:
        r''' After optimizing, please save your deck preset before running the simulator. '''
        return self._translate(11, 87, {})


    def deck_config_fsrs_simulator_experimental(self, ) -> str:
        r''' FSRS Simulator (Experimental) '''
        return self._translate(11, 88, {})


    def deck_config_fsrs_simulator_radio_count(self, ) -> str:
        r''' Reviews '''
        return self._translate(11, 89, {})


    def deck_config_fsrs_simulator_radio_memorized(self, ) -> str:
        r''' Memorized '''
        return self._translate(11, 90, {})


    def deck_config_fsrs_simulator_radio_ratio(self, ) -> str:
        r''' Time / Memorized Ratio '''
        return self._translate(11, 91, {})


    def deck_config_fsrs_simulator_ratio_tooltip(self, time: str) -> str:
        r''' {$time} per memorized card '''
        return self._translate(11, 92, {"time": time})


    def deck_config_fsrs_simulator_y_axis_title_count(self, ) -> str:
        r''' Review Count/Day '''
        return self._translate(11, 93, {})


    def deck_config_fsrs_simulator_y_axis_title_memorized(self, ) -> str:
        r''' Memorized Total '''
        return self._translate(11, 94, {})


    def deck_config_fsrs_simulator_y_axis_title_time(self, ) -> str:
        r''' Review Time/Day '''
        return self._translate(11, 95, {})


    def deck_config_fsrs_tooltip(self, ) -> str:
        r''' Affects the entire collection.

The Free Spaced Repetition Scheduler (FSRS) is an alternative to Anki's legacy SuperMemo 2 (SM-2) algorithm.
By more accurately determining how likely you are to forget a card, it can help you remember
more material in the same amount of time. This setting is shared by all presets. '''
        return self._translate(11, 96, {})


    def deck_config_get_params(self, ) -> str:
        r''' Get Params '''
        return self._translate(11, 97, {})


    def deck_config_good_above_easy(self, ) -> str:
        r''' The easy interval should be at least as long as the graduating interval. '''
        return self._translate(11, 98, {})


    def deck_config_graduating_interval_tooltip(self, ) -> str:
        r''' The number of days to wait before showing a card again, after the `Good` button
is pressed on the final learning step. '''
        return self._translate(11, 99, {})


    def deck_config_hard_interval_tooltip(self, ) -> str:
        r''' The multiplier applied to a review interval when answering `Hard`. '''
        return self._translate(11, 100, {})


    def deck_config_health_check(self, ) -> str:
        r''' Check health when optimizing '''
        return self._translate(11, 101, {})


    def deck_config_health_check_tooltip1(self, ) -> str:
        r''' This will show a warning if FSRS struggles to adapt to your memory. '''
        return self._translate(11, 102, {})


    def deck_config_health_check_tooltip2(self, ) -> str:
        r''' Health check is performed only when using Optimize Current Preset. '''
        return self._translate(11, 103, {})


    def deck_config_historical_retention(self, ) -> str:
        r''' Historical retention '''
        return self._translate(11, 104, {})


    def deck_config_historical_retention_tooltip(self, ) -> str:
        r''' When some of your review history is missing, FSRS needs to fill in the gaps. By default, it will
assume that when you did those old reviews, you remembered 90% of the material. If your old retention
was appreciably higher or lower than 90%, adjusting this option will allow FSRS to better approximate
the missing reviews.

Your review history may be incomplete for two reasons:
1. Because you're using the 'ignore cards reviewed before' option.
2. Because you previously deleted review logs to free up space, or imported material from a different
SRS program.

The latter is quite rare, so unless you're using the former option, you probably don't need to adjust
this option. '''
        return self._translate(11, 105, {})


    def deck_config_ignore_before(self, ) -> str:
        r''' Ignore cards reviewed before '''
        return self._translate(11, 106, {})


    def deck_config_ignore_before_info(self, included: str, total_cards: str) -> str:
        r''' (Approximately) {$included}/{$totalCards} cards will be used to optimize the FSRS parameters. '''
        return self._translate(11, 107, {"included": included, "totalCards": total_cards})


    def deck_config_ignore_before_tooltip(self, ) -> str:
        r''' If set, reviews before the provided date will be ignored when optimizing & evaluating FSRS parameters.
This can be useful if you imported someone else's scheduling data, or have changed the way you use the answer buttons. '''
        return self._translate(11, 108, {})


    def deck_config_ignore_before_tooltip_2(self, ) -> str:
        r''' If set, cards reviewed before the provided date will be ignored when optimizing FSRS parameters.
This can be useful if you imported someone else's scheduling data, or have changed the way you use the answer buttons. '''
        return self._translate(11, 109, {})


    def deck_config_interday_step_priority(self, ) -> str:
        r''' Interday learning/review order '''
        return self._translate(11, 110, {})


    def deck_config_interday_step_priority_tooltip(self, ) -> str:
        r''' When to show (re)learning cards that cross a day boundary.

The review limit is always applied first to interday learning cards, and
then review cards. This option will control the order the gathered cards are shown in,
but interday learning cards will always be gathered first. '''
        return self._translate(11, 111, {})


    def deck_config_interval_modifier_tooltip(self, ) -> str:
        r''' This multiplier is applied to all reviews, and minor adjustments can be used
to make Anki more conservative or aggressive in its scheduling. Please see
the manual before changing this option. '''
        return self._translate(11, 112, {})


    def deck_config_invalid_parameters(self, ) -> str:
        r''' The provided FSRS parameters are invalid. Leave them blank to use the default parameters. '''
        return self._translate(11, 113, {})


    def deck_config_invalid_weights(self, ) -> str:
        r''' Parameters must be either left blank to use the defaults, or must be 17 comma-separated numbers. '''
        return self._translate(11, 114, {})


    def deck_config_iterations(self, count: int) -> str:
        r''' Iteration: {$count}... '''
        return self._translate(11, 115, {"count": count})


    def deck_config_learning_step_above_graduating_interval(self, ) -> str:
        r''' The graduating interval should be at least as long as your final learning step. '''
        return self._translate(11, 116, {})


    def deck_config_learning_steps(self, ) -> str:
        r''' Learning steps '''
        return self._translate(11, 117, {})


    def deck_config_learning_steps_tooltip(self, ) -> str:
        r''' One or more delays, separated by spaces. The first delay will be used
when you press the `Again` button on a new card, and is 1 minute by default.
The `Good` button will advance to the next step, which is 10 minutes by default.
Once all steps have been passed, the card will become a review card, and
will appear on a different day.  '''
        return self._translate(11, 118, {})


    def deck_config_leech_action_tooltip(self, ) -> str:
        r''' `Tag Only`: Add a 'leech' tag to the note, and display a pop-up.

`Suspend Card`: In addition to tagging the note, hide the card until it is
manually unsuspended. '''
        return self._translate(11, 119, {})


    def deck_config_leech_threshold_tooltip(self, ) -> str:
        r''' The number of times `Again` needs to be pressed on a review card before it is
marked as a leech. Leeches are cards that consume a lot of your time, and
when a card is marked as a leech, it's a good idea to rewrite it, delete it, or
think of a mnemonic to help you remember it. '''
        return self._translate(11, 120, {})


    def deck_config_limit_deck_v3(self, ) -> str:
        r''' When studying a deck that has subdecks inside it, the limits set on each
subdeck control the maximum number of cards gathered from that particular deck.
The selected deck's limits control the total cards that will be shown. '''
        return self._translate(11, 121, {})


    def deck_config_limit_interday_bound_by_reviews(self, ) -> str:
        r''' The review limit also affects interday learning cards. When applying the limit,
interday learning cards are gathered first, then review cards. '''
        return self._translate(11, 122, {})


    def deck_config_limit_new_bound_by_reviews(self, ) -> str:
        r''' The review limit affects the new limit. For example, if your review limit is
set to 200, and you have 190 reviews waiting, a maximum of 10 new cards will
be introduced. If your review limit has been reached, no new cards will be
shown. '''
        return self._translate(11, 123, {})


    def deck_config_maximum_answer_secs(self, ) -> str:
        r''' Maximum answer seconds '''
        return self._translate(11, 124, {})


    def deck_config_maximum_answer_secs_above_recommended(self, ) -> str:
        r''' Anki can schedule your reviews more efficiently when you keep each question short. '''
        return self._translate(11, 125, {})


    def deck_config_maximum_answer_secs_tooltip(self, ) -> str:
        r''' The maximum number of seconds to record for a single review. If an answer
exceeds this time (because you stepped away from the screen for example),
the time taken will be recorded as the limit you have set. '''
        return self._translate(11, 126, {})


    def deck_config_maximum_interval_tooltip(self, ) -> str:
        r''' The maximum number of days a review card will wait. When reviews have
reached the limit, `Hard`, `Good` and `Easy` will all give the same delay.
The shorter you set this, the greater your workload will be. '''
        return self._translate(11, 127, {})


    def deck_config_minimum_interval_tooltip(self, ) -> str:
        r''' The minimum interval given to a review card after answering `Again`. '''
        return self._translate(11, 128, {})


    def deck_config_must_have_400_reviews(self, count: int) -> str:
        r''' Only {$count} reviews were found. You must have at least 400 reviews for this operation. '''
        return self._translate(11, 129, {"count": count})


    def deck_config_name_prompt(self, ) -> str:
        r''' Name '''
        return self._translate(11, 130, {})


    def deck_config_new_card_sort_order(self, ) -> str:
        r''' New card sort order '''
        return self._translate(11, 131, {})


    def deck_config_new_card_sort_order_tooltip_2(self, ) -> str:
        r''' `Card type, then order gathered`: Shows cards in order of card type number.
Cards of each card type number are shown in the order they were gathered. 
If you have sibling burying disabled, this will ensure all front→back cards are seen before any back→front cards.
This is useful to have all cards of the same note shown in the same session, but not
too close to one another.

`Order gathered`: Shows cards exactly as they were gathered. If sibling burying is disabled,
this will typically result in all cards of a note being seen one after the other.

`Card type, then random`: Shows cards in order of card type number. Cards of each card
type number are shown in a random order. This order is useful if you don't want sibling cards
to appear too close to each other, but still want the cards to appear in a random order.

`Random note, then card type`: Picks notes at random, then shows all of its cards
in order.

`Random`: Shows cards in a random order. '''
        return self._translate(11, 132, {})


    def deck_config_new_cards_ignore_review_limit(self, ) -> str:
        r''' New cards ignore review limit '''
        return self._translate(11, 133, {})


    def deck_config_new_cards_ignore_review_limit_tooltip(self, ) -> str:
        r''' By default, the review limit also applies to new cards, and no new cards will be
shown when the review limit has been reached. If this option is enabled, new cards
will be shown regardless of the review limit. '''
        return self._translate(11, 134, {})


    def deck_config_new_gather_priority(self, ) -> str:
        r''' New card gather order '''
        return self._translate(11, 135, {})


    def deck_config_new_gather_priority_deck(self, ) -> str:
        r''' Deck '''
        return self._translate(11, 136, {})


    def deck_config_new_gather_priority_deck_then_random_notes(self, ) -> str:
        r''' Deck, then random notes '''
        return self._translate(11, 137, {})


    def deck_config_new_gather_priority_position_highest_first(self, ) -> str:
        r''' Descending position '''
        return self._translate(11, 138, {})


    def deck_config_new_gather_priority_position_lowest_first(self, ) -> str:
        r''' Ascending position '''
        return self._translate(11, 139, {})


    def deck_config_new_gather_priority_random_cards(self, ) -> str:
        r''' Random cards '''
        return self._translate(11, 140, {})


    def deck_config_new_gather_priority_random_notes(self, ) -> str:
        r''' Random notes '''
        return self._translate(11, 141, {})


    def deck_config_new_gather_priority_tooltip_2(self, ) -> str:
        r''' `Deck`: Gathers cards from each subdeck in order, starting from the top. Cards from each subdeck are
gathered in ascending position. If the daily limit of the selected deck is reached, gathering
can stop before all subdecks have been checked. This order is fastest in large collections, and
allows you to prioritize subdecks that are closer to the top.

`Ascending position`: Gathers cards by ascending position (due #), which is typically
the oldest-added first.

`Descending position`: Gathers cards by descending position (due #), which is typically
the latest-added first.

`Random notes`: Picks notes at random, then gathers all of its cards.

`Random cards`: Gathers cards in a random order. '''
        return self._translate(11, 142, {})


    def deck_config_new_insertion_order(self, ) -> str:
        r''' Insertion order '''
        return self._translate(11, 143, {})


    def deck_config_new_insertion_order_random(self, ) -> str:
        r''' Random '''
        return self._translate(11, 144, {})


    def deck_config_new_insertion_order_random_with_v3(self, ) -> str:
        r''' With the v3 scheduler, it is better to leave this set to sequential, and
adjust the new card gather order instead. '''
        return self._translate(11, 145, {})


    def deck_config_new_insertion_order_sequential(self, ) -> str:
        r''' Sequential (oldest cards first) '''
        return self._translate(11, 146, {})


    def deck_config_new_insertion_order_tooltip(self, ) -> str:
        r''' Controls the position (due #) new cards are assigned when you add new cards.
Cards with a lower due number will be shown first when studying. Changing
this option will automatically update the existing position of new cards. '''
        return self._translate(11, 147, {})


    def deck_config_new_interval_tooltip(self, ) -> str:
        r''' The multiplier applied to a review interval when answering `Again`. '''
        return self._translate(11, 148, {})


    def deck_config_new_limit_tooltip(self, ) -> str:
        r''' The maximum number of new cards to introduce in a day, if new cards are available.
Because new material will increase your short-term review workload, this should typically
be at least 10x smaller than your review limit. '''
        return self._translate(11, 149, {})


    def deck_config_new_review_priority(self, ) -> str:
        r''' New/review order '''
        return self._translate(11, 150, {})


    def deck_config_new_review_priority_tooltip(self, ) -> str:
        r''' When to show new cards in relation to review cards. '''
        return self._translate(11, 151, {})


    def deck_config_not_enough_history(self, ) -> str:
        r''' Insufficient review history to perform this operation. '''
        return self._translate(11, 152, {})


    def deck_config_optimize_all_tip(self, ) -> str:
        r''' You can optimize all presets at once by using the dropdown button next to "Save". '''
        return self._translate(11, 153, {})


    def deck_config_optimize_button(self, ) -> str:
        r''' Optimize Current Preset '''
        return self._translate(11, 154, {})


    def deck_config_optimizing_preset(self, current_count: int, total_count: int) -> str:
        r''' Optimizing preset {$current_count}/{$total_count}... '''
        return self._translate(11, 155, {"current_count": current_count, "total_count": total_count})


    def deck_config_ordering_title(self, ) -> str:
        r''' Display Order '''
        return self._translate(11, 156, {})


    def deck_config_percent_input(self, pct: str) -> str:
        r''' {$pct}% '''
        return self._translate(11, 157, {"pct": pct})


    def deck_config_percent_of_reviews(self, reviews: int, pct: str) -> str:
        r''' {$pct}% of {$reviews} reviews '''
        return self._translate(11, 158, {"reviews": reviews, "pct": pct})


    def deck_config_please_save_your_changes_first(self, ) -> str:
        r''' Please save your changes first. '''
        return self._translate(11, 159, {})


    def deck_config_plotted_on_x_axis(self, ) -> str:
        r''' (Plotted on the X-axis) '''
        return self._translate(11, 160, {})


    def deck_config_predicted_minimum_recommended_retention(self, num: FluentVariable) -> str:
        r''' Minimum recommended retention: {$num} '''
        return self._translate(11, 161, {"num": num})


    def deck_config_predicted_optimal_retention(self, num: FluentVariable) -> str:
        r''' Minimum recommended retention: {$num} '''
        return self._translate(11, 162, {"num": num})


    def deck_config_question_action(self, ) -> str:
        r''' Question action '''
        return self._translate(11, 163, {})


    def deck_config_question_action_show_answer(self, ) -> str:
        r''' Show Answer '''
        return self._translate(11, 164, {})


    def deck_config_question_action_show_reminder(self, ) -> str:
        r''' Show Reminder '''
        return self._translate(11, 165, {})


    def deck_config_question_action_tool_tip(self, ) -> str:
        r''' The action to perform after the question is shown, and time has elapsed. '''
        return self._translate(11, 166, {})


    def deck_config_relearning_steps(self, ) -> str:
        r''' Relearning steps '''
        return self._translate(11, 167, {})


    def deck_config_relearning_steps_above_minimum_interval(self, ) -> str:
        r''' The minimum lapse interval should be at least as long as your final relearning step. '''
        return self._translate(11, 168, {})


    def deck_config_relearning_steps_tooltip(self, ) -> str:
        r''' Zero or more delays, separated by spaces. By default, pressing the `Again`
button on a review card will show it again 10 minutes later. If no delays
are provided, the card will have its interval changed, without entering
relearning.  '''
        return self._translate(11, 169, {})


    def deck_config_remove_group(self, ) -> str:
        r''' Remove Preset '''
        return self._translate(11, 170, {})


    def deck_config_rename_group(self, ) -> str:
        r''' Rename Preset '''
        return self._translate(11, 171, {})


    def deck_config_reschedule_cards_on_change(self, ) -> str:
        r''' Reschedule cards on change '''
        return self._translate(11, 172, {})


    def deck_config_reschedule_cards_on_change_tooltip(self, ) -> str:
        r''' Affects the entire collection, and is not saved.

This option controls whether the due dates of cards will be changed when you enable FSRS, or optimize
the parameters. The default is not to reschedule cards: future reviews will use the new scheduling, but
there will be no immediate change to your workload. If rescheduling is enabled, the due dates of cards
will be changed. '''
        return self._translate(11, 173, {})


    def deck_config_reschedule_cards_warning(self, ) -> str:
        r''' Depending on your desired retention, this can result in a large number of cards becoming
due, so is not recommended when first switching from SM-2.

Use this option sparingly, as it will add a review entry to each of your cards, and
increase the size of your collection. '''
        return self._translate(11, 174, {})


    def deck_config_revert_button_tooltip(self, ) -> str:
        r''' Restore this setting to its default value? '''
        return self._translate(11, 175, {})


    def deck_config_review_limit_tooltip(self, ) -> str:
        r''' The maximum number of review cards to show in a day,
if cards are ready for review. '''
        return self._translate(11, 176, {})


    def deck_config_review_mix_mix_with_reviews(self, ) -> str:
        r''' Mix with reviews '''
        return self._translate(11, 177, {})


    def deck_config_review_mix_show_after_reviews(self, ) -> str:
        r''' Show after reviews '''
        return self._translate(11, 178, {})


    def deck_config_review_mix_show_before_reviews(self, ) -> str:
        r''' Show before reviews '''
        return self._translate(11, 179, {})


    def deck_config_review_sort_order(self, ) -> str:
        r''' Review sort order '''
        return self._translate(11, 180, {})


    def deck_config_review_sort_order_tooltip(self, ) -> str:
        r''' The default order prioritizes cards that have been waiting longest, so that
if you have a backlog of reviews, the longest-waiting ones will appear
first. If you have a large backlog that will take more than a few days to
clear, or wish to see cards in subdeck order, you may find the alternate
sort orders preferable. '''
        return self._translate(11, 181, {})


    def deck_config_reviews_too_low(self, cards: int, expected: FluentVariable) -> str:
        r''' If adding {$cards} new cards each day, your review limit should be at least {$expected}. '''
        return self._translate(11, 182, {"cards": cards, "expected": expected})


    def deck_config_save_and_optimize(self, ) -> str:
        r''' Optimize All Presets '''
        return self._translate(11, 183, {})


    def deck_config_save_button(self, ) -> str:
        r''' Save '''
        return self._translate(11, 184, {})


    def deck_config_save_options_to_preset(self, ) -> str:
        r''' Save Changes to Preset '''
        return self._translate(11, 185, {})


    def deck_config_save_options_to_preset_confirm(self, ) -> str:
        r''' Overwrite the options in your current preset with the options that are currently set in the simulator? '''
        return self._translate(11, 186, {})


    def deck_config_save_to_all_subdecks(self, ) -> str:
        r''' Save to All Subdecks '''
        return self._translate(11, 187, {})


    def deck_config_seconds_to_show_answer(self, ) -> str:
        r''' Seconds to show answer for '''
        return self._translate(11, 188, {})


    def deck_config_seconds_to_show_answer_tooltip_2(self, ) -> str:
        r''' When auto advance is activated, the number of seconds to wait before applying the answer action. Set to 0 to disable. '''
        return self._translate(11, 189, {})


    def deck_config_seconds_to_show_question(self, ) -> str:
        r''' Seconds to show question for '''
        return self._translate(11, 190, {})


    def deck_config_seconds_to_show_question_tooltip(self, ) -> str:
        r''' When auto advance is activated, the number of seconds to wait before revealing the answer. Set to 0 to disable. '''
        return self._translate(11, 191, {})


    def deck_config_seconds_to_show_question_tooltip_2(self, ) -> str:
        r''' When auto advance is activated, the number of seconds to wait before revealing the answer. Set to 0 to disable. '''
        return self._translate(11, 192, {})


    def deck_config_seconds_to_show_question_tooltip_3(self, ) -> str:
        r''' When auto advance is activated, the number of seconds to wait before applying the question action. Set to 0 to disable. '''
        return self._translate(11, 193, {})


    def deck_config_shared_preset(self, ) -> str:
        r''' Preset '''
        return self._translate(11, 194, {})


    def deck_config_show_answer_timer_tooltip(self, ) -> str:
        r''' On the Study screen, show a timer that counts the time you're
taking to study each card. '''
        return self._translate(11, 195, {})


    def deck_config_show_reminder(self, ) -> str:
        r''' Show Reminder '''
        return self._translate(11, 196, {})


    def deck_config_simulate(self, ) -> str:
        r''' Simulate '''
        return self._translate(11, 197, {})


    def deck_config_skip_question_when_replaying(self, ) -> str:
        r''' Skip question when replaying answer '''
        return self._translate(11, 198, {})


    def deck_config_slow_suffix(self, text: str) -> str:
        r''' {$text} (slow) '''
        return self._translate(11, 199, {"text": text})


    def deck_config_smaller_is_better(self, ) -> str:
        r''' Smaller numbers indicate a better fit to your review history. '''
        return self._translate(11, 200, {})


    def deck_config_smooth_graph(self, ) -> str:
        r''' Smooth graph '''
        return self._translate(11, 201, {})


    def deck_config_sort_order_ascending_difficulty(self, ) -> str:
        r''' Easy cards first '''
        return self._translate(11, 202, {})


    def deck_config_sort_order_ascending_ease(self, ) -> str:
        r''' Ascending ease '''
        return self._translate(11, 203, {})


    def deck_config_sort_order_ascending_intervals(self, ) -> str:
        r''' Ascending intervals '''
        return self._translate(11, 204, {})


    def deck_config_sort_order_card_template_then_random(self, ) -> str:
        r''' Card type, then random '''
        return self._translate(11, 205, {})


    def deck_config_sort_order_deck_then_due_date(self, ) -> str:
        r''' Deck, then due date '''
        return self._translate(11, 206, {})


    def deck_config_sort_order_descending_difficulty(self, ) -> str:
        r''' Difficult cards first '''
        return self._translate(11, 207, {})


    def deck_config_sort_order_descending_ease(self, ) -> str:
        r''' Descending ease '''
        return self._translate(11, 208, {})


    def deck_config_sort_order_descending_intervals(self, ) -> str:
        r''' Descending intervals '''
        return self._translate(11, 209, {})


    def deck_config_sort_order_due_date_then_deck(self, ) -> str:
        r''' Due date, then deck '''
        return self._translate(11, 210, {})


    def deck_config_sort_order_due_date_then_random(self, ) -> str:
        r''' Due date, then random '''
        return self._translate(11, 211, {})


    def deck_config_sort_order_gather(self, ) -> str:
        r''' Order gathered '''
        return self._translate(11, 212, {})


    def deck_config_sort_order_random(self, ) -> str:
        r''' Random '''
        return self._translate(11, 213, {})


    def deck_config_sort_order_random_note_then_template(self, ) -> str:
        r''' Random note, then card type '''
        return self._translate(11, 214, {})


    def deck_config_sort_order_retrievability_ascending(self, ) -> str:
        r''' Ascending retrievability '''
        return self._translate(11, 215, {})


    def deck_config_sort_order_retrievability_descending(self, ) -> str:
        r''' Descending retrievability '''
        return self._translate(11, 216, {})


    def deck_config_sort_order_template_then_gather(self, ) -> str:
        r''' Card type, then order gathered '''
        return self._translate(11, 217, {})


    def deck_config_starting_ease_tooltip(self, ) -> str:
        r''' The ease multiplier new cards start with. By default, the `Good` button on a
newly-learned card will delay the next review by 2.5x the previous delay. '''
        return self._translate(11, 218, {})


    def deck_config_steps_too_large_for_fsrs(self, ) -> str:
        r''' When FSRS is enabled, steps of 1 day or more are not recommended. '''
        return self._translate(11, 219, {})


    def deck_config_stop_timer_on_answer(self, ) -> str:
        r''' Stop on-screen timer on answer '''
        return self._translate(11, 220, {})


    def deck_config_stop_timer_on_answer_tooltip(self, ) -> str:
        r''' Whether to stop the on-screen timer when the answer is revealed.
This doesn't affect statistics. '''
        return self._translate(11, 221, {})


    def deck_config_suspend_leeches(self, ) -> str:
        r''' Suspend leeches '''
        return self._translate(11, 222, {})


    def deck_config_tab_description(self, ) -> str:
        r''' - `Preset`: The limit applies to all decks using this preset.
- `This deck`: The limit is specific to this deck.
- `Today only`: Make a temporary change to this deck's limit. '''
        return self._translate(11, 223, {})


    def deck_config_time_to_optimize(self, ) -> str:
        r''' It's been a while - using the Optimize All Presets button is recommended. '''
        return self._translate(11, 224, {})


    def deck_config_timer_title(self, ) -> str:
        r''' Timers '''
        return self._translate(11, 225, {})


    def deck_config_title(self, ) -> str:
        r''' Deck Options '''
        return self._translate(11, 226, {})


    def deck_config_today_only(self, ) -> str:
        r''' Today only '''
        return self._translate(11, 227, {})


    def deck_config_too_short_maximum_interval(self, ) -> str:
        r''' A maximum interval less than 6 months is not recommended. '''
        return self._translate(11, 228, {})


    def deck_config_unable_to_determine_desired_retention(self, ) -> str:
        r''' Unable to determine a minimum recommended retention. '''
        return self._translate(11, 229, {})


    def deck_config_updating_cards(self, current_cards_count: int, total_cards_count: int) -> str:
        r''' Updating cards: {$current_cards_count}/{$total_cards_count}... '''
        return self._translate(11, 230, {"current_cards_count": current_cards_count, "total_cards_count": total_cards_count})


    def deck_config_used_by_decks(self, decks: int) -> str:
        r''' used by {$decks} decks '''
        return self._translate(11, 231, {"decks": decks})


    def deck_config_wait_for_audio(self, ) -> str:
        r''' Wait for audio '''
        return self._translate(11, 232, {})


    def deck_config_wait_for_audio_tooltip(self, ) -> str:
        r''' Wait for audio to finish before automatically revealing answer or next question. '''
        return self._translate(11, 233, {})


    def deck_config_wait_for_audio_tooltip_2(self, ) -> str:
        r''' Wait for audio to finish before automatically applying the question action or answer action. '''
        return self._translate(11, 234, {})


    def deck_config_weights(self, ) -> str:
        r''' FSRS parameters '''
        return self._translate(11, 235, {})


    def deck_config_weights_tooltip(self, ) -> str:
        r''' FSRS parameters affect how cards are scheduled. Anki will start with default parameters. Once
you've accumulated 1000+ reviews, you can use the option below to optimize the parameters to best
match your performance in decks using this preset. '''
        return self._translate(11, 236, {})


    def deck_config_weights_tooltip2(self, ) -> str:
        r''' FSRS parameters affect how cards are scheduled. Anki will start with default parameters. You can use 
the option below to optimize the parameters to best match your performance in decks using this preset. '''
        return self._translate(11, 237, {})


    def deck_config_which_deck(self, ) -> str:
        r''' Which deck would you like to display options for? '''
        return self._translate(11, 238, {})


    def deck_config_will_require_full_sync(self, ) -> str:
        r''' The requested change will require a one-way sync. If you have made changes
on another device, and not synced them to this device yet, please do so before
you proceed. '''
        return self._translate(11, 239, {})


    def deck_config_workload_factor_change(self, factor: str, previous_dr: str) -> str:
        r''' Approximate workload: {$factor}x
(compared to {$previousDR}% desired retention) '''
        return self._translate(11, 240, {"factor": factor, "previousDR": previous_dr})


    def deck_config_workload_factor_unchanged(self, ) -> str:
        r''' The higher this value, the more frequently cards will be shown to you. '''
        return self._translate(11, 241, {})


    def decks_add_new_deck_ctrlandn(self, ) -> str:
        r''' Add New Deck (Ctrl+N) '''
        return self._translate(12, 0, {})


    def decks_build(self, ) -> str:
        r''' Build '''
        return self._translate(12, 1, {})


    def decks_cards_selected_by(self, ) -> str:
        r''' cards selected by '''
        return self._translate(12, 2, {})


    def decks_create_deck(self, ) -> str:
        r''' Create Deck '''
        return self._translate(12, 3, {})


    def decks_custom_steps_in_minutes(self, ) -> str:
        r''' Custom steps (in minutes) '''
        return self._translate(12, 4, {})


    def decks_deck(self, ) -> str:
        r''' Deck '''
        return self._translate(12, 5, {})


    def decks_decreasing_intervals(self, ) -> str:
        r''' Decreasing intervals '''
        return self._translate(12, 6, {})


    def decks_delay_for_button(self, button: str) -> str:
        r''' Delay for {$button} '''
        return self._translate(12, 7, {"button": button})


    def decks_delete_deck(self, ) -> str:
        r''' Delete Deck '''
        return self._translate(12, 8, {})


    def decks_enable_second_filter(self, ) -> str:
        r''' Enable second filter '''
        return self._translate(12, 9, {})


    def decks_filter(self, ) -> str:
        r''' Filter: '''
        return self._translate(12, 10, {})


    def decks_filter_2(self, ) -> str:
        r''' Filter 2 '''
        return self._translate(12, 11, {})


    def decks_filtered_deck_search_empty(self, ) -> str:
        r''' No cards matched the provided search. Some cards may have been excluded because they are in a different filtered deck, or suspended. '''
        return self._translate(12, 12, {})


    def decks_get_shared(self, ) -> str:
        r''' Get Shared '''
        return self._translate(12, 13, {})


    def decks_import_file(self, ) -> str:
        r''' Import File '''
        return self._translate(12, 14, {})


    def decks_increasing_intervals(self, ) -> str:
        r''' Increasing intervals '''
        return self._translate(12, 15, {})


    def decks_latest_added_first(self, ) -> str:
        r''' Latest added first '''
        return self._translate(12, 16, {})


    def decks_learn_header(self, ) -> str:
        r''' Learn '''
        return self._translate(12, 17, {})


    def decks_limit_to(self, ) -> str:
        r''' Limit to '''
        return self._translate(12, 18, {})


    def decks_minutes(self, ) -> str:
        r''' minutes '''
        return self._translate(12, 19, {})


    def decks_most_lapses(self, ) -> str:
        r''' Most lapses '''
        return self._translate(12, 20, {})


    def decks_new_deck_name(self, ) -> str:
        r''' New deck name: '''
        return self._translate(12, 21, {})


    def decks_no_deck(self, ) -> str:
        r''' [no deck] '''
        return self._translate(12, 22, {})


    def decks_oldest_seen_first(self, ) -> str:
        r''' Oldest seen first '''
        return self._translate(12, 23, {})


    def decks_order_added(self, ) -> str:
        r''' Order added '''
        return self._translate(12, 24, {})


    def decks_order_due(self, ) -> str:
        r''' Order due '''
        return self._translate(12, 25, {})


    def decks_please_select_something(self, ) -> str:
        r''' Please select something. '''
        return self._translate(12, 26, {})


    def decks_random(self, ) -> str:
        r''' Random '''
        return self._translate(12, 27, {})


    def decks_relative_overdueness(self, ) -> str:
        r''' Relative overdueness '''
        return self._translate(12, 28, {})


    def decks_repeat_failed_cards_after(self, ) -> str:
        r''' Delay Repeat failed cards after '''
        return self._translate(12, 29, {})


    def decks_reschedule_cards_based_on_my_answers(self, ) -> str:
        r''' Reschedule cards based on my answers in this deck '''
        return self._translate(12, 30, {})


    def decks_review_header(self, ) -> str:
        r''' Due '''
        return self._translate(12, 31, {})


    def decks_study(self, ) -> str:
        r''' Study '''
        return self._translate(12, 32, {})


    def decks_study_deck(self, ) -> str:
        r''' Study Deck '''
        return self._translate(12, 33, {})


    def decks_unmovable_cards(self, ) -> str:
        r''' Show any excluded cards '''
        return self._translate(12, 34, {})


    def decks_zero_minutes_hint(self, ) -> str:
        r''' (0 = return card to original deck) '''
        return self._translate(12, 35, {})


    def decks_create_even_if_empty(self, ) -> str:
        r''' Create/update this deck even if empty '''
        return self._translate(12, 36, {})


    def editing_actual_size(self, ) -> str:
        r''' Toggle actual size '''
        return self._translate(13, 0, {})


    def editing_add_media(self, ) -> str:
        r''' Add Media '''
        return self._translate(13, 1, {})


    def editing_align_left(self, ) -> str:
        r''' Align left '''
        return self._translate(13, 2, {})


    def editing_align_right(self, ) -> str:
        r''' Align right '''
        return self._translate(13, 3, {})


    def editing_alignment(self, ) -> str:
        r''' Alignment '''
        return self._translate(13, 4, {})


    def editing_an_error_occurred_while_opening(self, val: FluentVariable) -> str:
        r''' An error occurred while opening {$val} '''
        return self._translate(13, 5, {"val": val})


    def editing_attach_picturesaudiovideo(self, ) -> str:
        r''' Attach pictures/audio/video '''
        return self._translate(13, 6, {})


    def editing_bold_text(self, ) -> str:
        r''' Bold text '''
        return self._translate(13, 7, {})


    def editing_cards(self, ) -> str:
        r''' Cards '''
        return self._translate(13, 8, {})


    def editing_center(self, ) -> str:
        r''' Center '''
        return self._translate(13, 9, {})


    def editing_change_color(self, ) -> str:
        r''' Change color '''
        return self._translate(13, 10, {})


    def editing_close_html_tags(self, ) -> str:
        r''' Auto-close HTML tags '''
        return self._translate(13, 11, {})


    def editing_cloze_deletion(self, ) -> str:
        r''' Cloze deletion (new card) '''
        return self._translate(13, 12, {})


    def editing_cloze_deletion_repeat(self, ) -> str:
        r''' Cloze deletion (same card) '''
        return self._translate(13, 13, {})


    def editing_collapse(self, ) -> str:
        r''' Collapse '''
        return self._translate(13, 14, {})


    def editing_collapse_field(self, ) -> str:
        r''' Collapse field '''
        return self._translate(13, 15, {})


    def editing_copy_image(self, ) -> str:
        r''' Copy image '''
        return self._translate(13, 16, {})


    def editing_couldnt_record_audio_have_you_installed(self, ) -> str:
        r''' Couldn't record audio. Have you installed 'lame'? '''
        return self._translate(13, 17, {})


    def editing_customize_card_templates(self, ) -> str:
        r''' Customize Card Templates '''
        return self._translate(13, 18, {})


    def editing_customize_fields(self, ) -> str:
        r''' Customize Fields '''
        return self._translate(13, 19, {})


    def editing_cut(self, ) -> str:
        r''' Cut '''
        return self._translate(13, 20, {})


    def editing_double_click_image(self, ) -> str:
        r''' double-click image '''
        return self._translate(13, 21, {})


    def editing_double_click_to_collapse(self, ) -> str:
        r''' double-click to collapse '''
        return self._translate(13, 22, {})


    def editing_double_click_to_expand(self, ) -> str:
        r''' double-click to expand '''
        return self._translate(13, 23, {})


    def editing_edit_current(self, ) -> str:
        r''' Edit Current '''
        return self._translate(13, 24, {})


    def editing_edit_html(self, ) -> str:
        r''' Edit HTML '''
        return self._translate(13, 25, {})


    def editing_equations(self, ) -> str:
        r''' Equations '''
        return self._translate(13, 26, {})


    def editing_expand(self, ) -> str:
        r''' Expand '''
        return self._translate(13, 27, {})


    def editing_expand_field(self, ) -> str:
        r''' Expand field '''
        return self._translate(13, 28, {})


    def editing_fields(self, ) -> str:
        r''' Fields '''
        return self._translate(13, 29, {})


    def editing_float_left(self, ) -> str:
        r''' Float left '''
        return self._translate(13, 30, {})


    def editing_float_none(self, ) -> str:
        r''' No float '''
        return self._translate(13, 31, {})


    def editing_float_right(self, ) -> str:
        r''' Float right '''
        return self._translate(13, 32, {})


    def editing_from_clipboard(self, ) -> str:
        r''' From Clipboard '''
        return self._translate(13, 33, {})


    def editing_html_editor(self, ) -> str:
        r''' HTML Editor '''
        return self._translate(13, 34, {})


    def editing_image_occlusion_align_bottom(self, ) -> str:
        r''' Align Bottom '''
        return self._translate(13, 35, {})


    def editing_image_occlusion_align_h_center(self, ) -> str:
        r''' Align Horizontal Centers '''
        return self._translate(13, 36, {})


    def editing_image_occlusion_align_left(self, ) -> str:
        r''' Align Left '''
        return self._translate(13, 37, {})


    def editing_image_occlusion_align_right(self, ) -> str:
        r''' Align Right '''
        return self._translate(13, 38, {})


    def editing_image_occlusion_align_top(self, ) -> str:
        r''' Align Top '''
        return self._translate(13, 39, {})


    def editing_image_occlusion_align_v_center(self, ) -> str:
        r''' Align Vertical Centers '''
        return self._translate(13, 40, {})


    def editing_image_occlusion_alignment(self, ) -> str:
        r''' Alignment '''
        return self._translate(13, 41, {})


    def editing_image_occlusion_confirm_reset(self, ) -> str:
        r''' Are you sure you want to reset this image occlusion? '''
        return self._translate(13, 42, {})


    def editing_image_occlusion_delete(self, ) -> str:
        r''' Delete '''
        return self._translate(13, 43, {})


    def editing_image_occlusion_duplicate(self, ) -> str:
        r''' Duplicate '''
        return self._translate(13, 44, {})


    def editing_image_occlusion_ellipse_tool(self, ) -> str:
        r''' Ellipse '''
        return self._translate(13, 45, {})


    def editing_image_occlusion_fill_tool(self, ) -> str:
        r''' Fill with colour '''
        return self._translate(13, 46, {})


    def editing_image_occlusion_group(self, ) -> str:
        r''' Group Selection '''
        return self._translate(13, 47, {})


    def editing_image_occlusion_mode(self, ) -> str:
        r''' Image Occlusion Mode '''
        return self._translate(13, 48, {})


    def editing_image_occlusion_polygon_tool(self, ) -> str:
        r''' Polygon '''
        return self._translate(13, 49, {})


    def editing_image_occlusion_rectangle_tool(self, ) -> str:
        r''' Rectangle '''
        return self._translate(13, 50, {})


    def editing_image_occlusion_reset(self, ) -> str:
        r''' Reset Image Occlusion '''
        return self._translate(13, 51, {})


    def editing_image_occlusion_select_all(self, ) -> str:
        r''' Select All '''
        return self._translate(13, 52, {})


    def editing_image_occlusion_select_tool(self, ) -> str:
        r''' Select '''
        return self._translate(13, 53, {})


    def editing_image_occlusion_text_tool(self, ) -> str:
        r''' Text '''
        return self._translate(13, 54, {})


    def editing_image_occlusion_toggle_mask_editor(self, ) -> str:
        r''' Toggle Mask Editor '''
        return self._translate(13, 55, {})


    def editing_image_occlusion_toggle_translucent(self, ) -> str:
        r''' Toggle Translucency '''
        return self._translate(13, 56, {})


    def editing_image_occlusion_ungroup(self, ) -> str:
        r''' Ungroup Selection '''
        return self._translate(13, 57, {})


    def editing_image_occlusion_zoom_in(self, ) -> str:
        r''' Zoom In '''
        return self._translate(13, 58, {})


    def editing_image_occlusion_zoom_out(self, ) -> str:
        r''' Zoom Out '''
        return self._translate(13, 59, {})


    def editing_image_occlusion_zoom_reset(self, ) -> str:
        r''' Reset Zoom '''
        return self._translate(13, 60, {})


    def editing_image_occlusion_zoom_tool(self, ) -> str:
        r''' Zoom '''
        return self._translate(13, 61, {})


    def editing_indent(self, ) -> str:
        r''' Increase indent '''
        return self._translate(13, 62, {})


    def editing_italic_text(self, ) -> str:
        r''' Italic text '''
        return self._translate(13, 63, {})


    def editing_jump_to_tags_with_ctrlandshiftandt(self, ) -> str:
        r''' Jump to tags with Ctrl+Shift+T '''
        return self._translate(13, 64, {})


    def editing_justify(self, ) -> str:
        r''' Justify '''
        return self._translate(13, 65, {})


    def editing_latex(self, ) -> str:
        r''' LaTeX '''
        return self._translate(13, 66, {})


    def editing_latex_equation(self, ) -> str:
        r''' LaTeX equation '''
        return self._translate(13, 67, {})


    def editing_latex_math_env(self, ) -> str:
        r''' LaTeX math env. '''
        return self._translate(13, 68, {})


    def editing_mathjax_block(self, ) -> str:
        r''' MathJax block '''
        return self._translate(13, 69, {})


    def editing_mathjax_chemistry(self, ) -> str:
        r''' MathJax chemistry '''
        return self._translate(13, 70, {})


    def editing_mathjax_inline(self, ) -> str:
        r''' MathJax inline '''
        return self._translate(13, 71, {})


    def editing_mathjax_placeholder(self, accept: str, newline: str) -> str:
        r''' Press {$accept} to accept, {$newline} for new line. '''
        return self._translate(13, 72, {"accept": accept, "newline": newline})


    def editing_mathjax_preview(self, ) -> str:
        r''' MathJax Preview '''
        return self._translate(13, 73, {})


    def editing_media(self, ) -> str:
        r''' Media '''
        return self._translate(13, 74, {})


    def editing_no_image_found_on_clipboard(self, ) -> str:
        r''' No image found on clipboard. '''
        return self._translate(13, 75, {})


    def editing_open_image(self, ) -> str:
        r''' Open image '''
        return self._translate(13, 76, {})


    def editing_ordered_list(self, ) -> str:
        r''' Ordered list '''
        return self._translate(13, 77, {})


    def editing_outdent(self, ) -> str:
        r''' Decrease indent '''
        return self._translate(13, 78, {})


    def editing_paste(self, ) -> str:
        r''' Paste '''
        return self._translate(13, 79, {})


    def editing_record_audio(self, ) -> str:
        r''' Record audio '''
        return self._translate(13, 80, {})


    def editing_remove_formatting(self, ) -> str:
        r''' Remove formatting '''
        return self._translate(13, 81, {})


    def editing_restore_original_size(self, ) -> str:
        r''' Restore original size '''
        return self._translate(13, 82, {})


    def editing_select_remove_formatting(self, ) -> str:
        r''' Select formatting to remove '''
        return self._translate(13, 83, {})


    def editing_show_duplicates(self, ) -> str:
        r''' Show Duplicates '''
        return self._translate(13, 84, {})


    def editing_show_in_folder(self, ) -> str:
        r''' Show in folder '''
        return self._translate(13, 85, {})


    def editing_shrink_images(self, ) -> str:
        r''' Shrink Images '''
        return self._translate(13, 86, {})


    def editing_subscript(self, ) -> str:
        r''' Subscript '''
        return self._translate(13, 87, {})


    def editing_superscript(self, ) -> str:
        r''' Superscript '''
        return self._translate(13, 88, {})


    def editing_tags(self, ) -> str:
        r''' Tags '''
        return self._translate(13, 89, {})


    def editing_tags_add(self, ) -> str:
        r''' Add tag '''
        return self._translate(13, 90, {})


    def editing_tags_copy(self, ) -> str:
        r''' Copy tags '''
        return self._translate(13, 91, {})


    def editing_tags_remove(self, ) -> str:
        r''' Remove tags '''
        return self._translate(13, 92, {})


    def editing_tags_select_all(self, ) -> str:
        r''' Select all tags '''
        return self._translate(13, 93, {})


    def editing_text_color(self, ) -> str:
        r''' Text color '''
        return self._translate(13, 94, {})


    def editing_text_highlight_color(self, ) -> str:
        r''' Text highlight color '''
        return self._translate(13, 95, {})


    def editing_to_make_a_cloze_deletion_on(self, ) -> str:
        r''' To make a cloze deletion on an existing note, you need to change it to a cloze type first, via 'Notes>Change Note Type' '''
        return self._translate(13, 96, {})


    def editing_toggle_html_editor(self, ) -> str:
        r''' Toggle HTML Editor '''
        return self._translate(13, 97, {})


    def editing_toggle_sticky(self, ) -> str:
        r''' Toggle sticky '''
        return self._translate(13, 98, {})


    def editing_toggle_visual_editor(self, ) -> str:
        r''' Toggle Visual Editor '''
        return self._translate(13, 99, {})


    def editing_underline_text(self, ) -> str:
        r''' Underline text '''
        return self._translate(13, 100, {})


    def editing_unordered_list(self, ) -> str:
        r''' Unordered list '''
        return self._translate(13, 101, {})


    def editing_warning_cloze_deletions_will_not_work(self, ) -> str:
        r''' Warning, cloze deletions will not work until you switch the type at the top to Cloze. '''
        return self._translate(13, 102, {})


    def empty_cards_count_line(self, empty_count: int, existing_count: int, template_names: str) -> str:
        r''' {$empty_count} of {$existing_count} cards empty ({$template_names}). '''
        return self._translate(14, 0, {"empty_count": empty_count, "existing_count": existing_count, "template_names": template_names})


    def empty_cards_delete_button(self, ) -> str:
        r''' Delete '''
        return self._translate(14, 1, {})


    def empty_cards_delete_empty_cards(self, ) -> str:
        r''' Delete Empty Cards '''
        return self._translate(14, 2, {})


    def empty_cards_delete_empty_notes(self, ) -> str:
        r''' Delete Empty Notes '''
        return self._translate(14, 3, {})


    def empty_cards_deleted_count(self, cards: int) -> str:
        r''' Deleted {$cards} cards. '''
        return self._translate(14, 4, {"cards": cards})


    def empty_cards_deleting(self, ) -> str:
        r''' Deleting... '''
        return self._translate(14, 5, {})


    def empty_cards_for_note_type(self, notetype: str) -> str:
        r''' Empty cards for {$notetype}: '''
        return self._translate(14, 6, {"notetype": notetype})


    def empty_cards_not_found(self, ) -> str:
        r''' No empty cards. '''
        return self._translate(14, 7, {})


    def empty_cards_preserve_notes_checkbox(self, ) -> str:
        r''' Keep notes with no valid cards '''
        return self._translate(14, 8, {})


    def empty_cards_window_title(self, ) -> str:
        r''' Empty Cards '''
        return self._translate(14, 9, {})


    def errors_100_tags_max(self, ) -> str:
        r''' A maximum of 100 tags can be selected. Listing the
tags you want instead of the ones you don't want is usually simpler, and there
is no need to select child tags if you have selected a parent tag. '''
        return self._translate(15, 0, {})


    def errors_accessing_db(self, ) -> str:
        r''' An error occurred while accessing the database.

Possible causes:

- Antivirus, firewall, backup, or synchronization software may be
interfering with Anki. Try disabling such software and see if the
problem goes away.
- Your disk may be full.
- The Documents/Anki folder may be on a network drive.
- Files in the Documents/Anki folder may not be writeable.
- Your hard disk may have errors.

It's a good idea to run Tools>Check Database to ensure your collection is not corrupt. '''
        return self._translate(15, 1, {})


    def errors_addons_active_popup(self, ) -> str:
        r''' # Error

An error occurred. Please start Anki while holding down the shift key,
which will temporarily disable the add-ons you have installed.

If the issue only occurs when add-ons are enabled, please use the
Tools > Add-ons menu item to disable some add-ons and restart Anki,
repeating until you discover the add-on that is causing the problem.

When you've discovered the add-on that is causing the problem, please
report the issue to the add-on author.

Debug info: '''
        return self._translate(15, 2, {})


    def errors_bad_directive(self, directive: str, error: str) -> str:
        r''' Error in directive '{$directive}': {$error} '''
        return self._translate(15, 3, {"directive": directive, "error": error})


    def errors_collection_too_new(self, ) -> str:
        r''' This collection requires a newer version of Anki to open. '''
        return self._translate(15, 4, {})


    def errors_copied_to_clipboard(self, ) -> str:
        r''' Copied to clipboard '''
        return self._translate(15, 5, {})


    def errors_copy_debug_info_button(self, ) -> str:
        r''' Copy Debug Info '''
        return self._translate(15, 6, {})


    def errors_filtered_deck_required(self, ) -> str:
        r''' This action can only be used on a filtered deck. '''
        return self._translate(15, 7, {})


    def errors_filtered_parent_deck(self, ) -> str:
        r''' Filtered decks can not have child decks. '''
        return self._translate(15, 8, {})


    def errors_inconsistent_db_state(self, ) -> str:
        r''' Your database appears to be in an inconsistent state. Please use the Check Database action. '''
        return self._translate(15, 9, {})


    def errors_invalid_ids(self, ) -> str:
        r''' This deck contains timestamps in the future. Please contact the deck author and ask them to fix the issue. '''
        return self._translate(15, 10, {})


    def errors_invalid_input_details(self, details: str) -> str:
        r''' Invalid input: {$details} '''
        return self._translate(15, 11, {"details": details})


    def errors_invalid_input_empty(self, ) -> str:
        r''' Invalid input. '''
        return self._translate(15, 12, {})


    def errors_may_be_addon(self, ) -> str:
        r''' The problem may be caused by an add-on. '''
        return self._translate(15, 13, {})


    def errors_multiple_notetypes_selected(self, ) -> str:
        r''' Please select notes from only one note type. '''
        return self._translate(15, 14, {})


    def errors_option_not_set(self, option: str) -> str:
        r''' '{$option}' not set '''
        return self._translate(15, 15, {"option": option})


    def errors_parse_number_fail(self, ) -> str:
        r''' A number was invalid or out of range. '''
        return self._translate(15, 16, {})


    def errors_please_check_database(self, ) -> str:
        r''' Please use the Check Database action, then try again. '''
        return self._translate(15, 17, {})


    def errors_please_check_media(self, ) -> str:
        r''' Please use the Check Media action, then try again. '''
        return self._translate(15, 18, {})


    def errors_standard_popup(self, ) -> str:
        r''' # Error

An error occurred. Please use **Tools > Check Database** to see if
that fixes the problem.

If problems persist, please report the problem on our .
Please copy and paste the information below into your report. '''
        return self._translate(15, 19, {})


    def errors_standard_popup2(self, ) -> str:
        r''' Anki encountered a problem. Please follow the troubleshooting steps. '''
        return self._translate(15, 20, {})


    def errors_troubleshooting_button(self, ) -> str:
        r''' Troubleshooting '''
        return self._translate(15, 21, {})


    def errors_unable_open_collection(self, ) -> str:
        r''' Anki was unable to open your collection file. If problems persist after restarting your computer, please use the Open Backup button in the profile manager.

Debug info: '''
        return self._translate(15, 22, {})


    def errors_windows_ssl_updates(self, ) -> str:
        r''' Secure connection failed. Please ensure Windows updates are installed, then try again. '''
        return self._translate(15, 23, {})


    def errors_windows_tts_runtime_error(self, ) -> str:
        r''' The TTS service failed. Please ensure Windows updates are installed, try restarting your computer, or try a different voice. '''
        return self._translate(15, 24, {})


    def exporting_all_decks(self, ) -> str:
        r''' All Decks '''
        return self._translate(16, 0, {})


    def exporting_anki_20_deck(self, ) -> str:
        r''' Anki 2.0 Deck '''
        return self._translate(16, 1, {})


    def exporting_anki_collection_package(self, ) -> str:
        r''' Anki Collection Package '''
        return self._translate(16, 2, {})


    def exporting_anki_deck_package(self, ) -> str:
        r''' Anki Deck Package '''
        return self._translate(16, 3, {})


    def exporting_card_exported(self, count: int) -> str:
        r''' {$count} cards exported. '''
        return self._translate(16, 4, {"count": count})


    def exporting_cards_in_plain_text(self, ) -> str:
        r''' Cards in Plain Text '''
        return self._translate(16, 5, {})


    def exporting_collection(self, ) -> str:
        r''' collection '''
        return self._translate(16, 6, {})


    def exporting_collection_exported(self, ) -> str:
        r''' Collection exported. '''
        return self._translate(16, 7, {})


    def exporting_colpkg_too_new(self, ) -> str:
        r''' Please update to the latest Anki version, then import the .colpkg/.apkg file again. '''
        return self._translate(16, 8, {})


    def exporting_couldnt_save_file(self, val: FluentVariable) -> str:
        r''' Couldn't save file: {$val} '''
        return self._translate(16, 9, {"val": val})


    def exporting_export(self, ) -> str:
        r''' Export... '''
        return self._translate(16, 10, {})


    def exporting_export_format(self, ) -> str:
        r''' <b>Export format</b>: '''
        return self._translate(16, 11, {})


    def exporting_exported_media_file(self, count: int) -> str:
        r''' Exported {$count} media files '''
        return self._translate(16, 12, {"count": count})


    def exporting_exporting_file(self, ) -> str:
        r''' Exporting file... '''
        return self._translate(16, 13, {})


    def exporting_include(self, ) -> str:
        r''' <b>Include</b>: '''
        return self._translate(16, 14, {})


    def exporting_include_deck(self, ) -> str:
        r''' Include deck name '''
        return self._translate(16, 15, {})


    def exporting_include_deck_configs(self, ) -> str:
        r''' Include deck presets '''
        return self._translate(16, 16, {})


    def exporting_include_guid(self, ) -> str:
        r''' Include unique identifier '''
        return self._translate(16, 17, {})


    def exporting_include_html_and_media_references(self, ) -> str:
        r''' Include HTML and media references '''
        return self._translate(16, 18, {})


    def exporting_include_media(self, ) -> str:
        r''' Include media '''
        return self._translate(16, 19, {})


    def exporting_include_notetype(self, ) -> str:
        r''' Include note type name '''
        return self._translate(16, 20, {})


    def exporting_include_scheduling_information(self, ) -> str:
        r''' Include scheduling information '''
        return self._translate(16, 21, {})


    def exporting_include_tags(self, ) -> str:
        r''' Include tags '''
        return self._translate(16, 22, {})


    def exporting_note_exported(self, count: int) -> str:
        r''' {$count} notes exported. '''
        return self._translate(16, 23, {"count": count})


    def exporting_notes_in_plain_text(self, ) -> str:
        r''' Notes in Plain Text '''
        return self._translate(16, 24, {})


    def exporting_processed_media_files(self, count: int) -> str:
        r''' Processed {$count} media files... '''
        return self._translate(16, 25, {"count": count})


    def exporting_selected_notes(self, ) -> str:
        r''' Selected Notes '''
        return self._translate(16, 26, {})


    def exporting_support_older_anki_versions(self, ) -> str:
        r''' Support older Anki versions (slower/larger files) '''
        return self._translate(16, 27, {})


    def fields_add_field(self, ) -> str:
        r''' Add Field '''
        return self._translate(17, 0, {})


    def fields_collapse_by_default(self, ) -> str:
        r''' Collapse by default '''
        return self._translate(17, 1, {})


    def fields_delete_field_from(self, val: FluentVariable) -> str:
        r''' Delete field from {$val}? '''
        return self._translate(17, 2, {"val": val})


    def fields_description(self, ) -> str:
        r''' Description '''
        return self._translate(17, 3, {})


    def fields_description_placeholder(self, ) -> str:
        r''' Text to show inside the field when it's empty '''
        return self._translate(17, 4, {})


    def fields_editing_font(self, ) -> str:
        r''' Editing Font '''
        return self._translate(17, 5, {})


    def fields_exclude_from_search(self, ) -> str:
        r''' Exclude from unqualified searches (slower) '''
        return self._translate(17, 6, {})


    def fields_field(self, ) -> str:
        r''' Field: '''
        return self._translate(17, 7, {})


    def fields_field_is_required(self, ) -> str:
        r''' This is a required field, and can not be deleted. '''
        return self._translate(17, 8, {})


    def fields_field_name(self, ) -> str:
        r''' Field name: '''
        return self._translate(17, 9, {})


    def fields_fields_for(self, val: FluentVariable) -> str:
        r''' Fields for {$val} '''
        return self._translate(17, 10, {"val": val})


    def fields_font(self, ) -> str:
        r''' Font: '''
        return self._translate(17, 11, {})


    def fields_html_by_default(self, ) -> str:
        r''' Use HTML editor by default '''
        return self._translate(17, 12, {})


    def fields_name_first_letter_not_valid(self, ) -> str:
        r''' The field name should not start with #, ^ or /. '''
        return self._translate(17, 13, {})


    def fields_name_invalid_letter(self, ) -> str:
        r''' The field name should not contain :, ",  or . '''
        return self._translate(17, 14, {})


    def fields_new_position_1(self, val: FluentVariable) -> str:
        r''' New position (1...{$val}): '''
        return self._translate(17, 15, {"val": val})


    def fields_notes_require_at_least_one_field(self, ) -> str:
        r''' Notes require at least one field. '''
        return self._translate(17, 16, {})


    def fields_reverse_text_direction_rtl(self, ) -> str:
        r''' Reverse text direction (RTL) '''
        return self._translate(17, 17, {})


    def fields_size(self, ) -> str:
        r''' Size: '''
        return self._translate(17, 18, {})


    def fields_sort_by_this_field_in_the(self, ) -> str:
        r''' Sort by this field in the browser '''
        return self._translate(17, 19, {})


    def fields_that_field_name_is_already_used(self, ) -> str:
        r''' That field name is already used. '''
        return self._translate(17, 20, {})


    def findreplace_notes_updated(self, total: int, changed: int) -> str:
        r''' {$changed} of {$total} notes updated '''
        return self._translate(18, 0, {"total": total, "changed": changed})


    def help_for_more_info(self, link: str) -> str:
        r''' For more information, see {$link} in the manual. '''
        return self._translate(19, 0, {"link": link})


    def help_no_explanation(self, link: str) -> str:
        r''' Whoops! There doesn't seem to be an explanation for this setting yet.

You can help us complete this help page on {$link}. '''
        return self._translate(19, 1, {"link": link})


    def help_ok(self, ) -> str:
        r''' OK '''
        return self._translate(19, 2, {})


    def help_open_manual_chapter(self, name: str) -> str:
        r''' Open {$name} in the manual '''
        return self._translate(19, 3, {"name": name})


    def importing_aborted(self, val: FluentVariable) -> str:
        r''' Aborted: {$val} '''
        return self._translate(20, 0, {"val": val})


    def importing_added(self, ) -> str:
        r''' Added '''
        return self._translate(20, 1, {})


    def importing_added_duplicate_with_first_field(self, val: FluentVariable) -> str:
        r''' Added duplicate with first field: {$val} '''
        return self._translate(20, 2, {"val": val})


    def importing_added_new_note(self, ) -> str:
        r''' New note added '''
        return self._translate(20, 3, {})


    def importing_all_supported_formats(self, val: FluentVariable) -> str:
        r''' All supported formats {$val} '''
        return self._translate(20, 4, {"val": val})


    def importing_allow_html_in_fields(self, ) -> str:
        r''' Allow HTML in fields '''
        return self._translate(20, 5, {})


    def importing_allow_html_in_fields_help(self, ) -> str:
        r''' Enable this if the file contains HTML formatting. E.g. if the file contains the string
'&lt;br&gt;', it will appear as a line break on your card. On the other hand, with this
option disabled, the literal characters '&lt;br&gt;' will be rendered. '''
        return self._translate(20, 6, {})


    def importing_also_import_progress(self, ) -> str:
        r''' Import any learning progress '''
        return self._translate(20, 7, {})


    def importing_anki_files_are_from_a_very(self, ) -> str:
        r''' .anki files are from a very old version of Anki. You can import them with add-on 175027074 or with Anki 2.0, available on the Anki website. '''
        return self._translate(20, 8, {})


    def importing_anki2_files_are_not_directly_importable(self, ) -> str:
        r''' .anki2 files are not directly importable - please import the .apkg or .zip file you have received instead. '''
        return self._translate(20, 9, {})


    def importing_appeared_twice_in_file(self, val: FluentVariable) -> str:
        r''' Appeared twice in file: {$val} '''
        return self._translate(20, 10, {"val": val})


    def importing_by_default_anki_will_detect_the(self, ) -> str:
        r''' By default, Anki will detect the character between fields, such as a tab, comma, and so on. If Anki is detecting the character incorrectly, you can enter it here. Use \t to represent tab. '''
        return self._translate(20, 11, {})


    def importing_cannot_merge_notetypes_of_different_kinds(self, ) -> str:
        r''' Cloze note types cannot be merged with regular note types.
You may still import the file with '' disabled. '''
        return self._translate(20, 12, {})


    def importing_cards_added(self, count: int) -> str:
        r''' {$count} cards added. '''
        return self._translate(20, 13, {"count": count})


    def importing_change(self, ) -> str:
        r''' Change '''
        return self._translate(20, 14, {})


    def importing_colon(self, ) -> str:
        r''' Colon '''
        return self._translate(20, 15, {})


    def importing_comma(self, ) -> str:
        r''' Comma '''
        return self._translate(20, 16, {})


    def importing_conflicting_notes_skipped(self, count: int) -> str:
        r''' {$count} notes were not imported, because their note type has changed. '''
        return self._translate(20, 17, {"count": count})


    def importing_conflicting_notes_skipped2(self, count: int) -> str:
        r''' {$count} notes were not imported, because their note type has changed, and '' was not enabled. '''
        return self._translate(20, 18, {"count": count})


    def importing_deck_help(self, ) -> str:
        r''' Imported cards will be placed in this deck. '''
        return self._translate(20, 19, {})


    def importing_details(self, ) -> str:
        r''' Details '''
        return self._translate(20, 20, {})


    def importing_duplicate(self, ) -> str:
        r''' Duplicate '''
        return self._translate(20, 21, {})


    def importing_duplicate_note_added(self, ) -> str:
        r''' Duplicate note added '''
        return self._translate(20, 22, {})


    def importing_empty_first_field(self, val: FluentVariable) -> str:
        r''' Empty first field: {$val} '''
        return self._translate(20, 23, {"val": val})


    def importing_existing_note_skipped(self, ) -> str:
        r''' Note skipped, as an up-to-date copy is already in your collection '''
        return self._translate(20, 24, {})


    def importing_existing_notes(self, ) -> str:
        r''' Existing notes '''
        return self._translate(20, 25, {})


    def importing_existing_notes_help(self, ) -> str:
        r''' What to do if an imported note matches an existing one.

- ``: Update the existing note.
- ``: Do nothing.
- ``: Create a new note. '''
        return self._translate(20, 26, {})


    def importing_existing_notes_skipped(self, count: int) -> str:
        r''' {$count} notes already present in your collection. '''
        return self._translate(20, 27, {"count": count})


    def importing_extracting(self, ) -> str:
        r''' Extracting data... '''
        return self._translate(20, 28, {})


    def importing_failed_debug_info(self, ) -> str:
        r''' Import failed. Debugging info: '''
        return self._translate(20, 29, {})


    def importing_failed_to_import_media_file(self, debug_info: str) -> str:
        r''' Failed to import media file: {$debugInfo} '''
        return self._translate(20, 30, {"debugInfo": debug_info})


    def importing_field_mapping(self, ) -> str:
        r''' Field mapping '''
        return self._translate(20, 31, {})


    def importing_field_of_file_is(self, val: FluentVariable) -> str:
        r''' Field <b>{$val}</b> of file is: '''
        return self._translate(20, 32, {"val": val})


    def importing_field_separator(self, ) -> str:
        r''' Field separator '''
        return self._translate(20, 33, {})


    def importing_field_separator_guessed(self, ) -> str:
        r''' Field separator (guessed) '''
        return self._translate(20, 34, {})


    def importing_field_separator_help(self, ) -> str:
        r''' The character separating fields in the text file. You can use the preview to check
if the fields are separated correctly.

Please note that if this character appears in any field itself, the field has to be
quoted accordingly to the CSV standard. Spreadsheet programs like LibreOffice will
do this automatically.

It cannot be changed if the text file forces use of a specific separator via a file header.
If a file header is not present, Anki will try to guess what the separator is. '''
        return self._translate(20, 35, {})


    def importing_fields_separated_by(self, val: FluentVariable) -> str:
        r''' Fields separated by: {$val} '''
        return self._translate(20, 36, {"val": val})


    def importing_file(self, ) -> str:
        r''' File '''
        return self._translate(20, 37, {})


    def importing_file_empty(self, ) -> str:
        r''' The file you selected is empty. '''
        return self._translate(20, 38, {})


    def importing_file_must_contain_field_column(self, ) -> str:
        r''' File must contain at least one column that can be mapped to a note field. '''
        return self._translate(20, 39, {})


    def importing_file_version_unknown_trying_import_anyway(self, ) -> str:
        r''' File version unknown, trying import anyway. '''
        return self._translate(20, 40, {})


    def importing_first_field_matched(self, val: FluentVariable) -> str:
        r''' First field matched: {$val} '''
        return self._translate(20, 41, {"val": val})


    def importing_gathering(self, ) -> str:
        r''' Gathering data... '''
        return self._translate(20, 42, {})


    def importing_identical(self, ) -> str:
        r''' Identical '''
        return self._translate(20, 43, {})


    def importing_ignore_field(self, ) -> str:
        r''' Ignore field '''
        return self._translate(20, 44, {})


    def importing_ignore_lines_where_first_field_matches(self, ) -> str:
        r''' Ignore lines where first field matches existing note '''
        return self._translate(20, 45, {})


    def importing_ignored(self, ) -> str:
        r''' <ignored> '''
        return self._translate(20, 46, {})


    def importing_import_even_if_existing_note_has(self, ) -> str:
        r''' Import even if existing note has same first field '''
        return self._translate(20, 47, {})


    def importing_import_log(self, ) -> str:
        r''' Import Log '''
        return self._translate(20, 48, {})


    def importing_import_options(self, ) -> str:
        r''' Import options '''
        return self._translate(20, 49, {})


    def importing_importing_collection(self, ) -> str:
        r''' Importing collection... '''
        return self._translate(20, 50, {})


    def importing_importing_complete(self, ) -> str:
        r''' Importing complete. '''
        return self._translate(20, 51, {})


    def importing_importing_file(self, ) -> str:
        r''' Importing file... '''
        return self._translate(20, 52, {})


    def importing_include_reviews(self, ) -> str:
        r''' Include reviews '''
        return self._translate(20, 53, {})


    def importing_include_reviews_help(self, ) -> str:
        r''' If enabled, any previous reviews that the deck sharer included will also be imported.
Otherwise, all cards will be imported as new cards, and any "leech" or "marked"
tags will be removed. '''
        return self._translate(20, 54, {})


    def importing_invalid_file_please_restore_from_backup(self, ) -> str:
        r''' Invalid file. Please restore from backup. '''
        return self._translate(20, 55, {})


    def importing_map_to(self, val: FluentVariable) -> str:
        r''' Map to {$val} '''
        return self._translate(20, 56, {"val": val})


    def importing_map_to_tags(self, ) -> str:
        r''' Map to Tags '''
        return self._translate(20, 57, {})


    def importing_mapped_to(self, val: FluentVariable) -> str:
        r''' mapped to <b>{$val}</b> '''
        return self._translate(20, 58, {"val": val})


    def importing_mapped_to_tags(self, ) -> str:
        r''' mapped to <b>Tags</b> '''
        return self._translate(20, 59, {})


    def importing_match_scope(self, ) -> str:
        r''' Match scope '''
        return self._translate(20, 60, {})


    def importing_match_scope_help(self, ) -> str:
        r''' Only existing notes with the same note type will be checked for duplicates. This can
additionally be restricted to notes with cards in the same deck. '''
        return self._translate(20, 61, {})


    def importing_merge_notetypes(self, ) -> str:
        r''' Merge note types '''
        return self._translate(20, 62, {})


    def importing_merge_notetypes_help(self, ) -> str:
        r''' If checked, and you or the deck author altered the schema of a note type, Anki will
merge the two versions instead of keeping both.

Altering a note type's schema means adding, removing, or reordering fields or templates,
or changing the sort field.
As a counterexample, changing the front side of an existing template does *not* constitute
a schema change.

Warning: This will require a one-way sync, and may mark existing notes as modified. '''
        return self._translate(20, 63, {})


    def importing_mnemosyne_20_deck_db(self, ) -> str:
        r''' Mnemosyne 2.0 Deck (*.db) '''
        return self._translate(20, 64, {})


    def importing_multicharacter_separators_are_not_supported_please(self, ) -> str:
        r''' Multi-character separators are not supported. Please enter one character only. '''
        return self._translate(20, 65, {})


    def importing_new_deck_will_be_created(self, name: str) -> str:
        r''' A new deck will be created: {$name} '''
        return self._translate(20, 66, {"name": name})


    def importing_no_notes_in_file(self, ) -> str:
        r''' No notes found in file. '''
        return self._translate(20, 67, {})


    def importing_note_added(self, count: int) -> str:
        r''' {$count} notes added '''
        return self._translate(20, 68, {"count": count})


    def importing_note_imported(self, count: int) -> str:
        r''' {$count} notes imported. '''
        return self._translate(20, 69, {"count": count})


    def importing_note_skipped_due_to_empty_first_field(self, ) -> str:
        r''' Note skipped, as its first field is empty '''
        return self._translate(20, 70, {})


    def importing_note_skipped_due_to_missing_deck(self, ) -> str:
        r''' Note skipped, as its deck was missing '''
        return self._translate(20, 71, {})


    def importing_note_skipped_due_to_missing_notetype(self, ) -> str:
        r''' Note skipped, as its notetype was missing '''
        return self._translate(20, 72, {})


    def importing_note_skipped_update_due_to_notetype(self, ) -> str:
        r''' Note not updated, as note type has been modified since you first imported the note '''
        return self._translate(20, 73, {})


    def importing_note_skipped_update_due_to_notetype2(self, ) -> str:
        r''' Note not updated, as note type has been modified since you first imported the note, and '' was not enabled '''
        return self._translate(20, 74, {})


    def importing_note_unchanged(self, count: int) -> str:
        r''' {$count} notes unchanged '''
        return self._translate(20, 75, {"count": count})


    def importing_note_updated(self, count: int) -> str:
        r''' {$count} notes updated '''
        return self._translate(20, 76, {"count": count})


    def importing_note_updated_as_file_had_newer(self, ) -> str:
        r''' Note updated, as file had newer version '''
        return self._translate(20, 77, {})


    def importing_notes_added(self, count: int) -> str:
        r''' {$count} new notes imported. '''
        return self._translate(20, 78, {"count": count})


    def importing_notes_added_from_file(self, val: FluentVariable) -> str:
        r''' Notes added from file: {$val} '''
        return self._translate(20, 79, {"val": val})


    def importing_notes_failed(self, count: int) -> str:
        r''' {$count} notes could not be imported. '''
        return self._translate(20, 80, {"count": count})


    def importing_notes_found_in_file(self, val: FluentVariable) -> str:
        r''' Notes found in file: {$val} '''
        return self._translate(20, 81, {"val": val})


    def importing_notes_found_in_file2(self, notes: int) -> str:
        r''' {$notes} notes found in file. Of those: '''
        return self._translate(20, 82, {"notes": notes})


    def importing_notes_skipped_as_theyre_already_in(self, val: FluentVariable) -> str:
        r''' Notes skipped, as up-to-date copies are already in your collection: {$val} '''
        return self._translate(20, 83, {"val": val})


    def importing_notes_skipped_update_due_to_notetype(self, val: FluentVariable) -> str:
        r''' Notes not updated, as note type has been modified since you first imported the notes: {$val} '''
        return self._translate(20, 84, {"val": val})


    def importing_notes_that_could_not_be_imported(self, val: FluentVariable) -> str:
        r''' Notes that could not be imported as note type has changed: {$val} '''
        return self._translate(20, 85, {"val": val})


    def importing_notes_updated(self, count: int) -> str:
        r''' {$count} notes were used to update existing ones. '''
        return self._translate(20, 86, {"count": count})


    def importing_notes_updated_as_file_had_newer(self, val: FluentVariable) -> str:
        r''' Notes updated, as file had newer version: {$val} '''
        return self._translate(20, 87, {"val": val})


    def importing_notetype_and_deck(self, ) -> str:
        r''' Note type and deck '''
        return self._translate(20, 88, {})


    def importing_notetype_help(self, ) -> str:
        r''' Newly-imported notes will have this note type, and only existing notes with this
note type will be updated.

You can choose which fields in the file correspond to which note type fields with the
mapping tool. '''
        return self._translate(20, 89, {})


    def importing_overview(self, ) -> str:
        r''' Overview '''
        return self._translate(20, 90, {})


    def importing_packaged_anki_deckcollection_apkg_colpkg_zip(self, ) -> str:
        r''' Packaged Anki Deck/Collection (*.apkg *.colpkg *.zip) '''
        return self._translate(20, 91, {})


    def importing_pauker_18_lesson_paugz(self, ) -> str:
        r''' Pauker 1.8 Lesson (*.pau.gz) '''
        return self._translate(20, 92, {})


    def importing_pipe(self, ) -> str:
        r''' Pipe '''
        return self._translate(20, 93, {})


    def importing_preserve(self, ) -> str:
        r''' Preserve '''
        return self._translate(20, 94, {})


    def importing_preview_truncated(self, count: int) -> str:
        r''' Only the first {$count} columns are shown. If this doesn't seem right, try changing the field separator. '''
        return self._translate(20, 95, {"count": count})


    def importing_processed_cards(self, count: int) -> str:
        r''' Processed {$count} cards... '''
        return self._translate(20, 96, {"count": count})


    def importing_processed_media_file(self, count: int) -> str:
        r''' Imported {$count} media files '''
        return self._translate(20, 97, {"count": count})


    def importing_processed_notes(self, count: int) -> str:
        r''' Processed {$count} notes... '''
        return self._translate(20, 98, {"count": count})


    def importing_rows_had_num1d_fields_expected_num2d(self, row: str, found: FluentVariable, expected: FluentVariable) -> str:
        r''' '{$row}' had {$found} fields, expected {$expected} '''
        return self._translate(20, 99, {"row": row, "found": found, "expected": expected})


    def importing_selected_file_was_not_in_utf8(self, ) -> str:
        r''' Selected file was not in UTF-8 format. Please see the importing section of the manual. '''
        return self._translate(20, 100, {})


    def importing_semicolon(self, ) -> str:
        r''' Semicolon '''
        return self._translate(20, 101, {})


    def importing_show(self, ) -> str:
        r''' Show '''
        return self._translate(20, 102, {})


    def importing_skipped(self, ) -> str:
        r''' Skipped '''
        return self._translate(20, 103, {})


    def importing_status(self, ) -> str:
        r''' Status '''
        return self._translate(20, 104, {})


    def importing_supermemo_xml_export_xml(self, ) -> str:
        r''' Supermemo XML export (*.xml) '''
        return self._translate(20, 105, {})


    def importing_tab(self, ) -> str:
        r''' Tab '''
        return self._translate(20, 106, {})


    def importing_tag_all_notes(self, ) -> str:
        r''' Tag all notes '''
        return self._translate(20, 107, {})


    def importing_tag_all_notes_help(self, ) -> str:
        r''' These tags will be added to both newly-imported and updated notes. '''
        return self._translate(20, 108, {})


    def importing_tag_modified_notes(self, ) -> str:
        r''' Tag modified notes: '''
        return self._translate(20, 109, {})


    def importing_tag_updated_notes(self, ) -> str:
        r''' Tag updated notes '''
        return self._translate(20, 110, {})


    def importing_tag_updated_notes_help(self, ) -> str:
        r''' These tags will be added to any updated notes. '''
        return self._translate(20, 111, {})


    def importing_text_separated_by_tabs_or_semicolons(self, ) -> str:
        r''' Text separated by tabs or semicolons (*) '''
        return self._translate(20, 112, {})


    def importing_the_first_field_of_the_note(self, ) -> str:
        r''' The first field of the note type must be mapped. '''
        return self._translate(20, 113, {})


    def importing_the_provided_file_is_not_a(self, ) -> str:
        r''' The provided file is not a valid .apkg file. '''
        return self._translate(20, 114, {})


    def importing_this_file_does_not_appear_to(self, ) -> str:
        r''' This file does not appear to be a valid .apkg file. If you're getting this error from a file downloaded from AnkiWeb, chances are that your download failed. Please try again, and if the problem persists, please try again with a different browser. '''
        return self._translate(20, 115, {})


    def importing_this_will_delete_your_existing_collection(self, ) -> str:
        r''' This will delete your existing collection and replace it with the data in the file you're importing. Are you sure? '''
        return self._translate(20, 116, {})


    def importing_unable_to_import_filename(self, filename: str) -> str:
        r''' Unable to import {$filename}: file type not supported '''
        return self._translate(20, 117, {"filename": filename})


    def importing_unable_to_import_from_a_readonly(self, ) -> str:
        r''' Unable to import from a read-only file. '''
        return self._translate(20, 118, {})


    def importing_unknown_file_format(self, ) -> str:
        r''' Unknown file format. '''
        return self._translate(20, 119, {})


    def importing_update(self, ) -> str:
        r''' Update '''
        return self._translate(20, 120, {})


    def importing_update_always(self, ) -> str:
        r''' Always '''
        return self._translate(20, 121, {})


    def importing_update_existing_notes_when_first_field(self, ) -> str:
        r''' Update existing notes when first field matches '''
        return self._translate(20, 122, {})


    def importing_update_if_newer(self, ) -> str:
        r''' If newer '''
        return self._translate(20, 123, {})


    def importing_update_never(self, ) -> str:
        r''' Never '''
        return self._translate(20, 124, {})


    def importing_update_notes(self, ) -> str:
        r''' Update notes '''
        return self._translate(20, 125, {})


    def importing_update_notes_help(self, ) -> str:
        r''' When to update an existing note in your collection. By default, this is only done
if the matching imported note was more recently modified. '''
        return self._translate(20, 126, {})


    def importing_update_notetypes(self, ) -> str:
        r''' Update note types '''
        return self._translate(20, 127, {})


    def importing_update_notetypes_help(self, ) -> str:
        r''' When to update an existing note type in your collection. By default, this is only done
if the matching imported note type was more recently modified. Changes to template text
and styling can always be imported, but for schema changes (e.g. the number or order of
fields has changed), the '' option will also need to be enabled. '''
        return self._translate(20, 128, {})


    def importing_updated(self, ) -> str:
        r''' Updated '''
        return self._translate(20, 129, {})


    def importing_updates(self, ) -> str:
        r''' Updates '''
        return self._translate(20, 130, {})


    def importing_with_deck_configs(self, ) -> str:
        r''' Import any deck presets '''
        return self._translate(20, 131, {})


    def importing_with_deck_configs_help(self, ) -> str:
        r''' If enabled, any deck options that the deck sharer included will also be imported.
Otherwise, all decks will be assigned the default preset. '''
        return self._translate(20, 132, {})


    def keyboard_ctrl(self, ) -> str:
        r''' Ctrl '''
        return self._translate(21, 0, {})


    def keyboard_shift(self, ) -> str:
        r''' Shift '''
        return self._translate(21, 1, {})


    def media_error_executing(self, val: FluentVariable) -> str:
        r''' Error executing {$val}. '''
        return self._translate(22, 0, {"val": val})


    def media_error_running(self, val: FluentVariable) -> str:
        r''' Error running {$val} '''
        return self._translate(22, 1, {"val": val})


    def media_for_security_reasons_is_not(self, val: FluentVariable) -> str:
        r''' For security reasons, '{$val}' is not allowed on cards. You can still use it by placing the command in a different package, and importing that package in the LaTeX header instead. '''
        return self._translate(22, 2, {"val": val})


    def media_generated_file(self, val: FluentVariable) -> str:
        r''' Generated file: {$val} '''
        return self._translate(22, 3, {"val": val})


    def media_have_you_installed_latex_and_dvipngdvisvgm(self, ) -> str:
        r''' Have you installed latex and dvipng/dvisvgm? '''
        return self._translate(22, 4, {})


    def media_recordingtime(self, secs: str) -> str:
        r''' Recording...<br>Time: {$secs} '''
        return self._translate(22, 5, {"secs": secs})


    def media_sound_and_video_on_cards_will(self, ) -> str:
        r''' Sound and video on cards will not function until mpv or mplayer is installed. '''
        return self._translate(22, 6, {})


    def media_check_add_tag(self, ) -> str:
        r''' Tag Missing '''
        return self._translate(23, 0, {})


    def media_check_all_latex_rendered(self, ) -> str:
        r''' All LaTeX rendered. '''
        return self._translate(23, 1, {})


    def media_check_check_media_action(self, ) -> str:
        r''' Check Media '''
        return self._translate(23, 2, {})


    def media_check_checked(self, count: int) -> str:
        r''' Checked {$count}... '''
        return self._translate(23, 3, {"count": count})


    def media_check_delete_unused(self, ) -> str:
        r''' Delete Unused '''
        return self._translate(23, 4, {})


    def media_check_delete_unused_complete(self, count: int) -> str:
        r''' {$count} files moved to the trash. '''
        return self._translate(23, 5, {"count": count})


    def media_check_delete_unused_confirm(self, ) -> str:
        r''' Delete unused media? '''
        return self._translate(23, 6, {})


    def media_check_empty_trash(self, ) -> str:
        r''' Empty Trash '''
        return self._translate(23, 7, {})


    def media_check_extracted_count(self, count: int) -> str:
        r''' Extracted images: {$count} '''
        return self._translate(23, 8, {"count": count})


    def media_check_files_remaining(self, count: int) -> str:
        r''' {$count} files remaining. '''
        return self._translate(23, 9, {"count": count})


    def media_check_missing_count(self, count: int) -> str:
        r''' Missing files: {$count} '''
        return self._translate(23, 10, {"count": count})


    def media_check_missing_file(self, filename: str) -> str:
        r''' Missing: {$filename} '''
        return self._translate(23, 11, {"filename": filename})


    def media_check_missing_header(self, ) -> str:
        r''' The following files are referenced by cards, but were not found in the media folder: '''
        return self._translate(23, 12, {})


    def media_check_missing_media_tag(self, ) -> str:
        r''' missing-media '''
        return self._translate(23, 13, {})


    def media_check_notetype_template(self, notetype: str, card_type: str, side: str) -> str:
        r''' {$notetype}: {$card_type} ({$side}) '''
        return self._translate(23, 14, {"notetype": notetype, "card_type": card_type, "side": side})


    def media_check_oversize_count(self, count: int) -> str:
        r''' Over 100MB: {$count} '''
        return self._translate(23, 15, {"count": count})


    def media_check_oversize_file(self, filename: str) -> str:
        r''' Over 100MB: {$filename} '''
        return self._translate(23, 16, {"filename": filename})


    def media_check_oversize_header(self, ) -> str:
        r''' Files over 100MB can not be synced with AnkiWeb. '''
        return self._translate(23, 17, {})


    def media_check_renamed_count(self, count: int) -> str:
        r''' Renamed files: {$count} '''
        return self._translate(23, 18, {"count": count})


    def media_check_renamed_file(self, old: str, new: str) -> str:
        r''' Renamed: {$old} -> {$new} '''
        return self._translate(23, 19, {"old": old, "new": new})


    def media_check_renamed_header(self, ) -> str:
        r''' Some files have been renamed for compatibility: '''
        return self._translate(23, 20, {})


    def media_check_render_latex(self, ) -> str:
        r''' Render LaTeX '''
        return self._translate(23, 21, {})


    def media_check_restore_trash(self, ) -> str:
        r''' Restore Deleted '''
        return self._translate(23, 22, {})


    def media_check_subfolder_count(self, count: int) -> str:
        r''' Subfolders: {$count} '''
        return self._translate(23, 23, {"count": count})


    def media_check_subfolder_file(self, filename: str) -> str:
        r''' Folder: {$filename} '''
        return self._translate(23, 24, {"filename": filename})


    def media_check_subfolder_header(self, ) -> str:
        r''' Folders inside the media folder are not supported. '''
        return self._translate(23, 25, {})


    def media_check_template_references_field_header(self, ) -> str:
        r''' Anki can not detect used files when you use  references in media/LaTeX tags. The media/LaTeX tags should be placed on individual notes instead.

Referencing templates: '''
        return self._translate(23, 26, {})


    def media_check_trash_count(self, count: int, megs: FluentVariable) -> str:
        r''' Trash folder: {$count} files, {$megs}MB '''
        return self._translate(23, 27, {"count": count, "megs": megs})


    def media_check_trash_emptied(self, ) -> str:
        r''' The trash folder is now empty. '''
        return self._translate(23, 28, {})


    def media_check_trash_restored(self, ) -> str:
        r''' Restored deleted files to the media folder. '''
        return self._translate(23, 29, {})


    def media_check_unused_count(self, count: int) -> str:
        r''' Unused files: {$count} '''
        return self._translate(23, 30, {"count": count})


    def media_check_unused_file(self, filename: str) -> str:
        r''' Unused: {$filename} '''
        return self._translate(23, 31, {"filename": filename})


    def media_check_unused_header(self, ) -> str:
        r''' The following files were found in the media folder, but do not appear to be used on any cards: '''
        return self._translate(23, 32, {})


    def media_check_window_title(self, ) -> str:
        r''' Check Media '''
        return self._translate(23, 33, {})


    def network_details(self, details: str) -> str:
        r''' Error details: {$details} '''
        return self._translate(24, 0, {"details": details})


    def network_offline(self, ) -> str:
        r''' Please check your internet connection. '''
        return self._translate(24, 1, {})


    def network_other(self, ) -> str:
        r''' A network error occurred. '''
        return self._translate(24, 2, {})


    def network_proxy_auth(self, ) -> str:
        r''' Your proxy requires authentication. '''
        return self._translate(24, 3, {})


    def network_timeout(self, ) -> str:
        r''' Connection timed out. Please try again. If you see frequent timeouts, please try a different network connection. '''
        return self._translate(24, 4, {})


    def notetype_error_no_image_to_show(self, ) -> str:
        r''' No image to show. '''
        return self._translate(25, 0, {})


    def notetypes_add(self, val: FluentVariable) -> str:
        r''' Add: {$val} '''
        return self._translate(25, 1, {"val": val})


    def notetypes_add_note_type(self, ) -> str:
        r''' Add Note Type '''
        return self._translate(25, 2, {})


    def notetypes_add_reverse_field(self, ) -> str:
        r''' Add Reverse '''
        return self._translate(25, 3, {})


    def notetypes_back_extra_field(self, ) -> str:
        r''' Back Extra '''
        return self._translate(25, 4, {})


    def notetypes_back_field(self, ) -> str:
        r''' Back '''
        return self._translate(25, 5, {})


    def notetypes_basic_name(self, ) -> str:
        r''' Basic '''
        return self._translate(25, 6, {})


    def notetypes_basic_optional_reversed_name(self, ) -> str:
        r''' Basic (optional reversed card) '''
        return self._translate(25, 7, {})


    def notetypes_basic_reversed_name(self, ) -> str:
        r''' Basic (and reversed card) '''
        return self._translate(25, 8, {})


    def notetypes_basic_type_answer_name(self, ) -> str:
        r''' Basic (type in the answer) '''
        return self._translate(25, 9, {})


    def notetypes_card_1_name(self, ) -> str:
        r''' Card 1 '''
        return self._translate(25, 10, {})


    def notetypes_card_2_name(self, ) -> str:
        r''' Card 2 '''
        return self._translate(25, 11, {})


    def notetypes_cards(self, ) -> str:
        r''' Cards '''
        return self._translate(25, 12, {})


    def notetypes_clone(self, val: FluentVariable) -> str:
        r''' Clone: {$val} '''
        return self._translate(25, 13, {"val": val})


    def notetypes_cloze_name(self, ) -> str:
        r''' Cloze '''
        return self._translate(25, 14, {})


    def notetypes_comments_field(self, ) -> str:
        r''' Comments '''
        return self._translate(25, 15, {})


    def notetypes_copy(self, val: FluentVariable) -> str:
        r''' {$val} copy '''
        return self._translate(25, 16, {"val": val})


    def notetypes_create_scalable_images_with_dvisvgm(self, ) -> str:
        r''' Create scalable images with dvisvgm '''
        return self._translate(25, 17, {})


    def notetypes_delete_this_note_type_and_all(self, ) -> str:
        r''' Delete this note type and all its cards? '''
        return self._translate(25, 18, {})


    def notetypes_delete_this_unused_note_type(self, ) -> str:
        r''' Delete this unused note type? '''
        return self._translate(25, 19, {})


    def notetypes_error_generating_cloze(self, ) -> str:
        r''' An error occurred when generating an image occlusion note '''
        return self._translate(25, 20, {})


    def notetypes_error_getting_imagecloze(self, ) -> str:
        r''' An error occurred while fetching an image occlusion note '''
        return self._translate(25, 21, {})


    def notetypes_error_loading_image_occlusion(self, ) -> str:
        r''' Error loading image occlusion. Is your Anki version up to date? '''
        return self._translate(25, 22, {})


    def notetypes_fields(self, ) -> str:
        r''' Fields '''
        return self._translate(25, 23, {})


    def notetypes_footer(self, ) -> str:
        r''' Footer '''
        return self._translate(25, 24, {})


    def notetypes_front_field(self, ) -> str:
        r''' Front '''
        return self._translate(25, 25, {})


    def notetypes_header(self, ) -> str:
        r''' Header '''
        return self._translate(25, 26, {})


    def notetypes_hide_all_guess_one(self, ) -> str:
        r''' Hide All, Guess One '''
        return self._translate(25, 27, {})


    def notetypes_hide_one_guess_one(self, ) -> str:
        r''' Hide One, Guess One '''
        return self._translate(25, 28, {})


    def notetypes_image(self, ) -> str:
        r''' Image '''
        return self._translate(25, 29, {})


    def notetypes_image_occlusion_name(self, ) -> str:
        r''' Image Occlusion '''
        return self._translate(25, 30, {})


    def notetypes_io_paste_image_from_clipboard(self, ) -> str:
        r''' Paste Image from Clipboard '''
        return self._translate(25, 31, {})


    def notetypes_io_select_image(self, ) -> str:
        r''' Select Image '''
        return self._translate(25, 32, {})


    def notetypes_no_occlusion_created(self, ) -> str:
        r''' You must make at least one occlusion. '''
        return self._translate(25, 33, {})


    def notetypes_no_occlusion_created2(self, ) -> str:
        r''' Unable to add. Either you have not added any occlusions, or the first field is empty. '''
        return self._translate(25, 34, {})


    def notetypes_note_types(self, ) -> str:
        r''' Note Types '''
        return self._translate(25, 35, {})


    def notetypes_notetype(self, ) -> str:
        r''' Note Type '''
        return self._translate(25, 36, {})


    def notetypes_occlusion(self, ) -> str:
        r''' Occlusion '''
        return self._translate(25, 37, {})


    def notetypes_occlusion_mask(self, ) -> str:
        r''' Mask '''
        return self._translate(25, 38, {})


    def notetypes_occlusion_note(self, ) -> str:
        r''' Note '''
        return self._translate(25, 39, {})


    def notetypes_options(self, ) -> str:
        r''' Options '''
        return self._translate(25, 40, {})


    def notetypes_please_add_another_note_type_first(self, ) -> str:
        r''' Please add another note type first. '''
        return self._translate(25, 41, {})


    def notetypes_text_field(self, ) -> str:
        r''' Text '''
        return self._translate(25, 42, {})


    def notetypes_toggle_masks(self, ) -> str:
        r''' Toggle Masks '''
        return self._translate(25, 43, {})


    def notetypes_type(self, ) -> str:
        r''' Type '''
        return self._translate(25, 44, {})


    def preferences_account(self, ) -> str:
        r''' AnkiWeb Account '''
        return self._translate(26, 0, {})


    def preferences_always(self, ) -> str:
        r''' Always '''
        return self._translate(26, 1, {})


    def preferences_ankihub_intro(self, ) -> str:
        r''' AnkiHub provides collaborative deck editing and additional study tools. A paid subscription is required to access certain features. '''
        return self._translate(26, 2, {})


    def preferences_ankihub_not_logged_in(self, ) -> str:
        r''' Not currently logged in to AnkiHub. '''
        return self._translate(26, 3, {})


    def preferences_ankiweb_intro(self, ) -> str:
        r''' AnkiWeb is a free service that lets you keep your flashcard data in sync across your devices, and provides a way to recover the data if your device breaks or is lost. '''
        return self._translate(26, 4, {})


    def preferences_answer_keys(self, ) -> str:
        r''' Answer keys '''
        return self._translate(26, 5, {})


    def preferences_appearance(self, ) -> str:
        r''' Appearance '''
        return self._translate(26, 6, {})


    def preferences_automatically_sync_on_profile_openclose(self, ) -> str:
        r''' Automatically sync on profile open/close '''
        return self._translate(26, 7, {})


    def preferences_backup_explanation(self, ) -> str:
        r''' Anki periodically backs up your collection. After backups are more than 2 days old,
Anki will start removing some of them to free up disk space. '''
        return self._translate(26, 8, {})


    def preferences_backups(self, ) -> str:
        r''' Backups '''
        return self._translate(26, 9, {})


    def preferences_basic(self, ) -> str:
        r''' Basic '''
        return self._translate(26, 10, {})


    def preferences_browsing(self, ) -> str:
        r''' Browsing '''
        return self._translate(26, 11, {})


    def preferences_change_deck_depending_on_note_type(self, ) -> str:
        r''' Change deck depending on note type '''
        return self._translate(26, 12, {})


    def preferences_changes_will_take_effect_when_you(self, ) -> str:
        r''' Changes will take effect when you restart Anki. '''
        return self._translate(26, 13, {})


    def preferences_check_for_updates(self, ) -> str:
        r''' Check for program updates '''
        return self._translate(26, 14, {})


    def preferences_custom_sync_url(self, ) -> str:
        r''' Self-hosted sync server '''
        return self._translate(26, 15, {})


    def preferences_custom_sync_url_disclaimer(self, ) -> str:
        r''' For advanced users - please see the manual '''
        return self._translate(26, 16, {})


    def preferences_daily_backups(self, ) -> str:
        r''' Daily backups to keep: '''
        return self._translate(26, 17, {})


    def preferences_default_deck(self, ) -> str:
        r''' Default deck '''
        return self._translate(26, 18, {})


    def preferences_default_search_text(self, ) -> str:
        r''' Default search text '''
        return self._translate(26, 19, {})


    def preferences_default_search_text_example(self, ) -> str:
        r''' e.g. "deck:current" '''
        return self._translate(26, 20, {})


    def preferences_distractions(self, ) -> str:
        r''' Distractions '''
        return self._translate(26, 21, {})


    def preferences_editing(self, ) -> str:
        r''' Editing '''
        return self._translate(26, 22, {})


    def preferences_full_screen_only(self, ) -> str:
        r''' Full screen only '''
        return self._translate(26, 23, {})


    def preferences_general(self, ) -> str:
        r''' General '''
        return self._translate(26, 24, {})


    def preferences_generate_latex_images_automatically(self, ) -> str:
        r''' Generate LaTeX images (security risk) '''
        return self._translate(26, 25, {})


    def preferences_hide_bottom_bar_during_review(self, ) -> str:
        r''' Hide bottom bar during review '''
        return self._translate(26, 26, {})


    def preferences_hide_top_bar_during_review(self, ) -> str:
        r''' Hide top bar during review '''
        return self._translate(26, 27, {})


    def preferences_hours_past_midnight(self, ) -> str:
        r''' hours past midnight '''
        return self._translate(26, 28, {})


    def preferences_ignore_accents_in_search(self, ) -> str:
        r''' Ignore accents in search (slower) '''
        return self._translate(26, 29, {})


    def preferences_import_export(self, ) -> str:
        r''' Import/Export '''
        return self._translate(26, 30, {})


    def preferences_interrupt_current_audio_when_answering(self, ) -> str:
        r''' Interrupt current audio when answering '''
        return self._translate(26, 31, {})


    def preferences_language(self, ) -> str:
        r''' Language '''
        return self._translate(26, 32, {})


    def preferences_latex_generation_disabled(self, ) -> str:
        r''' LaTeX image generation is disabled in the preferences. '''
        return self._translate(26, 33, {})


    def preferences_learn_ahead_limit(self, ) -> str:
        r''' Learn ahead limit '''
        return self._translate(26, 34, {})


    def preferences_legacy_timezone_handling(self, ) -> str:
        r''' Legacy timezone handling (buggy, but required for AnkiDroid <= 2.14) '''
        return self._translate(26, 35, {})


    def preferences_login_successful_sync_now(self, ) -> str:
        r''' Log-in successful. Save preferences and sync now? '''
        return self._translate(26, 36, {})


    def preferences_media(self, ) -> str:
        r''' Media '''
        return self._translate(26, 37, {})


    def preferences_media_is_not_backed_up(self, ) -> str:
        r''' Media is not backed up. Please create a periodic backup of your Anki folder to be safe. '''
        return self._translate(26, 38, {})


    def preferences_minimalist_mode(self, ) -> str:
        r''' Minimalist mode '''
        return self._translate(26, 39, {})


    def preferences_minimalist_mode_tooltip(self, ) -> str:
        r''' Make the interface more compact/less fancy '''
        return self._translate(26, 40, {})


    def preferences_mins(self, ) -> str:
        r''' mins '''
        return self._translate(26, 41, {})


    def preferences_minutes_between_backups(self, ) -> str:
        r''' Minutes between automatic backups: '''
        return self._translate(26, 42, {})


    def preferences_monthly_backups(self, ) -> str:
        r''' Monthly backups to keep: '''
        return self._translate(26, 43, {})


    def preferences_network(self, ) -> str:
        r''' Syncing '''
        return self._translate(26, 44, {})


    def preferences_network_timeout(self, ) -> str:
        r''' Network timeout '''
        return self._translate(26, 45, {})


    def preferences_next_day_starts_at(self, ) -> str:
        r''' Next day starts at '''
        return self._translate(26, 46, {})


    def preferences_not_logged_in(self, ) -> str:
        r''' Not currently logged in to AnkiWeb. '''
        return self._translate(26, 47, {})


    def preferences_note(self, ) -> str:
        r''' Note '''
        return self._translate(26, 48, {})


    def preferences_on_next_sync_force_changes_in(self, ) -> str:
        r''' On next sync, force changes in one direction '''
        return self._translate(26, 49, {})


    def preferences_paste_clipboard_images_as_png(self, ) -> str:
        r''' Paste clipboard images as PNG '''
        return self._translate(26, 50, {})


    def preferences_paste_without_shift_key_strips_formatting(self, ) -> str:
        r''' Paste without shift key strips formatting '''
        return self._translate(26, 51, {})


    def preferences_periodically_sync_media(self, ) -> str:
        r''' Periodically sync media '''
        return self._translate(26, 52, {})


    def preferences_please_restart_anki_to_complete_language(self, ) -> str:
        r''' Please restart Anki to complete language change. '''
        return self._translate(26, 53, {})


    def preferences_preferences(self, ) -> str:
        r''' Preferences '''
        return self._translate(26, 54, {})


    def preferences_reduce_motion(self, ) -> str:
        r''' Reduce motion '''
        return self._translate(26, 55, {})


    def preferences_reduce_motion_tooltip(self, ) -> str:
        r''' Disable various animations and transitions of the user interface '''
        return self._translate(26, 56, {})


    def preferences_reset_window_sizes(self, ) -> str:
        r''' Reset Window Sizes '''
        return self._translate(26, 57, {})


    def preferences_reset_window_sizes_complete(self, ) -> str:
        r''' Window sizes and locations have been reset. '''
        return self._translate(26, 58, {})


    def preferences_review(self, ) -> str:
        r''' Review '''
        return self._translate(26, 59, {})


    def preferences_reviewer(self, ) -> str:
        r''' Reviewer '''
        return self._translate(26, 60, {})


    def preferences_scheduler(self, ) -> str:
        r''' Scheduler '''
        return self._translate(26, 61, {})


    def preferences_scheduling(self, ) -> str:
        r''' Scheduling '''
        return self._translate(26, 62, {})


    def preferences_shortcut_placeholder(self, ) -> str:
        r''' Enter an unused shortcut key, or leave empty to disable. '''
        return self._translate(26, 63, {})


    def preferences_show_learning_cards_with_larger_steps(self, ) -> str:
        r''' Show learning cards with larger steps before reviews '''
        return self._translate(26, 64, {})


    def preferences_show_next_review_time_above_answer(self, ) -> str:
        r''' Show next review time above answer buttons '''
        return self._translate(26, 65, {})


    def preferences_show_play_buttons_on_cards_with(self, ) -> str:
        r''' Show play buttons on cards with audio '''
        return self._translate(26, 66, {})


    def preferences_show_remaining_card_count(self, ) -> str:
        r''' Show remaining card count '''
        return self._translate(26, 67, {})


    def preferences_some_settings_will_take_effect_after(self, ) -> str:
        r''' Some settings will take effect after you restart Anki. '''
        return self._translate(26, 68, {})


    def preferences_spacebar_rates_card(self, ) -> str:
        r''' Spacebar (or enter) also answers card '''
        return self._translate(26, 69, {})


    def preferences_style(self, ) -> str:
        r''' Style '''
        return self._translate(26, 70, {})


    def preferences_synchronize_audio_and_images_too(self, ) -> str:
        r''' Synchronize audio and images too '''
        return self._translate(26, 71, {})


    def preferences_tab_synchronisation(self, ) -> str:
        r''' Synchronization '''
        return self._translate(26, 72, {})


    def preferences_theme(self, ) -> str:
        r''' Theme '''
        return self._translate(26, 73, {})


    def preferences_theme_dark(self, ) -> str:
        r''' Dark '''
        return self._translate(26, 74, {})


    def preferences_theme_follow_system(self, ) -> str:
        r''' Follow System '''
        return self._translate(26, 75, {})


    def preferences_theme_light(self, ) -> str:
        r''' Light '''
        return self._translate(26, 76, {})


    def preferences_third_party_description(self, ) -> str:
        r''' Third-party services are unaffiliated with and not endorsed by Anki. Use of these services may require payment. '''
        return self._translate(26, 77, {})


    def preferences_third_party_services(self, ) -> str:
        r''' Third-Party Services '''
        return self._translate(26, 78, {})


    def preferences_timebox_time_limit(self, ) -> str:
        r''' Timebox time limit '''
        return self._translate(26, 79, {})


    def preferences_url_scheme_allow_once(self, ) -> str:
        r''' Allow Once '''
        return self._translate(26, 80, {})


    def preferences_url_scheme_always_allow(self, ) -> str:
        r''' Always Allow '''
        return self._translate(26, 81, {})


    def preferences_url_scheme_prompt(self, ) -> str:
        r''' Allowed URL Schemes (space-separated): '''
        return self._translate(26, 82, {})


    def preferences_url_scheme_warning(self, link: str, scheme: str) -> str:
        r''' Blocked attempt to open `{$link}`, which may be a security issue.

If you trust the deck author and wish to proceed, you can add `{$scheme}` to your allowed URL Schemes. '''
        return self._translate(26, 83, {"link": link, "scheme": scheme})


    def preferences_url_schemes(self, ) -> str:
        r''' URL Schemes '''
        return self._translate(26, 84, {})


    def preferences_user_interface(self, ) -> str:
        r''' User Interface '''
        return self._translate(26, 85, {})


    def preferences_user_interface_size(self, ) -> str:
        r''' User interface size '''
        return self._translate(26, 86, {})


    def preferences_v3_scheduler(self, ) -> str:
        r''' V3 scheduler '''
        return self._translate(26, 87, {})


    def preferences_video_driver(self, ) -> str:
        r''' Video driver '''
        return self._translate(26, 88, {})


    def preferences_video_driver_angle(self, ) -> str:
        r''' ANGLE (may work better than OpenGL) '''
        return self._translate(26, 89, {})


    def preferences_video_driver_default(self, ) -> str:
        r''' default '''
        return self._translate(26, 90, {})


    def preferences_video_driver_opengl_mac(self, ) -> str:
        r''' OpenGL (recommended on Macs) '''
        return self._translate(26, 91, {})


    def preferences_video_driver_opengl_other(self, ) -> str:
        r''' OpenGL (faster, may cause issues) '''
        return self._translate(26, 92, {})


    def preferences_video_driver_software_mac(self, ) -> str:
        r''' Software (not recommended) '''
        return self._translate(26, 93, {})


    def preferences_video_driver_software_other(self, ) -> str:
        r''' Software (slower) '''
        return self._translate(26, 94, {})


    def preferences_weekly_backups(self, ) -> str:
        r''' Weekly backups to keep: '''
        return self._translate(26, 95, {})


    def preferences_when_adding_default_to_current_deck(self, ) -> str:
        r''' When adding, default to current deck '''
        return self._translate(26, 96, {})


    def preferences_you_can_restore_backups_via_fileswitch(self, ) -> str:
        r''' You can restore backups via File > Switch Profile. '''
        return self._translate(26, 97, {})


    def profiles_anki_could_not_read_your_profile(self, ) -> str:
        r''' Anki could not read your profile data. Window sizes and your sync login details have been forgotten. '''
        return self._translate(27, 0, {})


    def profiles_anki_could_not_rename_your_profile(self, ) -> str:
        r''' Anki could not rename your profile because it could not rename the profile folder on disk. Please ensure you have permission to write to Documents/Anki and no other programs are accessing your profile folders, then try again. '''
        return self._translate(27, 1, {})


    def profiles_backup_created(self, ) -> str:
        r''' Backup created. '''
        return self._translate(27, 2, {})


    def profiles_backup_creation_failed(self, reason: str) -> str:
        r''' Backup creation failed: {$reason} '''
        return self._translate(27, 3, {"reason": reason})


    def profiles_backup_unchanged(self, ) -> str:
        r''' No changes since latest backup. '''
        return self._translate(27, 4, {})


    def profiles_confirm_lang_choice(self, lang: str) -> str:
        r''' Are you sure you wish to display Anki's interface in {$lang}? '''
        return self._translate(27, 5, {"lang": lang})


    def profiles_could_not_create_data_folder(self, ) -> str:
        r''' Anki could not create its data folder. Please see the File Locations section of the manual, and ensure that location is not read-only. '''
        return self._translate(27, 6, {})


    def profiles_creating_backup(self, ) -> str:
        r''' Creating Backup... '''
        return self._translate(27, 7, {})


    def profiles_downgrade_and_quit(self, ) -> str:
        r''' Downgrade && Quit '''
        return self._translate(27, 8, {})


    def profiles_folder_already_exists(self, ) -> str:
        r''' Folder already exists. '''
        return self._translate(27, 9, {})


    def profiles_folder_readme(self, link: str) -> str:
        r''' This folder stores all of your Anki data in a single location,
to make backups easy. To tell Anki to use a different location,
please see:

{$link} '''
        return self._translate(27, 10, {"link": link})


    def profiles_open(self, ) -> str:
        r''' Open '''
        return self._translate(27, 11, {})


    def profiles_open_backup(self, ) -> str:
        r''' Open Backup... '''
        return self._translate(27, 12, {})


    def profiles_please_remove_the_folder_and(self, val: FluentVariable) -> str:
        r''' Please remove the folder {$val} and try again. '''
        return self._translate(27, 13, {"val": val})


    def profiles_prefs_corrupt_title(self, ) -> str:
        r''' Preferences Corrupt '''
        return self._translate(27, 14, {})


    def profiles_prefs_file_is_corrupt(self, ) -> str:
        r''' Anki's prefs21.db file was corrupt and has been recreated. If you were using multiple profiles, please add them back using the same names to recover your cards. '''
        return self._translate(27, 15, {})


    def profiles_profile_corrupt(self, ) -> str:
        r''' Profile Corrupt '''
        return self._translate(27, 16, {})


    def profiles_profile_does_not_exist(self, ) -> str:
        r''' Requested profile does not exist. '''
        return self._translate(27, 17, {})


    def profiles_profiles(self, ) -> str:
        r''' Profiles '''
        return self._translate(27, 18, {})


    def profiles_quit(self, ) -> str:
        r''' Quit '''
        return self._translate(27, 19, {})


    def profiles_user_1(self, ) -> str:
        r''' User 1 '''
        return self._translate(27, 20, {})


    def qt_accel_about(self, ) -> str:
        r''' &About '''
        return self._translate(28, 0, {})


    def qt_accel_about_mac(self, ) -> str:
        r''' About Anki... '''
        return self._translate(28, 1, {})


    def qt_accel_cards(self, ) -> str:
        r''' &Cards '''
        return self._translate(28, 2, {})


    def qt_accel_check_database(self, ) -> str:
        r''' &Check Database '''
        return self._translate(28, 3, {})


    def qt_accel_check_media(self, ) -> str:
        r''' Check &Media '''
        return self._translate(28, 4, {})


    def qt_accel_create_backup(self, ) -> str:
        r''' Create &Backup '''
        return self._translate(28, 5, {})


    def qt_accel_edit(self, ) -> str:
        r''' &Edit '''
        return self._translate(28, 6, {})


    def qt_accel_exit(self, ) -> str:
        r''' E&xit '''
        return self._translate(28, 7, {})


    def qt_accel_export(self, ) -> str:
        r''' &Export... '''
        return self._translate(28, 8, {})


    def qt_accel_export_notes(self, ) -> str:
        r''' &Export Notes... '''
        return self._translate(28, 9, {})


    def qt_accel_file(self, ) -> str:
        r''' &File '''
        return self._translate(28, 10, {})


    def qt_accel_filter(self, ) -> str:
        r''' Fil&ter '''
        return self._translate(28, 11, {})


    def qt_accel_find(self, ) -> str:
        r''' &Find '''
        return self._translate(28, 12, {})


    def qt_accel_find_and_replace(self, ) -> str:
        r''' Find and Re&place... '''
        return self._translate(28, 13, {})


    def qt_accel_find_duplicates(self, ) -> str:
        r''' Find &Duplicates... '''
        return self._translate(28, 14, {})


    def qt_accel_forget(self, ) -> str:
        r''' &Reset '''
        return self._translate(28, 15, {})


    def qt_accel_full_screen(self, ) -> str:
        r''' Toggle &Full Screen '''
        return self._translate(28, 16, {})


    def qt_accel_go(self, ) -> str:
        r''' &Go '''
        return self._translate(28, 17, {})


    def qt_accel_guide(self, ) -> str:
        r''' &Guide '''
        return self._translate(28, 18, {})


    def qt_accel_help(self, ) -> str:
        r''' &Help '''
        return self._translate(28, 19, {})


    def qt_accel_import(self, ) -> str:
        r''' &Import... '''
        return self._translate(28, 20, {})


    def qt_accel_info(self, ) -> str:
        r''' &Info... '''
        return self._translate(28, 21, {})


    def qt_accel_invert_selection(self, ) -> str:
        r''' &Invert Selection '''
        return self._translate(28, 22, {})


    def qt_accel_layout(self, ) -> str:
        r''' &Layout '''
        return self._translate(28, 23, {})


    def qt_accel_layout_auto(self, ) -> str:
        r''' &Auto '''
        return self._translate(28, 24, {})


    def qt_accel_layout_horizontal(self, ) -> str:
        r''' &Horizontal '''
        return self._translate(28, 25, {})


    def qt_accel_layout_vertical(self, ) -> str:
        r''' &Vertical '''
        return self._translate(28, 26, {})


    def qt_accel_load_backup(self, ) -> str:
        r''' &Revert to Backup '''
        return self._translate(28, 27, {})


    def qt_accel_next_card(self, ) -> str:
        r''' &Next Card '''
        return self._translate(28, 28, {})


    def qt_accel_note(self, ) -> str:
        r''' N&ote '''
        return self._translate(28, 29, {})


    def qt_accel_notes(self, ) -> str:
        r''' &Notes '''
        return self._translate(28, 30, {})


    def qt_accel_preferences(self, ) -> str:
        r''' &Preferences '''
        return self._translate(28, 31, {})


    def qt_accel_previous_card(self, ) -> str:
        r''' &Previous Card '''
        return self._translate(28, 32, {})


    def qt_accel_redo(self, ) -> str:
        r''' &Redo '''
        return self._translate(28, 33, {})


    def qt_accel_reset_zoom(self, ) -> str:
        r''' &Reset Zoom '''
        return self._translate(28, 34, {})


    def qt_accel_select_all(self, ) -> str:
        r''' Select &All '''
        return self._translate(28, 35, {})


    def qt_accel_select_notes(self, ) -> str:
        r''' Select &Notes '''
        return self._translate(28, 36, {})


    def qt_accel_set_due_date(self, ) -> str:
        r''' Set &Due Date... '''
        return self._translate(28, 37, {})


    def qt_accel_support_anki(self, ) -> str:
        r''' &Support Anki '''
        return self._translate(28, 38, {})


    def qt_accel_switch_profile(self, ) -> str:
        r''' &Switch Profile '''
        return self._translate(28, 39, {})


    def qt_accel_toggle_sidebar(self, ) -> str:
        r''' Toggle Sidebar '''
        return self._translate(28, 40, {})


    def qt_accel_tools(self, ) -> str:
        r''' &Tools '''
        return self._translate(28, 41, {})


    def qt_accel_undo(self, ) -> str:
        r''' &Undo '''
        return self._translate(28, 42, {})


    def qt_accel_upgrade_downgrade(self, ) -> str:
        r''' Upgrade/Downgrade '''
        return self._translate(28, 43, {})


    def qt_accel_view(self, ) -> str:
        r''' &View '''
        return self._translate(28, 44, {})


    def qt_accel_zoom_editor_in(self, ) -> str:
        r''' Zoom Editor &In '''
        return self._translate(28, 45, {})


    def qt_accel_zoom_editor_out(self, ) -> str:
        r''' Zoom Editor &Out '''
        return self._translate(28, 46, {})


    def qt_accel_zoom_in(self, ) -> str:
        r''' Zoom &In '''
        return self._translate(28, 47, {})


    def qt_accel_zoom_out(self, ) -> str:
        r''' Zoom &Out '''
        return self._translate(28, 48, {})


    def qt_misc_addon_will_be_installed_when_a(self, ) -> str:
        r''' Add-on will be installed when a profile is opened. '''
        return self._translate(29, 0, {})


    def qt_misc_addons(self, ) -> str:
        r''' Add-ons '''
        return self._translate(29, 1, {})


    def qt_misc_all_cards_notes_and_media_for(self, ) -> str:
        r''' All cards, notes, and media for this profile will be deleted. Are you sure? '''
        return self._translate(29, 2, {})


    def qt_misc_all_cards_notes_and_media_for2(self, name: str) -> str:
        r''' All cards, notes, and media for the profile "{$name}" will be deleted. Are you sure? '''
        return self._translate(29, 3, {"name": name})


    def qt_misc_anki_is_running(self, ) -> str:
        r''' Anki Already Running '''
        return self._translate(29, 4, {})


    def qt_misc_anki_updatedanki_has_been_released(self, val: FluentVariable) -> str:
        r''' <h1>Anki Updated</h1>Anki {$val} has been released.<br><br> '''
        return self._translate(29, 5, {"val": val})


    def qt_misc_automatic_syncing_and_backups_have_been(self, ) -> str:
        r''' Backup successfully restored. Automatic syncing and backups have been disabled for now. To enable them again, close the profile or restart Anki. '''
        return self._translate(29, 6, {})


    def qt_misc_back_side_only(self, ) -> str:
        r''' Back Side Only '''
        return self._translate(29, 7, {})


    def qt_misc_backing_up(self, ) -> str:
        r''' Backing Up... '''
        return self._translate(29, 8, {})


    def qt_misc_browse(self, ) -> str:
        r''' Browse '''
        return self._translate(29, 9, {})


    def qt_misc_change_note_type_ctrlandn(self, ) -> str:
        r''' Change Note Type (Ctrl+N) '''
        return self._translate(29, 10, {})


    def qt_misc_check_the_files_in_the_media(self, ) -> str:
        r''' Check the files in the media directory '''
        return self._translate(29, 11, {})


    def qt_misc_choose_deck(self, ) -> str:
        r''' Choose Deck '''
        return self._translate(29, 12, {})


    def qt_misc_choose_note_type(self, ) -> str:
        r''' Choose Note Type '''
        return self._translate(29, 13, {})


    def qt_misc_closing(self, ) -> str:
        r''' Closing... '''
        return self._translate(29, 14, {})


    def qt_misc_configure_interface_language_and_options(self, ) -> str:
        r''' Configure interface language and options '''
        return self._translate(29, 15, {})


    def qt_misc_copy_to_clipboard(self, ) -> str:
        r''' Copy to Clipboard '''
        return self._translate(29, 16, {})


    def qt_misc_create_filtered_deck(self, ) -> str:
        r''' Create Filtered Deck... '''
        return self._translate(29, 17, {})


    def qt_misc_debug_console(self, ) -> str:
        r''' Debug Console '''
        return self._translate(29, 18, {})


    def qt_misc_deck_will_be_imported_when_a(self, ) -> str:
        r''' Deck will be imported when a profile is opened. '''
        return self._translate(29, 19, {})


    def qt_misc_empty_cards(self, ) -> str:
        r''' Empty Cards... '''
        return self._translate(29, 20, {})


    def qt_misc_error(self, ) -> str:
        r''' Error '''
        return self._translate(29, 21, {})


    def qt_misc_error_during_startup(self, val: FluentVariable) -> str:
        r''' Error during startup: {$val} '''
        return self._translate(29, 22, {"val": val})


    def qt_misc_error_loading_graphics_driver(self, mode: str, context: str) -> str:
        r''' Error loading '{$mode}' graphics driver. Please start Anki again to try the next driver. {$context} '''
        return self._translate(29, 23, {"mode": mode, "context": context})


    def qt_misc_if_instance_is_not_responding(self, ) -> str:
        r''' If the existing instance of Anki is not responding, please close it using your task manager, or restart your computer. '''
        return self._translate(29, 24, {})


    def qt_misc_ignore_this_update(self, ) -> str:
        r''' Ignore this update '''
        return self._translate(29, 25, {})


    def qt_misc_in_order_to_ensure_your_collection(self, val: FluentVariable) -> str:
        r''' In order to ensure your collection works correctly when moved between devices, Anki requires your computer's internal clock to be set correctly. The internal clock can be wrong even if your system is showing the correct local time.<br><br>Please go to the time settings on your computer and check the following:<br><br>- AM/PM<br>- Clock drift<br>- Day, month and year<br>- Timezone<br>- Daylight savings<br><br>Difference to correct time: {$val}. '''
        return self._translate(29, 26, {"val": val})


    def qt_misc_incompatible_video_driver(self, ) -> str:
        r''' Your video driver is incompatible. Please start Anki again, and Anki will switch to a slower, more compatible mode. '''
        return self._translate(29, 27, {})


    def qt_misc_invalid_property_found_on_card_please(self, ) -> str:
        r''' Invalid property found on card. Please use Tools>Check Database, and if the problem comes up again, please ask on the support site. '''
        return self._translate(29, 28, {})


    def qt_misc_layout_auto_enabled(self, ) -> str:
        r''' Responsive layout enabled '''
        return self._translate(29, 29, {})


    def qt_misc_layout_horizontal_enabled(self, ) -> str:
        r''' Horizontal layout enabled '''
        return self._translate(29, 30, {})


    def qt_misc_layout_vertical_enabled(self, ) -> str:
        r''' Vertical layout enabled '''
        return self._translate(29, 31, {})


    def qt_misc_loading(self, ) -> str:
        r''' Loading... '''
        return self._translate(29, 32, {})


    def qt_misc_manage(self, ) -> str:
        r''' Manage '''
        return self._translate(29, 33, {})


    def qt_misc_manage_note_types(self, ) -> str:
        r''' Manage Note Types '''
        return self._translate(29, 34, {})


    def qt_misc_name_exists(self, ) -> str:
        r''' Name exists. '''
        return self._translate(29, 35, {})


    def qt_misc_no_temp_folder(self, ) -> str:
        r''' No usable temporary folder found. Make sure C:\\temp exists or TEMP in your environment points to a valid, writable folder. '''
        return self._translate(29, 36, {})


    def qt_misc_non_unicode_text(self, ) -> str:
        r''' <non-unicode text> '''
        return self._translate(29, 37, {})


    def qt_misc_open_anki_launcher(self, ) -> str:
        r''' Change to a different Anki version? '''
        return self._translate(29, 38, {})


    def qt_misc_optimizing(self, ) -> str:
        r''' Optimizing... '''
        return self._translate(29, 39, {})


    def qt_misc_please_ensure_a_profile_is_open(self, ) -> str:
        r''' Please ensure a profile is open and Anki is not busy, then try again. '''
        return self._translate(29, 40, {})


    def qt_misc_please_select_1_card(self, ) -> str:
        r''' (please select 1 card) '''
        return self._translate(29, 41, {})


    def qt_misc_please_select_a_deck(self, ) -> str:
        r''' Please select a deck. '''
        return self._translate(29, 42, {})


    def qt_misc_please_use_fileimport_to_import_this(self, ) -> str:
        r''' Please use File>Import to import this file. '''
        return self._translate(29, 43, {})


    def qt_misc_processing(self, ) -> str:
        r''' Processing... '''
        return self._translate(29, 44, {})


    def qt_misc_replace_your_collection_with_an_earlier(self, ) -> str:
        r''' Replace your collection with an earlier backup? '''
        return self._translate(29, 45, {})


    def qt_misc_replace_your_collection_with_an_earlier2(self, val: FluentVariable) -> str:
        r''' Replace your collection with an earlier backup from {$val}? '''
        return self._translate(29, 46, {"val": val})


    def qt_misc_revert_to_backup(self, ) -> str:
        r''' Revert to backup '''
        return self._translate(29, 47, {})


    def qt_misc_second(self, count: int) -> str:
        r''' {$count} seconds '''
        return self._translate(29, 48, {"count": count})


    def qt_misc_segoe_ui(self, ) -> str:
        r''' "Segoe UI" '''
        return self._translate(29, 49, {})


    def qt_misc_shift_key_was_held_down_skipping(self, ) -> str:
        r''' Shift key was held down. Skipping automatic syncing and add-on loading. '''
        return self._translate(29, 50, {})


    def qt_misc_shortcut_key_left_arrow(self, ) -> str:
        r''' Shortcut key: Left arrow '''
        return self._translate(29, 51, {})


    def qt_misc_shortcut_key_right_arrow_or_enter(self, ) -> str:
        r''' Shortcut key: Right arrow or Enter '''
        return self._translate(29, 52, {})


    def qt_misc_stats(self, ) -> str:
        r''' Stats '''
        return self._translate(29, 53, {})


    def qt_misc_study_deck(self, ) -> str:
        r''' Study Deck... '''
        return self._translate(29, 54, {})


    def qt_misc_sync(self, ) -> str:
        r''' Sync '''
        return self._translate(29, 55, {})


    def qt_misc_target_deck_ctrlandd(self, ) -> str:
        r''' Target Deck (Ctrl+D) '''
        return self._translate(29, 56, {})


    def qt_misc_the_following_character_can_not_be(self, val: FluentVariable) -> str:
        r''' The following character can not be used: {$val} '''
        return self._translate(29, 57, {"val": val})


    def qt_misc_the_requested_change_will_require_a(self, ) -> str:
        r''' The requested change will require a full upload of the database when you next synchronize your collection. If you have reviews or other changes waiting on another device that haven't been synchronized here yet, they will be lost. Continue? '''
        return self._translate(29, 58, {})


    def qt_misc_there_must_be_at_least_one(self, ) -> str:
        r''' There must be at least one profile. '''
        return self._translate(29, 59, {})


    def qt_misc_this_file_exists_are_you_sure(self, ) -> str:
        r''' This file exists. Are you sure you want to overwrite it? '''
        return self._translate(29, 60, {})


    def qt_misc_unable_to_access_anki_media_folder(self, ) -> str:
        r''' Unable to access Anki media folder. The permissions on your system's temporary folder may be incorrect. '''
        return self._translate(29, 61, {})


    def qt_misc_unable_to_record(self, error: str) -> str:
        r''' Unable to record. Please ensure a microphone is connected, and Anki has permission to use the microphone.
If other programs are using your microphone, closing them may help.

Original error: {$error} '''
        return self._translate(29, 62, {"error": error})


    def qt_misc_unexpected_response_code(self, val: FluentVariable) -> str:
        r''' Unexpected response code: {$val} '''
        return self._translate(29, 63, {"val": val})


    def qt_misc_would_you_like_to_download_it(self, ) -> str:
        r''' Would you like to download it now? '''
        return self._translate(29, 64, {})


    def qt_misc_your_collection_file_appears_to_be(self, ) -> str:
        r''' Your collection file appears to be corrupt. This can happen when the file is copied or moved while Anki is open, or when the collection is stored on a network or cloud drive. If problems persist after restarting your computer, please open an automatic backup from the profile screen. '''
        return self._translate(29, 65, {})


    def qt_misc_your_computers_storage_may_be_full(self, ) -> str:
        r''' Your computer's storage may be full. Please delete some unneeded files, then try again. '''
        return self._translate(29, 66, {})


    def qt_misc_your_firewall_or_antivirus_program_is(self, ) -> str:
        r''' Your firewall or antivirus program is preventing Anki from creating a connection to itself. Please add an exception for Anki. '''
        return self._translate(29, 67, {})


    def scheduling_always_include_question_side_when_replaying(self, ) -> str:
        r''' Always include question side when replaying audio '''
        return self._translate(30, 0, {})


    def scheduling_answer_button_time_days(self, amount: int) -> str:
        r''' {$amount}d '''
        return self._translate(30, 1, {"amount": amount})


    def scheduling_answer_button_time_hours(self, amount: int) -> str:
        r''' {$amount}h '''
        return self._translate(30, 2, {"amount": amount})


    def scheduling_answer_button_time_minutes(self, amount: int) -> str:
        r''' {$amount}m '''
        return self._translate(30, 3, {"amount": amount})


    def scheduling_answer_button_time_months(self, amount: int) -> str:
        r''' {$amount}mo '''
        return self._translate(30, 4, {"amount": amount})


    def scheduling_answer_button_time_seconds(self, amount: int) -> str:
        r''' {$amount}s '''
        return self._translate(30, 5, {"amount": amount})


    def scheduling_answer_button_time_years(self, amount: int) -> str:
        r''' {$amount}y '''
        return self._translate(30, 6, {"amount": amount})


    def scheduling_at_least_one_step_is_required(self, ) -> str:
        r''' At least one step is required. '''
        return self._translate(30, 7, {})


    def scheduling_automatically_play_audio(self, ) -> str:
        r''' Automatically play audio '''
        return self._translate(30, 8, {})


    def scheduling_buried_cards_found(self, unbury_them: str) -> str:
        r''' One or more cards were buried, and will be shown tomorrow. You can {$unburyThem} if you wish to see them immediately. '''
        return self._translate(30, 9, {"unburyThem": unbury_them})


    def scheduling_bury_related_new_cards_until_the(self, ) -> str:
        r''' Bury related new cards until the next day '''
        return self._translate(30, 10, {})


    def scheduling_bury_related_reviews_until_the_next(self, ) -> str:
        r''' Bury related reviews until the next day '''
        return self._translate(30, 11, {})


    def scheduling_congratulations_finished(self, ) -> str:
        r''' Congratulations! You have finished this deck for now. '''
        return self._translate(30, 12, {})


    def scheduling_custom_study(self, ) -> str:
        r''' custom study '''
        return self._translate(30, 13, {})


    def scheduling_days(self, ) -> str:
        r''' days '''
        return self._translate(30, 14, {})


    def scheduling_deck_updated(self, count: int) -> str:
        r''' {$count} decks updated. '''
        return self._translate(30, 15, {"count": count})


    def scheduling_description(self, ) -> str:
        r''' Description '''
        return self._translate(30, 16, {})


    def scheduling_easy_bonus(self, ) -> str:
        r''' Easy bonus '''
        return self._translate(30, 17, {})


    def scheduling_easy_interval(self, ) -> str:
        r''' Easy interval '''
        return self._translate(30, 18, {})


    def scheduling_end(self, ) -> str:
        r''' (end) '''
        return self._translate(30, 19, {})


    def scheduling_forgot_cards(self, cards: int) -> str:
        r''' Reset {$cards} cards. '''
        return self._translate(30, 20, {"cards": cards})


    def scheduling_general(self, ) -> str:
        r''' General '''
        return self._translate(30, 21, {})


    def scheduling_graded_cards_done(self, cards: int) -> str:
        r''' Graded {$cards} cards. '''
        return self._translate(30, 22, {"cards": cards})


    def scheduling_graduating_interval(self, ) -> str:
        r''' Graduating interval '''
        return self._translate(30, 23, {})


    def scheduling_hard_interval(self, ) -> str:
        r''' Hard interval '''
        return self._translate(30, 24, {})


    def scheduling_how_to_custom_study(self, custom_study: str) -> str:
        r''' If you wish to study outside of the regular schedule, you can use the {$customStudy} feature. '''
        return self._translate(30, 25, {"customStudy": custom_study})


    def scheduling_ignore_answer_times_longer_than(self, ) -> str:
        r''' Ignore answer times longer than '''
        return self._translate(30, 26, {})


    def scheduling_interval_modifier(self, ) -> str:
        r''' Interval modifier '''
        return self._translate(30, 27, {})


    def scheduling_lapses(self, ) -> str:
        r''' Lapses '''
        return self._translate(30, 28, {})


    def scheduling_lapses2(self, ) -> str:
        r''' lapses '''
        return self._translate(30, 29, {})


    def scheduling_learn_remaining(self, remaining: int) -> str:
        r''' There are {$remaining} learning cards due later today. '''
        return self._translate(30, 30, {"remaining": remaining})


    def scheduling_learning(self, ) -> str:
        r''' Learning '''
        return self._translate(30, 31, {})


    def scheduling_leech_action(self, ) -> str:
        r''' Leech action '''
        return self._translate(30, 32, {})


    def scheduling_leech_threshold(self, ) -> str:
        r''' Leech threshold '''
        return self._translate(30, 33, {})


    def scheduling_maximum_interval(self, ) -> str:
        r''' Maximum interval '''
        return self._translate(30, 34, {})


    def scheduling_maximum_reviewsday(self, ) -> str:
        r''' Maximum reviews/day '''
        return self._translate(30, 35, {})


    def scheduling_minimum_interval(self, ) -> str:
        r''' Minimum interval '''
        return self._translate(30, 36, {})


    def scheduling_mix_new_cards_and_reviews(self, ) -> str:
        r''' Mix new cards and reviews '''
        return self._translate(30, 37, {})


    def scheduling_new_cards(self, ) -> str:
        r''' New Cards '''
        return self._translate(30, 38, {})


    def scheduling_new_cardsday(self, ) -> str:
        r''' New cards/day '''
        return self._translate(30, 39, {})


    def scheduling_new_interval(self, ) -> str:
        r''' New interval '''
        return self._translate(30, 40, {})


    def scheduling_new_options_group_name(self, ) -> str:
        r''' New options group name: '''
        return self._translate(30, 41, {})


    def scheduling_next_learn_due(self, unit: str, amount: int) -> str:
        r''' The next learning card will be ready in {$amount} hours. '''
        return self._translate(30, 42, {"unit": unit, "amount": amount})


    def scheduling_options_group(self, ) -> str:
        r''' Options group: '''
        return self._translate(30, 43, {})


    def scheduling_order(self, ) -> str:
        r''' Order '''
        return self._translate(30, 44, {})


    def scheduling_parent_limit(self, val: FluentVariable) -> str:
        r''' (parent limit: {$val}) '''
        return self._translate(30, 45, {"val": val})


    def scheduling_reset_counts(self, ) -> str:
        r''' Reset repetition and lapse counts '''
        return self._translate(30, 46, {})


    def scheduling_restore_position(self, ) -> str:
        r''' Restore original position where possible '''
        return self._translate(30, 47, {})


    def scheduling_review(self, ) -> str:
        r''' Review '''
        return self._translate(30, 48, {})


    def scheduling_reviews(self, ) -> str:
        r''' Reviews '''
        return self._translate(30, 49, {})


    def scheduling_seconds(self, ) -> str:
        r''' seconds '''
        return self._translate(30, 50, {})


    def scheduling_set_all_decks_below_to(self, val: FluentVariable) -> str:
        r''' Set all decks below {$val} to this option group? '''
        return self._translate(30, 51, {"val": val})


    def scheduling_set_due_date_done(self, cards: int) -> str:
        r''' Set due date of {$cards} cards. '''
        return self._translate(30, 52, {"cards": cards})


    def scheduling_set_due_date_prompt(self, cards: int) -> str:
        r''' Show cards in how many days? '''
        return self._translate(30, 53, {"cards": cards})


    def scheduling_set_due_date_prompt_hint(self, ) -> str:
        r''' 0 = today
1! = tomorrow + change interval to 1
3-7 = random choice of 3-7 days '''
        return self._translate(30, 54, {})


    def scheduling_set_for_all_subdecks(self, ) -> str:
        r''' Set for all subdecks '''
        return self._translate(30, 55, {})


    def scheduling_show_answer_timer(self, ) -> str:
        r''' Show on-screen timer '''
        return self._translate(30, 56, {})


    def scheduling_show_new_cards_after_reviews(self, ) -> str:
        r''' Show new cards after reviews '''
        return self._translate(30, 57, {})


    def scheduling_show_new_cards_before_reviews(self, ) -> str:
        r''' Show new cards before reviews '''
        return self._translate(30, 58, {})


    def scheduling_show_new_cards_in_order_added(self, ) -> str:
        r''' Show new cards in order added '''
        return self._translate(30, 59, {})


    def scheduling_show_new_cards_in_random_order(self, ) -> str:
        r''' Show new cards in random order '''
        return self._translate(30, 60, {})


    def scheduling_starting_ease(self, ) -> str:
        r''' Starting ease '''
        return self._translate(30, 61, {})


    def scheduling_steps_in_minutes(self, ) -> str:
        r''' Steps (in minutes) '''
        return self._translate(30, 62, {})


    def scheduling_steps_must_be_numbers(self, ) -> str:
        r''' Steps must be numbers. '''
        return self._translate(30, 63, {})


    def scheduling_tag_only(self, ) -> str:
        r''' Tag Only '''
        return self._translate(30, 64, {})


    def scheduling_the_default_configuration_cant_be_removed(self, ) -> str:
        r''' The default configuration can't be removed. '''
        return self._translate(30, 65, {})


    def scheduling_time_span_days(self, amount: int) -> str:
        r''' {$amount} days '''
        return self._translate(30, 66, {"amount": amount})


    def scheduling_time_span_hours(self, amount: int) -> str:
        r''' {$amount} hours '''
        return self._translate(30, 67, {"amount": amount})


    def scheduling_time_span_minutes(self, amount: int) -> str:
        r''' {$amount} minutes '''
        return self._translate(30, 68, {"amount": amount})


    def scheduling_time_span_months(self, amount: int) -> str:
        r''' {$amount} months '''
        return self._translate(30, 69, {"amount": amount})


    def scheduling_time_span_seconds(self, amount: int) -> str:
        r''' {$amount} seconds '''
        return self._translate(30, 70, {"amount": amount})


    def scheduling_time_span_years(self, amount: int) -> str:
        r''' {$amount} years '''
        return self._translate(30, 71, {"amount": amount})


    def scheduling_today_new_limit_reached(self, ) -> str:
        r''' There are more new cards available, but the daily limit has been
reached. You can increase the limit in the options, but please
bear in mind that the more new cards you introduce, the higher
your short-term review workload will become. '''
        return self._translate(30, 72, {})


    def scheduling_today_review_limit_reached(self, ) -> str:
        r''' Today's review limit has been reached, but there are still cards
waiting to be reviewed. For optimum memory, consider increasing
the daily limit in the options. '''
        return self._translate(30, 73, {})


    def scheduling_unbury_them(self, ) -> str:
        r''' unbury them '''
        return self._translate(30, 74, {})


    def scheduling_update_button(self, ) -> str:
        r''' Update '''
        return self._translate(30, 75, {})


    def scheduling_update_done(self, ) -> str:
        r''' Scheduler updated successfully. '''
        return self._translate(30, 76, {})


    def scheduling_update_later_button(self, ) -> str:
        r''' Later '''
        return self._translate(30, 77, {})


    def scheduling_update_more_info_button(self, ) -> str:
        r''' Learn More '''
        return self._translate(30, 78, {})


    def scheduling_update_required(self, ) -> str:
        r''' Your collection needs to be upgraded to the V2 scheduler.
Please select  before proceeding. '''
        return self._translate(30, 79, {})


    def scheduling_update_soon(self, ) -> str:
        r''' Anki 2.1 comes with a new scheduler, which fixes a number of issues that previous Anki versions had. Updating to it is recommended. '''
        return self._translate(30, 80, {})


    def scheduling_your_changes_will_affect_multiple_decks(self, ) -> str:
        r''' Your changes will affect multiple decks. If you wish to change only the current deck, please add a new options group first. '''
        return self._translate(30, 81, {})


    def search_card_modified(self, ) -> str:
        r''' Card Modified '''
        return self._translate(31, 0, {})


    def search_empty_group(self, ) -> str:
        r''' a group `(...)` was found, but there was nothing between the brackets to search for. If you want to search for literal brackets, wrap them in double quotes: `"( )"`. '''
        return self._translate(31, 1, {})


    def search_empty_quote(self, ) -> str:
        r''' a pair of double quotes `""` was found, but there was nothing between them to search for. If you want to search for literal double quotes, prepend backslashes: `\"\"`. '''
        return self._translate(31, 2, {})


    def search_invalid_answer_button(self, context: str, provided: str) -> str:
        r''' expected an answer button between 1-4 in "`{$context}`", but found "`{$provided}`". '''
        return self._translate(31, 3, {"context": context, "provided": provided})


    def search_invalid_argument(self, term: str, argument: str) -> str:
        r''' `{$term}` was given an invalid argument '`{$argument}`'. '''
        return self._translate(31, 4, {"term": term, "argument": argument})


    def search_invalid_flag_2(self, ) -> str:
        r''' `flag:` must be followed by a valid flag number: `1` (red), `2` (orange), `3` (green), `4` (blue), `5` (pink), `6` (turquoise), `7` (purple) or `0` (no flag). '''
        return self._translate(31, 5, {})


    def search_invalid_negative_whole_number(self, context: str, provided: str) -> str:
        r''' expected a whole number less than or equal to 0 in "`{$context}`", but found "`{$provided}`". '''
        return self._translate(31, 6, {"context": context, "provided": provided})


    def search_invalid_number(self, context: str, provided: str) -> str:
        r''' expected a number in "`{$context}`", but found "`{$provided}`". '''
        return self._translate(31, 7, {"context": context, "provided": provided})


    def search_invalid_other(self, ) -> str:
        r''' please check for typing mistakes. '''
        return self._translate(31, 8, {})


    def search_invalid_positive_whole_number(self, context: str, provided: str) -> str:
        r''' expected a positive whole number in "`{$context}`", but found "`{$provided}`". '''
        return self._translate(31, 9, {"context": context, "provided": provided})


    def search_invalid_prop_operator(self, val: FluentVariable) -> str:
        r''' `prop:{$val}` must be followed by one of the following comparison operators: `=`, `!=`, `<`, `>`, `<=` or `>=`. '''
        return self._translate(31, 10, {"val": val})


    def search_invalid_search(self, reason: str) -> str:
        r''' Invalid search: {$reason} '''
        return self._translate(31, 11, {"reason": reason})


    def search_invalid_whole_number(self, context: str, provided: str) -> str:
        r''' expected a whole number in "`{$context}`", but found "`{$provided}`". '''
        return self._translate(31, 12, {"context": context, "provided": provided})


    def search_misplaced_and(self, ) -> str:
        r''' an `and` was found but it is not connecting two search terms. If you want to search for the word itself, wrap it in double quotes: `"and"`. '''
        return self._translate(31, 13, {})


    def search_misplaced_or(self, ) -> str:
        r''' an `or` was found but it is not connecting two search terms. If you want to search for the word itself, wrap it in double quotes: `"or"`. '''
        return self._translate(31, 14, {})


    def search_missing_key(self, ) -> str:
        r''' a colon `:` was found, but there was no keyword preceding it. If you want to search for a literal `:`, prepend a backslash: `\:`. '''
        return self._translate(31, 15, {})


    def search_note_modified(self, ) -> str:
        r''' Note Modified '''
        return self._translate(31, 16, {})


    def search_unclosed_group(self, ) -> str:
        r''' an opening bracket `(` was found, but there was no closing bracket `)` following it. If you want to search for a literal `(`, wrap it in double quotes or prepend a backslash: `"("` or `\(` . '''
        return self._translate(31, 17, {})


    def search_unclosed_quote(self, ) -> str:
        r''' an opening double quote `"` was found, but there was no second one to close it. If you want to search for a literal `"`, prepend a backslash: `\"`. '''
        return self._translate(31, 18, {})


    def search_unknown_escape(self, val: FluentVariable) -> str:
        r''' the escape sequence `{$val}` is not defined. If you want to search for a literal backslash `\`, prepend another one: `\\`. '''
        return self._translate(31, 19, {"val": val})


    def search_unopened_group(self, ) -> str:
        r''' a closing bracket `)` was found, but there was no opening bracket `(` preceding it. If you want to search for a literal `)`, wrap it in double quotes or prepend a backslash: `")"` or `\)`. '''
        return self._translate(31, 20, {})


    def search_view_in_browser(self, ) -> str:
        r''' View in browser '''
        return self._translate(31, 21, {})


    def statistics_added_subtitle(self, ) -> str:
        r''' The number of new cards you have added. '''
        return self._translate(32, 0, {})


    def statistics_added_title(self, ) -> str:
        r''' Added '''
        return self._translate(32, 1, {})


    def statistics_amount_of_total_with_percentage(self, amount: int, total: int, percent: FluentVariable) -> str:
        r''' {$amount} of {$total} ({$percent}%) '''
        return self._translate(32, 2, {"amount": amount, "total": total, "percent": percent})


    def statistics_answer_buttons_button_number(self, ) -> str:
        r''' Button '''
        return self._translate(32, 3, {})


    def statistics_answer_buttons_button_pressed(self, ) -> str:
        r''' Times pressed '''
        return self._translate(32, 4, {})


    def statistics_answer_buttons_subtitle(self, ) -> str:
        r''' The number of times you have pressed each button. '''
        return self._translate(32, 5, {})


    def statistics_answer_buttons_title(self, ) -> str:
        r''' Answer Buttons '''
        return self._translate(32, 6, {})


    def statistics_average(self, ) -> str:
        r''' Average '''
        return self._translate(32, 7, {})


    def statistics_average_answer_time(self, average_seconds: float, cards_per_minute: float) -> str:
        r''' {$average-seconds}s () '''
        return self._translate(32, 8, {"average-seconds": average_seconds, "cards-per-minute": cards_per_minute})


    def statistics_average_answer_time_label(self, ) -> str:
        r''' Average answer time '''
        return self._translate(32, 9, {})


    def statistics_average_difficulty(self, ) -> str:
        r''' Average difficulty '''
        return self._translate(32, 10, {})


    def statistics_average_ease(self, ) -> str:
        r''' Average ease '''
        return self._translate(32, 11, {})


    def statistics_average_for_days_studied(self, ) -> str:
        r''' Average for days studied '''
        return self._translate(32, 12, {})


    def statistics_average_interval(self, ) -> str:
        r''' Average interval '''
        return self._translate(32, 13, {})


    def statistics_average_over_period(self, ) -> str:
        r''' Average over period '''
        return self._translate(32, 14, {})


    def statistics_average_retrievability(self, ) -> str:
        r''' Average retrievability '''
        return self._translate(32, 15, {})


    def statistics_average_stability(self, ) -> str:
        r''' Average stability '''
        return self._translate(32, 16, {})


    def statistics_backlog_checkbox(self, ) -> str:
        r''' Backlog '''
        return self._translate(32, 17, {})


    def statistics_calendar_title(self, ) -> str:
        r''' Calendar '''
        return self._translate(32, 18, {})


    def statistics_card_difficulty_subtitle2(self, ) -> str:
        r''' The higher the difficulty, the slower stability will increase. '''
        return self._translate(32, 19, {})


    def statistics_card_difficulty_title(self, ) -> str:
        r''' Card Difficulty '''
        return self._translate(32, 20, {})


    def statistics_card_difficulty_tooltip(self, cards: int, percent: FluentVariable) -> str:
        r''' {$cards} cards with {$percent} difficulty '''
        return self._translate(32, 21, {"cards": cards, "percent": percent})


    def statistics_card_ease_subtitle(self, ) -> str:
        r''' The lower the ease, the more frequently a card will appear. '''
        return self._translate(32, 22, {})


    def statistics_card_ease_title(self, ) -> str:
        r''' Card Ease '''
        return self._translate(32, 23, {})


    def statistics_card_ease_tooltip(self, cards: int, percent: FluentVariable) -> str:
        r''' {$cards} cards with {$percent} ease '''
        return self._translate(32, 24, {"cards": cards, "percent": percent})


    def statistics_card_retrievability_title(self, ) -> str:
        r''' Card Retrievability '''
        return self._translate(32, 25, {})


    def statistics_card_stability_subtitle(self, ) -> str:
        r''' The delay at which retrievability falls to 90%. '''
        return self._translate(32, 26, {})


    def statistics_card_stability_title(self, ) -> str:
        r''' Card Stability '''
        return self._translate(32, 27, {})


    def statistics_cards(self, cards: int) -> str:
        r''' {$cards} cards '''
        return self._translate(32, 28, {"cards": cards})


    def statistics_cards_due(self, cards: int) -> str:
        r''' {$cards} cards due '''
        return self._translate(32, 29, {"cards": cards})


    def statistics_cards_per_day(self, count: int) -> str:
        r''' {$count} cards/day '''
        return self._translate(32, 30, {"count": count})


    def statistics_cards_per_min(self, cards_per_minute: float) -> str:
        r''' {$cards-per-minute} cards/minute '''
        return self._translate(32, 31, {"cards-per-minute": cards_per_minute})


    def statistics_counts_buried_cards(self, ) -> str:
        r''' Buried '''
        return self._translate(32, 32, {})


    def statistics_counts_filtered_cards(self, ) -> str:
        r''' Filtered '''
        return self._translate(32, 33, {})


    def statistics_counts_learning_cards(self, ) -> str:
        r''' Learning '''
        return self._translate(32, 34, {})


    def statistics_counts_mature_cards(self, ) -> str:
        r''' Mature '''
        return self._translate(32, 35, {})


    def statistics_counts_new_cards(self, ) -> str:
        r''' New '''
        return self._translate(32, 36, {})


    def statistics_counts_relearning_cards(self, ) -> str:
        r''' Relearning '''
        return self._translate(32, 37, {})


    def statistics_counts_separate_suspended_buried_cards(self, ) -> str:
        r''' Separate suspended/buried cards '''
        return self._translate(32, 38, {})


    def statistics_counts_suspended_cards(self, ) -> str:
        r''' Suspended '''
        return self._translate(32, 39, {})


    def statistics_counts_title(self, ) -> str:
        r''' Card Counts '''
        return self._translate(32, 40, {})


    def statistics_counts_total_cards(self, ) -> str:
        r''' Total '''
        return self._translate(32, 41, {})


    def statistics_counts_young_cards(self, ) -> str:
        r''' Young '''
        return self._translate(32, 42, {})


    def statistics_daily_load(self, ) -> str:
        r''' Daily load '''
        return self._translate(32, 43, {})


    def statistics_days_ago_range(self, days_start: int, days_end: int) -> str:
        r''' {$daysStart}-{$daysEnd} days ago '''
        return self._translate(32, 44, {"daysStart": days_start, "daysEnd": days_end})


    def statistics_days_ago_single(self, days: int) -> str:
        r''' {$days} days ago '''
        return self._translate(32, 45, {"days": days})


    def statistics_days_studied(self, ) -> str:
        r''' Days studied '''
        return self._translate(32, 46, {})


    def statistics_due_count(self, ) -> str:
        r''' Due '''
        return self._translate(32, 47, {})


    def statistics_due_date(self, ) -> str:
        r''' Due '''
        return self._translate(32, 48, {})


    def statistics_due_for_new_card(self, number: FluentVariable) -> str:
        r''' New #{$number} '''
        return self._translate(32, 49, {"number": number})


    def statistics_due_tomorrow(self, ) -> str:
        r''' Due tomorrow '''
        return self._translate(32, 50, {})


    def statistics_elapsed_time_days(self, amount: int) -> str:
        r''' {$amount}d '''
        return self._translate(32, 51, {"amount": amount})


    def statistics_elapsed_time_hours(self, amount: int) -> str:
        r''' {$amount}h '''
        return self._translate(32, 52, {"amount": amount})


    def statistics_elapsed_time_minutes(self, amount: int) -> str:
        r''' {$amount}m '''
        return self._translate(32, 53, {"amount": amount})


    def statistics_elapsed_time_months(self, amount: int) -> str:
        r''' {$amount}mo '''
        return self._translate(32, 54, {"amount": amount})


    def statistics_elapsed_time_seconds(self, amount: int) -> str:
        r''' {$amount}s '''
        return self._translate(32, 55, {"amount": amount})


    def statistics_elapsed_time_years(self, amount: int) -> str:
        r''' {$amount}y '''
        return self._translate(32, 56, {"amount": amount})


    def statistics_estimated_total_knowledge(self, ) -> str:
        r''' Estimated total knowledge '''
        return self._translate(32, 57, {})


    def statistics_future_due_subtitle(self, ) -> str:
        r''' The number of reviews due in the future. '''
        return self._translate(32, 58, {})


    def statistics_future_due_title(self, ) -> str:
        r''' Future Due '''
        return self._translate(32, 59, {})


    def statistics_hours_correct(self, correct: int, total: int, percent: FluentVariable) -> str:
        r''' {$correct}/{$total} correct ({$percent}%) '''
        return self._translate(32, 60, {"correct": correct, "total": total, "percent": percent})


    def statistics_hours_correct_info(self, ) -> str:
        r''' → (not 'Again') '''
        return self._translate(32, 61, {})


    def statistics_hours_correct_reviews(self, percent: FluentVariable, reviews: int) -> str:
        r''' 📈 {$percent}% correct ({$reviews}) '''
        return self._translate(32, 62, {"percent": percent, "reviews": reviews})


    def statistics_hours_range(self, hour_start: int, hour_end: int) -> str:
        r''' From {$hourStart}:00~{$hourEnd}:00 '''
        return self._translate(32, 63, {"hourStart": hour_start, "hourEnd": hour_end})


    def statistics_hours_reviews(self, reviews: int) -> str:
        r''' 📊 {$reviews} reviews '''
        return self._translate(32, 64, {"reviews": reviews})


    def statistics_hours_subtitle(self, ) -> str:
        r''' Review success rate for each hour of the day. '''
        return self._translate(32, 65, {})


    def statistics_hours_title(self, ) -> str:
        r''' Hourly Breakdown '''
        return self._translate(32, 66, {})


    def statistics_in_days_range(self, days_start: int, days_end: int) -> str:
        r''' In {$daysStart}-{$daysEnd} days '''
        return self._translate(32, 67, {"daysStart": days_start, "daysEnd": days_end})


    def statistics_in_days_single(self, days: int) -> str:
        r''' In {$days} days '''
        return self._translate(32, 68, {"days": days})


    def statistics_in_time_span_days(self, amount: int) -> str:
        r''' in {$amount} days '''
        return self._translate(32, 69, {"amount": amount})


    def statistics_in_time_span_hours(self, amount: int) -> str:
        r''' in {$amount} hours '''
        return self._translate(32, 70, {"amount": amount})


    def statistics_in_time_span_minutes(self, amount: int) -> str:
        r''' in {$amount} minutes '''
        return self._translate(32, 71, {"amount": amount})


    def statistics_in_time_span_months(self, amount: int) -> str:
        r''' in {$amount} months '''
        return self._translate(32, 72, {"amount": amount})


    def statistics_in_time_span_seconds(self, amount: int) -> str:
        r''' in {$amount} seconds '''
        return self._translate(32, 73, {"amount": amount})


    def statistics_in_time_span_years(self, amount: int) -> str:
        r''' in {$amount} years '''
        return self._translate(32, 74, {"amount": amount})


    def statistics_intervals_day_range(self, cards: int, days_start: int, days_end: int) -> str:
        r''' {$cards} cards with a {$daysStart}~{$daysEnd} day interval '''
        return self._translate(32, 75, {"cards": cards, "daysStart": days_start, "daysEnd": days_end})


    def statistics_intervals_day_single(self, cards: int, day: FluentVariable) -> str:
        r''' {$cards} cards with a {$day} day interval '''
        return self._translate(32, 76, {"cards": cards, "day": day})


    def statistics_intervals_subtitle(self, ) -> str:
        r''' Delays until review cards are shown again. '''
        return self._translate(32, 77, {})


    def statistics_intervals_title(self, ) -> str:
        r''' Review Intervals '''
        return self._translate(32, 78, {})


    def statistics_median_difficulty(self, ) -> str:
        r''' Median difficulty '''
        return self._translate(32, 79, {})


    def statistics_median_ease(self, ) -> str:
        r''' Median ease '''
        return self._translate(32, 80, {})


    def statistics_median_interval(self, ) -> str:
        r''' Median interval '''
        return self._translate(32, 81, {})


    def statistics_median_stability(self, ) -> str:
        r''' Median stability '''
        return self._translate(32, 82, {})


    def statistics_memorized(self, memorized: str) -> str:
        r''' {$memorized} cards memorized '''
        return self._translate(32, 83, {"memorized": memorized})


    def statistics_minutes_per_day(self, count: int) -> str:
        r''' {$count} minutes/day '''
        return self._translate(32, 84, {"count": count})


    def statistics_no_data(self, ) -> str:
        r''' NO DATA '''
        return self._translate(32, 85, {})


    def statistics_notes(self, notes: int) -> str:
        r''' {$notes} notes '''
        return self._translate(32, 86, {"notes": notes})


    def statistics_range_1_year_history(self, ) -> str:
        r''' last 12 months '''
        return self._translate(32, 87, {})


    def statistics_range_all_history(self, ) -> str:
        r''' all history '''
        return self._translate(32, 88, {})


    def statistics_range_all_time(self, ) -> str:
        r''' all '''
        return self._translate(32, 89, {})


    def statistics_range_collection(self, ) -> str:
        r''' collection '''
        return self._translate(32, 90, {})


    def statistics_range_deck(self, ) -> str:
        r''' deck '''
        return self._translate(32, 91, {})


    def statistics_range_search(self, ) -> str:
        r''' Search '''
        return self._translate(32, 92, {})


    def statistics_retrievability_subtitle(self, ) -> str:
        r''' The probability of recalling a card today. '''
        return self._translate(32, 93, {})


    def statistics_retrievability_tooltip(self, cards: int, percent: FluentVariable) -> str:
        r''' {$cards} cards with {$percent} retrievability '''
        return self._translate(32, 94, {"cards": cards, "percent": percent})


    def statistics_reviews(self, reviews: int) -> str:
        r''' {$reviews} reviews '''
        return self._translate(32, 95, {"reviews": reviews})


    def statistics_reviews_count_subtitle(self, ) -> str:
        r''' The number of questions you have answered. '''
        return self._translate(32, 96, {})


    def statistics_reviews_per_day(self, count: int) -> str:
        r''' {$count} reviews/day '''
        return self._translate(32, 97, {"count": count})


    def statistics_reviews_time_checkbox(self, ) -> str:
        r''' Time '''
        return self._translate(32, 98, {})


    def statistics_reviews_time_subtitle(self, ) -> str:
        r''' The time taken to answer the questions. '''
        return self._translate(32, 99, {})


    def statistics_reviews_title(self, ) -> str:
        r''' Reviews '''
        return self._translate(32, 100, {})


    def statistics_running_total(self, ) -> str:
        r''' Running total '''
        return self._translate(32, 101, {})


    def statistics_save_pdf(self, ) -> str:
        r''' Save PDF '''
        return self._translate(32, 102, {})


    def statistics_saved(self, ) -> str:
        r''' Saved. '''
        return self._translate(32, 103, {})


    def statistics_stability_day_range(self, cards: int, days_start: int, days_end: int) -> str:
        r''' {$cards} cards with a {$daysStart}~{$daysEnd} day stability '''
        return self._translate(32, 104, {"cards": cards, "daysStart": days_start, "daysEnd": days_end})


    def statistics_stability_day_single(self, cards: int, day: FluentVariable) -> str:
        r''' {$cards} cards with a {$day} day stability '''
        return self._translate(32, 105, {"cards": cards, "day": day})


    def statistics_stats(self, ) -> str:
        r''' stats '''
        return self._translate(32, 106, {})


    def statistics_studied_today(self, unit: str, secs_per_card: int, amount: int, cards: int) -> str:
        r''' Studied 
 today
({$secs-per-card}s/card) '''
        return self._translate(32, 107, {"unit": unit, "secs-per-card": secs_per_card, "amount": amount, "cards": cards})


    def statistics_title(self, ) -> str:
        r''' Statistics '''
        return self._translate(32, 108, {})


    def statistics_today_again_count(self, ) -> str:
        r''' Again count: '''
        return self._translate(32, 109, {})


    def statistics_today_correct_mature(self, correct: int, total: int, percent: FluentVariable) -> str:
        r''' Correct answers on mature cards: {$correct}/{$total} ({$percent}%) '''
        return self._translate(32, 110, {"correct": correct, "total": total, "percent": percent})


    def statistics_today_no_cards(self, ) -> str:
        r''' No cards have been studied today. '''
        return self._translate(32, 111, {})


    def statistics_today_no_mature_cards(self, ) -> str:
        r''' No mature cards were studied today. '''
        return self._translate(32, 112, {})


    def statistics_today_title(self, ) -> str:
        r''' Today '''
        return self._translate(32, 113, {})


    def statistics_today_type_counts(self, learn_count: int, review_count: int, relearn_count: int, filtered_count: int) -> str:
        r''' Learn: {$learnCount}, Review: {$reviewCount}, Relearn: {$relearnCount}, Filtered: {$filteredCount} '''
        return self._translate(32, 114, {"learnCount": learn_count, "reviewCount": review_count, "relearnCount": relearn_count, "filteredCount": filtered_count})


    def statistics_total(self, ) -> str:
        r''' Total '''
        return self._translate(32, 115, {})


    def statistics_true_retention_all(self, ) -> str:
        r''' All '''
        return self._translate(32, 116, {})


    def statistics_true_retention_all_time(self, ) -> str:
        r''' All time '''
        return self._translate(32, 117, {})


    def statistics_true_retention_count(self, ) -> str:
        r''' Count '''
        return self._translate(32, 118, {})


    def statistics_true_retention_fail(self, ) -> str:
        r''' Fail '''
        return self._translate(32, 119, {})


    def statistics_true_retention_mature(self, ) -> str:
        r''' Mature '''
        return self._translate(32, 120, {})


    def statistics_true_retention_month(self, ) -> str:
        r''' Last month '''
        return self._translate(32, 121, {})


    def statistics_true_retention_not_applicable(self, ) -> str:
        r''' N/A '''
        return self._translate(32, 122, {})


    def statistics_true_retention_pass(self, ) -> str:
        r''' Pass '''
        return self._translate(32, 123, {})


    def statistics_true_retention_range(self, ) -> str:
        r''' Range '''
        return self._translate(32, 124, {})


    def statistics_true_retention_retention(self, ) -> str:
        r''' Retention '''
        return self._translate(32, 125, {})


    def statistics_true_retention_subtitle(self, ) -> str:
        r''' Pass rate of cards with an interval ≥ 1 day. '''
        return self._translate(32, 126, {})


    def statistics_true_retention_title(self, ) -> str:
        r''' Retention '''
        return self._translate(32, 127, {})


    def statistics_true_retention_today(self, ) -> str:
        r''' Today '''
        return self._translate(32, 128, {})


    def statistics_true_retention_tooltip(self, ) -> str:
        r''' If you are using FSRS, your retention is expected to be close to your desired retention. Please keep in mind that data for a single day is noisy, so it's better to look at monthly data. '''
        return self._translate(32, 129, {})


    def statistics_true_retention_total(self, ) -> str:
        r''' Total '''
        return self._translate(32, 130, {})


    def statistics_true_retention_week(self, ) -> str:
        r''' Last week '''
        return self._translate(32, 131, {})


    def statistics_true_retention_year(self, ) -> str:
        r''' Last year '''
        return self._translate(32, 132, {})


    def statistics_true_retention_yesterday(self, ) -> str:
        r''' Yesterday '''
        return self._translate(32, 133, {})


    def statistics_true_retention_young(self, ) -> str:
        r''' Young '''
        return self._translate(32, 134, {})


    def studying_again(self, ) -> str:
        r''' Again '''
        return self._translate(33, 0, {})


    def studying_all_buried_cards(self, ) -> str:
        r''' All Buried Cards '''
        return self._translate(33, 1, {})


    def studying_answer_time_elapsed(self, ) -> str:
        r''' Answer time elapsed '''
        return self._translate(33, 2, {})


    def studying_audio_5s(self, ) -> str:
        r''' Audio -5s '''
        return self._translate(33, 3, {})


    def studying_audio_and5s(self, ) -> str:
        r''' Audio +5s '''
        return self._translate(33, 4, {})


    def studying_buried_siblings(self, ) -> str:
        r''' Buried Siblings '''
        return self._translate(33, 5, {})


    def studying_bury(self, ) -> str:
        r''' Bury '''
        return self._translate(33, 6, {})


    def studying_bury_card(self, ) -> str:
        r''' Bury Card '''
        return self._translate(33, 7, {})


    def studying_bury_note(self, ) -> str:
        r''' Bury Note '''
        return self._translate(33, 8, {})


    def studying_card_studied_in(self, count: int) -> str:
        r''' {$count} cards studied in '''
        return self._translate(33, 9, {"count": count})


    def studying_card_suspended(self, ) -> str:
        r''' Card suspended. '''
        return self._translate(33, 10, {})


    def studying_card_was_a_leech(self, ) -> str:
        r''' Card was a leech. '''
        return self._translate(33, 11, {})


    def studying_cards_buried(self, count: int) -> str:
        r''' {$count} cards buried. '''
        return self._translate(33, 12, {"count": count})


    def studying_cards_will_be_automatically_returned_to(self, ) -> str:
        r''' Cards will be automatically returned to their original decks after you review them. '''
        return self._translate(33, 13, {})


    def studying_continue(self, ) -> str:
        r''' Continue '''
        return self._translate(33, 14, {})


    def studying_counts_differ(self, ) -> str:
        r''' Counts differ from the deck list, because burying is enabled. Some cards have been excluded, and others may have taken their place. '''
        return self._translate(33, 15, {})


    def studying_delete_note(self, ) -> str:
        r''' Delete Note '''
        return self._translate(33, 16, {})


    def studying_deleting_this_deck_from_the_deck(self, ) -> str:
        r''' Deleting this deck from the deck list will return all remaining cards to their original deck. '''
        return self._translate(33, 17, {})


    def studying_easy(self, ) -> str:
        r''' Easy '''
        return self._translate(33, 18, {})


    def studying_edit(self, ) -> str:
        r''' Edit '''
        return self._translate(33, 19, {})


    def studying_empty(self, ) -> str:
        r''' Empty '''
        return self._translate(33, 20, {})


    def studying_finish(self, ) -> str:
        r''' Finish '''
        return self._translate(33, 21, {})


    def studying_flag_card(self, ) -> str:
        r''' Flag Card '''
        return self._translate(33, 22, {})


    def studying_good(self, ) -> str:
        r''' Good '''
        return self._translate(33, 23, {})


    def studying_hard(self, ) -> str:
        r''' Hard '''
        return self._translate(33, 24, {})


    def studying_it_has_been_suspended(self, ) -> str:
        r''' It has been suspended. '''
        return self._translate(33, 25, {})


    def studying_manually_buried_cards(self, ) -> str:
        r''' Manually Buried Cards '''
        return self._translate(33, 26, {})


    def studying_mark_note(self, ) -> str:
        r''' Mark Note '''
        return self._translate(33, 27, {})


    def studying_minute(self, count: int) -> str:
        r''' {$count} minutes. '''
        return self._translate(33, 28, {"count": count})


    def studying_more(self, ) -> str:
        r''' More '''
        return self._translate(33, 29, {})


    def studying_no_cards_are_due_yet(self, ) -> str:
        r''' No cards are due yet. '''
        return self._translate(33, 30, {})


    def studying_note_suspended(self, ) -> str:
        r''' Note suspended. '''
        return self._translate(33, 31, {})


    def studying_pause_audio(self, ) -> str:
        r''' Pause Audio '''
        return self._translate(33, 32, {})


    def studying_please_run_toolsempty_cards(self, ) -> str:
        r''' Please run Tools>Empty Cards '''
        return self._translate(33, 33, {})


    def studying_question_time_elapsed(self, ) -> str:
        r''' Question time elapsed '''
        return self._translate(33, 34, {})


    def studying_record_own_voice(self, ) -> str:
        r''' Record Own Voice '''
        return self._translate(33, 35, {})


    def studying_replay_own_voice(self, ) -> str:
        r''' Replay Own Voice '''
        return self._translate(33, 36, {})


    def studying_show_answer(self, ) -> str:
        r''' Show Answer '''
        return self._translate(33, 37, {})


    def studying_space(self, ) -> str:
        r''' Space '''
        return self._translate(33, 38, {})


    def studying_study_now(self, ) -> str:
        r''' Study Now '''
        return self._translate(33, 39, {})


    def studying_suspend(self, ) -> str:
        r''' Suspend '''
        return self._translate(33, 40, {})


    def studying_suspend_note(self, ) -> str:
        r''' Suspend Note '''
        return self._translate(33, 41, {})


    def studying_this_is_a_special_deck_for(self, ) -> str:
        r''' This is a special deck for studying outside of the normal schedule. '''
        return self._translate(33, 42, {})


    def studying_to_review(self, ) -> str:
        r''' To Review '''
        return self._translate(33, 43, {})


    def studying_type_answer_unknown_field(self, val: FluentVariable) -> str:
        r''' Type answer: unknown field {$val} '''
        return self._translate(33, 44, {"val": val})


    def studying_unbury(self, ) -> str:
        r''' Unbury '''
        return self._translate(33, 45, {})


    def studying_what_would_you_like_to_unbury(self, ) -> str:
        r''' What would you like to unbury? '''
        return self._translate(33, 46, {})


    def studying_you_havent_recorded_your_voice_yet(self, ) -> str:
        r''' You haven't recorded your voice yet. '''
        return self._translate(33, 47, {})


    def sync_abort_button(self, ) -> str:
        r''' Abort '''
        return self._translate(34, 0, {})


    def sync_account_required(self, link: str) -> str:
        r''' <h1>Account Required</h1>
A free account is required to keep your collection synchronized. Please <a href="{$link}">sign up</a> for an account, then enter your details below. '''
        return self._translate(34, 1, {"link": link})


    def sync_added_updated_count(self, up: FluentVariable, down: FluentVariable) -> str:
        r''' Added/modified: {$up}↑ {$down}↓ '''
        return self._translate(34, 2, {"up": up, "down": down})


    def sync_ankihub_addon_installation(self, ) -> str:
        r''' AnkiHub Add-on Installation '''
        return self._translate(34, 3, {})


    def sync_ankihub_dialog_heading(self, ) -> str:
        r''' AnkiHub Login '''
        return self._translate(34, 4, {})


    def sync_ankihub_login_failed(self, ) -> str:
        r''' Unable to log in to AnkiHub with the provided credentials. '''
        return self._translate(34, 5, {})


    def sync_ankihub_username_label(self, ) -> str:
        r''' Username or Email: '''
        return self._translate(34, 6, {})


    def sync_ankiweb_id_label(self, ) -> str:
        r''' Email: '''
        return self._translate(34, 7, {})


    def sync_cancel_button(self, ) -> str:
        r''' Cancel '''
        return self._translate(34, 8, {})


    def sync_checking(self, ) -> str:
        r''' Checking... '''
        return self._translate(34, 9, {})


    def sync_client_too_old(self, ) -> str:
        r''' Your Anki version is too old. Please update to the latest version to continue syncing. '''
        return self._translate(34, 10, {})


    def sync_clock_off(self, ) -> str:
        r''' Unable to sync - your clock is not set to the correct time. '''
        return self._translate(34, 11, {})


    def sync_collection_complete(self, ) -> str:
        r''' Collection sync complete. '''
        return self._translate(34, 12, {})


    def sync_confirm_empty_download(self, ) -> str:
        r''' Local collection has no cards. Download from AnkiWeb? '''
        return self._translate(34, 13, {})


    def sync_confirm_empty_upload(self, ) -> str:
        r''' AnkiWeb collection has no cards. Replace it with local collection? '''
        return self._translate(34, 14, {})


    def sync_conflict(self, ) -> str:
        r''' Only one copy of Anki can sync to your account at once. Please wait a few minutes, then try again. '''
        return self._translate(34, 15, {})


    def sync_conflict_explanation(self, ) -> str:
        r''' Your decks here and on AnkiWeb differ in such a way that they can't be merged together, so it's necessary to overwrite the decks on one side with the decks from the other.

If you choose download, Anki will fetch the collection from AnkiWeb, and any changes you have made on this device since the last sync will be lost.

If you choose upload, Anki will send this device's data to AnkiWeb, and any changes that are waiting on AnkiWeb will be lost.

After all devices are in sync, future reviews and added cards can be merged automatically. '''
        return self._translate(34, 16, {})


    def sync_conflict_explanation2(self, ) -> str:
        r''' There is a conflict between decks on this device and AnkiWeb. You must choose which version to keep:

- Select **** to replace decks here with AnkiWeb’s version. You will lose any changes you made on this device since your last sync.
- Select **** to overwrite AnkiWeb’s versions with decks from this device, and delete any changes on AnkiWeb.

Once the conflict is resolved, syncing will work as usual. '''
        return self._translate(34, 17, {})


    def sync_connecting(self, ) -> str:
        r''' Connecting... '''
        return self._translate(34, 18, {})


    def sync_download_from_ankiweb(self, ) -> str:
        r''' Download from AnkiWeb '''
        return self._translate(34, 19, {})


    def sync_downloading_from_ankiweb(self, ) -> str:
        r''' Downloading from AnkiWeb... '''
        return self._translate(34, 20, {})


    def sync_log_in_button(self, ) -> str:
        r''' Log In '''
        return self._translate(34, 21, {})


    def sync_log_out_button(self, ) -> str:
        r''' Log Out '''
        return self._translate(34, 22, {})


    def sync_media_aborted(self, ) -> str:
        r''' Media sync aborted. '''
        return self._translate(34, 23, {})


    def sync_media_aborting(self, ) -> str:
        r''' Media sync aborting... '''
        return self._translate(34, 24, {})


    def sync_media_added_count(self, up: FluentVariable, down: FluentVariable) -> str:
        r''' Added: {$up}↑ {$down}↓ '''
        return self._translate(34, 25, {"up": up, "down": down})


    def sync_media_checked_count(self, count: int) -> str:
        r''' Checked: {$count} '''
        return self._translate(34, 26, {"count": count})


    def sync_media_complete(self, ) -> str:
        r''' Media sync complete. '''
        return self._translate(34, 27, {})


    def sync_media_disabled(self, ) -> str:
        r''' Media sync disabled. '''
        return self._translate(34, 28, {})


    def sync_media_failed(self, ) -> str:
        r''' Media sync failed. '''
        return self._translate(34, 29, {})


    def sync_media_log_button(self, ) -> str:
        r''' Media Log '''
        return self._translate(34, 30, {})


    def sync_media_log_title(self, ) -> str:
        r''' Media Sync Log '''
        return self._translate(34, 31, {})


    def sync_media_removed_count(self, up: FluentVariable, down: FluentVariable) -> str:
        r''' Removed: {$up}↑ {$down}↓ '''
        return self._translate(34, 32, {"up": up, "down": down})


    def sync_media_starting(self, ) -> str:
        r''' Media sync starting... '''
        return self._translate(34, 33, {})


    def sync_must_wait_for_end(self, ) -> str:
        r''' Anki is currently syncing. Please wait for the sync to complete, then try again. '''
        return self._translate(34, 34, {})


    def sync_password_label(self, ) -> str:
        r''' Password: '''
        return self._translate(34, 35, {})


    def sync_resync_required(self, ) -> str:
        r''' Please sync again. If this message keeps appearing, please post on the support site. '''
        return self._translate(34, 36, {})


    def sync_sanity_check_failed(self, ) -> str:
        r''' Please use the Check Database function, then sync again. If problems persist, please force a one-way sync in the preferences screen. '''
        return self._translate(34, 37, {})


    def sync_server_error(self, ) -> str:
        r''' AnkiWeb encountered a problem. Please try again in a few minutes. '''
        return self._translate(34, 38, {})


    def sync_sign_in(self, ) -> str:
        r''' Sign in '''
        return self._translate(34, 39, {})


    def sync_syncing(self, ) -> str:
        r''' Syncing... '''
        return self._translate(34, 40, {})


    def sync_upload_to_ankiweb(self, ) -> str:
        r''' Upload to AnkiWeb '''
        return self._translate(34, 41, {})


    def sync_upload_too_large(self, details: str) -> str:
        r''' Your collection file is too large to send to AnkiWeb. You can reduce its size by removing any unwanted decks (optionally exporting them first), and then using Check Database to shrink the file size down.

{$details} (uncompressed) '''
        return self._translate(34, 42, {"details": details})


    def sync_uploading_to_ankiweb(self, ) -> str:
        r''' Uploading to AnkiWeb... '''
        return self._translate(34, 43, {})


    def sync_wrong_pass(self, ) -> str:
        r''' Email or password was incorrect; please try again. '''
        return self._translate(34, 44, {})


    def undo_action_redone(self, action: str) -> str:
        r''' {$action} redone '''
        return self._translate(35, 0, {"action": action})


    def undo_action_undone(self, action: str) -> str:
        r''' {$action} undone '''
        return self._translate(35, 1, {"action": action})


    def undo_redo(self, ) -> str:
        r''' Redo '''
        return self._translate(35, 2, {})


    def undo_redo_action(self, action: str) -> str:
        r''' Redo {$action} '''
        return self._translate(35, 3, {"action": action})


    def undo_undo(self, ) -> str:
        r''' Undo '''
        return self._translate(35, 4, {})


    def undo_undo_action(self, val: FluentVariable) -> str:
        r''' Undo {$val} '''
        return self._translate(35, 5, {"val": val})

class LegacyTranslationEnum:
    ABOUT_A_BIG_THANKS_TO_ALL_THE = (0, 0)
    ABOUT_ABOUT_ANKI = (0, 1)
    ABOUT_AND_OTHERS = (0, 2)
    ABOUT_ANKI_IS_A_FRIENDLY_INTELLIGENT_SPACED = (0, 3)
    ABOUT_ANKI_IS_LICENSED_UNDER_THE_AGPL3 = (0, 4)
    ABOUT_COPIED_TO_CLIPBOARD = (0, 5)
    ABOUT_COPY_DEBUG_INFO = (0, 6)
    ABOUT_IF_YOU_HAVE_CONTRIBUTED_AND_ARE = (0, 7)
    ABOUT_VERSION = (0, 8)
    ABOUT_VISIT_WEBSITE = (0, 9)
    ABOUT_WRITTEN_BY_DAMIEN_ELMES_WITH_PATCHES = (0, 10)
    ACTIONS_ADD = (1, 0)
    ACTIONS_ADD_DECK = (1, 1)
    ACTIONS_ADD_NOTE = (1, 2)
    ACTIONS_ADD_NOTETYPE = (1, 3)
    ACTIONS_ALL_SELECTED = (1, 4)
    ACTIONS_ANSWER_CARD = (1, 5)
    ACTIONS_ANY_SELECTED = (1, 6)
    ACTIONS_AUTO_ADVANCE = (1, 7)
    ACTIONS_AUTO_ADVANCE_ACTIVATED = (1, 8)
    ACTIONS_AUTO_ADVANCE_DEACTIVATED = (1, 9)
    ACTIONS_BUILD_FILTERED_DECK = (1, 10)
    ACTIONS_CANCEL = (1, 11)
    ACTIONS_CARD_INFO = (1, 12)
    ACTIONS_CHOOSE = (1, 13)
    ACTIONS_CLOSE = (1, 14)
    ACTIONS_COPY = (1, 15)
    ACTIONS_CREATE_COPY = (1, 16)
    ACTIONS_CUSTOM_STUDY = (1, 17)
    ACTIONS_DECKS = (1, 18)
    ACTIONS_DECREMENT_VALUE = (1, 19)
    ACTIONS_DELETE = (1, 20)
    ACTIONS_DISCARD = (1, 21)
    ACTIONS_EMPTY_CARDS = (1, 22)
    ACTIONS_EXPORT = (1, 23)
    ACTIONS_FILTER = (1, 24)
    ACTIONS_FLAG_BLUE = (1, 25)
    ACTIONS_FLAG_GREEN = (1, 26)
    ACTIONS_FLAG_NUMBER = (1, 27)
    ACTIONS_FLAG_ORANGE = (1, 28)
    ACTIONS_FLAG_PINK = (1, 29)
    ACTIONS_FLAG_PURPLE = (1, 30)
    ACTIONS_FLAG_RED = (1, 31)
    ACTIONS_FLAG_TURQUOISE = (1, 32)
    ACTIONS_FORGET_CARD = (1, 33)
    ACTIONS_FULLSCREEN_UNSUPPORTED = (1, 34)
    ACTIONS_GRADE_NOW = (1, 35)
    ACTIONS_HELP = (1, 36)
    ACTIONS_IMPORT = (1, 37)
    ACTIONS_INCREMENT_VALUE = (1, 38)
    ACTIONS_MANAGE = (1, 39)
    ACTIONS_NAME = (1, 40)
    ACTIONS_NEW = (1, 41)
    ACTIONS_NEW_NAME = (1, 42)
    ACTIONS_NOTHING_TO_REDO = (1, 43)
    ACTIONS_NOTHING_TO_UNDO = (1, 44)
    ACTIONS_OPTIONS = (1, 45)
    ACTIONS_OPTIONS_FOR = (1, 46)
    ACTIONS_PREVIEW = (1, 47)
    ACTIONS_PREVIOUS_CARD_INFO = (1, 48)
    ACTIONS_PROCESSING = (1, 49)
    ACTIONS_REBUILD = (1, 50)
    ACTIONS_REMOVE_NOTETYPE = (1, 51)
    ACTIONS_REMOVE_TAG = (1, 52)
    ACTIONS_RENAME = (1, 53)
    ACTIONS_RENAME_DECK = (1, 54)
    ACTIONS_RENAME_TAG = (1, 55)
    ACTIONS_RENAME_WITH_PARENTS = (1, 56)
    ACTIONS_REPLAY_AUDIO = (1, 57)
    ACTIONS_REPOSITION = (1, 58)
    ACTIONS_SAVE = (1, 59)
    ACTIONS_SEARCH = (1, 60)
    ACTIONS_SELECT = (1, 61)
    ACTIONS_SET_DUE_DATE = (1, 62)
    ACTIONS_SET_FLAG = (1, 63)
    ACTIONS_SHORTCUT_KEY = (1, 64)
    ACTIONS_SUSPEND_CARD = (1, 65)
    ACTIONS_TOGGLE_LOAD_BALANCER = (1, 66)
    ACTIONS_UNBURY_UNSUSPEND = (1, 67)
    ACTIONS_UPDATE_CARD = (1, 68)
    ACTIONS_UPDATE_CONFIG = (1, 69)
    ACTIONS_UPDATE_DECK = (1, 70)
    ACTIONS_UPDATE_NOTE = (1, 71)
    ACTIONS_UPDATE_NOTETYPE = (1, 72)
    ACTIONS_UPDATE_TAG = (1, 73)
    ACTIONS_WITH_ELLIPSIS = (1, 74)
    ADDING_ADD_SHORTCUT_CTRLANDENTER = (2, 0)
    ADDING_ADDED = (2, 1)
    ADDING_CLOZE_OUTSIDE_CLOZE_FIELD = (2, 2)
    ADDING_CLOZE_OUTSIDE_CLOZE_NOTETYPE = (2, 3)
    ADDING_DISCARD_CURRENT_INPUT = (2, 4)
    ADDING_EDIT = (2, 5)
    ADDING_HISTORY = (2, 6)
    ADDING_KEEP_EDITING = (2, 7)
    ADDING_NOTE_DELETED = (2, 8)
    ADDING_SHORTCUT = (2, 9)
    ADDING_THE_FIRST_FIELD_IS_EMPTY = (2, 10)
    ADDING_YOU_HAVE_A_CLOZE_DELETION_NOTE = (2, 11)
    ADDONS_ADDON_HAS_NO_CONFIGURATION = (3, 0)
    ADDONS_ADDON_INSTALLATION_ERROR = (3, 1)
    ADDONS_BROWSE_ADDONS = (3, 2)
    ADDONS_CHANGES_WILL_TAKE_EFFECT_WHEN_ANKI = (3, 3)
    ADDONS_CHECK_FOR_UPDATES = (3, 4)
    ADDONS_CHECKING = (3, 5)
    ADDONS_CHOOSE_UPDATE_UPDATE_ALL = (3, 6)
    ADDONS_CHOOSE_UPDATE_WINDOW_TITLE = (3, 7)
    ADDONS_CODE = (3, 8)
    ADDONS_CONFIG = (3, 9)
    ADDONS_CONFIG_VALIDATION_ERROR = (3, 10)
    ADDONS_CONFIG_WINDOW_TITLE = (3, 11)
    ADDONS_CONFIGURATION = (3, 12)
    ADDONS_CORRUPT_ADDON_FILE = (3, 13)
    ADDONS_DELETE_THE_NUMD_SELECTED_ADDON = (3, 14)
    ADDONS_DISABLED = (3, 15)
    ADDONS_DISABLED2 = (3, 16)
    ADDONS_DOWNLOAD_COMPLETE_PLEASE_RESTART_ANKI_TO = (3, 17)
    ADDONS_DOWNLOADED_FNAMES = (3, 18)
    ADDONS_DOWNLOADING_ADBD_KB02FKB = (3, 19)
    ADDONS_ERROR_DOWNLOADING_IDS_ERRORS = (3, 20)
    ADDONS_ERROR_INSTALLING_BASES_ERRORS = (3, 21)
    ADDONS_FAILED_TO_LOAD = (3, 22)
    ADDONS_FAILED_TO_LOAD2 = (3, 23)
    ADDONS_GET_ADDONS = (3, 24)
    ADDONS_IMPORTANT_AS_ADDONS_ARE_PROGRAMS_DOWNLOADED = (3, 25)
    ADDONS_INSTALL_ADDON = (3, 26)
    ADDONS_INSTALL_ADDONS = (3, 27)
    ADDONS_INSTALL_ANKI_ADDON = (3, 28)
    ADDONS_INSTALL_FROM_FILE = (3, 29)
    ADDONS_INSTALLATION_COMPLETE = (3, 30)
    ADDONS_INSTALLED_NAMES = (3, 31)
    ADDONS_INSTALLED_SUCCESSFULLY = (3, 32)
    ADDONS_INVALID_ADDON_MANIFEST = (3, 33)
    ADDONS_INVALID_CODE = (3, 34)
    ADDONS_INVALID_CODE_OR_ADDON_NOT_AVAILABLE = (3, 35)
    ADDONS_INVALID_CONFIGURATION = (3, 36)
    ADDONS_INVALID_CONFIGURATION_TOP_LEVEL_OBJECT_MUST = (3, 37)
    ADDONS_NO_UPDATES_AVAILABLE = (3, 38)
    ADDONS_ONE_OR_MORE_ERRORS_OCCURRED = (3, 39)
    ADDONS_PACKAGED_ANKI_ADDON = (3, 40)
    ADDONS_PLEASE_CHECK_YOUR_INTERNET_CONNECTION = (3, 41)
    ADDONS_PLEASE_REPORT_THIS_TO_THE_RESPECTIVE = (3, 42)
    ADDONS_PLEASE_RESTART_ANKI_TO_COMPLETE_THE = (3, 43)
    ADDONS_PLEASE_SELECT_A_SINGLE_ADDON_FIRST = (3, 44)
    ADDONS_POSSIBLY_INVOLVED = (3, 45)
    ADDONS_REQUIRES = (3, 46)
    ADDONS_RESTORED_DEFAULTS = (3, 47)
    ADDONS_STARTUP_FAILED = (3, 48)
    ADDONS_THE_FOLLOWING_ADDONS_ARE_INCOMPATIBLE_WITH = (3, 49)
    ADDONS_THE_FOLLOWING_ADDONS_HAVE_UPDATES_AVAILABLE = (3, 50)
    ADDONS_THE_FOLLOWING_CONFLICTING_ADDONS_WERE_DISABLED = (3, 51)
    ADDONS_THIS_ADDON_IS_NOT_COMPATIBLE_WITH = (3, 52)
    ADDONS_TO_BROWSE_ADDONS_PLEASE_CLICK_THE = (3, 53)
    ADDONS_TOGGLE_ENABLED = (3, 54)
    ADDONS_UNABLE_TO_UPDATE_OR_DELETE_ADDON = (3, 55)
    ADDONS_UNKNOWN_ERROR = (3, 56)
    ADDONS_VIEW_ADDON_PAGE = (3, 57)
    ADDONS_VIEW_FILES = (3, 58)
    ADDONS_WINDOW_TITLE = (3, 59)
    BROWSING_ADD_NOTES = (4, 0)
    BROWSING_ADD_TAGS2 = (4, 1)
    BROWSING_ADD_TO_SELECTED_NOTES = (4, 2)
    BROWSING_ADDED_TODAY = (4, 3)
    BROWSING_ADDON = (4, 4)
    BROWSING_AGAIN_TODAY = (4, 5)
    BROWSING_ALL_FIELDS = (4, 6)
    BROWSING_ANSWER = (4, 7)
    BROWSING_ANY_FLAG = (4, 8)
    BROWSING_AVERAGE_EASE = (4, 9)
    BROWSING_AVERAGE_INTERVAL = (4, 10)
    BROWSING_BROWSER_APPEARANCE = (4, 11)
    BROWSING_BROWSER_OPTIONS = (4, 12)
    BROWSING_BURIED = (4, 13)
    BROWSING_CARD = (4, 14)
    BROWSING_CARD_INITIAL = (4, 15)
    BROWSING_CARD_LIST = (4, 16)
    BROWSING_CARDS = (4, 17)
    BROWSING_CARDS_CANT_BE_MANUALLY_MOVED_INTO = (4, 18)
    BROWSING_CARDS_DELETED = (4, 19)
    BROWSING_CARDS_DELETED_WITH_DECKNAME = (4, 20)
    BROWSING_CARDS_UPDATED = (4, 21)
    BROWSING_CHANGE_DECK = (4, 22)
    BROWSING_CHANGE_DECK2 = (4, 23)
    BROWSING_CHANGE_NOTE_TYPE = (4, 24)
    BROWSING_CHANGE_NOTE_TYPE2 = (4, 25)
    BROWSING_CHANGE_NOTETYPE = (4, 26)
    BROWSING_CHANGED_NEW_POSITION = (4, 27)
    BROWSING_CLEAR_UNUSED_TAGS = (4, 28)
    BROWSING_CONFIRM_SAVED_SEARCH_OVERWRITE = (4, 29)
    BROWSING_CREATED = (4, 30)
    BROWSING_CURRENT_DECK = (4, 31)
    BROWSING_CURRENT_NOTE_TYPE = (4, 32)
    BROWSING_DELETE_NOTES = (4, 33)
    BROWSING_DUPLICATE = (4, 34)
    BROWSING_EASE = (4, 35)
    BROWSING_EDITED_TODAY = (4, 36)
    BROWSING_ENTER_TAGS_TO_ADD = (4, 37)
    BROWSING_ENTER_TAGS_TO_DELETE = (4, 38)
    BROWSING_FILTERED = (4, 39)
    BROWSING_FIND = (4, 40)
    BROWSING_FIND_AND_REPLACE = (4, 41)
    BROWSING_FIND_DUPLICATES = (4, 42)
    BROWSING_FIRST_CARD = (4, 43)
    BROWSING_FLAG = (4, 44)
    BROWSING_FONT = (4, 45)
    BROWSING_FONT_SIZE = (4, 46)
    BROWSING_FOUND_AS_ACROSS_BS = (4, 47)
    BROWSING_GROUP = (4, 48)
    BROWSING_IGNORE_CASE = (4, 49)
    BROWSING_IN = (4, 50)
    BROWSING_INTERVAL = (4, 51)
    BROWSING_LAST_CARD = (4, 52)
    BROWSING_LEARNING = (4, 53)
    BROWSING_LINE_SIZE = (4, 54)
    BROWSING_MANAGE_NOTE_TYPES = (4, 55)
    BROWSING_MOVE_CARDS = (4, 56)
    BROWSING_MOVE_CARDS_TO_DECK = (4, 57)
    BROWSING_NEW = (4, 58)
    BROWSING_NEW_NOTE_TYPE = (4, 59)
    BROWSING_NO_FLAG = (4, 60)
    BROWSING_NO_SELECTION = (4, 61)
    BROWSING_NOTE = (4, 62)
    BROWSING_NOTE_COUNT = (4, 63)
    BROWSING_NOTE_INITIAL = (4, 64)
    BROWSING_NOTES = (4, 65)
    BROWSING_NOTES_UPDATED = (4, 66)
    BROWSING_OPTIONAL_FILTER = (4, 67)
    BROWSING_OVERRIDE_BACK_TEMPLATE = (4, 68)
    BROWSING_OVERRIDE_FONT = (4, 69)
    BROWSING_OVERRIDE_FRONT_TEMPLATE = (4, 70)
    BROWSING_PLEASE_GIVE_YOUR_FILTER_A_NAME = (4, 71)
    BROWSING_PREVIEW_SELECTED_CARD = (4, 72)
    BROWSING_QUESTION = (4, 73)
    BROWSING_QUEUE_BOTTOM = (4, 74)
    BROWSING_QUEUE_TOP = (4, 75)
    BROWSING_RANDOMIZE_ORDER = (4, 76)
    BROWSING_REMOVE_FROM_SELECTED_NOTES = (4, 77)
    BROWSING_REMOVE_TAGS = (4, 78)
    BROWSING_REMOVED_UNUSED_TAGS_COUNT = (4, 79)
    BROWSING_REPARENTED_DECKS = (4, 80)
    BROWSING_REPLACE_WITH = (4, 81)
    BROWSING_REPOSITION = (4, 82)
    BROWSING_REPOSITION_NEW_CARDS = (4, 83)
    BROWSING_RESCHEDULE = (4, 84)
    BROWSING_ROW_DELETED = (4, 85)
    BROWSING_SEARCH_BAR_HINT = (4, 86)
    BROWSING_SEARCH_IN = (4, 87)
    BROWSING_SEARCH_WITHIN_FORMATTING_SLOW = (4, 88)
    BROWSING_SELECT_DECK = (4, 89)
    BROWSING_SELECTED_NOTES_ONLY = (4, 90)
    BROWSING_SHIFT_POSITION_OF_EXISTING_CARDS = (4, 91)
    BROWSING_SIDEBAR = (4, 92)
    BROWSING_SIDEBAR_CARD_STATE = (4, 93)
    BROWSING_SIDEBAR_CARD_STATE_REVIEW = (4, 94)
    BROWSING_SIDEBAR_COLLAPSE = (4, 95)
    BROWSING_SIDEBAR_COLLAPSE_CHILDREN = (4, 96)
    BROWSING_SIDEBAR_DECKS = (4, 97)
    BROWSING_SIDEBAR_DUE_TODAY = (4, 98)
    BROWSING_SIDEBAR_EXPAND = (4, 99)
    BROWSING_SIDEBAR_EXPAND_CHILDREN = (4, 100)
    BROWSING_SIDEBAR_FILTER = (4, 101)
    BROWSING_SIDEBAR_FIRST_REVIEW = (4, 102)
    BROWSING_SIDEBAR_FLAGS = (4, 103)
    BROWSING_SIDEBAR_NOTETYPES = (4, 104)
    BROWSING_SIDEBAR_OVERDUE = (4, 105)
    BROWSING_SIDEBAR_RESCHEDULED = (4, 106)
    BROWSING_SIDEBAR_SAVE_CURRENT_SEARCH = (4, 107)
    BROWSING_SIDEBAR_SAVED_SEARCHES = (4, 108)
    BROWSING_SIDEBAR_TAGS = (4, 109)
    BROWSING_SIDEBAR_UNTAGGED = (4, 110)
    BROWSING_SORT_FIELD = (4, 111)
    BROWSING_SORTING_ON_THIS_COLUMN_IS_NOT = (4, 112)
    BROWSING_START_POSITION = (4, 113)
    BROWSING_STEP = (4, 114)
    BROWSING_STUDIED_TODAY = (4, 115)
    BROWSING_SUSPENDED = (4, 116)
    BROWSING_TAG_DUPLICATES = (4, 117)
    BROWSING_TAG_RENAME_WARNING_EMPTY = (4, 118)
    BROWSING_TARGET_FIELD = (4, 119)
    BROWSING_TODAY = (4, 120)
    BROWSING_TOGGLE_BURY = (4, 121)
    BROWSING_TOGGLE_MARK = (4, 122)
    BROWSING_TOGGLE_SHOWING_CARDS_NOTES = (4, 123)
    BROWSING_TOGGLE_SUSPEND = (4, 124)
    BROWSING_TOOLTIP_ANSWER = (4, 125)
    BROWSING_TOOLTIP_CARD = (4, 126)
    BROWSING_TOOLTIP_CARD_MODIFIED = (4, 127)
    BROWSING_TOOLTIP_CARDS = (4, 128)
    BROWSING_TOOLTIP_NOTE_MODIFIED = (4, 129)
    BROWSING_TOOLTIP_NOTETYPE = (4, 130)
    BROWSING_TOOLTIP_QUESTION = (4, 131)
    BROWSING_TREAT_INPUT_AS_REGULAR_EXPRESSION = (4, 132)
    BROWSING_UPDATE_SAVED_SEARCH = (4, 133)
    BROWSING_WHOLE_COLLECTION = (4, 134)
    BROWSING_WINDOW_TITLE = (4, 135)
    BROWSING_WINDOW_TITLE_NOTES = (4, 136)
    BROWSING_YOU_MUST_HAVE_AT_LEAST_ONE = (4, 137)
    CARD_STATS_ADDED = (5, 0)
    CARD_STATS_AVERAGE_TIME = (5, 1)
    CARD_STATS_CARD_ID = (5, 2)
    CARD_STATS_CARD_TEMPLATE = (5, 3)
    CARD_STATS_CURRENT_CARD = (5, 4)
    CARD_STATS_CUSTOM_DATA = (5, 5)
    CARD_STATS_DECK_NAME = (5, 6)
    CARD_STATS_EASE = (5, 7)
    CARD_STATS_FIRST_REVIEW = (5, 8)
    CARD_STATS_FSRS_DIFFICULTY = (5, 9)
    CARD_STATS_FSRS_FORGETTING_CURVE_ALL_TIME = (5, 10)
    CARD_STATS_FSRS_FORGETTING_CURVE_DESIRED_RETENTION = (5, 11)
    CARD_STATS_FSRS_FORGETTING_CURVE_FIRST_MONTH = (5, 12)
    CARD_STATS_FSRS_FORGETTING_CURVE_FIRST_WEEK = (5, 13)
    CARD_STATS_FSRS_FORGETTING_CURVE_FIRST_YEAR = (5, 14)
    CARD_STATS_FSRS_FORGETTING_CURVE_PROBABILITY_OF_RECALLING = (5, 15)
    CARD_STATS_FSRS_FORGETTING_CURVE_TITLE = (5, 16)
    CARD_STATS_FSRS_RETRIEVABILITY = (5, 17)
    CARD_STATS_FSRS_STABILITY = (5, 18)
    CARD_STATS_INTERVAL = (5, 19)
    CARD_STATS_LAPSE_COUNT = (5, 20)
    CARD_STATS_LATEST_REVIEW = (5, 21)
    CARD_STATS_NEW_CARD_POSITION = (5, 22)
    CARD_STATS_NO_CARD = (5, 23)
    CARD_STATS_NOTE_ID = (5, 24)
    CARD_STATS_NOTE_TYPE = (5, 25)
    CARD_STATS_PRESET = (5, 26)
    CARD_STATS_PREVIOUS_CARD = (5, 27)
    CARD_STATS_REVIEW_COUNT = (5, 28)
    CARD_STATS_REVIEW_LOG_DATE = (5, 29)
    CARD_STATS_REVIEW_LOG_ELAPSED_TIME = (5, 30)
    CARD_STATS_REVIEW_LOG_RATING = (5, 31)
    CARD_STATS_REVIEW_LOG_TIME_TAKEN = (5, 32)
    CARD_STATS_REVIEW_LOG_TYPE = (5, 33)
    CARD_STATS_REVIEW_LOG_TYPE_FILTERED = (5, 34)
    CARD_STATS_REVIEW_LOG_TYPE_LEARN = (5, 35)
    CARD_STATS_REVIEW_LOG_TYPE_MANUAL = (5, 36)
    CARD_STATS_REVIEW_LOG_TYPE_RELEARN = (5, 37)
    CARD_STATS_REVIEW_LOG_TYPE_RESCHEDULED = (5, 38)
    CARD_STATS_REVIEW_LOG_TYPE_REVIEW = (5, 39)
    CARD_STATS_TOTAL_TIME = (5, 40)
    CARD_TEMPLATE_RENDERING_BACK_SIDE_PROBLEM = (6, 0)
    CARD_TEMPLATE_RENDERING_BROWSER_BACK_SIDE_PROBLEM = (6, 1)
    CARD_TEMPLATE_RENDERING_BROWSER_FRONT_SIDE_PROBLEM = (6, 2)
    CARD_TEMPLATE_RENDERING_CONDITIONAL_NOT_CLOSED = (6, 3)
    CARD_TEMPLATE_RENDERING_CONDITIONAL_NOT_OPEN = (6, 4)
    CARD_TEMPLATE_RENDERING_EMPTY_FRONT = (6, 5)
    CARD_TEMPLATE_RENDERING_FRONT_SIDE_PROBLEM = (6, 6)
    CARD_TEMPLATE_RENDERING_MISSING_CLOZE = (6, 7)
    CARD_TEMPLATE_RENDERING_MORE_INFO = (6, 8)
    CARD_TEMPLATE_RENDERING_NO_CLOSING_BRACKETS = (6, 9)
    CARD_TEMPLATE_RENDERING_NO_SUCH_FIELD = (6, 10)
    CARD_TEMPLATE_RENDERING_WRONG_CONDITIONAL_CLOSED = (6, 11)
    CARD_TEMPLATES_ADD_CARD_TYPE = (7, 0)
    CARD_TEMPLATES_ADD_MOBILE_CLASS = (7, 1)
    CARD_TEMPLATES_ANKI_COULDNT_FIND_THE_LINE_BETWEEN = (7, 2)
    CARD_TEMPLATES_AT_LEAST_ONE_CARD_TYPE_IS = (7, 3)
    CARD_TEMPLATES_BACK_PREVIEW = (7, 4)
    CARD_TEMPLATES_BACK_TEMPLATE = (7, 5)
    CARD_TEMPLATES_BLANK = (7, 6)
    CARD_TEMPLATES_BROWSER_APPEARANCE = (7, 7)
    CARD_TEMPLATES_CARD = (7, 8)
    CARD_TEMPLATES_CARD_COUNT = (7, 9)
    CARD_TEMPLATES_CARD_TYPE = (7, 10)
    CARD_TEMPLATES_CARD_TYPES_FOR = (7, 11)
    CARD_TEMPLATES_CHANGES_SAVED = (7, 12)
    CARD_TEMPLATES_CHANGES_WILL_AFFECT_NOTES = (7, 13)
    CARD_TEMPLATES_CLOZE = (7, 14)
    CARD_TEMPLATES_COPY_INFO = (7, 15)
    CARD_TEMPLATES_DECK_OVERRIDE = (7, 16)
    CARD_TEMPLATES_DELETE_THE_AS_CARD_TYPE_AND = (7, 17)
    CARD_TEMPLATES_DISCARD_CHANGES = (7, 18)
    CARD_TEMPLATES_ENTER_DECK_TO_PLACE_NEW = (7, 19)
    CARD_TEMPLATES_ENTER_NEW_CARD_POSITION_1 = (7, 20)
    CARD_TEMPLATES_EXTRANEOUS_CLOZE = (7, 21)
    CARD_TEMPLATES_FIELD_NOT_FOUND = (7, 22)
    CARD_TEMPLATES_FILL_EMPTY = (7, 23)
    CARD_TEMPLATES_FLIP = (7, 24)
    CARD_TEMPLATES_FORM = (7, 25)
    CARD_TEMPLATES_FRONT_PREVIEW = (7, 26)
    CARD_TEMPLATES_FRONT_TEMPLATE = (7, 27)
    CARD_TEMPLATES_IDENTICAL_FRONT = (7, 28)
    CARD_TEMPLATES_INVALID_TEMPLATE_NUMBER = (7, 29)
    CARD_TEMPLATES_MISSING_CLOZE = (7, 30)
    CARD_TEMPLATES_NIGHT_MODE = (7, 31)
    CARD_TEMPLATES_NO_FRONT_FIELD = (7, 32)
    CARD_TEMPLATES_OFF = (7, 33)
    CARD_TEMPLATES_ON = (7, 34)
    CARD_TEMPLATES_PREVIEW_BOX = (7, 35)
    CARD_TEMPLATES_PREVIEW_SETTINGS = (7, 36)
    CARD_TEMPLATES_REMOVE_CARD_TYPE = (7, 37)
    CARD_TEMPLATES_RENAME_CARD_TYPE = (7, 38)
    CARD_TEMPLATES_REPOSITION_CARD_TYPE = (7, 39)
    CARD_TEMPLATES_RESTORE_TO_DEFAULT = (7, 40)
    CARD_TEMPLATES_RESTORE_TO_DEFAULT_CONFIRMATION = (7, 41)
    CARD_TEMPLATES_RESTORED_TO_DEFAULT = (7, 42)
    CARD_TEMPLATES_SAMPLE_CLOZE = (7, 43)
    CARD_TEMPLATES_SEE_PREVIEW = (7, 44)
    CARD_TEMPLATES_TEMPLATE_BOX = (7, 45)
    CARD_TEMPLATES_TEMPLATE_STYLING = (7, 46)
    CARD_TEMPLATES_THIS_WILL_CREATE_CARD_PROCEED = (7, 47)
    CARD_TEMPLATES_TYPE_BOXES_WARNING = (7, 48)
    CHANGE_NOTETYPE_COLLAPSE = (8, 0)
    CHANGE_NOTETYPE_CURRENT = (8, 1)
    CHANGE_NOTETYPE_EXPAND = (8, 2)
    CHANGE_NOTETYPE_FIELDS = (8, 3)
    CHANGE_NOTETYPE_NEW = (8, 4)
    CHANGE_NOTETYPE_NOTHING = (8, 5)
    CHANGE_NOTETYPE_TEMPLATES = (8, 6)
    CHANGE_NOTETYPE_TO_FROM_CLOZE = (8, 7)
    CHANGE_NOTETYPE_WILL_DISCARD_CARDS = (8, 8)
    CHANGE_NOTETYPE_WILL_DISCARD_CONTENT = (8, 9)
    CUSTOM_STUDY_ALL_CARDS_IN_RANDOM_ORDER_DONT = (9, 0)
    CUSTOM_STUDY_ALL_REVIEW_CARDS_IN_RANDOM_ORDER = (9, 1)
    CUSTOM_STUDY_AVAILABLE_CHILD_COUNT = (9, 2)
    CUSTOM_STUDY_AVAILABLE_NEW_CARDS = (9, 3)
    CUSTOM_STUDY_AVAILABLE_NEW_CARDS_2 = (9, 4)
    CUSTOM_STUDY_AVAILABLE_REVIEW_CARDS = (9, 5)
    CUSTOM_STUDY_AVAILABLE_REVIEW_CARDS_2 = (9, 6)
    CUSTOM_STUDY_CARDS = (9, 7)
    CUSTOM_STUDY_CARDS_FROM_THE_DECK = (9, 8)
    CUSTOM_STUDY_CHOOSE_TAGS = (9, 9)
    CUSTOM_STUDY_CUSTOM_STUDY_SESSION = (9, 10)
    CUSTOM_STUDY_DUE_CARDS_ONLY = (9, 11)
    CUSTOM_STUDY_INCREASE_TODAYS_NEW_CARD_LIMIT = (9, 12)
    CUSTOM_STUDY_INCREASE_TODAYS_NEW_CARD_LIMIT_BY = (9, 13)
    CUSTOM_STUDY_INCREASE_TODAYS_REVIEW_CARD_LIMIT = (9, 14)
    CUSTOM_STUDY_INCREASE_TODAYS_REVIEW_LIMIT_BY = (9, 15)
    CUSTOM_STUDY_MUST_RENAME_DECK = (9, 16)
    CUSTOM_STUDY_NEW_CARDS_ONLY = (9, 17)
    CUSTOM_STUDY_NO_CARDS_MATCHED_THE_CRITERIA_YOU = (9, 18)
    CUSTOM_STUDY_OK = (9, 19)
    CUSTOM_STUDY_PREVIEW_NEW_CARDS = (9, 20)
    CUSTOM_STUDY_PREVIEW_NEW_CARDS_ADDED_IN_THE = (9, 21)
    CUSTOM_STUDY_REQUIRE_ONE_OR_MORE_OF_THESE = (9, 22)
    CUSTOM_STUDY_REVIEW_AHEAD = (9, 23)
    CUSTOM_STUDY_REVIEW_AHEAD_BY = (9, 24)
    CUSTOM_STUDY_REVIEW_CARDS_FORGOTTEN_IN_LAST = (9, 25)
    CUSTOM_STUDY_REVIEW_FORGOTTEN_CARDS = (9, 26)
    CUSTOM_STUDY_SELECT = (9, 27)
    CUSTOM_STUDY_SELECT_TAGS_TO_EXCLUDE = (9, 28)
    CUSTOM_STUDY_SELECTIVE_STUDY = (9, 29)
    CUSTOM_STUDY_STUDY_BY_CARD_STATE_OR_TAG = (9, 30)
    DATABASE_CHECK_CARD_LAST_REVIEW_TIME_EMPTY = (10, 0)
    DATABASE_CHECK_CARD_MISSING_NOTE = (10, 1)
    DATABASE_CHECK_CARD_PROPERTIES = (10, 2)
    DATABASE_CHECK_CHECKING_CARDS = (10, 3)
    DATABASE_CHECK_CHECKING_HISTORY = (10, 4)
    DATABASE_CHECK_CHECKING_INTEGRITY = (10, 5)
    DATABASE_CHECK_CHECKING_NOTES = (10, 6)
    DATABASE_CHECK_CORRUPT = (10, 7)
    DATABASE_CHECK_DUPLICATE_CARD_ORDS = (10, 8)
    DATABASE_CHECK_FIELD_COUNT = (10, 9)
    DATABASE_CHECK_FIXED_INVALID_IDS = (10, 10)
    DATABASE_CHECK_MISSING_DECKS = (10, 11)
    DATABASE_CHECK_MISSING_TEMPLATES = (10, 12)
    DATABASE_CHECK_NEW_CARD_HIGH_DUE = (10, 13)
    DATABASE_CHECK_NOTES_WITH_INVALID_UTF8 = (10, 14)
    DATABASE_CHECK_NOTETYPES_RECOVERED = (10, 15)
    DATABASE_CHECK_REBUILDING = (10, 16)
    DATABASE_CHECK_REBUILT = (10, 17)
    DATABASE_CHECK_REVLOG_PROPERTIES = (10, 18)
    DATABASE_CHECK_TITLE = (10, 19)
    DECK_CONFIG_A_100_DAY_INTERVAL = (11, 0)
    DECK_CONFIG_ADD_GROUP = (11, 1)
    DECK_CONFIG_ADDITIONAL_NEW_CARDS_TO_SIMULATE = (11, 2)
    DECK_CONFIG_ADVANCED_SETTINGS = (11, 3)
    DECK_CONFIG_ADVANCED_TITLE = (11, 4)
    DECK_CONFIG_AFFECTS_ENTIRE_COLLECTION = (11, 5)
    DECK_CONFIG_ALWAYS_INCLUDE_QUESTION_AUDIO_TOOLTIP = (11, 6)
    DECK_CONFIG_ANSWER_ACTION = (11, 7)
    DECK_CONFIG_ANSWER_ACTION_TOOLTIP = (11, 8)
    DECK_CONFIG_ANSWER_ACTION_TOOLTIP_2 = (11, 9)
    DECK_CONFIG_ANSWER_AGAIN = (11, 10)
    DECK_CONFIG_ANSWER_GOOD = (11, 11)
    DECK_CONFIG_ANSWER_HARD = (11, 12)
    DECK_CONFIG_APPLY_ALL_PARENT_LIMITS = (11, 13)
    DECK_CONFIG_APPLY_ALL_PARENT_LIMITS_TOOLTIP = (11, 14)
    DECK_CONFIG_AUDIO_TITLE = (11, 15)
    DECK_CONFIG_BURY_IF_NEW = (11, 16)
    DECK_CONFIG_BURY_IF_NEW_OR_REVIEW = (11, 17)
    DECK_CONFIG_BURY_IF_NEW_REVIEW_OR_INTERDAY = (11, 18)
    DECK_CONFIG_BURY_INTERDAY_LEARNING_SIBLINGS = (11, 19)
    DECK_CONFIG_BURY_INTERDAY_LEARNING_TOOLTIP = (11, 20)
    DECK_CONFIG_BURY_NEW_SIBLINGS = (11, 21)
    DECK_CONFIG_BURY_NEW_TOOLTIP = (11, 22)
    DECK_CONFIG_BURY_PRIORITY_TOOLTIP = (11, 23)
    DECK_CONFIG_BURY_REVIEW_SIBLINGS = (11, 24)
    DECK_CONFIG_BURY_REVIEW_TOOLTIP = (11, 25)
    DECK_CONFIG_BURY_SIBLINGS = (11, 26)
    DECK_CONFIG_BURY_TITLE = (11, 27)
    DECK_CONFIG_BURY_TOOLTIP = (11, 28)
    DECK_CONFIG_CHECKING_FOR_IMPROVEMENT = (11, 29)
    DECK_CONFIG_CLEAR_LAST_SIMULATE = (11, 30)
    DECK_CONFIG_CLONE_GROUP = (11, 31)
    DECK_CONFIG_COMPLETE = (11, 32)
    DECK_CONFIG_COMPUTE_BUTTON = (11, 33)
    DECK_CONFIG_COMPUTE_MINIMUM_RECOMMENDED_RETENTION = (11, 34)
    DECK_CONFIG_COMPUTE_OPTIMAL_RETENTION = (11, 35)
    DECK_CONFIG_COMPUTE_OPTIMAL_RETENTION_TOOLTIP = (11, 36)
    DECK_CONFIG_COMPUTE_OPTIMAL_RETENTION_TOOLTIP2 = (11, 37)
    DECK_CONFIG_COMPUTE_OPTIMAL_RETENTION_TOOLTIP3 = (11, 38)
    DECK_CONFIG_COMPUTE_OPTIMAL_RETENTION_TOOLTIP4 = (11, 39)
    DECK_CONFIG_COMPUTE_OPTIMAL_WEIGHTS = (11, 40)
    DECK_CONFIG_COMPUTE_OPTIMAL_WEIGHTS_TOOLTIP = (11, 41)
    DECK_CONFIG_COMPUTE_OPTIMAL_WEIGHTS_TOOLTIP2 = (11, 42)
    DECK_CONFIG_CONFIRM_REMOVE_NAME = (11, 43)
    DECK_CONFIG_CUSTOM_SCHEDULING = (11, 44)
    DECK_CONFIG_CUSTOM_SCHEDULING_TOOLTIP = (11, 45)
    DECK_CONFIG_DAILY_LIMIT_WILL_BE_CAPPED = (11, 46)
    DECK_CONFIG_DAILY_LIMITS = (11, 47)
    DECK_CONFIG_DAYS_TO_SIMULATE = (11, 48)
    DECK_CONFIG_DECK_ONLY = (11, 49)
    DECK_CONFIG_DEFAULT_NAME = (11, 50)
    DECK_CONFIG_DESCRIPTION_NEW_HANDLING = (11, 51)
    DECK_CONFIG_DESCRIPTION_NEW_HANDLING_HINT = (11, 52)
    DECK_CONFIG_DESIRED_RETENTION = (11, 53)
    DECK_CONFIG_DESIRED_RETENTION_BELOW_OPTIMAL = (11, 54)
    DECK_CONFIG_DESIRED_RETENTION_TOO_HIGH = (11, 55)
    DECK_CONFIG_DESIRED_RETENTION_TOO_LOW = (11, 56)
    DECK_CONFIG_DESIRED_RETENTION_TOOLTIP = (11, 57)
    DECK_CONFIG_DESIRED_RETENTION_TOOLTIP2 = (11, 58)
    DECK_CONFIG_DISABLE_AUTOPLAY = (11, 59)
    DECK_CONFIG_DISABLE_AUTOPLAY_TOOLTIP = (11, 60)
    DECK_CONFIG_DISPLAY_ORDER_WILL_USE_CURRENT_DECK = (11, 61)
    DECK_CONFIG_DO_NOT_BURY = (11, 62)
    DECK_CONFIG_EASY_BONUS_TOOLTIP = (11, 63)
    DECK_CONFIG_EASY_DAYS_CHANGE = (11, 64)
    DECK_CONFIG_EASY_DAYS_FRIDAY = (11, 65)
    DECK_CONFIG_EASY_DAYS_MINIMUM = (11, 66)
    DECK_CONFIG_EASY_DAYS_MONDAY = (11, 67)
    DECK_CONFIG_EASY_DAYS_NO_NORMAL_DAYS = (11, 68)
    DECK_CONFIG_EASY_DAYS_NORMAL = (11, 69)
    DECK_CONFIG_EASY_DAYS_REDUCED = (11, 70)
    DECK_CONFIG_EASY_DAYS_SATURDAY = (11, 71)
    DECK_CONFIG_EASY_DAYS_SUNDAY = (11, 72)
    DECK_CONFIG_EASY_DAYS_THURSDAY = (11, 73)
    DECK_CONFIG_EASY_DAYS_TITLE = (11, 74)
    DECK_CONFIG_EASY_DAYS_TUESDAY = (11, 75)
    DECK_CONFIG_EASY_DAYS_WEDNESDAY = (11, 76)
    DECK_CONFIG_EASY_INTERVAL_TOOLTIP = (11, 77)
    DECK_CONFIG_EVALUATE_BUTTON = (11, 78)
    DECK_CONFIG_FSRS_BAD_FIT_WARNING = (11, 79)
    DECK_CONFIG_FSRS_DESIRED_RETENTION_HELP_ME_DECIDE_EXPERIMENTAL = (11, 80)
    DECK_CONFIG_FSRS_GOOD_FIT = (11, 81)
    DECK_CONFIG_FSRS_MUST_BE_ENABLED = (11, 82)
    DECK_CONFIG_FSRS_ON_ALL_CLIENTS = (11, 83)
    DECK_CONFIG_FSRS_PARAMS_NO_REVIEWS = (11, 84)
    DECK_CONFIG_FSRS_PARAMS_OPTIMAL = (11, 85)
    DECK_CONFIG_FSRS_SIMULATE_DESIRED_RETENTION_EXPERIMENTAL = (11, 86)
    DECK_CONFIG_FSRS_SIMULATE_SAVE_PRESET = (11, 87)
    DECK_CONFIG_FSRS_SIMULATOR_EXPERIMENTAL = (11, 88)
    DECK_CONFIG_FSRS_SIMULATOR_RADIO_COUNT = (11, 89)
    DECK_CONFIG_FSRS_SIMULATOR_RADIO_MEMORIZED = (11, 90)
    DECK_CONFIG_FSRS_SIMULATOR_RADIO_RATIO = (11, 91)
    DECK_CONFIG_FSRS_SIMULATOR_RATIO_TOOLTIP = (11, 92)
    DECK_CONFIG_FSRS_SIMULATOR_Y_AXIS_TITLE_COUNT = (11, 93)
    DECK_CONFIG_FSRS_SIMULATOR_Y_AXIS_TITLE_MEMORIZED = (11, 94)
    DECK_CONFIG_FSRS_SIMULATOR_Y_AXIS_TITLE_TIME = (11, 95)
    DECK_CONFIG_FSRS_TOOLTIP = (11, 96)
    DECK_CONFIG_GET_PARAMS = (11, 97)
    DECK_CONFIG_GOOD_ABOVE_EASY = (11, 98)
    DECK_CONFIG_GRADUATING_INTERVAL_TOOLTIP = (11, 99)
    DECK_CONFIG_HARD_INTERVAL_TOOLTIP = (11, 100)
    DECK_CONFIG_HEALTH_CHECK = (11, 101)
    DECK_CONFIG_HEALTH_CHECK_TOOLTIP1 = (11, 102)
    DECK_CONFIG_HEALTH_CHECK_TOOLTIP2 = (11, 103)
    DECK_CONFIG_HISTORICAL_RETENTION = (11, 104)
    DECK_CONFIG_HISTORICAL_RETENTION_TOOLTIP = (11, 105)
    DECK_CONFIG_IGNORE_BEFORE = (11, 106)
    DECK_CONFIG_IGNORE_BEFORE_INFO = (11, 107)
    DECK_CONFIG_IGNORE_BEFORE_TOOLTIP = (11, 108)
    DECK_CONFIG_IGNORE_BEFORE_TOOLTIP_2 = (11, 109)
    DECK_CONFIG_INTERDAY_STEP_PRIORITY = (11, 110)
    DECK_CONFIG_INTERDAY_STEP_PRIORITY_TOOLTIP = (11, 111)
    DECK_CONFIG_INTERVAL_MODIFIER_TOOLTIP = (11, 112)
    DECK_CONFIG_INVALID_PARAMETERS = (11, 113)
    DECK_CONFIG_INVALID_WEIGHTS = (11, 114)
    DECK_CONFIG_ITERATIONS = (11, 115)
    DECK_CONFIG_LEARNING_STEP_ABOVE_GRADUATING_INTERVAL = (11, 116)
    DECK_CONFIG_LEARNING_STEPS = (11, 117)
    DECK_CONFIG_LEARNING_STEPS_TOOLTIP = (11, 118)
    DECK_CONFIG_LEECH_ACTION_TOOLTIP = (11, 119)
    DECK_CONFIG_LEECH_THRESHOLD_TOOLTIP = (11, 120)
    DECK_CONFIG_LIMIT_DECK_V3 = (11, 121)
    DECK_CONFIG_LIMIT_INTERDAY_BOUND_BY_REVIEWS = (11, 122)
    DECK_CONFIG_LIMIT_NEW_BOUND_BY_REVIEWS = (11, 123)
    DECK_CONFIG_MAXIMUM_ANSWER_SECS = (11, 124)
    DECK_CONFIG_MAXIMUM_ANSWER_SECS_ABOVE_RECOMMENDED = (11, 125)
    DECK_CONFIG_MAXIMUM_ANSWER_SECS_TOOLTIP = (11, 126)
    DECK_CONFIG_MAXIMUM_INTERVAL_TOOLTIP = (11, 127)
    DECK_CONFIG_MINIMUM_INTERVAL_TOOLTIP = (11, 128)
    DECK_CONFIG_MUST_HAVE_400_REVIEWS = (11, 129)
    DECK_CONFIG_NAME_PROMPT = (11, 130)
    DECK_CONFIG_NEW_CARD_SORT_ORDER = (11, 131)
    DECK_CONFIG_NEW_CARD_SORT_ORDER_TOOLTIP_2 = (11, 132)
    DECK_CONFIG_NEW_CARDS_IGNORE_REVIEW_LIMIT = (11, 133)
    DECK_CONFIG_NEW_CARDS_IGNORE_REVIEW_LIMIT_TOOLTIP = (11, 134)
    DECK_CONFIG_NEW_GATHER_PRIORITY = (11, 135)
    DECK_CONFIG_NEW_GATHER_PRIORITY_DECK = (11, 136)
    DECK_CONFIG_NEW_GATHER_PRIORITY_DECK_THEN_RANDOM_NOTES = (11, 137)
    DECK_CONFIG_NEW_GATHER_PRIORITY_POSITION_HIGHEST_FIRST = (11, 138)
    DECK_CONFIG_NEW_GATHER_PRIORITY_POSITION_LOWEST_FIRST = (11, 139)
    DECK_CONFIG_NEW_GATHER_PRIORITY_RANDOM_CARDS = (11, 140)
    DECK_CONFIG_NEW_GATHER_PRIORITY_RANDOM_NOTES = (11, 141)
    DECK_CONFIG_NEW_GATHER_PRIORITY_TOOLTIP_2 = (11, 142)
    DECK_CONFIG_NEW_INSERTION_ORDER = (11, 143)
    DECK_CONFIG_NEW_INSERTION_ORDER_RANDOM = (11, 144)
    DECK_CONFIG_NEW_INSERTION_ORDER_RANDOM_WITH_V3 = (11, 145)
    DECK_CONFIG_NEW_INSERTION_ORDER_SEQUENTIAL = (11, 146)
    DECK_CONFIG_NEW_INSERTION_ORDER_TOOLTIP = (11, 147)
    DECK_CONFIG_NEW_INTERVAL_TOOLTIP = (11, 148)
    DECK_CONFIG_NEW_LIMIT_TOOLTIP = (11, 149)
    DECK_CONFIG_NEW_REVIEW_PRIORITY = (11, 150)
    DECK_CONFIG_NEW_REVIEW_PRIORITY_TOOLTIP = (11, 151)
    DECK_CONFIG_NOT_ENOUGH_HISTORY = (11, 152)
    DECK_CONFIG_OPTIMIZE_ALL_TIP = (11, 153)
    DECK_CONFIG_OPTIMIZE_BUTTON = (11, 154)
    DECK_CONFIG_OPTIMIZING_PRESET = (11, 155)
    DECK_CONFIG_ORDERING_TITLE = (11, 156)
    DECK_CONFIG_PERCENT_INPUT = (11, 157)
    DECK_CONFIG_PERCENT_OF_REVIEWS = (11, 158)
    DECK_CONFIG_PLEASE_SAVE_YOUR_CHANGES_FIRST = (11, 159)
    DECK_CONFIG_PLOTTED_ON_X_AXIS = (11, 160)
    DECK_CONFIG_PREDICTED_MINIMUM_RECOMMENDED_RETENTION = (11, 161)
    DECK_CONFIG_PREDICTED_OPTIMAL_RETENTION = (11, 162)
    DECK_CONFIG_QUESTION_ACTION = (11, 163)
    DECK_CONFIG_QUESTION_ACTION_SHOW_ANSWER = (11, 164)
    DECK_CONFIG_QUESTION_ACTION_SHOW_REMINDER = (11, 165)
    DECK_CONFIG_QUESTION_ACTION_TOOL_TIP = (11, 166)
    DECK_CONFIG_RELEARNING_STEPS = (11, 167)
    DECK_CONFIG_RELEARNING_STEPS_ABOVE_MINIMUM_INTERVAL = (11, 168)
    DECK_CONFIG_RELEARNING_STEPS_TOOLTIP = (11, 169)
    DECK_CONFIG_REMOVE_GROUP = (11, 170)
    DECK_CONFIG_RENAME_GROUP = (11, 171)
    DECK_CONFIG_RESCHEDULE_CARDS_ON_CHANGE = (11, 172)
    DECK_CONFIG_RESCHEDULE_CARDS_ON_CHANGE_TOOLTIP = (11, 173)
    DECK_CONFIG_RESCHEDULE_CARDS_WARNING = (11, 174)
    DECK_CONFIG_REVERT_BUTTON_TOOLTIP = (11, 175)
    DECK_CONFIG_REVIEW_LIMIT_TOOLTIP = (11, 176)
    DECK_CONFIG_REVIEW_MIX_MIX_WITH_REVIEWS = (11, 177)
    DECK_CONFIG_REVIEW_MIX_SHOW_AFTER_REVIEWS = (11, 178)
    DECK_CONFIG_REVIEW_MIX_SHOW_BEFORE_REVIEWS = (11, 179)
    DECK_CONFIG_REVIEW_SORT_ORDER = (11, 180)
    DECK_CONFIG_REVIEW_SORT_ORDER_TOOLTIP = (11, 181)
    DECK_CONFIG_REVIEWS_TOO_LOW = (11, 182)
    DECK_CONFIG_SAVE_AND_OPTIMIZE = (11, 183)
    DECK_CONFIG_SAVE_BUTTON = (11, 184)
    DECK_CONFIG_SAVE_OPTIONS_TO_PRESET = (11, 185)
    DECK_CONFIG_SAVE_OPTIONS_TO_PRESET_CONFIRM = (11, 186)
    DECK_CONFIG_SAVE_TO_ALL_SUBDECKS = (11, 187)
    DECK_CONFIG_SECONDS_TO_SHOW_ANSWER = (11, 188)
    DECK_CONFIG_SECONDS_TO_SHOW_ANSWER_TOOLTIP_2 = (11, 189)
    DECK_CONFIG_SECONDS_TO_SHOW_QUESTION = (11, 190)
    DECK_CONFIG_SECONDS_TO_SHOW_QUESTION_TOOLTIP = (11, 191)
    DECK_CONFIG_SECONDS_TO_SHOW_QUESTION_TOOLTIP_2 = (11, 192)
    DECK_CONFIG_SECONDS_TO_SHOW_QUESTION_TOOLTIP_3 = (11, 193)
    DECK_CONFIG_SHARED_PRESET = (11, 194)
    DECK_CONFIG_SHOW_ANSWER_TIMER_TOOLTIP = (11, 195)
    DECK_CONFIG_SHOW_REMINDER = (11, 196)
    DECK_CONFIG_SIMULATE = (11, 197)
    DECK_CONFIG_SKIP_QUESTION_WHEN_REPLAYING = (11, 198)
    DECK_CONFIG_SLOW_SUFFIX = (11, 199)
    DECK_CONFIG_SMALLER_IS_BETTER = (11, 200)
    DECK_CONFIG_SMOOTH_GRAPH = (11, 201)
    DECK_CONFIG_SORT_ORDER_ASCENDING_DIFFICULTY = (11, 202)
    DECK_CONFIG_SORT_ORDER_ASCENDING_EASE = (11, 203)
    DECK_CONFIG_SORT_ORDER_ASCENDING_INTERVALS = (11, 204)
    DECK_CONFIG_SORT_ORDER_CARD_TEMPLATE_THEN_RANDOM = (11, 205)
    DECK_CONFIG_SORT_ORDER_DECK_THEN_DUE_DATE = (11, 206)
    DECK_CONFIG_SORT_ORDER_DESCENDING_DIFFICULTY = (11, 207)
    DECK_CONFIG_SORT_ORDER_DESCENDING_EASE = (11, 208)
    DECK_CONFIG_SORT_ORDER_DESCENDING_INTERVALS = (11, 209)
    DECK_CONFIG_SORT_ORDER_DUE_DATE_THEN_DECK = (11, 210)
    DECK_CONFIG_SORT_ORDER_DUE_DATE_THEN_RANDOM = (11, 211)
    DECK_CONFIG_SORT_ORDER_GATHER = (11, 212)
    DECK_CONFIG_SORT_ORDER_RANDOM = (11, 213)
    DECK_CONFIG_SORT_ORDER_RANDOM_NOTE_THEN_TEMPLATE = (11, 214)
    DECK_CONFIG_SORT_ORDER_RETRIEVABILITY_ASCENDING = (11, 215)
    DECK_CONFIG_SORT_ORDER_RETRIEVABILITY_DESCENDING = (11, 216)
    DECK_CONFIG_SORT_ORDER_TEMPLATE_THEN_GATHER = (11, 217)
    DECK_CONFIG_STARTING_EASE_TOOLTIP = (11, 218)
    DECK_CONFIG_STEPS_TOO_LARGE_FOR_FSRS = (11, 219)
    DECK_CONFIG_STOP_TIMER_ON_ANSWER = (11, 220)
    DECK_CONFIG_STOP_TIMER_ON_ANSWER_TOOLTIP = (11, 221)
    DECK_CONFIG_SUSPEND_LEECHES = (11, 222)
    DECK_CONFIG_TAB_DESCRIPTION = (11, 223)
    DECK_CONFIG_TIME_TO_OPTIMIZE = (11, 224)
    DECK_CONFIG_TIMER_TITLE = (11, 225)
    DECK_CONFIG_TITLE = (11, 226)
    DECK_CONFIG_TODAY_ONLY = (11, 227)
    DECK_CONFIG_TOO_SHORT_MAXIMUM_INTERVAL = (11, 228)
    DECK_CONFIG_UNABLE_TO_DETERMINE_DESIRED_RETENTION = (11, 229)
    DECK_CONFIG_UPDATING_CARDS = (11, 230)
    DECK_CONFIG_USED_BY_DECKS = (11, 231)
    DECK_CONFIG_WAIT_FOR_AUDIO = (11, 232)
    DECK_CONFIG_WAIT_FOR_AUDIO_TOOLTIP = (11, 233)
    DECK_CONFIG_WAIT_FOR_AUDIO_TOOLTIP_2 = (11, 234)
    DECK_CONFIG_WEIGHTS = (11, 235)
    DECK_CONFIG_WEIGHTS_TOOLTIP = (11, 236)
    DECK_CONFIG_WEIGHTS_TOOLTIP2 = (11, 237)
    DECK_CONFIG_WHICH_DECK = (11, 238)
    DECK_CONFIG_WILL_REQUIRE_FULL_SYNC = (11, 239)
    DECK_CONFIG_WORKLOAD_FACTOR_CHANGE = (11, 240)
    DECK_CONFIG_WORKLOAD_FACTOR_UNCHANGED = (11, 241)
    DECKS_ADD_NEW_DECK_CTRLANDN = (12, 0)
    DECKS_BUILD = (12, 1)
    DECKS_CARDS_SELECTED_BY = (12, 2)
    DECKS_CREATE_DECK = (12, 3)
    DECKS_CUSTOM_STEPS_IN_MINUTES = (12, 4)
    DECKS_DECK = (12, 5)
    DECKS_DECREASING_INTERVALS = (12, 6)
    DECKS_DELAY_FOR_BUTTON = (12, 7)
    DECKS_DELETE_DECK = (12, 8)
    DECKS_ENABLE_SECOND_FILTER = (12, 9)
    DECKS_FILTER = (12, 10)
    DECKS_FILTER_2 = (12, 11)
    DECKS_FILTERED_DECK_SEARCH_EMPTY = (12, 12)
    DECKS_GET_SHARED = (12, 13)
    DECKS_IMPORT_FILE = (12, 14)
    DECKS_INCREASING_INTERVALS = (12, 15)
    DECKS_LATEST_ADDED_FIRST = (12, 16)
    DECKS_LEARN_HEADER = (12, 17)
    DECKS_LIMIT_TO = (12, 18)
    DECKS_MINUTES = (12, 19)
    DECKS_MOST_LAPSES = (12, 20)
    DECKS_NEW_DECK_NAME = (12, 21)
    DECKS_NO_DECK = (12, 22)
    DECKS_OLDEST_SEEN_FIRST = (12, 23)
    DECKS_ORDER_ADDED = (12, 24)
    DECKS_ORDER_DUE = (12, 25)
    DECKS_PLEASE_SELECT_SOMETHING = (12, 26)
    DECKS_RANDOM = (12, 27)
    DECKS_RELATIVE_OVERDUENESS = (12, 28)
    DECKS_REPEAT_FAILED_CARDS_AFTER = (12, 29)
    DECKS_RESCHEDULE_CARDS_BASED_ON_MY_ANSWERS = (12, 30)
    DECKS_REVIEW_HEADER = (12, 31)
    DECKS_STUDY = (12, 32)
    DECKS_STUDY_DECK = (12, 33)
    DECKS_UNMOVABLE_CARDS = (12, 34)
    DECKS_ZERO_MINUTES_HINT = (12, 35)
    DECKS_CREATE_EVEN_IF_EMPTY = (12, 36)
    EDITING_ACTUAL_SIZE = (13, 0)
    EDITING_ADD_MEDIA = (13, 1)
    EDITING_ALIGN_LEFT = (13, 2)
    EDITING_ALIGN_RIGHT = (13, 3)
    EDITING_ALIGNMENT = (13, 4)
    EDITING_AN_ERROR_OCCURRED_WHILE_OPENING = (13, 5)
    EDITING_ATTACH_PICTURESAUDIOVIDEO = (13, 6)
    EDITING_BOLD_TEXT = (13, 7)
    EDITING_CARDS = (13, 8)
    EDITING_CENTER = (13, 9)
    EDITING_CHANGE_COLOR = (13, 10)
    EDITING_CLOSE_HTML_TAGS = (13, 11)
    EDITING_CLOZE_DELETION = (13, 12)
    EDITING_CLOZE_DELETION_REPEAT = (13, 13)
    EDITING_COLLAPSE = (13, 14)
    EDITING_COLLAPSE_FIELD = (13, 15)
    EDITING_COPY_IMAGE = (13, 16)
    EDITING_COULDNT_RECORD_AUDIO_HAVE_YOU_INSTALLED = (13, 17)
    EDITING_CUSTOMIZE_CARD_TEMPLATES = (13, 18)
    EDITING_CUSTOMIZE_FIELDS = (13, 19)
    EDITING_CUT = (13, 20)
    EDITING_DOUBLE_CLICK_IMAGE = (13, 21)
    EDITING_DOUBLE_CLICK_TO_COLLAPSE = (13, 22)
    EDITING_DOUBLE_CLICK_TO_EXPAND = (13, 23)
    EDITING_EDIT_CURRENT = (13, 24)
    EDITING_EDIT_HTML = (13, 25)
    EDITING_EQUATIONS = (13, 26)
    EDITING_EXPAND = (13, 27)
    EDITING_EXPAND_FIELD = (13, 28)
    EDITING_FIELDS = (13, 29)
    EDITING_FLOAT_LEFT = (13, 30)
    EDITING_FLOAT_NONE = (13, 31)
    EDITING_FLOAT_RIGHT = (13, 32)
    EDITING_FROM_CLIPBOARD = (13, 33)
    EDITING_HTML_EDITOR = (13, 34)
    EDITING_IMAGE_OCCLUSION_ALIGN_BOTTOM = (13, 35)
    EDITING_IMAGE_OCCLUSION_ALIGN_H_CENTER = (13, 36)
    EDITING_IMAGE_OCCLUSION_ALIGN_LEFT = (13, 37)
    EDITING_IMAGE_OCCLUSION_ALIGN_RIGHT = (13, 38)
    EDITING_IMAGE_OCCLUSION_ALIGN_TOP = (13, 39)
    EDITING_IMAGE_OCCLUSION_ALIGN_V_CENTER = (13, 40)
    EDITING_IMAGE_OCCLUSION_ALIGNMENT = (13, 41)
    EDITING_IMAGE_OCCLUSION_CONFIRM_RESET = (13, 42)
    EDITING_IMAGE_OCCLUSION_DELETE = (13, 43)
    EDITING_IMAGE_OCCLUSION_DUPLICATE = (13, 44)
    EDITING_IMAGE_OCCLUSION_ELLIPSE_TOOL = (13, 45)
    EDITING_IMAGE_OCCLUSION_FILL_TOOL = (13, 46)
    EDITING_IMAGE_OCCLUSION_GROUP = (13, 47)
    EDITING_IMAGE_OCCLUSION_MODE = (13, 48)
    EDITING_IMAGE_OCCLUSION_POLYGON_TOOL = (13, 49)
    EDITING_IMAGE_OCCLUSION_RECTANGLE_TOOL = (13, 50)
    EDITING_IMAGE_OCCLUSION_RESET = (13, 51)
    EDITING_IMAGE_OCCLUSION_SELECT_ALL = (13, 52)
    EDITING_IMAGE_OCCLUSION_SELECT_TOOL = (13, 53)
    EDITING_IMAGE_OCCLUSION_TEXT_TOOL = (13, 54)
    EDITING_IMAGE_OCCLUSION_TOGGLE_MASK_EDITOR = (13, 55)
    EDITING_IMAGE_OCCLUSION_TOGGLE_TRANSLUCENT = (13, 56)
    EDITING_IMAGE_OCCLUSION_UNGROUP = (13, 57)
    EDITING_IMAGE_OCCLUSION_ZOOM_IN = (13, 58)
    EDITING_IMAGE_OCCLUSION_ZOOM_OUT = (13, 59)
    EDITING_IMAGE_OCCLUSION_ZOOM_RESET = (13, 60)
    EDITING_IMAGE_OCCLUSION_ZOOM_TOOL = (13, 61)
    EDITING_INDENT = (13, 62)
    EDITING_ITALIC_TEXT = (13, 63)
    EDITING_JUMP_TO_TAGS_WITH_CTRLANDSHIFTANDT = (13, 64)
    EDITING_JUSTIFY = (13, 65)
    EDITING_LATEX = (13, 66)
    EDITING_LATEX_EQUATION = (13, 67)
    EDITING_LATEX_MATH_ENV = (13, 68)
    EDITING_MATHJAX_BLOCK = (13, 69)
    EDITING_MATHJAX_CHEMISTRY = (13, 70)
    EDITING_MATHJAX_INLINE = (13, 71)
    EDITING_MATHJAX_PLACEHOLDER = (13, 72)
    EDITING_MATHJAX_PREVIEW = (13, 73)
    EDITING_MEDIA = (13, 74)
    EDITING_NO_IMAGE_FOUND_ON_CLIPBOARD = (13, 75)
    EDITING_OPEN_IMAGE = (13, 76)
    EDITING_ORDERED_LIST = (13, 77)
    EDITING_OUTDENT = (13, 78)
    EDITING_PASTE = (13, 79)
    EDITING_RECORD_AUDIO = (13, 80)
    EDITING_REMOVE_FORMATTING = (13, 81)
    EDITING_RESTORE_ORIGINAL_SIZE = (13, 82)
    EDITING_SELECT_REMOVE_FORMATTING = (13, 83)
    EDITING_SHOW_DUPLICATES = (13, 84)
    EDITING_SHOW_IN_FOLDER = (13, 85)
    EDITING_SHRINK_IMAGES = (13, 86)
    EDITING_SUBSCRIPT = (13, 87)
    EDITING_SUPERSCRIPT = (13, 88)
    EDITING_TAGS = (13, 89)
    EDITING_TAGS_ADD = (13, 90)
    EDITING_TAGS_COPY = (13, 91)
    EDITING_TAGS_REMOVE = (13, 92)
    EDITING_TAGS_SELECT_ALL = (13, 93)
    EDITING_TEXT_COLOR = (13, 94)
    EDITING_TEXT_HIGHLIGHT_COLOR = (13, 95)
    EDITING_TO_MAKE_A_CLOZE_DELETION_ON = (13, 96)
    EDITING_TOGGLE_HTML_EDITOR = (13, 97)
    EDITING_TOGGLE_STICKY = (13, 98)
    EDITING_TOGGLE_VISUAL_EDITOR = (13, 99)
    EDITING_UNDERLINE_TEXT = (13, 100)
    EDITING_UNORDERED_LIST = (13, 101)
    EDITING_WARNING_CLOZE_DELETIONS_WILL_NOT_WORK = (13, 102)
    EMPTY_CARDS_COUNT_LINE = (14, 0)
    EMPTY_CARDS_DELETE_BUTTON = (14, 1)
    EMPTY_CARDS_DELETE_EMPTY_CARDS = (14, 2)
    EMPTY_CARDS_DELETE_EMPTY_NOTES = (14, 3)
    EMPTY_CARDS_DELETED_COUNT = (14, 4)
    EMPTY_CARDS_DELETING = (14, 5)
    EMPTY_CARDS_FOR_NOTE_TYPE = (14, 6)
    EMPTY_CARDS_NOT_FOUND = (14, 7)
    EMPTY_CARDS_PRESERVE_NOTES_CHECKBOX = (14, 8)
    EMPTY_CARDS_WINDOW_TITLE = (14, 9)
    ERRORS_100_TAGS_MAX = (15, 0)
    ERRORS_ACCESSING_DB = (15, 1)
    ERRORS_ADDONS_ACTIVE_POPUP = (15, 2)
    ERRORS_BAD_DIRECTIVE = (15, 3)
    ERRORS_COLLECTION_TOO_NEW = (15, 4)
    ERRORS_COPIED_TO_CLIPBOARD = (15, 5)
    ERRORS_COPY_DEBUG_INFO_BUTTON = (15, 6)
    ERRORS_FILTERED_DECK_REQUIRED = (15, 7)
    ERRORS_FILTERED_PARENT_DECK = (15, 8)
    ERRORS_INCONSISTENT_DB_STATE = (15, 9)
    ERRORS_INVALID_IDS = (15, 10)
    ERRORS_INVALID_INPUT_DETAILS = (15, 11)
    ERRORS_INVALID_INPUT_EMPTY = (15, 12)
    ERRORS_MAY_BE_ADDON = (15, 13)
    ERRORS_MULTIPLE_NOTETYPES_SELECTED = (15, 14)
    ERRORS_OPTION_NOT_SET = (15, 15)
    ERRORS_PARSE_NUMBER_FAIL = (15, 16)
    ERRORS_PLEASE_CHECK_DATABASE = (15, 17)
    ERRORS_PLEASE_CHECK_MEDIA = (15, 18)
    ERRORS_STANDARD_POPUP = (15, 19)
    ERRORS_STANDARD_POPUP2 = (15, 20)
    ERRORS_TROUBLESHOOTING_BUTTON = (15, 21)
    ERRORS_UNABLE_OPEN_COLLECTION = (15, 22)
    ERRORS_WINDOWS_SSL_UPDATES = (15, 23)
    ERRORS_WINDOWS_TTS_RUNTIME_ERROR = (15, 24)
    EXPORTING_ALL_DECKS = (16, 0)
    EXPORTING_ANKI_20_DECK = (16, 1)
    EXPORTING_ANKI_COLLECTION_PACKAGE = (16, 2)
    EXPORTING_ANKI_DECK_PACKAGE = (16, 3)
    EXPORTING_CARD_EXPORTED = (16, 4)
    EXPORTING_CARDS_IN_PLAIN_TEXT = (16, 5)
    EXPORTING_COLLECTION = (16, 6)
    EXPORTING_COLLECTION_EXPORTED = (16, 7)
    EXPORTING_COLPKG_TOO_NEW = (16, 8)
    EXPORTING_COULDNT_SAVE_FILE = (16, 9)
    EXPORTING_EXPORT = (16, 10)
    EXPORTING_EXPORT_FORMAT = (16, 11)
    EXPORTING_EXPORTED_MEDIA_FILE = (16, 12)
    EXPORTING_EXPORTING_FILE = (16, 13)
    EXPORTING_INCLUDE = (16, 14)
    EXPORTING_INCLUDE_DECK = (16, 15)
    EXPORTING_INCLUDE_DECK_CONFIGS = (16, 16)
    EXPORTING_INCLUDE_GUID = (16, 17)
    EXPORTING_INCLUDE_HTML_AND_MEDIA_REFERENCES = (16, 18)
    EXPORTING_INCLUDE_MEDIA = (16, 19)
    EXPORTING_INCLUDE_NOTETYPE = (16, 20)
    EXPORTING_INCLUDE_SCHEDULING_INFORMATION = (16, 21)
    EXPORTING_INCLUDE_TAGS = (16, 22)
    EXPORTING_NOTE_EXPORTED = (16, 23)
    EXPORTING_NOTES_IN_PLAIN_TEXT = (16, 24)
    EXPORTING_PROCESSED_MEDIA_FILES = (16, 25)
    EXPORTING_SELECTED_NOTES = (16, 26)
    EXPORTING_SUPPORT_OLDER_ANKI_VERSIONS = (16, 27)
    FIELDS_ADD_FIELD = (17, 0)
    FIELDS_COLLAPSE_BY_DEFAULT = (17, 1)
    FIELDS_DELETE_FIELD_FROM = (17, 2)
    FIELDS_DESCRIPTION = (17, 3)
    FIELDS_DESCRIPTION_PLACEHOLDER = (17, 4)
    FIELDS_EDITING_FONT = (17, 5)
    FIELDS_EXCLUDE_FROM_SEARCH = (17, 6)
    FIELDS_FIELD = (17, 7)
    FIELDS_FIELD_IS_REQUIRED = (17, 8)
    FIELDS_FIELD_NAME = (17, 9)
    FIELDS_FIELDS_FOR = (17, 10)
    FIELDS_FONT = (17, 11)
    FIELDS_HTML_BY_DEFAULT = (17, 12)
    FIELDS_NAME_FIRST_LETTER_NOT_VALID = (17, 13)
    FIELDS_NAME_INVALID_LETTER = (17, 14)
    FIELDS_NEW_POSITION_1 = (17, 15)
    FIELDS_NOTES_REQUIRE_AT_LEAST_ONE_FIELD = (17, 16)
    FIELDS_REVERSE_TEXT_DIRECTION_RTL = (17, 17)
    FIELDS_SIZE = (17, 18)
    FIELDS_SORT_BY_THIS_FIELD_IN_THE = (17, 19)
    FIELDS_THAT_FIELD_NAME_IS_ALREADY_USED = (17, 20)
    FINDREPLACE_NOTES_UPDATED = (18, 0)
    HELP_FOR_MORE_INFO = (19, 0)
    HELP_NO_EXPLANATION = (19, 1)
    HELP_OK = (19, 2)
    HELP_OPEN_MANUAL_CHAPTER = (19, 3)
    IMPORTING_ABORTED = (20, 0)
    IMPORTING_ADDED = (20, 1)
    IMPORTING_ADDED_DUPLICATE_WITH_FIRST_FIELD = (20, 2)
    IMPORTING_ADDED_NEW_NOTE = (20, 3)
    IMPORTING_ALL_SUPPORTED_FORMATS = (20, 4)
    IMPORTING_ALLOW_HTML_IN_FIELDS = (20, 5)
    IMPORTING_ALLOW_HTML_IN_FIELDS_HELP = (20, 6)
    IMPORTING_ALSO_IMPORT_PROGRESS = (20, 7)
    IMPORTING_ANKI_FILES_ARE_FROM_A_VERY = (20, 8)
    IMPORTING_ANKI2_FILES_ARE_NOT_DIRECTLY_IMPORTABLE = (20, 9)
    IMPORTING_APPEARED_TWICE_IN_FILE = (20, 10)
    IMPORTING_BY_DEFAULT_ANKI_WILL_DETECT_THE = (20, 11)
    IMPORTING_CANNOT_MERGE_NOTETYPES_OF_DIFFERENT_KINDS = (20, 12)
    IMPORTING_CARDS_ADDED = (20, 13)
    IMPORTING_CHANGE = (20, 14)
    IMPORTING_COLON = (20, 15)
    IMPORTING_COMMA = (20, 16)
    IMPORTING_CONFLICTING_NOTES_SKIPPED = (20, 17)
    IMPORTING_CONFLICTING_NOTES_SKIPPED2 = (20, 18)
    IMPORTING_DECK_HELP = (20, 19)
    IMPORTING_DETAILS = (20, 20)
    IMPORTING_DUPLICATE = (20, 21)
    IMPORTING_DUPLICATE_NOTE_ADDED = (20, 22)
    IMPORTING_EMPTY_FIRST_FIELD = (20, 23)
    IMPORTING_EXISTING_NOTE_SKIPPED = (20, 24)
    IMPORTING_EXISTING_NOTES = (20, 25)
    IMPORTING_EXISTING_NOTES_HELP = (20, 26)
    IMPORTING_EXISTING_NOTES_SKIPPED = (20, 27)
    IMPORTING_EXTRACTING = (20, 28)
    IMPORTING_FAILED_DEBUG_INFO = (20, 29)
    IMPORTING_FAILED_TO_IMPORT_MEDIA_FILE = (20, 30)
    IMPORTING_FIELD_MAPPING = (20, 31)
    IMPORTING_FIELD_OF_FILE_IS = (20, 32)
    IMPORTING_FIELD_SEPARATOR = (20, 33)
    IMPORTING_FIELD_SEPARATOR_GUESSED = (20, 34)
    IMPORTING_FIELD_SEPARATOR_HELP = (20, 35)
    IMPORTING_FIELDS_SEPARATED_BY = (20, 36)
    IMPORTING_FILE = (20, 37)
    IMPORTING_FILE_EMPTY = (20, 38)
    IMPORTING_FILE_MUST_CONTAIN_FIELD_COLUMN = (20, 39)
    IMPORTING_FILE_VERSION_UNKNOWN_TRYING_IMPORT_ANYWAY = (20, 40)
    IMPORTING_FIRST_FIELD_MATCHED = (20, 41)
    IMPORTING_GATHERING = (20, 42)
    IMPORTING_IDENTICAL = (20, 43)
    IMPORTING_IGNORE_FIELD = (20, 44)
    IMPORTING_IGNORE_LINES_WHERE_FIRST_FIELD_MATCHES = (20, 45)
    IMPORTING_IGNORED = (20, 46)
    IMPORTING_IMPORT_EVEN_IF_EXISTING_NOTE_HAS = (20, 47)
    IMPORTING_IMPORT_LOG = (20, 48)
    IMPORTING_IMPORT_OPTIONS = (20, 49)
    IMPORTING_IMPORTING_COLLECTION = (20, 50)
    IMPORTING_IMPORTING_COMPLETE = (20, 51)
    IMPORTING_IMPORTING_FILE = (20, 52)
    IMPORTING_INCLUDE_REVIEWS = (20, 53)
    IMPORTING_INCLUDE_REVIEWS_HELP = (20, 54)
    IMPORTING_INVALID_FILE_PLEASE_RESTORE_FROM_BACKUP = (20, 55)
    IMPORTING_MAP_TO = (20, 56)
    IMPORTING_MAP_TO_TAGS = (20, 57)
    IMPORTING_MAPPED_TO = (20, 58)
    IMPORTING_MAPPED_TO_TAGS = (20, 59)
    IMPORTING_MATCH_SCOPE = (20, 60)
    IMPORTING_MATCH_SCOPE_HELP = (20, 61)
    IMPORTING_MERGE_NOTETYPES = (20, 62)
    IMPORTING_MERGE_NOTETYPES_HELP = (20, 63)
    IMPORTING_MNEMOSYNE_20_DECK_DB = (20, 64)
    IMPORTING_MULTICHARACTER_SEPARATORS_ARE_NOT_SUPPORTED_PLEASE = (20, 65)
    IMPORTING_NEW_DECK_WILL_BE_CREATED = (20, 66)
    IMPORTING_NO_NOTES_IN_FILE = (20, 67)
    IMPORTING_NOTE_ADDED = (20, 68)
    IMPORTING_NOTE_IMPORTED = (20, 69)
    IMPORTING_NOTE_SKIPPED_DUE_TO_EMPTY_FIRST_FIELD = (20, 70)
    IMPORTING_NOTE_SKIPPED_DUE_TO_MISSING_DECK = (20, 71)
    IMPORTING_NOTE_SKIPPED_DUE_TO_MISSING_NOTETYPE = (20, 72)
    IMPORTING_NOTE_SKIPPED_UPDATE_DUE_TO_NOTETYPE = (20, 73)
    IMPORTING_NOTE_SKIPPED_UPDATE_DUE_TO_NOTETYPE2 = (20, 74)
    IMPORTING_NOTE_UNCHANGED = (20, 75)
    IMPORTING_NOTE_UPDATED = (20, 76)
    IMPORTING_NOTE_UPDATED_AS_FILE_HAD_NEWER = (20, 77)
    IMPORTING_NOTES_ADDED = (20, 78)
    IMPORTING_NOTES_ADDED_FROM_FILE = (20, 79)
    IMPORTING_NOTES_FAILED = (20, 80)
    IMPORTING_NOTES_FOUND_IN_FILE = (20, 81)
    IMPORTING_NOTES_FOUND_IN_FILE2 = (20, 82)
    IMPORTING_NOTES_SKIPPED_AS_THEYRE_ALREADY_IN = (20, 83)
    IMPORTING_NOTES_SKIPPED_UPDATE_DUE_TO_NOTETYPE = (20, 84)
    IMPORTING_NOTES_THAT_COULD_NOT_BE_IMPORTED = (20, 85)
    IMPORTING_NOTES_UPDATED = (20, 86)
    IMPORTING_NOTES_UPDATED_AS_FILE_HAD_NEWER = (20, 87)
    IMPORTING_NOTETYPE_AND_DECK = (20, 88)
    IMPORTING_NOTETYPE_HELP = (20, 89)
    IMPORTING_OVERVIEW = (20, 90)
    IMPORTING_PACKAGED_ANKI_DECKCOLLECTION_APKG_COLPKG_ZIP = (20, 91)
    IMPORTING_PAUKER_18_LESSON_PAUGZ = (20, 92)
    IMPORTING_PIPE = (20, 93)
    IMPORTING_PRESERVE = (20, 94)
    IMPORTING_PREVIEW_TRUNCATED = (20, 95)
    IMPORTING_PROCESSED_CARDS = (20, 96)
    IMPORTING_PROCESSED_MEDIA_FILE = (20, 97)
    IMPORTING_PROCESSED_NOTES = (20, 98)
    IMPORTING_ROWS_HAD_NUM1D_FIELDS_EXPECTED_NUM2D = (20, 99)
    IMPORTING_SELECTED_FILE_WAS_NOT_IN_UTF8 = (20, 100)
    IMPORTING_SEMICOLON = (20, 101)
    IMPORTING_SHOW = (20, 102)
    IMPORTING_SKIPPED = (20, 103)
    IMPORTING_STATUS = (20, 104)
    IMPORTING_SUPERMEMO_XML_EXPORT_XML = (20, 105)
    IMPORTING_TAB = (20, 106)
    IMPORTING_TAG_ALL_NOTES = (20, 107)
    IMPORTING_TAG_ALL_NOTES_HELP = (20, 108)
    IMPORTING_TAG_MODIFIED_NOTES = (20, 109)
    IMPORTING_TAG_UPDATED_NOTES = (20, 110)
    IMPORTING_TAG_UPDATED_NOTES_HELP = (20, 111)
    IMPORTING_TEXT_SEPARATED_BY_TABS_OR_SEMICOLONS = (20, 112)
    IMPORTING_THE_FIRST_FIELD_OF_THE_NOTE = (20, 113)
    IMPORTING_THE_PROVIDED_FILE_IS_NOT_A = (20, 114)
    IMPORTING_THIS_FILE_DOES_NOT_APPEAR_TO = (20, 115)
    IMPORTING_THIS_WILL_DELETE_YOUR_EXISTING_COLLECTION = (20, 116)
    IMPORTING_UNABLE_TO_IMPORT_FILENAME = (20, 117)
    IMPORTING_UNABLE_TO_IMPORT_FROM_A_READONLY = (20, 118)
    IMPORTING_UNKNOWN_FILE_FORMAT = (20, 119)
    IMPORTING_UPDATE = (20, 120)
    IMPORTING_UPDATE_ALWAYS = (20, 121)
    IMPORTING_UPDATE_EXISTING_NOTES_WHEN_FIRST_FIELD = (20, 122)
    IMPORTING_UPDATE_IF_NEWER = (20, 123)
    IMPORTING_UPDATE_NEVER = (20, 124)
    IMPORTING_UPDATE_NOTES = (20, 125)
    IMPORTING_UPDATE_NOTES_HELP = (20, 126)
    IMPORTING_UPDATE_NOTETYPES = (20, 127)
    IMPORTING_UPDATE_NOTETYPES_HELP = (20, 128)
    IMPORTING_UPDATED = (20, 129)
    IMPORTING_UPDATES = (20, 130)
    IMPORTING_WITH_DECK_CONFIGS = (20, 131)
    IMPORTING_WITH_DECK_CONFIGS_HELP = (20, 132)
    KEYBOARD_CTRL = (21, 0)
    KEYBOARD_SHIFT = (21, 1)
    MEDIA_ERROR_EXECUTING = (22, 0)
    MEDIA_ERROR_RUNNING = (22, 1)
    MEDIA_FOR_SECURITY_REASONS_IS_NOT = (22, 2)
    MEDIA_GENERATED_FILE = (22, 3)
    MEDIA_HAVE_YOU_INSTALLED_LATEX_AND_DVIPNGDVISVGM = (22, 4)
    MEDIA_RECORDINGTIME = (22, 5)
    MEDIA_SOUND_AND_VIDEO_ON_CARDS_WILL = (22, 6)
    MEDIA_CHECK_ADD_TAG = (23, 0)
    MEDIA_CHECK_ALL_LATEX_RENDERED = (23, 1)
    MEDIA_CHECK_CHECK_MEDIA_ACTION = (23, 2)
    MEDIA_CHECK_CHECKED = (23, 3)
    MEDIA_CHECK_DELETE_UNUSED = (23, 4)
    MEDIA_CHECK_DELETE_UNUSED_COMPLETE = (23, 5)
    MEDIA_CHECK_DELETE_UNUSED_CONFIRM = (23, 6)
    MEDIA_CHECK_EMPTY_TRASH = (23, 7)
    MEDIA_CHECK_EXTRACTED_COUNT = (23, 8)
    MEDIA_CHECK_FILES_REMAINING = (23, 9)
    MEDIA_CHECK_MISSING_COUNT = (23, 10)
    MEDIA_CHECK_MISSING_FILE = (23, 11)
    MEDIA_CHECK_MISSING_HEADER = (23, 12)
    MEDIA_CHECK_MISSING_MEDIA_TAG = (23, 13)
    MEDIA_CHECK_NOTETYPE_TEMPLATE = (23, 14)
    MEDIA_CHECK_OVERSIZE_COUNT = (23, 15)
    MEDIA_CHECK_OVERSIZE_FILE = (23, 16)
    MEDIA_CHECK_OVERSIZE_HEADER = (23, 17)
    MEDIA_CHECK_RENAMED_COUNT = (23, 18)
    MEDIA_CHECK_RENAMED_FILE = (23, 19)
    MEDIA_CHECK_RENAMED_HEADER = (23, 20)
    MEDIA_CHECK_RENDER_LATEX = (23, 21)
    MEDIA_CHECK_RESTORE_TRASH = (23, 22)
    MEDIA_CHECK_SUBFOLDER_COUNT = (23, 23)
    MEDIA_CHECK_SUBFOLDER_FILE = (23, 24)
    MEDIA_CHECK_SUBFOLDER_HEADER = (23, 25)
    MEDIA_CHECK_TEMPLATE_REFERENCES_FIELD_HEADER = (23, 26)
    MEDIA_CHECK_TRASH_COUNT = (23, 27)
    MEDIA_CHECK_TRASH_EMPTIED = (23, 28)
    MEDIA_CHECK_TRASH_RESTORED = (23, 29)
    MEDIA_CHECK_UNUSED_COUNT = (23, 30)
    MEDIA_CHECK_UNUSED_FILE = (23, 31)
    MEDIA_CHECK_UNUSED_HEADER = (23, 32)
    MEDIA_CHECK_WINDOW_TITLE = (23, 33)
    NETWORK_DETAILS = (24, 0)
    NETWORK_OFFLINE = (24, 1)
    NETWORK_OTHER = (24, 2)
    NETWORK_PROXY_AUTH = (24, 3)
    NETWORK_TIMEOUT = (24, 4)
    NOTETYPE_ERROR_NO_IMAGE_TO_SHOW = (25, 0)
    NOTETYPES_ADD = (25, 1)
    NOTETYPES_ADD_NOTE_TYPE = (25, 2)
    NOTETYPES_ADD_REVERSE_FIELD = (25, 3)
    NOTETYPES_BACK_EXTRA_FIELD = (25, 4)
    NOTETYPES_BACK_FIELD = (25, 5)
    NOTETYPES_BASIC_NAME = (25, 6)
    NOTETYPES_BASIC_OPTIONAL_REVERSED_NAME = (25, 7)
    NOTETYPES_BASIC_REVERSED_NAME = (25, 8)
    NOTETYPES_BASIC_TYPE_ANSWER_NAME = (25, 9)
    NOTETYPES_CARD_1_NAME = (25, 10)
    NOTETYPES_CARD_2_NAME = (25, 11)
    NOTETYPES_CARDS = (25, 12)
    NOTETYPES_CLONE = (25, 13)
    NOTETYPES_CLOZE_NAME = (25, 14)
    NOTETYPES_COMMENTS_FIELD = (25, 15)
    NOTETYPES_COPY = (25, 16)
    NOTETYPES_CREATE_SCALABLE_IMAGES_WITH_DVISVGM = (25, 17)
    NOTETYPES_DELETE_THIS_NOTE_TYPE_AND_ALL = (25, 18)
    NOTETYPES_DELETE_THIS_UNUSED_NOTE_TYPE = (25, 19)
    NOTETYPES_ERROR_GENERATING_CLOZE = (25, 20)
    NOTETYPES_ERROR_GETTING_IMAGECLOZE = (25, 21)
    NOTETYPES_ERROR_LOADING_IMAGE_OCCLUSION = (25, 22)
    NOTETYPES_FIELDS = (25, 23)
    NOTETYPES_FOOTER = (25, 24)
    NOTETYPES_FRONT_FIELD = (25, 25)
    NOTETYPES_HEADER = (25, 26)
    NOTETYPES_HIDE_ALL_GUESS_ONE = (25, 27)
    NOTETYPES_HIDE_ONE_GUESS_ONE = (25, 28)
    NOTETYPES_IMAGE = (25, 29)
    NOTETYPES_IMAGE_OCCLUSION_NAME = (25, 30)
    NOTETYPES_IO_PASTE_IMAGE_FROM_CLIPBOARD = (25, 31)
    NOTETYPES_IO_SELECT_IMAGE = (25, 32)
    NOTETYPES_NO_OCCLUSION_CREATED = (25, 33)
    NOTETYPES_NO_OCCLUSION_CREATED2 = (25, 34)
    NOTETYPES_NOTE_TYPES = (25, 35)
    NOTETYPES_NOTETYPE = (25, 36)
    NOTETYPES_OCCLUSION = (25, 37)
    NOTETYPES_OCCLUSION_MASK = (25, 38)
    NOTETYPES_OCCLUSION_NOTE = (25, 39)
    NOTETYPES_OPTIONS = (25, 40)
    NOTETYPES_PLEASE_ADD_ANOTHER_NOTE_TYPE_FIRST = (25, 41)
    NOTETYPES_TEXT_FIELD = (25, 42)
    NOTETYPES_TOGGLE_MASKS = (25, 43)
    NOTETYPES_TYPE = (25, 44)
    PREFERENCES_ACCOUNT = (26, 0)
    PREFERENCES_ALWAYS = (26, 1)
    PREFERENCES_ANKIHUB_INTRO = (26, 2)
    PREFERENCES_ANKIHUB_NOT_LOGGED_IN = (26, 3)
    PREFERENCES_ANKIWEB_INTRO = (26, 4)
    PREFERENCES_ANSWER_KEYS = (26, 5)
    PREFERENCES_APPEARANCE = (26, 6)
    PREFERENCES_AUTOMATICALLY_SYNC_ON_PROFILE_OPENCLOSE = (26, 7)
    PREFERENCES_BACKUP_EXPLANATION = (26, 8)
    PREFERENCES_BACKUPS = (26, 9)
    PREFERENCES_BASIC = (26, 10)
    PREFERENCES_BROWSING = (26, 11)
    PREFERENCES_CHANGE_DECK_DEPENDING_ON_NOTE_TYPE = (26, 12)
    PREFERENCES_CHANGES_WILL_TAKE_EFFECT_WHEN_YOU = (26, 13)
    PREFERENCES_CHECK_FOR_UPDATES = (26, 14)
    PREFERENCES_CUSTOM_SYNC_URL = (26, 15)
    PREFERENCES_CUSTOM_SYNC_URL_DISCLAIMER = (26, 16)
    PREFERENCES_DAILY_BACKUPS = (26, 17)
    PREFERENCES_DEFAULT_DECK = (26, 18)
    PREFERENCES_DEFAULT_SEARCH_TEXT = (26, 19)
    PREFERENCES_DEFAULT_SEARCH_TEXT_EXAMPLE = (26, 20)
    PREFERENCES_DISTRACTIONS = (26, 21)
    PREFERENCES_EDITING = (26, 22)
    PREFERENCES_FULL_SCREEN_ONLY = (26, 23)
    PREFERENCES_GENERAL = (26, 24)
    PREFERENCES_GENERATE_LATEX_IMAGES_AUTOMATICALLY = (26, 25)
    PREFERENCES_HIDE_BOTTOM_BAR_DURING_REVIEW = (26, 26)
    PREFERENCES_HIDE_TOP_BAR_DURING_REVIEW = (26, 27)
    PREFERENCES_HOURS_PAST_MIDNIGHT = (26, 28)
    PREFERENCES_IGNORE_ACCENTS_IN_SEARCH = (26, 29)
    PREFERENCES_IMPORT_EXPORT = (26, 30)
    PREFERENCES_INTERRUPT_CURRENT_AUDIO_WHEN_ANSWERING = (26, 31)
    PREFERENCES_LANGUAGE = (26, 32)
    PREFERENCES_LATEX_GENERATION_DISABLED = (26, 33)
    PREFERENCES_LEARN_AHEAD_LIMIT = (26, 34)
    PREFERENCES_LEGACY_TIMEZONE_HANDLING = (26, 35)
    PREFERENCES_LOGIN_SUCCESSFUL_SYNC_NOW = (26, 36)
    PREFERENCES_MEDIA = (26, 37)
    PREFERENCES_MEDIA_IS_NOT_BACKED_UP = (26, 38)
    PREFERENCES_MINIMALIST_MODE = (26, 39)
    PREFERENCES_MINIMALIST_MODE_TOOLTIP = (26, 40)
    PREFERENCES_MINS = (26, 41)
    PREFERENCES_MINUTES_BETWEEN_BACKUPS = (26, 42)
    PREFERENCES_MONTHLY_BACKUPS = (26, 43)
    PREFERENCES_NETWORK = (26, 44)
    PREFERENCES_NETWORK_TIMEOUT = (26, 45)
    PREFERENCES_NEXT_DAY_STARTS_AT = (26, 46)
    PREFERENCES_NOT_LOGGED_IN = (26, 47)
    PREFERENCES_NOTE = (26, 48)
    PREFERENCES_ON_NEXT_SYNC_FORCE_CHANGES_IN = (26, 49)
    PREFERENCES_PASTE_CLIPBOARD_IMAGES_AS_PNG = (26, 50)
    PREFERENCES_PASTE_WITHOUT_SHIFT_KEY_STRIPS_FORMATTING = (26, 51)
    PREFERENCES_PERIODICALLY_SYNC_MEDIA = (26, 52)
    PREFERENCES_PLEASE_RESTART_ANKI_TO_COMPLETE_LANGUAGE = (26, 53)
    PREFERENCES_PREFERENCES = (26, 54)
    PREFERENCES_REDUCE_MOTION = (26, 55)
    PREFERENCES_REDUCE_MOTION_TOOLTIP = (26, 56)
    PREFERENCES_RESET_WINDOW_SIZES = (26, 57)
    PREFERENCES_RESET_WINDOW_SIZES_COMPLETE = (26, 58)
    PREFERENCES_REVIEW = (26, 59)
    PREFERENCES_REVIEWER = (26, 60)
    PREFERENCES_SCHEDULER = (26, 61)
    PREFERENCES_SCHEDULING = (26, 62)
    PREFERENCES_SHORTCUT_PLACEHOLDER = (26, 63)
    PREFERENCES_SHOW_LEARNING_CARDS_WITH_LARGER_STEPS = (26, 64)
    PREFERENCES_SHOW_NEXT_REVIEW_TIME_ABOVE_ANSWER = (26, 65)
    PREFERENCES_SHOW_PLAY_BUTTONS_ON_CARDS_WITH = (26, 66)
    PREFERENCES_SHOW_REMAINING_CARD_COUNT = (26, 67)
    PREFERENCES_SOME_SETTINGS_WILL_TAKE_EFFECT_AFTER = (26, 68)
    PREFERENCES_SPACEBAR_RATES_CARD = (26, 69)
    PREFERENCES_STYLE = (26, 70)
    PREFERENCES_SYNCHRONIZE_AUDIO_AND_IMAGES_TOO = (26, 71)
    PREFERENCES_TAB_SYNCHRONISATION = (26, 72)
    PREFERENCES_THEME = (26, 73)
    PREFERENCES_THEME_DARK = (26, 74)
    PREFERENCES_THEME_FOLLOW_SYSTEM = (26, 75)
    PREFERENCES_THEME_LIGHT = (26, 76)
    PREFERENCES_THIRD_PARTY_DESCRIPTION = (26, 77)
    PREFERENCES_THIRD_PARTY_SERVICES = (26, 78)
    PREFERENCES_TIMEBOX_TIME_LIMIT = (26, 79)
    PREFERENCES_URL_SCHEME_ALLOW_ONCE = (26, 80)
    PREFERENCES_URL_SCHEME_ALWAYS_ALLOW = (26, 81)
    PREFERENCES_URL_SCHEME_PROMPT = (26, 82)
    PREFERENCES_URL_SCHEME_WARNING = (26, 83)
    PREFERENCES_URL_SCHEMES = (26, 84)
    PREFERENCES_USER_INTERFACE = (26, 85)
    PREFERENCES_USER_INTERFACE_SIZE = (26, 86)
    PREFERENCES_V3_SCHEDULER = (26, 87)
    PREFERENCES_VIDEO_DRIVER = (26, 88)
    PREFERENCES_VIDEO_DRIVER_ANGLE = (26, 89)
    PREFERENCES_VIDEO_DRIVER_DEFAULT = (26, 90)
    PREFERENCES_VIDEO_DRIVER_OPENGL_MAC = (26, 91)
    PREFERENCES_VIDEO_DRIVER_OPENGL_OTHER = (26, 92)
    PREFERENCES_VIDEO_DRIVER_SOFTWARE_MAC = (26, 93)
    PREFERENCES_VIDEO_DRIVER_SOFTWARE_OTHER = (26, 94)
    PREFERENCES_WEEKLY_BACKUPS = (26, 95)
    PREFERENCES_WHEN_ADDING_DEFAULT_TO_CURRENT_DECK = (26, 96)
    PREFERENCES_YOU_CAN_RESTORE_BACKUPS_VIA_FILESWITCH = (26, 97)
    PROFILES_ANKI_COULD_NOT_READ_YOUR_PROFILE = (27, 0)
    PROFILES_ANKI_COULD_NOT_RENAME_YOUR_PROFILE = (27, 1)
    PROFILES_BACKUP_CREATED = (27, 2)
    PROFILES_BACKUP_CREATION_FAILED = (27, 3)
    PROFILES_BACKUP_UNCHANGED = (27, 4)
    PROFILES_CONFIRM_LANG_CHOICE = (27, 5)
    PROFILES_COULD_NOT_CREATE_DATA_FOLDER = (27, 6)
    PROFILES_CREATING_BACKUP = (27, 7)
    PROFILES_DOWNGRADE_AND_QUIT = (27, 8)
    PROFILES_FOLDER_ALREADY_EXISTS = (27, 9)
    PROFILES_FOLDER_README = (27, 10)
    PROFILES_OPEN = (27, 11)
    PROFILES_OPEN_BACKUP = (27, 12)
    PROFILES_PLEASE_REMOVE_THE_FOLDER_AND = (27, 13)
    PROFILES_PREFS_CORRUPT_TITLE = (27, 14)
    PROFILES_PREFS_FILE_IS_CORRUPT = (27, 15)
    PROFILES_PROFILE_CORRUPT = (27, 16)
    PROFILES_PROFILE_DOES_NOT_EXIST = (27, 17)
    PROFILES_PROFILES = (27, 18)
    PROFILES_QUIT = (27, 19)
    PROFILES_USER_1 = (27, 20)
    QT_ACCEL_ABOUT = (28, 0)
    QT_ACCEL_ABOUT_MAC = (28, 1)
    QT_ACCEL_CARDS = (28, 2)
    QT_ACCEL_CHECK_DATABASE = (28, 3)
    QT_ACCEL_CHECK_MEDIA = (28, 4)
    QT_ACCEL_CREATE_BACKUP = (28, 5)
    QT_ACCEL_EDIT = (28, 6)
    QT_ACCEL_EXIT = (28, 7)
    QT_ACCEL_EXPORT = (28, 8)
    QT_ACCEL_EXPORT_NOTES = (28, 9)
    QT_ACCEL_FILE = (28, 10)
    QT_ACCEL_FILTER = (28, 11)
    QT_ACCEL_FIND = (28, 12)
    QT_ACCEL_FIND_AND_REPLACE = (28, 13)
    QT_ACCEL_FIND_DUPLICATES = (28, 14)
    QT_ACCEL_FORGET = (28, 15)
    QT_ACCEL_FULL_SCREEN = (28, 16)
    QT_ACCEL_GO = (28, 17)
    QT_ACCEL_GUIDE = (28, 18)
    QT_ACCEL_HELP = (28, 19)
    QT_ACCEL_IMPORT = (28, 20)
    QT_ACCEL_INFO = (28, 21)
    QT_ACCEL_INVERT_SELECTION = (28, 22)
    QT_ACCEL_LAYOUT = (28, 23)
    QT_ACCEL_LAYOUT_AUTO = (28, 24)
    QT_ACCEL_LAYOUT_HORIZONTAL = (28, 25)
    QT_ACCEL_LAYOUT_VERTICAL = (28, 26)
    QT_ACCEL_LOAD_BACKUP = (28, 27)
    QT_ACCEL_NEXT_CARD = (28, 28)
    QT_ACCEL_NOTE = (28, 29)
    QT_ACCEL_NOTES = (28, 30)
    QT_ACCEL_PREFERENCES = (28, 31)
    QT_ACCEL_PREVIOUS_CARD = (28, 32)
    QT_ACCEL_REDO = (28, 33)
    QT_ACCEL_RESET_ZOOM = (28, 34)
    QT_ACCEL_SELECT_ALL = (28, 35)
    QT_ACCEL_SELECT_NOTES = (28, 36)
    QT_ACCEL_SET_DUE_DATE = (28, 37)
    QT_ACCEL_SUPPORT_ANKI = (28, 38)
    QT_ACCEL_SWITCH_PROFILE = (28, 39)
    QT_ACCEL_TOGGLE_SIDEBAR = (28, 40)
    QT_ACCEL_TOOLS = (28, 41)
    QT_ACCEL_UNDO = (28, 42)
    QT_ACCEL_UPGRADE_DOWNGRADE = (28, 43)
    QT_ACCEL_VIEW = (28, 44)
    QT_ACCEL_ZOOM_EDITOR_IN = (28, 45)
    QT_ACCEL_ZOOM_EDITOR_OUT = (28, 46)
    QT_ACCEL_ZOOM_IN = (28, 47)
    QT_ACCEL_ZOOM_OUT = (28, 48)
    QT_MISC_ADDON_WILL_BE_INSTALLED_WHEN_A = (29, 0)
    QT_MISC_ADDONS = (29, 1)
    QT_MISC_ALL_CARDS_NOTES_AND_MEDIA_FOR = (29, 2)
    QT_MISC_ALL_CARDS_NOTES_AND_MEDIA_FOR2 = (29, 3)
    QT_MISC_ANKI_IS_RUNNING = (29, 4)
    QT_MISC_ANKI_UPDATEDANKI_HAS_BEEN_RELEASED = (29, 5)
    QT_MISC_AUTOMATIC_SYNCING_AND_BACKUPS_HAVE_BEEN = (29, 6)
    QT_MISC_BACK_SIDE_ONLY = (29, 7)
    QT_MISC_BACKING_UP = (29, 8)
    QT_MISC_BROWSE = (29, 9)
    QT_MISC_CHANGE_NOTE_TYPE_CTRLANDN = (29, 10)
    QT_MISC_CHECK_THE_FILES_IN_THE_MEDIA = (29, 11)
    QT_MISC_CHOOSE_DECK = (29, 12)
    QT_MISC_CHOOSE_NOTE_TYPE = (29, 13)
    QT_MISC_CLOSING = (29, 14)
    QT_MISC_CONFIGURE_INTERFACE_LANGUAGE_AND_OPTIONS = (29, 15)
    QT_MISC_COPY_TO_CLIPBOARD = (29, 16)
    QT_MISC_CREATE_FILTERED_DECK = (29, 17)
    QT_MISC_DEBUG_CONSOLE = (29, 18)
    QT_MISC_DECK_WILL_BE_IMPORTED_WHEN_A = (29, 19)
    QT_MISC_EMPTY_CARDS = (29, 20)
    QT_MISC_ERROR = (29, 21)
    QT_MISC_ERROR_DURING_STARTUP = (29, 22)
    QT_MISC_ERROR_LOADING_GRAPHICS_DRIVER = (29, 23)
    QT_MISC_IF_INSTANCE_IS_NOT_RESPONDING = (29, 24)
    QT_MISC_IGNORE_THIS_UPDATE = (29, 25)
    QT_MISC_IN_ORDER_TO_ENSURE_YOUR_COLLECTION = (29, 26)
    QT_MISC_INCOMPATIBLE_VIDEO_DRIVER = (29, 27)
    QT_MISC_INVALID_PROPERTY_FOUND_ON_CARD_PLEASE = (29, 28)
    QT_MISC_LAYOUT_AUTO_ENABLED = (29, 29)
    QT_MISC_LAYOUT_HORIZONTAL_ENABLED = (29, 30)
    QT_MISC_LAYOUT_VERTICAL_ENABLED = (29, 31)
    QT_MISC_LOADING = (29, 32)
    QT_MISC_MANAGE = (29, 33)
    QT_MISC_MANAGE_NOTE_TYPES = (29, 34)
    QT_MISC_NAME_EXISTS = (29, 35)
    QT_MISC_NO_TEMP_FOLDER = (29, 36)
    QT_MISC_NON_UNICODE_TEXT = (29, 37)
    QT_MISC_OPEN_ANKI_LAUNCHER = (29, 38)
    QT_MISC_OPTIMIZING = (29, 39)
    QT_MISC_PLEASE_ENSURE_A_PROFILE_IS_OPEN = (29, 40)
    QT_MISC_PLEASE_SELECT_1_CARD = (29, 41)
    QT_MISC_PLEASE_SELECT_A_DECK = (29, 42)
    QT_MISC_PLEASE_USE_FILEIMPORT_TO_IMPORT_THIS = (29, 43)
    QT_MISC_PROCESSING = (29, 44)
    QT_MISC_REPLACE_YOUR_COLLECTION_WITH_AN_EARLIER = (29, 45)
    QT_MISC_REPLACE_YOUR_COLLECTION_WITH_AN_EARLIER2 = (29, 46)
    QT_MISC_REVERT_TO_BACKUP = (29, 47)
    QT_MISC_SECOND = (29, 48)
    QT_MISC_SEGOE_UI = (29, 49)
    QT_MISC_SHIFT_KEY_WAS_HELD_DOWN_SKIPPING = (29, 50)
    QT_MISC_SHORTCUT_KEY_LEFT_ARROW = (29, 51)
    QT_MISC_SHORTCUT_KEY_RIGHT_ARROW_OR_ENTER = (29, 52)
    QT_MISC_STATS = (29, 53)
    QT_MISC_STUDY_DECK = (29, 54)
    QT_MISC_SYNC = (29, 55)
    QT_MISC_TARGET_DECK_CTRLANDD = (29, 56)
    QT_MISC_THE_FOLLOWING_CHARACTER_CAN_NOT_BE = (29, 57)
    QT_MISC_THE_REQUESTED_CHANGE_WILL_REQUIRE_A = (29, 58)
    QT_MISC_THERE_MUST_BE_AT_LEAST_ONE = (29, 59)
    QT_MISC_THIS_FILE_EXISTS_ARE_YOU_SURE = (29, 60)
    QT_MISC_UNABLE_TO_ACCESS_ANKI_MEDIA_FOLDER = (29, 61)
    QT_MISC_UNABLE_TO_RECORD = (29, 62)
    QT_MISC_UNEXPECTED_RESPONSE_CODE = (29, 63)
    QT_MISC_WOULD_YOU_LIKE_TO_DOWNLOAD_IT = (29, 64)
    QT_MISC_YOUR_COLLECTION_FILE_APPEARS_TO_BE = (29, 65)
    QT_MISC_YOUR_COMPUTERS_STORAGE_MAY_BE_FULL = (29, 66)
    QT_MISC_YOUR_FIREWALL_OR_ANTIVIRUS_PROGRAM_IS = (29, 67)
    SCHEDULING_ALWAYS_INCLUDE_QUESTION_SIDE_WHEN_REPLAYING = (30, 0)
    SCHEDULING_ANSWER_BUTTON_TIME_DAYS = (30, 1)
    SCHEDULING_ANSWER_BUTTON_TIME_HOURS = (30, 2)
    SCHEDULING_ANSWER_BUTTON_TIME_MINUTES = (30, 3)
    SCHEDULING_ANSWER_BUTTON_TIME_MONTHS = (30, 4)
    SCHEDULING_ANSWER_BUTTON_TIME_SECONDS = (30, 5)
    SCHEDULING_ANSWER_BUTTON_TIME_YEARS = (30, 6)
    SCHEDULING_AT_LEAST_ONE_STEP_IS_REQUIRED = (30, 7)
    SCHEDULING_AUTOMATICALLY_PLAY_AUDIO = (30, 8)
    SCHEDULING_BURIED_CARDS_FOUND = (30, 9)
    SCHEDULING_BURY_RELATED_NEW_CARDS_UNTIL_THE = (30, 10)
    SCHEDULING_BURY_RELATED_REVIEWS_UNTIL_THE_NEXT = (30, 11)
    SCHEDULING_CONGRATULATIONS_FINISHED = (30, 12)
    SCHEDULING_CUSTOM_STUDY = (30, 13)
    SCHEDULING_DAYS = (30, 14)
    SCHEDULING_DECK_UPDATED = (30, 15)
    SCHEDULING_DESCRIPTION = (30, 16)
    SCHEDULING_EASY_BONUS = (30, 17)
    SCHEDULING_EASY_INTERVAL = (30, 18)
    SCHEDULING_END = (30, 19)
    SCHEDULING_FORGOT_CARDS = (30, 20)
    SCHEDULING_GENERAL = (30, 21)
    SCHEDULING_GRADED_CARDS_DONE = (30, 22)
    SCHEDULING_GRADUATING_INTERVAL = (30, 23)
    SCHEDULING_HARD_INTERVAL = (30, 24)
    SCHEDULING_HOW_TO_CUSTOM_STUDY = (30, 25)
    SCHEDULING_IGNORE_ANSWER_TIMES_LONGER_THAN = (30, 26)
    SCHEDULING_INTERVAL_MODIFIER = (30, 27)
    SCHEDULING_LAPSES = (30, 28)
    SCHEDULING_LAPSES2 = (30, 29)
    SCHEDULING_LEARN_REMAINING = (30, 30)
    SCHEDULING_LEARNING = (30, 31)
    SCHEDULING_LEECH_ACTION = (30, 32)
    SCHEDULING_LEECH_THRESHOLD = (30, 33)
    SCHEDULING_MAXIMUM_INTERVAL = (30, 34)
    SCHEDULING_MAXIMUM_REVIEWSDAY = (30, 35)
    SCHEDULING_MINIMUM_INTERVAL = (30, 36)
    SCHEDULING_MIX_NEW_CARDS_AND_REVIEWS = (30, 37)
    SCHEDULING_NEW_CARDS = (30, 38)
    SCHEDULING_NEW_CARDSDAY = (30, 39)
    SCHEDULING_NEW_INTERVAL = (30, 40)
    SCHEDULING_NEW_OPTIONS_GROUP_NAME = (30, 41)
    SCHEDULING_NEXT_LEARN_DUE = (30, 42)
    SCHEDULING_OPTIONS_GROUP = (30, 43)
    SCHEDULING_ORDER = (30, 44)
    SCHEDULING_PARENT_LIMIT = (30, 45)
    SCHEDULING_RESET_COUNTS = (30, 46)
    SCHEDULING_RESTORE_POSITION = (30, 47)
    SCHEDULING_REVIEW = (30, 48)
    SCHEDULING_REVIEWS = (30, 49)
    SCHEDULING_SECONDS = (30, 50)
    SCHEDULING_SET_ALL_DECKS_BELOW_TO = (30, 51)
    SCHEDULING_SET_DUE_DATE_DONE = (30, 52)
    SCHEDULING_SET_DUE_DATE_PROMPT = (30, 53)
    SCHEDULING_SET_DUE_DATE_PROMPT_HINT = (30, 54)
    SCHEDULING_SET_FOR_ALL_SUBDECKS = (30, 55)
    SCHEDULING_SHOW_ANSWER_TIMER = (30, 56)
    SCHEDULING_SHOW_NEW_CARDS_AFTER_REVIEWS = (30, 57)
    SCHEDULING_SHOW_NEW_CARDS_BEFORE_REVIEWS = (30, 58)
    SCHEDULING_SHOW_NEW_CARDS_IN_ORDER_ADDED = (30, 59)
    SCHEDULING_SHOW_NEW_CARDS_IN_RANDOM_ORDER = (30, 60)
    SCHEDULING_STARTING_EASE = (30, 61)
    SCHEDULING_STEPS_IN_MINUTES = (30, 62)
    SCHEDULING_STEPS_MUST_BE_NUMBERS = (30, 63)
    SCHEDULING_TAG_ONLY = (30, 64)
    SCHEDULING_THE_DEFAULT_CONFIGURATION_CANT_BE_REMOVED = (30, 65)
    SCHEDULING_TIME_SPAN_DAYS = (30, 66)
    SCHEDULING_TIME_SPAN_HOURS = (30, 67)
    SCHEDULING_TIME_SPAN_MINUTES = (30, 68)
    SCHEDULING_TIME_SPAN_MONTHS = (30, 69)
    SCHEDULING_TIME_SPAN_SECONDS = (30, 70)
    SCHEDULING_TIME_SPAN_YEARS = (30, 71)
    SCHEDULING_TODAY_NEW_LIMIT_REACHED = (30, 72)
    SCHEDULING_TODAY_REVIEW_LIMIT_REACHED = (30, 73)
    SCHEDULING_UNBURY_THEM = (30, 74)
    SCHEDULING_UPDATE_BUTTON = (30, 75)
    SCHEDULING_UPDATE_DONE = (30, 76)
    SCHEDULING_UPDATE_LATER_BUTTON = (30, 77)
    SCHEDULING_UPDATE_MORE_INFO_BUTTON = (30, 78)
    SCHEDULING_UPDATE_REQUIRED = (30, 79)
    SCHEDULING_UPDATE_SOON = (30, 80)
    SCHEDULING_YOUR_CHANGES_WILL_AFFECT_MULTIPLE_DECKS = (30, 81)
    SEARCH_CARD_MODIFIED = (31, 0)
    SEARCH_EMPTY_GROUP = (31, 1)
    SEARCH_EMPTY_QUOTE = (31, 2)
    SEARCH_INVALID_ANSWER_BUTTON = (31, 3)
    SEARCH_INVALID_ARGUMENT = (31, 4)
    SEARCH_INVALID_FLAG_2 = (31, 5)
    SEARCH_INVALID_NEGATIVE_WHOLE_NUMBER = (31, 6)
    SEARCH_INVALID_NUMBER = (31, 7)
    SEARCH_INVALID_OTHER = (31, 8)
    SEARCH_INVALID_POSITIVE_WHOLE_NUMBER = (31, 9)
    SEARCH_INVALID_PROP_OPERATOR = (31, 10)
    SEARCH_INVALID_SEARCH = (31, 11)
    SEARCH_INVALID_WHOLE_NUMBER = (31, 12)
    SEARCH_MISPLACED_AND = (31, 13)
    SEARCH_MISPLACED_OR = (31, 14)
    SEARCH_MISSING_KEY = (31, 15)
    SEARCH_NOTE_MODIFIED = (31, 16)
    SEARCH_UNCLOSED_GROUP = (31, 17)
    SEARCH_UNCLOSED_QUOTE = (31, 18)
    SEARCH_UNKNOWN_ESCAPE = (31, 19)
    SEARCH_UNOPENED_GROUP = (31, 20)
    SEARCH_VIEW_IN_BROWSER = (31, 21)
    STATISTICS_ADDED_SUBTITLE = (32, 0)
    STATISTICS_ADDED_TITLE = (32, 1)
    STATISTICS_AMOUNT_OF_TOTAL_WITH_PERCENTAGE = (32, 2)
    STATISTICS_ANSWER_BUTTONS_BUTTON_NUMBER = (32, 3)
    STATISTICS_ANSWER_BUTTONS_BUTTON_PRESSED = (32, 4)
    STATISTICS_ANSWER_BUTTONS_SUBTITLE = (32, 5)
    STATISTICS_ANSWER_BUTTONS_TITLE = (32, 6)
    STATISTICS_AVERAGE = (32, 7)
    STATISTICS_AVERAGE_ANSWER_TIME = (32, 8)
    STATISTICS_AVERAGE_ANSWER_TIME_LABEL = (32, 9)
    STATISTICS_AVERAGE_DIFFICULTY = (32, 10)
    STATISTICS_AVERAGE_EASE = (32, 11)
    STATISTICS_AVERAGE_FOR_DAYS_STUDIED = (32, 12)
    STATISTICS_AVERAGE_INTERVAL = (32, 13)
    STATISTICS_AVERAGE_OVER_PERIOD = (32, 14)
    STATISTICS_AVERAGE_RETRIEVABILITY = (32, 15)
    STATISTICS_AVERAGE_STABILITY = (32, 16)
    STATISTICS_BACKLOG_CHECKBOX = (32, 17)
    STATISTICS_CALENDAR_TITLE = (32, 18)
    STATISTICS_CARD_DIFFICULTY_SUBTITLE2 = (32, 19)
    STATISTICS_CARD_DIFFICULTY_TITLE = (32, 20)
    STATISTICS_CARD_DIFFICULTY_TOOLTIP = (32, 21)
    STATISTICS_CARD_EASE_SUBTITLE = (32, 22)
    STATISTICS_CARD_EASE_TITLE = (32, 23)
    STATISTICS_CARD_EASE_TOOLTIP = (32, 24)
    STATISTICS_CARD_RETRIEVABILITY_TITLE = (32, 25)
    STATISTICS_CARD_STABILITY_SUBTITLE = (32, 26)
    STATISTICS_CARD_STABILITY_TITLE = (32, 27)
    STATISTICS_CARDS = (32, 28)
    STATISTICS_CARDS_DUE = (32, 29)
    STATISTICS_CARDS_PER_DAY = (32, 30)
    STATISTICS_CARDS_PER_MIN = (32, 31)
    STATISTICS_COUNTS_BURIED_CARDS = (32, 32)
    STATISTICS_COUNTS_FILTERED_CARDS = (32, 33)
    STATISTICS_COUNTS_LEARNING_CARDS = (32, 34)
    STATISTICS_COUNTS_MATURE_CARDS = (32, 35)
    STATISTICS_COUNTS_NEW_CARDS = (32, 36)
    STATISTICS_COUNTS_RELEARNING_CARDS = (32, 37)
    STATISTICS_COUNTS_SEPARATE_SUSPENDED_BURIED_CARDS = (32, 38)
    STATISTICS_COUNTS_SUSPENDED_CARDS = (32, 39)
    STATISTICS_COUNTS_TITLE = (32, 40)
    STATISTICS_COUNTS_TOTAL_CARDS = (32, 41)
    STATISTICS_COUNTS_YOUNG_CARDS = (32, 42)
    STATISTICS_DAILY_LOAD = (32, 43)
    STATISTICS_DAYS_AGO_RANGE = (32, 44)
    STATISTICS_DAYS_AGO_SINGLE = (32, 45)
    STATISTICS_DAYS_STUDIED = (32, 46)
    STATISTICS_DUE_COUNT = (32, 47)
    STATISTICS_DUE_DATE = (32, 48)
    STATISTICS_DUE_FOR_NEW_CARD = (32, 49)
    STATISTICS_DUE_TOMORROW = (32, 50)
    STATISTICS_ELAPSED_TIME_DAYS = (32, 51)
    STATISTICS_ELAPSED_TIME_HOURS = (32, 52)
    STATISTICS_ELAPSED_TIME_MINUTES = (32, 53)
    STATISTICS_ELAPSED_TIME_MONTHS = (32, 54)
    STATISTICS_ELAPSED_TIME_SECONDS = (32, 55)
    STATISTICS_ELAPSED_TIME_YEARS = (32, 56)
    STATISTICS_ESTIMATED_TOTAL_KNOWLEDGE = (32, 57)
    STATISTICS_FUTURE_DUE_SUBTITLE = (32, 58)
    STATISTICS_FUTURE_DUE_TITLE = (32, 59)
    STATISTICS_HOURS_CORRECT = (32, 60)
    STATISTICS_HOURS_CORRECT_INFO = (32, 61)
    STATISTICS_HOURS_CORRECT_REVIEWS = (32, 62)
    STATISTICS_HOURS_RANGE = (32, 63)
    STATISTICS_HOURS_REVIEWS = (32, 64)
    STATISTICS_HOURS_SUBTITLE = (32, 65)
    STATISTICS_HOURS_TITLE = (32, 66)
    STATISTICS_IN_DAYS_RANGE = (32, 67)
    STATISTICS_IN_DAYS_SINGLE = (32, 68)
    STATISTICS_IN_TIME_SPAN_DAYS = (32, 69)
    STATISTICS_IN_TIME_SPAN_HOURS = (32, 70)
    STATISTICS_IN_TIME_SPAN_MINUTES = (32, 71)
    STATISTICS_IN_TIME_SPAN_MONTHS = (32, 72)
    STATISTICS_IN_TIME_SPAN_SECONDS = (32, 73)
    STATISTICS_IN_TIME_SPAN_YEARS = (32, 74)
    STATISTICS_INTERVALS_DAY_RANGE = (32, 75)
    STATISTICS_INTERVALS_DAY_SINGLE = (32, 76)
    STATISTICS_INTERVALS_SUBTITLE = (32, 77)
    STATISTICS_INTERVALS_TITLE = (32, 78)
    STATISTICS_MEDIAN_DIFFICULTY = (32, 79)
    STATISTICS_MEDIAN_EASE = (32, 80)
    STATISTICS_MEDIAN_INTERVAL = (32, 81)
    STATISTICS_MEDIAN_STABILITY = (32, 82)
    STATISTICS_MEMORIZED = (32, 83)
    STATISTICS_MINUTES_PER_DAY = (32, 84)
    STATISTICS_NO_DATA = (32, 85)
    STATISTICS_NOTES = (32, 86)
    STATISTICS_RANGE_1_YEAR_HISTORY = (32, 87)
    STATISTICS_RANGE_ALL_HISTORY = (32, 88)
    STATISTICS_RANGE_ALL_TIME = (32, 89)
    STATISTICS_RANGE_COLLECTION = (32, 90)
    STATISTICS_RANGE_DECK = (32, 91)
    STATISTICS_RANGE_SEARCH = (32, 92)
    STATISTICS_RETRIEVABILITY_SUBTITLE = (32, 93)
    STATISTICS_RETRIEVABILITY_TOOLTIP = (32, 94)
    STATISTICS_REVIEWS = (32, 95)
    STATISTICS_REVIEWS_COUNT_SUBTITLE = (32, 96)
    STATISTICS_REVIEWS_PER_DAY = (32, 97)
    STATISTICS_REVIEWS_TIME_CHECKBOX = (32, 98)
    STATISTICS_REVIEWS_TIME_SUBTITLE = (32, 99)
    STATISTICS_REVIEWS_TITLE = (32, 100)
    STATISTICS_RUNNING_TOTAL = (32, 101)
    STATISTICS_SAVE_PDF = (32, 102)
    STATISTICS_SAVED = (32, 103)
    STATISTICS_STABILITY_DAY_RANGE = (32, 104)
    STATISTICS_STABILITY_DAY_SINGLE = (32, 105)
    STATISTICS_STATS = (32, 106)
    STATISTICS_STUDIED_TODAY = (32, 107)
    STATISTICS_TITLE = (32, 108)
    STATISTICS_TODAY_AGAIN_COUNT = (32, 109)
    STATISTICS_TODAY_CORRECT_MATURE = (32, 110)
    STATISTICS_TODAY_NO_CARDS = (32, 111)
    STATISTICS_TODAY_NO_MATURE_CARDS = (32, 112)
    STATISTICS_TODAY_TITLE = (32, 113)
    STATISTICS_TODAY_TYPE_COUNTS = (32, 114)
    STATISTICS_TOTAL = (32, 115)
    STATISTICS_TRUE_RETENTION_ALL = (32, 116)
    STATISTICS_TRUE_RETENTION_ALL_TIME = (32, 117)
    STATISTICS_TRUE_RETENTION_COUNT = (32, 118)
    STATISTICS_TRUE_RETENTION_FAIL = (32, 119)
    STATISTICS_TRUE_RETENTION_MATURE = (32, 120)
    STATISTICS_TRUE_RETENTION_MONTH = (32, 121)
    STATISTICS_TRUE_RETENTION_NOT_APPLICABLE = (32, 122)
    STATISTICS_TRUE_RETENTION_PASS = (32, 123)
    STATISTICS_TRUE_RETENTION_RANGE = (32, 124)
    STATISTICS_TRUE_RETENTION_RETENTION = (32, 125)
    STATISTICS_TRUE_RETENTION_SUBTITLE = (32, 126)
    STATISTICS_TRUE_RETENTION_TITLE = (32, 127)
    STATISTICS_TRUE_RETENTION_TODAY = (32, 128)
    STATISTICS_TRUE_RETENTION_TOOLTIP = (32, 129)
    STATISTICS_TRUE_RETENTION_TOTAL = (32, 130)
    STATISTICS_TRUE_RETENTION_WEEK = (32, 131)
    STATISTICS_TRUE_RETENTION_YEAR = (32, 132)
    STATISTICS_TRUE_RETENTION_YESTERDAY = (32, 133)
    STATISTICS_TRUE_RETENTION_YOUNG = (32, 134)
    STUDYING_AGAIN = (33, 0)
    STUDYING_ALL_BURIED_CARDS = (33, 1)
    STUDYING_ANSWER_TIME_ELAPSED = (33, 2)
    STUDYING_AUDIO_5S = (33, 3)
    STUDYING_AUDIO_AND5S = (33, 4)
    STUDYING_BURIED_SIBLINGS = (33, 5)
    STUDYING_BURY = (33, 6)
    STUDYING_BURY_CARD = (33, 7)
    STUDYING_BURY_NOTE = (33, 8)
    STUDYING_CARD_STUDIED_IN = (33, 9)
    STUDYING_CARD_SUSPENDED = (33, 10)
    STUDYING_CARD_WAS_A_LEECH = (33, 11)
    STUDYING_CARDS_BURIED = (33, 12)
    STUDYING_CARDS_WILL_BE_AUTOMATICALLY_RETURNED_TO = (33, 13)
    STUDYING_CONTINUE = (33, 14)
    STUDYING_COUNTS_DIFFER = (33, 15)
    STUDYING_DELETE_NOTE = (33, 16)
    STUDYING_DELETING_THIS_DECK_FROM_THE_DECK = (33, 17)
    STUDYING_EASY = (33, 18)
    STUDYING_EDIT = (33, 19)
    STUDYING_EMPTY = (33, 20)
    STUDYING_FINISH = (33, 21)
    STUDYING_FLAG_CARD = (33, 22)
    STUDYING_GOOD = (33, 23)
    STUDYING_HARD = (33, 24)
    STUDYING_IT_HAS_BEEN_SUSPENDED = (33, 25)
    STUDYING_MANUALLY_BURIED_CARDS = (33, 26)
    STUDYING_MARK_NOTE = (33, 27)
    STUDYING_MINUTE = (33, 28)
    STUDYING_MORE = (33, 29)
    STUDYING_NO_CARDS_ARE_DUE_YET = (33, 30)
    STUDYING_NOTE_SUSPENDED = (33, 31)
    STUDYING_PAUSE_AUDIO = (33, 32)
    STUDYING_PLEASE_RUN_TOOLSEMPTY_CARDS = (33, 33)
    STUDYING_QUESTION_TIME_ELAPSED = (33, 34)
    STUDYING_RECORD_OWN_VOICE = (33, 35)
    STUDYING_REPLAY_OWN_VOICE = (33, 36)
    STUDYING_SHOW_ANSWER = (33, 37)
    STUDYING_SPACE = (33, 38)
    STUDYING_STUDY_NOW = (33, 39)
    STUDYING_SUSPEND = (33, 40)
    STUDYING_SUSPEND_NOTE = (33, 41)
    STUDYING_THIS_IS_A_SPECIAL_DECK_FOR = (33, 42)
    STUDYING_TO_REVIEW = (33, 43)
    STUDYING_TYPE_ANSWER_UNKNOWN_FIELD = (33, 44)
    STUDYING_UNBURY = (33, 45)
    STUDYING_WHAT_WOULD_YOU_LIKE_TO_UNBURY = (33, 46)
    STUDYING_YOU_HAVENT_RECORDED_YOUR_VOICE_YET = (33, 47)
    SYNC_ABORT_BUTTON = (34, 0)
    SYNC_ACCOUNT_REQUIRED = (34, 1)
    SYNC_ADDED_UPDATED_COUNT = (34, 2)
    SYNC_ANKIHUB_ADDON_INSTALLATION = (34, 3)
    SYNC_ANKIHUB_DIALOG_HEADING = (34, 4)
    SYNC_ANKIHUB_LOGIN_FAILED = (34, 5)
    SYNC_ANKIHUB_USERNAME_LABEL = (34, 6)
    SYNC_ANKIWEB_ID_LABEL = (34, 7)
    SYNC_CANCEL_BUTTON = (34, 8)
    SYNC_CHECKING = (34, 9)
    SYNC_CLIENT_TOO_OLD = (34, 10)
    SYNC_CLOCK_OFF = (34, 11)
    SYNC_COLLECTION_COMPLETE = (34, 12)
    SYNC_CONFIRM_EMPTY_DOWNLOAD = (34, 13)
    SYNC_CONFIRM_EMPTY_UPLOAD = (34, 14)
    SYNC_CONFLICT = (34, 15)
    SYNC_CONFLICT_EXPLANATION = (34, 16)
    SYNC_CONFLICT_EXPLANATION2 = (34, 17)
    SYNC_CONNECTING = (34, 18)
    SYNC_DOWNLOAD_FROM_ANKIWEB = (34, 19)
    SYNC_DOWNLOADING_FROM_ANKIWEB = (34, 20)
    SYNC_LOG_IN_BUTTON = (34, 21)
    SYNC_LOG_OUT_BUTTON = (34, 22)
    SYNC_MEDIA_ABORTED = (34, 23)
    SYNC_MEDIA_ABORTING = (34, 24)
    SYNC_MEDIA_ADDED_COUNT = (34, 25)
    SYNC_MEDIA_CHECKED_COUNT = (34, 26)
    SYNC_MEDIA_COMPLETE = (34, 27)
    SYNC_MEDIA_DISABLED = (34, 28)
    SYNC_MEDIA_FAILED = (34, 29)
    SYNC_MEDIA_LOG_BUTTON = (34, 30)
    SYNC_MEDIA_LOG_TITLE = (34, 31)
    SYNC_MEDIA_REMOVED_COUNT = (34, 32)
    SYNC_MEDIA_STARTING = (34, 33)
    SYNC_MUST_WAIT_FOR_END = (34, 34)
    SYNC_PASSWORD_LABEL = (34, 35)
    SYNC_RESYNC_REQUIRED = (34, 36)
    SYNC_SANITY_CHECK_FAILED = (34, 37)
    SYNC_SERVER_ERROR = (34, 38)
    SYNC_SIGN_IN = (34, 39)
    SYNC_SYNCING = (34, 40)
    SYNC_UPLOAD_TO_ANKIWEB = (34, 41)
    SYNC_UPLOAD_TOO_LARGE = (34, 42)
    SYNC_UPLOADING_TO_ANKIWEB = (34, 43)
    SYNC_WRONG_PASS = (34, 44)
    UNDO_ACTION_REDONE = (35, 0)
    UNDO_ACTION_UNDONE = (35, 1)
    UNDO_REDO = (35, 2)
    UNDO_REDO_ACTION = (35, 3)
    UNDO_UNDO = (35, 4)
    UNDO_UNDO_ACTION = (35, 5)
