# Now maybe you want the equivalent width of a spectral line. That requires
# normalizing by a continuum estimate:
#
import warnings
from specutils.fitting import fit_generic_continuum
with warnings.catch_warnings():  # Ignore warnings
    warnings.simplefilter('ignore')
    cont_norm_spec = spec / fit_generic_continuum(spec)(spec.spectral_axis) # doctest: +REMOTE_DATA
#
f, ax = plt.subplots()  # doctest: +IGNORE_OUTPUT +REMOTE_DATA
ax.step(cont_norm_spec.wavelength, cont_norm_spec.flux)  # doctest: +IGNORE_OUTPUT +REMOTE_DATA
ax.set_xlim(654 * u.nm, 660 * u.nm)  # doctest: +IGNORE_OUTPUT +REMOTE_DATA
#
# But then you can apply a single function over the region of the spectrum
# containing the line:
#
from specutils import SpectralRegion
from specutils.analysis import equivalent_width
equivalent_width(cont_norm_spec, regions=SpectralRegion(6562 * u.AA, 6575 * u.AA)) # doctest: +REMOTE_DATA +FLOAT_CMP
# Expected:
## <Quantity -14.82013888 Angstrom>
