import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.grain_models import Y24

fig, ax = plt.subplots()

ext_model = Y24()

lam = np.logspace(np.log10(1.0/ext_model.x_range[1]),
                  np.log10(1.0/ext_model.x_range[0]),
                  num=1000)
x = (1.0 / lam) / u.micron

# define the extinction model
ax.plot(lam,ext_model(x),label=ext_model.__class__.__name__)

ax.set_xlabel(r'$\lambda$ [$\mu m$]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.set_xscale('log')
ax.set_yscale('log')

ax.legend(loc='best')
plt.show()