import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.grain_models import P24

fig, ax = plt.subplots()

# define the extinction model
ext_model = P24()

# generate the curves and plot them
x = np.arange(1.0/ext_model.x_range[1], 1.0/ext_model.x_range[0],
              0.01) * u.micron

ax.plot(x,ext_model(x),label='P24')

ax.set_xlabel(r'$\lambda$ [$\mu m$]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.legend(loc='best')
plt.show()