import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u
from dust_extinction.parameter_averages import G23

# define the model
extmod = G23(Rv=3.1)

# wavelengths as 1D arrays
wavelengths = np.logspace(np.log10(0.1), np.log10(30.0), num=1000)*u.micron

# extinction at the wavelengths
ext = extmod(wavelengths)

# plot the intrinsic and extinguished fluxes
fig, ax = plt.subplots()

ax.plot(wavelengths, ext, label='G23 (Rv=3.1)', linewidth=6, alpha=0.5)

ax.set_xlabel(r'$\lambda$ [{}]'.format(wavelengths.unit))
ax.set_ylabel(r'$A(\lambda)/A(V)$')

ax.set_xscale('log')
ax.set_yscale('log')

ax.legend(loc='best')
plt.tight_layout()
plt.show()