import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.parameter_averages import D22

fig, ax = plt.subplots()

# temp model to get the correct x range
text_model = D22()

# generate the curves and plot them
x = np.arange(text_model.x_range[0], text_model.x_range[1], 0.01) / u.micron

Rvs = [2.5, 3.1, 4.0, 4.75, 5.5]
for cur_Rv in Rvs:
    ext_model = D22(Rv=cur_Rv)
    ax.plot(1. / x, ext_model(x), label="R(V) = " + str(cur_Rv))

ax.set_xlabel(r"$\lambda$ [$\mu m$]")
ax.set_ylabel(r"$A(x)/A(V)$")

ax.legend(loc="best")
plt.show()