/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.spinner;

import java.lang.invoke.MethodHandles;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntSpinner
extends JSpinner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public IntSpinner() {
        super(new SpinnerNumberModel());
    }

    public IntSpinner(int value, int minimum, int maximum, int stepSize) {
        if (maximum < minimum) {
            throw new IllegalArgumentException("IntSpinner maximum must be >= than minimum");
        }
        int setval = value;
        if (setval < minimum) {
            LOGGER.warn("spinner init val {} < min {}; re-setting it", (Object)setval, (Object)minimum);
            setval = minimum;
        } else if (setval > maximum) {
            LOGGER.warn("spinner init val {} > max {}; re-setting it", (Object)setval, (Object)maximum);
            setval = maximum;
        }
        SpinnerNumberModel model = new SpinnerNumberModel(setval, minimum, maximum, stepSize);
        this.setModel(model);
        this.addChangeListener(e -> this.repaint());
    }

    public int SpinnerNumberModel() {
        return ((SpinnerNumberModel)this.getModel()).getNumber().intValue();
    }

    public int getIntValue() {
        return (Integer)this.getValue();
    }

    public void setValue(int value) {
        this.setValue((Object)value);
    }

    public int getMaximum() {
        SpinnerNumberModel snm = (SpinnerNumberModel)this.getModel();
        Integer max = (Integer)snm.getMaximum();
        return max;
    }

    public void setMaximum(int newmax) {
        SpinnerNumberModel snm = (SpinnerNumberModel)this.getModel();
        snm.setMaximum(Integer.valueOf(newmax));
    }
}

