/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.graphics.CmykColorSpace;
import gov.nasa.giss.ui.color.chooser.CmykSlider;
import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserPreview;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmykSliderPanel
extends ColorChooserPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CmykTextField cField_;
    private CmykTextField mField_;
    private CmykTextField yField_;
    private CmykTextField kField_;
    private JLabel hexLabel_;
    private ColorSpace cspace = new CmykColorSpace();

    @Override
    void setComponent(ColorComponentID compID, int value) {
        switch (compID) {
            case CYAN: 
            case MAGENTA: 
            case YELLOW: 
            case BLACK: {
                this.setComponent(compID, (float)value / 100.0f);
            }
        }
    }

    @Override
    void setComponent(ColorComponentID compID, float value) {
        if (value < 0.0f || value > 1.0f) {
            LOGGER.warn("{}, {}", (Object)compID, (Object)Float.valueOf(value));
            return;
        }
        Color c = this.getColorSelectionModel().getSelectedColor();
        float[] cmyk = c.getColorComponents(this.cspace, null);
        try {
            switch (compID) {
                case CYAN: {
                    cmyk[0] = value;
                    break;
                }
                case MAGENTA: {
                    cmyk[1] = value;
                    break;
                }
                case YELLOW: {
                    cmyk[2] = value;
                    break;
                }
                case BLACK: {
                    cmyk[3] = value;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        c = new Color(this.cspace, cmyk, 1.0f);
        this.setColor(c);
    }

    @Override
    public void buildChooser() {
        ColorSelectionModel csmodel = this.getColorSelectionModel();
        ColorChooserPreview colorbox = new ColorChooserPreview(csmodel);
        JLabel cLabel = new JLabel("C", 4);
        JLabel mLabel = new JLabel("M", 4);
        JLabel yLabel = new JLabel("Y", 4);
        JLabel kLabel = new JLabel("K", 4);
        JLabel cUnits = new JLabel("%", 2);
        JLabel mUnits = new JLabel("%", 2);
        JLabel yUnits = new JLabel("%", 2);
        JLabel kUnits = new JLabel("%", 2);
        Font lfont = cLabel.getFont().deriveFont((float)((double)cLabel.getFont().getSize() - 3.0));
        cLabel.setFont(lfont);
        mLabel.setFont(lfont);
        yLabel.setFont(lfont);
        kLabel.setFont(lfont);
        cUnits.setFont(lfont);
        mUnits.setFont(lfont);
        yUnits.setFont(lfont);
        kUnits.setFont(lfont);
        this.cField_ = new CmykTextField(ColorComponentID.CYAN);
        this.mField_ = new CmykTextField(ColorComponentID.MAGENTA);
        this.yField_ = new CmykTextField(ColorComponentID.YELLOW);
        this.kField_ = new CmykTextField(ColorComponentID.BLACK);
        this.hexLabel_ = new JLabel("#FFFFFF", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 6), 2, 4);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(5, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)colorbox, new FGConstraint(1, 0, 1, 3, 0.5, 0.0));
        this.add((Component)cLabel, new FGConstraint(3, 0, 1, 1));
        this.add((Component)new CmykSlider(this, ColorComponentID.CYAN), new FGConstraint(4, 0, 1, 1));
        this.add((Component)this.cField_, new FGConstraint(5, 0, 1, 1));
        this.add((Component)cUnits, new FGConstraint(6, 0, 1, 1));
        this.add((Component)mLabel, new FGConstraint(3, 1, 1, 1));
        this.add((Component)new CmykSlider(this, ColorComponentID.MAGENTA), new FGConstraint(4, 1, 1, 1));
        this.add((Component)this.mField_, new FGConstraint(5, 1, 1, 1));
        this.add((Component)mUnits, new FGConstraint(6, 1, 1, 1));
        this.add((Component)yLabel, new FGConstraint(3, 2, 1, 1));
        this.add((Component)new CmykSlider(this, ColorComponentID.YELLOW), new FGConstraint(4, 2, 1, 1));
        this.add((Component)this.yField_, new FGConstraint(5, 2, 1, 1));
        this.add((Component)yUnits, new FGConstraint(6, 2, 1, 1));
        this.add((Component)kLabel, new FGConstraint(3, 3, 1, 1));
        this.add((Component)new CmykSlider(this, ColorComponentID.BLACK), new FGConstraint(4, 3, 1, 1));
        this.add((Component)this.kField_, new FGConstraint(5, 3, 1, 1));
        this.add((Component)kUnits, new FGConstraint(6, 3, 1, 1));
        this.add((Component)this.hexLabel_, new FGConstraint(1, 4, 6, 1, 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 5, 1, 1));
    }

    @Override
    public void updateChooser() {
        this.cField_.refresh();
        this.mField_.refresh();
        this.yField_.refresh();
        this.kField_.refresh();
        Color c = this.getColorSelectionModel().getSelectedColor();
        String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
        this.hexLabel_.setText(hex);
        this.repaint();
    }

    @Override
    public String getDisplayName() {
        return "CMYK";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class CmykTextField
    extends JTextField {
        private final ColorComponentID compID_;

        CmykTextField(ColorComponentID compID) {
            super(4);
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.compID_ = compID;
            switch (compID) {
                case CYAN: 
                case MAGENTA: 
                case YELLOW: 
                case BLACK: {
                    this.setText("100");
                    break;
                }
            }
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    CmykTextField.this.respond();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(e -> this.respond());
        }

        private void refresh() {
            ColorSelectionModel csm = CmykSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            float[] cmyk = c.getColorComponents(CmykSliderPanel.this.cspace, null);
            switch (this.compID_) {
                case CYAN: {
                    this.setText(Integer.toString((int)(cmyk[0] * 100.0f)));
                    break;
                }
                case MAGENTA: {
                    this.setText(Integer.toString((int)(cmyk[1] * 100.0f)));
                    break;
                }
                case YELLOW: {
                    this.setText(Integer.toString((int)(cmyk[2] * 100.0f)));
                    break;
                }
                case BLACK: {
                    this.setText(Integer.toString((int)(cmyk[3] * 100.0f)));
                    break;
                }
            }
        }

        private void respond() {
            try {
                CmykSliderPanel.this.setComponent(this.compID_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }
}

